<?php


namespace App\Services;


use App\Entities\Master;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Exception\ClientException;
use http\Env\Request;

class IuguService
{
    //ARCNET PROD 8CCCFC05D54C31B8863C28707010E7BC0D723C8171B2500B069D1DBF94BA9DB3
    //ARCNET TEST E541D15D35800AA0B0EDB6C635447DDC4E147B4DDF8DA064A42A60BD266F41CF

    //EDUTEC PROD EF60065FC408B36EDFB8605BA4BC20FAF0E76339A828876C5AE8EACE78E581E9
    //EDUTEC TEST BBE2BAAF538A91A8755CFCA70AF1A65900584AD0BDAC724ABF3FD3B0342CC0D4

    //HOTTANET PROD A7B1E433642F200F2D39AB465AC9FBE615ED595108299F8B931288BF1C1EF70D
    //HOTTANET TEST AB7015F0E9E2A7F3DAB0DFFD68BE8316831569DD3F5A793C52DD23DB04AC0197

    //EBAC PROD 09EE7092F7F0EEAAD1D4A1B9879BD2566325E6AB26EE09B34EABDCE3B4D46CE3
    //EBAC TEST CAA0ABA1E8D11D86DC744E79BE1FBFBD5D836507D0776337F7CFA6E66F652109

    //JGS PROD 9826A08005D18340C81551D145694A67E8B10B8E4003E79ED1FCEFCB91E39A21
    //JGS TEST AA199A6A4906CB29581DA3400D69D1C3CD9130B07E418A4F29C5C33DBF4EDE6E

    //AMERICO PROD EF3F25BF807729182BE6339B7C5E18187BC826BF0922CC8D4D7EA6947F6F5015
    //AMERICO TEST 0469F63793F6D3E232F30073A951B2AE3B4A587FC7B5164B4B5DE48904B73798

    //CARLOS PROD 529F0BE7FD1A8BCB19DA8A52F2D06CCAE346BB31AE4872151B501DC5ACD4F330
    //CARLOS TEST 15F8E8A3B4930367F2F32E2F72A7A0D40B3242736E86AEF3349896264DD47E92

    private $token = '581c5eb0ccaa199984b4f1fe70e482a7';
    private $tokenSubAccount = '';

    public function __construct()
    {
        $this->setSubAccountToken();
    }

    private function setSubAccountToken()
    {
        $master = Master::first();
        if(!$master) {
            return;
        }
        $this->tokenSubAccount = $master->subAccountToken;
    }

    private function getIuguId()
    {
        $master = Master::first();
        if(!$master){
            throw new \Exception("Master não encontrado");
        }
        if (isset($master->iugu) && strlen($master->iugu) > 0){
            return $master->iugu;
        }
        if (!$master->iugu) {
            $id = $this->getCliente($master->stCNPJ);
            if($id){
                $master->iugu = $id;
                $master->save();
                return $master->iugu;
            }
        }
    }

    private function getCliente(string $cnpj)
    {
        $client = new Client();
        $url = 'https://api.iugu.com/v1/customers?query=' . $cnpj . '&api_token=' . $this->token;
        try {
            $response = $client->request('GET', $url);
        } catch (GuzzleException $e) {
            return $e;
        }

        $data = $response->getBody();
        $data = json_decode($data, true);
        return $data['items'][0]['id'];
    }

    /**
     * @return string
     */
    public function getInvoices()
    {
        $client = new Client();
        $id = $this->getIuguId();
        $url = 'https://api.iugu.com/v1/invoices?customer_id='. $id .'&api_token=' . $this->token;
        try {
            $response = $client->request('GET', $url);
        } catch (GuzzleException $e) {
            return $e;
        }

        $data = $response->getBody();
        $data = json_decode($data, true);
        return $data['items'];


    }

    public function getCompany(string $cnpj)
    {
        if(!$this->tokenSubAccount) throw new \Exception('Invalid token');

        $client = new Client();
        $url = 'https://api.iugu.com/v1/customers?query=' . $cnpj . '&api_token=' . $this->tokenSubAccount;
        try {
            $response = $client->request('GET', $url, ['connect_timeout' => 0]);
        } catch (GuzzleException $e) {
            return $e;
        }

        $data = $response->getBody();
        $data = json_decode($data, true);
        if(isset($data['items'][0])) return $data['items'][0];
        return;
    }

    public function storeClient($request)
    {
        $client = new Client();
        $url = 'https://api.iugu.com/v1/customers?' . '&api_token=' . $this->tokenSubAccount;
        try {
            $response = $client->post($url, [
                'headers' => ['Content-Type' => 'application/json'],
                'json' => [
                    'email' => $request->email,
                    'name' => $request->nome,
                    'cpf_cnpj' => $request->cnpj,
                    'phone' => $request->telefone,
                    'phone_prefix' => $request->prefixo,
                    'zip_code' => $request->cep,
                    'number' => $request->numero,
                    'street' => $request->rua,
                    'city' => $request->city,
                    'state' => $request->estado,
                    'district' => $request->bairro,
                    'complement' => $request->complemento,
                    'cc_emails' => $request->emails_cc
                ]
            ],
            );
        } catch (GuzzleException $e) {
            throw new \Exception($e->getMessage(), $e->getCode());
        }

        $data = $response->getBody();
        $data = json_decode($data, true);
        return $data;
    }

    public function getSubscriptions($paymentProviderClientId)
    {
        $client = new Client();
        $url = 'https://api.iugu.com/v1/subscriptions?customer_id=' . $paymentProviderClientId . '&api_token=' . $this->tokenSubAccount;
        try {
            $response = $client->request('GET', $url);
        } catch (GuzzleException $e) {
            return $e;
        }

        $data = $response->getBody();
        $data = json_decode($data, true);
        if(isset($data['items'][0]['id'])) return $data;
        return null;
    }

    public function searchSubscription($paymentProviderSubscriptionId)
    {
        $client = new Client();
        $url = 'https://api.iugu.com/v1/subscriptions/' . $paymentProviderSubscriptionId . '?api_token=' . $this->tokenSubAccount;
        try {
            $response = $client->get($url);
        } catch (GuzzleException $e) {
            return null;
        }

        $data = $response->getBody();
        $data = json_decode($data, true);
        return $data;
    }

        // public function updateClient($idClient, $request)
    // {
    //     $client = new Client();
    //     $url = 'https://api.iugu.com/v1/customers' . "/$idClient" . '?api_token=' . $this->tokenTest;
    //     try {
    //         $response = $client->put($url, [
    //             'headers' => ['Content-Type:' => 'application/json'],
    //             'json' => [
    //                 'id' => $idClient,
    //                 'name' => $request->nome,
    //                 'email' => $request->email,
    //                 'phone' => $request->telefone,
    //                 'phone_prefix' => $request->prefixo,
    //                 'cpf_cnpj' => $request->cnpj,
    //                 'zip_code' => $request->cep,
    //                 'number' => $request->numero,
    //                 'street' => $request->rua,
    //                 'city' => $request->cidade,
    //                 'state' => $request->estado,
    //                 'district' => $request->bairro,
    //                 'complement' => $request->complemento,
    //             ]
    //         ]);
    //         $data = $response->getBody();
    //         return $data = json_decode($data, true);
    //     } catch (GuzzleException $e) {
    //         return $e;
    //     }

    //     $data = $response->getBody();
    //     $data = json_decode($data, true);
    //     return $data;
    // }

    public function activateSubscription($id)
    {
        $client = new Client();
        $url = "https://api.iugu.com/v1/subscriptions/{$id}/activate?" . 'api_token=' .  $this->tokenSubAccount;
        try {
            $response = $client->post($url, [
                'headers' => ['Accept' => 'application/json'],
            ],
            );
        } catch (GuzzleException $e) {
            throw new \Exception($e->getMessage(), $e->getCode());
        }

        $data = $response->getBody();
        $data = json_decode($data, true);
        return $data;
    }

//    public function getInvocies($cnpj)
//    {
//        $client = new Client();
//        $url = "https://api.iugu.com/v1/invoices?query=" . $cnpj . '&api_token=' .  $this->tokenSubAccount;
//
//        try {
//            $response = $client->request('GET', $url);
//        } catch (GuzzleException $e) {
//            throw new \Exception($e->getMessage(), $e->getCode());
//        }
//
//        $data = $response->getBody();
//        $data = json_decode($data, true);
//        if(isset($data['items'][0])) return $data['items'][0];
//        return;
//    }
}
