<?php

namespace App\Services;

use App\Entities\Sangria;
use App\Repositories\SangriaRepository;
use App\Validators\Nati\SangriaValidator;

class SangriaService
{
    protected $repository;
    protected $validator;

    public function __construct(SangriaRepository $repository, SangriaValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }


    public function getSupplies($id_open)
    {
        return Sangria::where('id_open', $id_open)
            ->where('value_sangria', '<', 0)
            ->get();
    }

    public function getSangrias($id_open)
    {
        return $this->repository->findWhere(['id_open' => $id_open])
            ->where('value_sangria', '>', 0);
    }

}
