<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEstEstoquesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('est_Estoques')) {
            Schema::create('est_Estoques', function (Blueprint $table) {
                $table->integer('idEstoque', false, true);
                $table->string('stEstoque', 20);
                $table->boolean('flOrigem');
                $table->boolean('flTipoEstoque')->default(true);
                $table->boolean('flEntrada');
                $table->boolean('flAtivo')->default(true);
                $table->boolean('flAtivarSaldo')->default(true);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('est_Estoques');
    }
}
