<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMasterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('Master')) {
            Schema::create('Master', function (Blueprint $table) {
                $table->integer('idCliente');
                $table->integer('idVendedor')->default(1);
                $table->string('stCliente', 50)->default('SISTEMA NATI');
                $table->string('stEndereco', 50)->default('RUA MELO PEIXOTO, 1163');
                $table->string('stBairro', 50)->default('TATUAPE');
                $table->string('stComplemento', 50)->nullable();
                $table->string('stTelefone1', 50);
                $table->string('stTelefone2', 50);
                $table->string('stMarketing', 50)->default('www.sistemanati.com.br');
                $table->string('stCNPJ', 21)->nullable();
                $table->string('stIE', 25)->nullable();
                $table->string('stLetraComanda', 1)->default('W');
                $table->decimal('vrDesconto', 9, 2)->default(5);
                $table->decimal('vrVendaPermitida', 9, 2)->default(500);
                $table->integer('nrDigitosComanda')->default(3);
                $table->decimal('vrAlertaSangria', 9, 2)->default(1000);
                $table->boolean('flSangriaObrigatoria')->default(false);
                $table->string('stTipoComanda', 10)->default('WDDD');
                $table->boolean('flAtivarModoRestaurante')->default(false);
                $table->decimal('vrTaxaServico', 9, 2)->default(10);
                $table->string('stAtivacao', 32);
                $table->datetime('dtValidade');
                $table->string('stMesas', 9)->default('1@200');
                $table->boolean('flInformarGarcom')->default(false);
                $table->boolean('flPizzaMeioMeio')->default(true);
                $table->integer('nrNumeroLogradouro')->default(0);
                $table->string('stCidade', 50)->default('SAO PAULO');
                $table->string('stEstado', 2)->default('SP');
                $table->string('stCEP', 8);
                $table->boolean('flF')->default(false);
                $table->integer('nrDiasValidade')->default(60);
                $table->integer('nrPedido')->default(0);
                $table->boolean('flExibirTaxaServico')->default(false);
                $table->boolean('flFechamentoAnalitico')->default(false);
                $table->boolean('flUsarPrecoAtual')->default(false);
                $table->boolean('flVendaComComanda')->default(false);
                $table->boolean('flSimplesNacional')->default(false);
                $table->decimal('vrDiversos', 9, 2)->default(1);
                $table->datetime('dtAlteracao')->default(Carbon::now());
                $table->integer('nrPedidoDelivery')->default(0);
                $table->string('stChaveCR', 250)->default('T0ZGOzA7RkFMU0U7RkFMU0U=');
                $table->boolean('flTaxaServicoTerminal')->default(false);
                $table->boolean('flTitulosDiarios')->default(false);
                $table->string('stIM', 15);
                $table->string('stIS', 15);
                $table->bigInteger('idCidade')->default(3550308);
                $table->decimal('vrAliquotaSimplesNacional', 9, 2)->default(0);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('Master');
    }
}
