<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterDesenfilaConfigs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(Schema::hasColumn('desenfila_config', 'taxApi')) {
            DB::statement($this->deleteConstrainttaxApi());
            Schema::table('desenfila_config', function (Blueprint $table) {
                $table->string('taxApi', 120)->nullable()->change();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

    public function deleteConstrainttaxApi()
    {
        return "DECLARE @MyCursor CURSOR;
                DECLARE @FieldName varchar(200);
                DECLARE @tableName varchar(200) = 'desenfila_config';
                DECLARE @Column varchar(200) = 'taxApi';
                DECLARE @ShortColumn varchar(200) = 'taxAp';
                DECLARE @Cols AS int = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = @tableName AND COLUMN_NAME = @Column AND TABLE_SCHEMA='DBO')

                IF @Cols > 0
                BEGIN
                    SET @MyCursor = CURSOR FOR
                        SELECT name from sys.default_constraints where parent_object_id =OBJECT_ID(@tableName) AND name like '%' + @ShortColumn + '%'
                    OPEN @MyCursor
                    FETCH NEXT FROM @MyCursor
                    INTO @FieldName
                    WHILE @@FETCH_STATUS = 0
                    BEGIN
                    EXEC('ALTER TABLE ['+ @tableName +'] drop constraint [' + @FieldName + ']')
                        FETCH NEXT FROM @MyCursor
                        INTO @FieldName
                    END
                    --EXEC('ALTER TABLE ['+ @tableName +'] drop column [' + @Column + ']')
                END";
    }
}
