<?php

namespace Database\Seeders;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class v6_1_11_2 extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if(!Schema::hasColumn('prd_config', 'flProductsBalanceExport')) {
            Schema::table('prd_config', function(Blueprint $table) {
                $table->boolean('flProductsBalanceExport')->default(0);
            });
        }

        if($this->thereProductsExport()){
            $this->activeFlbalanca();
        }
    }

    private function thereProductsExport()
    {
        $idProdutos = $this->getOldProducts();
        if(!$idProdutos[0]) {
            return false;
        }

        $queryResult = DB::Table('prd_config')
                            ->select('flProductsBalanceExport')
                            ->pluck('flProductsBalanceExport');

        if($queryResult[0] == '0') return true;
        return false;
    }

    private function activeFlbalanca()
    {
        $idProdutos = $this->getOldProducts();

        DB::statement('update prd_produtos set flBalanca = 0 where flBalanca = 1');
        foreach($idProdutos as $id) {
            DB::statement("update prd_produtos set flBalanca = 1 where idproduto = '$id'");
        }
        DB::statement('update prd_config set flProductsBalanceExport = 1');

    }

    private function getOldProducts()
    {
        $queryResult = DB::table('prd_config')
            ->select(DB::raw('cast(stBalanca as TEXT) as stBalanca'))
            ->get();
        $idProdutosString = $queryResult[0]->stBalanca;
        $idProdutos = $this->transformArray($idProdutosString);
        return $idProdutos;
    }

    private function transformArray($idProdutosString)
    {
        $idProdutosString = str_replace('[', '', $idProdutosString );
        $idProdutosString = str_replace(']', '', $idProdutosString );
        $idProdutosString = explode(",", $idProdutosString);
        foreach ($idProdutosString as $item) {
            $idProdutos[] =  str_replace('"', '', $item);
        }
        return $idProdutos;
    }

}
