document.addEventListener("DOMContentLoaded", function() {
    var pagina = $("#idPagina").val();
    if(pagina == "localizacoes"){
        var data = {action: 'getLocais'};
        $.post('produtos/resources/php/produtos_functions.php', data, function(dados) {
            var linha = '';
            for (var i = 0; i < dados.length; i++) {
                linha += '<tr><td class="tdStyle" id="st'+dados[i].idLocalizacao+'">'+dados[i].stLocalizacao+'</td>';
                linha += '<td class="tdStyle">';
                linha += '<a onclick="editLocal('+dados[i].idLocalizacao+')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
                linha += '<a onclick="excluirLocal('+dados[i].idLocalizacao+')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-remove col-md-6" align="center" title="Remover"></span></a>';
                linha += '</td></tr>';
            }
            $(linha).appendTo($("#bodyTabelaCategoriasItens"));
        });
    }
});

function initializeDataTables(name) {
    $('#'+name).DataTable( {
        "language": 
        {
            "url": "produtos/resources/js/Portuguese-Brasil.json"
        }
    });
}

function imprimirListagem() {
    var dataTable = $("#listagem_produtos").DataTable();
    dataTable.column(8).visible(false);
    var htmlTable = '<table class="display table table-striped table-bordered" cellspacing="0" width="100%" style="border-bottom-left-radius: 0.5em;border-bottom-right-radius: 0.5em"><caption class="table-caption"><b>Listagem de Produtos</b></caption><thead><tr><th>Códigos</th><th>Produto</th><th>Categoria</th><th>Sub Categoria</th><th>Medida</th><th>Setor</th><th>Valor</th><th>Aliquota</th></tr></thead><tbody>';
    dataTable.$('tr', {"filter":"applied"}).each( function () {
        htmlTable += this.outerHTML;
    });
    htmlTable += '</tbody></table>';
    newWin = window.open("");
    newWin.document.write('<link href="produtos/resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>');
    newWin.document.write(htmlTable);
    newWin.print();
    dataTable.column(8).visible(true);
    newWin.close();
}

function openDetalheProduto(status, idCodigo) {
    $("#statusModal").val(status);
    if (status == "ativo") {
        status = 1;
    }else if(status == "inativo"){
        status = 0;
    }
    var data = {action: "getProductById", status: status, idCodigo: idCodigo};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        $("#stProdutoModal").html(response.stProduto);
        $("#stProdutoAbrModal").html(response.stProdutoAbreviado);
        $("#vrPrecoModal").html("R$ " + response.vrUnitario);
        $("#stMedidaModal").html(response.stMedida);
        $("#stCategoriaModal").html(response.stCategoria);
        $("#stSetorModal").html(response.stSetor);
        $("#stAliquotaModal").html(response.stAliquota);
        $("#stLocalModal").html(response.stLocalizacao);
        $("#idCodigoModal").html(response.idCodigo);
        $("#dtEditadoModal").html(response.dtAlteracao);
        $("#productCode").val(response.idCodigo);
        $("#firstCode").val(response.primeiro);
        $("#previousCode").val(response.anterior);
        $("#nextCode").val(response.proximo);
        $("#lastCode").val(response.ultimo);
    });
    $("#modalProduto").modal("show");
}

function getProdutoModal(direcao) {
    switch(direcao) {
        case 'primeiro':
        openDetalheProduto($("#statusModal").val(), $("#firstCode").val());
        break;
        case 'anterior':
        openDetalheProduto($("#statusModal").val(), $("#previousCode").val());
        break;
        case 'proximo':
        openDetalheProduto($("#statusModal").val(), $("#nextCode").val());
        break;
        case 'ultimo':
        openDetalheProduto($("#statusModal").val(), $("#lastCode").val());
        break;

    }
}

function getFornecedoresModal() {
    toastr.options = 
    {
        "positionClass": "toast-bottom-right"
    }
    var codigoProduto = $("#productCode").val();
    var data = {action: "getFornecedoresByCodigoProduto", idCodigo: codigoProduto};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        if(response != null){
            $("#codigoModalFornecedor").val(codigoProduto);
            for (var i = 0; i < response.length; i++) {
                var linha = '<tr><td>'+ response[i].stNomeFornecedor +'</td><td>'+ response[i].dtData +'</td><td>'+ response[i].vrValor +'</td></tr>';
                $(linha).appendTo($("#bodyTableFornecedores"));
            }
            $("#modalProduto").modal("hide");
            $("#modalFornecedor").modal("show");
        }else{
            toastr.error("Nenhum fornecedor vinculado ao produto");
        }
    });
}

$('#modalFornecedor').on('hidden.bs.modal', function () {
  $("#bodyTableFornecedores").html("");
  openDetalheProduto($("#codigoModalFornecedor").val());
});

function desativarProduto(idCodigo) {
    toastr.options = 
    {
        "positionClass": "toast-bottom-right"
    }

    swal({   
        title: 'Tem certeza?',   
        text: 'Tem certeza que deseja desativar este produto?',   
        type: 'warning',   
        showCancelButton: true,   
        confirmButtonColor: '#2A98D3',   
        cancelButtonColor: '#FF2727',   
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',   
        closeOnConfirm: true 
    }, function() { 
        $("body").addClass("loading");
        var data = {action: "desativarProduto", idCodigo: idCodigo};
        $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if(response.status){
                toastr.success(response.msg);
                setTimeout(function(){location.reload();},1000);
            }else{
                toastr.error(response.msg);
            }          
        });
    });
};

function reativarProduto(idCodigo) {
    toastr.options = 
    {
        "positionClass": "toast-bottom-right"
    }

    swal({   
        title: 'Tem certeza?',   
        text: 'Tem certeza que deseja reativar este produto?',   
        type: 'warning',   
        showCancelButton: true,   
        confirmButtonColor: '#2A98D3',   
        cancelButtonColor: '#FF2727',   
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',   
        closeOnConfirm: true 
    }, function() { 
        $("body").addClass("loading");
        var data = {action: "reativarProduto", idCodigo: idCodigo};
        $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if(response.status){
                toastr.success(response.msg);
                setTimeout(function(){location.reload();},1000);
            }else{
                toastr.error(response.msg);
            }          
        });
    });
};

function excluirProduto(idCodigo) {
    toastr.options = 
    {
        "positionClass": "toast-bottom-right"
    }

    swal({   
        title: 'Tem certeza?',   
        text: 'Tem certeza que deseja excluir este produto?',   
        type: 'warning',   
        showCancelButton: true,   
        confirmButtonColor: '#2A98D3',   
        cancelButtonColor: '#FF2727',   
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',   
        closeOnConfirm: true 
    }, function() { 
        $("body").addClass("loading");
        var data = {action: "excluirProduto", idCodigo: idCodigo};
        $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if(response.status){
                toastr.success(response.msg);
                setTimeout(function(){location.reload();},1000);
            }else{
                toastr.error(response.msg);
            }          
        });
    });
};

function novoLocal () {
    $("#modalLocalTitle").html('Cadastro de Categoria');
    $("#modalLocal").modal('show');
}

function editLocal (idLocal) {
    var stLocal = $("#st"+idLocal).html();
    $("#codigoLocal").val(idLocal);
    $("#stLocal").val(stLocal);
    $("#modalLocalTitle").html('Edição de Categoria');
    $("#modalLocal").modal('show');
}

function cadastrarLocal() {
    toastr.options = 
    {
        "positionClass": "toast-bottom-right"
    }
    var idLocal = $("#codigoLocal").val();
    var stLocal = $("#stLocal").val();
    if (stLocal.length == 0) {
        toastr.error('Digite um nome para a localização!');
        $("#divStLocal").addClass('has-error');
        return false;
    }
    var action = 'cadastrarLocal';
    if(idLocal){
        action = 'editarLocal';
        var data = {action: action, idLocal: idLocal, stLocal: stLocal};
    }else{
        var data = {action: action, stLocal: stLocal};
    }
    $.post('produtos/resources/php/produtos_functions.php', data, function(dados) {
        if(dados.status){
            toastr.success(dados.msg);
            setTimeout(function(){location.reload();},1000);
        }else{
            toastr.error(dados.msg);
        } 
    });
}

function excluirLocal(idLocal) {
    toastr.options = 
    {
        "positionClass": "toast-bottom-right"
    }

    swal({   
        title: 'Tem certeza?',   
        text: 'Tem certeza que deseja excluir esta Categoria de Item ?',   
        type: 'warning',   
        showCancelButton: true,   
        confirmButtonColor: '#2A98D3',   
        cancelButtonColor: '#FF2727',   
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',   
        closeOnConfirm: true 
    }, function() { 
        $("body").addClass("loading");
        var data = {action: "excluirLocal", idLocal: idLocal};
        $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if(response.status){
                toastr.success(response.msg);
                setTimeout(function(){location.reload();},1000);
            }else{
                toastr.error(response.msg);
            }          
        });
    });
};

$('#modalLocal').on('hidden.bs.modal', function (e) {
  $("#divStLocal").removeClass('has-error');
  $("#stLocal").val('');
})