document.addEventListener("DOMContentLoaded", function() {
	var data = {action: 'getSATs'};
	$.post('sat/resources/php/listagem_functions.php', data, function(dados) {
		var linha = '';
		for (var i = 0; i < dados.length; i++) {
			var status = 'DESATIVADO';
			var icon = 'glyphicon-plus';
			var iconTitle = 'Ativar';
			if (dados[i].Active == 1) {
				status = 'ATIVO';
				icon = 'glyphicon-minus';
				iconTitle = 'Desativar';
			}
			linha += '<tr><td>'+dados[i].serial+'</td>';
			linha += '<td>'+status+'</td>';
			linha += '<td>'+dados[i].DataCadastro+'</td>';
			linha += '<td>'+dados[i].dtAlteracao+'</td>';
			linha += '<td>';
			linha += '<a onclick="edit('+dados[i].id+')" style="cursor:pointer"><span class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
			linha += '<a onclick="changeStatus('+dados[i].id+', '+dados[i].Active+')" style="cursor:pointer"><span class="glyphicon '+icon+' col-md-6" align="center" title="'+iconTitle+'"></span></a>';
			linha += '</td></tr>';
		}
		$(linha).appendTo($("#bodyListagem"));
	});
});

function edit (id) {
	var data ={action: 'getById', id: id};
	$.post('sat/resources/php/listagem_functions.php', data, function(dados) {
		$("#idSATModal").val(dados.id);
		$("#serial").val(dados.serial);
		$("#tituloModalSAT").html("Edição de Equipamento SAT");
		$("#modalSAT").modal('show');
	});
}

function novoSAT () {
	$("#tituloModalSAT").html("Cadastro de Equipamento SAT");
	$("#modalSAT").modal('show');
}

function cadastrarSAT () {
	toastr.options = 
	{
		"positionClass": "toast-bottom-right"
	}
	var id = $("#idSATModal").val();
	var serial = $("#serial").val();
	if(serial.length <= 0){
		toastr.error("Não é possível salvar um equipamento sem serial.");
		return false;
	}
	var data = {action: 'save', id: id, serial:serial};
	$.post('sat/resources/php/listagem_functions.php', data, function(response) {
		if(response.status){
			toastr.success(response.msg);
			setTimeout("location.reload()", 1500);
		}else{
			toastr.error(response.msg);
		} 
	});
}

function changeStatus(id, active) {
	toastr.options = 
	{
		"positionClass": "toast-bottom-right"
	}

	var message = 'Esta ação irá ativar o equipamento SAT.';
	var action = 'activate';
	if (active == 1) {
		message = 'Esta ação irá desativar o equipamento SAT.';
		action = 'deactivate';
	}

	swal({   
		title: 'Tem certeza?',   
		text: message,   
		type: 'warning',   
		showCancelButton: true,   
		confirmButtonColor: '#2A98D3',   
		cancelButtonColor: '#FF2727',   
		confirmButtonText: 'Continuar',
		cancelButtonText: 'Cancelar',   
		closeOnConfirm: true 
	}, function() { 
		$("body").addClass("loading");
		var data = {action: action, id: id}
		$.post('sat/resources/php/listagem_functions.php', data, function (response) {
			$("body").removeClass("loading");
			if(response.status){
				toastr.success(response.msg);
				setTimeout("location.reload()", 1500);
			}else{
				toastr.error(response.msg);
			}          
		});
	});
}

$('#modalEstoque').on('hidden.bs.modal', function () {
	$("#idEstoqueModal").val("");
	$("#stEstoqueModal").val("");
	$("#checkSaldoModal").removeAttr("checked");
	$("#origemEstoqueModal").val("1");
})

$("#serial").on("keypress keyup blur",function (event) {    
           $(this).val($(this).val().replace(/[^\d].+/, ""));
            if ((event.which < 48 || event.which > 57)) {
                event.preventDefault();
            }
        });