<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../functions.php";
db_conn();

if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'getEquipamentos':
		getEquipamentos();
		break;
		case 'pegarXML':
		pegarXML($_POST['de'], $_POST['ate'], $_POST['equipamentos']);
		break;
		case 'inserirCEST':
		inserirCEST();
		break;
	}
}

function getEquipamentos()
{
	$sql = "SELECT id, serial FROM sat_equipamentos WHERE Active = 1";
	$res = mssql_query($sql);
	while ($arr = mssql_fetch_assoc($res)) {
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function pegarXML($de, $ate, $equipamentos)
{
	$folder = './xml';
	if(!is_dir($folder)){
		mkdir($folder, 0777);
	}
	if (file_exists('xml.zip')) {
		unlink('xml.zip');
	}
	$zip = new ZipArchive();
	$tmp_file = "xml.zip";
	$zip->open($tmp_file, ZipArchive::CREATE);

	$de = explode('/', $de);
	$de = $de[2].'-'.$de[1].'-'.$de[0].' 00:00:00';
	$ate = explode('/', $ate);
	$ate = $ate[2].'-'.$ate[1].'-'.$ate[0].' 23:59:59';

	$equipamentos = rtrim($equipamentos, ',');
	$qry = "SELECT x.* FROM sat_xml x
	INNER JOIN sat_vendas v ON v.XmlSat_Id = x.id
	WHERE x.dtAlteracao BETWEEN '".$de."' AND '".$ate."'
	AND v.EquipamentoId IN (".$equipamentos.")";
	
	$res = mssql_query($qry);
	while ($arr = mssql_fetch_assoc($res)) {
		if ( base64_encode(base64_decode($arr['xml'])) === $arr['xml']){
			$arr['xml'] = base64_decode($arr['xml']);
		}
		$file = $folder.'/'.substr($arr['xml'],56, 47).".xml";
		@unlink($file);
		$fopen = @fopen($file, "w") or $erro = true;
		@fwrite($fopen, $arr['xml']) or $erro = true;
		@fclose($fopen) or $erro = true;
		$zip->addFile($file);
	}

	$zip->close();

	$files = glob($folder.'/*');
	foreach($files as $file){
		if(is_file($file))
			unlink($file);
	}
	rmdir($folder);
	if($erro){
		echo retornaJson(false, 'nok');
	}
	echo retornaJson(true, 'ok');
}

function inserirCEST() {
	$sql = "UPDATE
		    	prd_Produtos
			SET
			    prd_Produtos.stCest = B.nrCEST
			FROM
			    prd_Produtos A
			INNER JOIN
			    cad_Cest B
			ON 
			    A.nrNCM = B.nrNCM";
	$res = mssql_query($sql);

	if ($res) {
		echo retornaJson(true, 'ok');
	} else {
		echo retornaJson(false, 'nok');
	}
}