<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class CategoryPermission extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'op_Categorias';
    protected $primaryKey = 'idCategoria';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'id',
        'name',
        'updated_at'
    ];

    protected $maps = [
        'id' => 'idCategoria',
        'name' => 'stCategoria',
        'updated_at' => 'dtAlteracao',
    ];

    protected $hidden = [
        'idCategoria',
        'stCategoria',
        'dtAlteracao',
    ];

    protected $appends = [
        'id',
        'name',
        'updated_at'
    ];
}
