<?php


namespace App\Entities\Delivery;


use App\Entities\Nati\FichaTecnica;
use App\Entities\Nati\Product;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Item extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = "dlv_Itens";
    protected $primaryKey = ['idAtendimento', 'nrItem'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idAtendimento',
        'nrItem',
        'idProduto',
        'stOperador',
        'nrQuantidade',
        'dtData',
        'vrUnitario',
        'vrTotal',
        'stOBS',
        'stObservacoes',
        'stValores',
        'stCodigos',
        'stQuantidades',
        'flPrint',
        'idComanda',
        'dtAlteracao',
        'flAtivo',
        'produto',
        'dtAlteracao',
        'codigo',
        'descricao',
        'cfop',
        'ncm',
        'cstIcms',
        'aliquotaIcms',
        'cstPis',
        'aliquotaPis',
        'cstCofins',
        'aliquotaCofins',
        'ibpt',
        'medida',
        'desconto'
    ];

    protected $casts = [
        'flPrint' => 'boolean',
        'flAtivo' => 'boolean',
        'vrTotal' => 'float'
    ];

    public function produto()
    {
        return $this->hasOne(Product::class, 'idProduto', 'idProduto');
    }

    public function subItens()
    {
        return $this->hasMany(SubItem::class, ['idAtendimento', 'nrItem']);
    }

    public function Order()
    {
        return $this->belongsTo(Order::class, 'idAtendimento');
    }

    public function fichaTecnica()
    {
        return $this->hasMany(FichaTecnica::class, 'idProduto', 'idProduto');
    }

}
