<?php

namespace App\Entities;

use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Expense extends Model implements Transformable
{
    use TransformableTrait;

//    //    use HasCompositePrimaryKey;

    protected $table = 'cx_Despesas';
    protected $primaryKey = ['idDespesa', 'idAbertura'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idDespesa',
        'idAbertura',
        'stDescricao',
        'dtData',
        'vrDespesa',
        'idFormaPagamento',
        'flCompensado',
        'flAtivo',
        'dtAlteracao',
        'uuid'
    ];

    protected $hidden = [
//    'idDespesa',
//    'idAbertura',
//    'stDescricao',
//    'dtData',
//    'vrDespesa',
//    'idFormaPagamento',
//    'flCompensado',
//    'flAtivo',
//    'dtAlteracao'
    ];

    protected $appends = [
//    'id',
//    'id_open',
//    'description',
//    'date',
//    'value_despesa',
//    'id_payment',
//    'is_compensado',
//    'active',
//    'update_date',
    ];

    protected $maps = [
//    'id' => 'idDespesa',
//    'id_open' => 'idAbertura',
//    'description' => 'stDescricao',
//    'date' => 'dtData',
//    'value_despesa' => 'vrDespesa',
//    'id_payment' => 'idFormaPagamento',
//    'is_compensado' => 'flCompensado',
//    'active' => 'flAtivo',
//    'update_date' => 'dtAlteracao'
    ];

    protected $casts = [
        'flCompensado' => 'boolean',
        'flAtivo' => 'boolean',
        'vrDespesa' => 'float',
    ];

    public function gerenciador()
    {
        return $this->belongsTo(Manager::class, 'idAbertura', 'idAbertura');
    }

    public function formaPagamento()
    {
        return $this->belongsTo(PaymentMethod::class, 'idFormaPagamento', 'idFormaPagamento');
    }
}
