<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Database\Factories\MasterV8Factory;

class Master extends Model implements Transformable
{
    use TransformableTrait, HasFactory;

    protected $table = 'master';
    protected $primaryKey = 'idCliente';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idCliente',
        'idVendedor',
        'stCliente',
        'stEndereco',
        'stBairro',
        'stComplemento',
        'stTelefone1',
        'stTelefone2',
        'stMarketing',
        'stCNPJ',
        'stIE',
        'stLetraComanda',
        'vrDesconto',
        'vrVendaPermitida',
        'nrDigitosComanda',
        'vrAlertaSangria',
        'flSangriaObrigatoria',
        'stServidor',
        'stTipoComanda',
        'flAtivarAliquotaUnica',
        'stAliquotaUnica',
        'flAtivarModoRestaurante',
        'vrTaxaServico',
        'stAtivacao',
        'dtValidade',
        'stMesas',
        'flInformarGarcom',
        'flPizzaMeioMeio',
        'nrNumeroLogradouro',
        'stCidade',
        'stEstado',
        'stCEP',
        'flF',
        'nrDiasValidade',
        'flAtivarPosto',
        'nrPedido',
        'flExibirTaxaServico',
        'flFechamentoAnalitico',
        'flUsarPrecoAtual',
        'flVendaComComanda',
        'nrNFe',
        'vrDiversos',
        'dtAlteracao',
        'nrPedidoDelivery',
        'stChaveCR',
        'vrAliquotaPIS',
        'flTaxaServicoTerminal',
        'flTitulosDiarios',
        'stIM',
        'stIS',
        'indicadorNaturezaPJ',
        'vrAliquotaSimplesNacional',
        'flSimplesNacional',
        'flPainelAliquotas',
        'flFiscalManager',
        'flBloquearComandasInativas',
        'flBloquearPedidosDeliveryInativos',
        'subAccountToken'
    ];

    protected $casts = [
        'flSangriaObrigatoria' => 'boolean',
        'flAtivarAliquotaUnica' => 'boolean',
        'flAtivarModoRestaurante' => 'boolean',
        'flExibirTaxaServico' => 'boolean',
        'flTaxaServicoTerminal' => 'boolean',
        'flSimplesNacional' => 'boolean',
        'flVendaComComanda' => 'boolean',
        'flFechamentoAnalitico' => 'boolean',
        'flF' => 'boolean',
        'flPizzaMeioMeio' => 'boolean',
        'flInformarGarcom' => 'boolean',
        'vrDiversos' => 'float',
        'vrAliquotaSimplesNacional' => 'float',
        'flPainelAliquotas' => 'boolean',
        'flFiscalManager' => 'boolean',
        'flBloquearComandasInativas' => 'boolean',
        'flBloquearPedidosDeliveryInativos' => 'boolean'
    ];

    public function getNatiKeyAttribute()
    {
        $stChave[] = substr($this->activation_key, 0, 6);
        $stChave[] = date("d", strtotime($this->validate));
        $stChave[] = substr($this->activation_key, 6, 6);
        $stChave[] = substr($this->activation_key, 12, 6);
        $stChave[] = date("m", strtotime($this->validate));
        $stChave[] = substr($this->activation_key, 18, 6);
        $stChave[] = substr($this->activation_key, 24, 6);
        $stChave[] = date("Y", strtotime($this->validate));
        $stChave[] = substr($this->activation_key, 30, 2);

        $size = count($stChave);
        $assEletronica = "";
        for ($i = 0; $i < $size; $i++) {
            $assEletronica .= $stChave[$i];
            if (($i + 1) < $size) {
                $assEletronica .= "-";
            }
        }
        return $assEletronica;
    }

    public function generateTags(): array
    {
        return [
            'config'
        ];
    }

    protected $auditExclude = [
        'dtAlteracao',
        'dtValidade'
    ];

    /**
     * Create a new factory instance for the model.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return MasterV8Factory::new();
    }

}
