<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class OrderDeletedItem extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'mt_ItensExcluidos';
    protected $primaryKey = ['idAtendimento', 'nrItem'];
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idAtendimento',
        'nrItem',
        'idProduto',
        'stOperador',
        'nrQuantidade',
        'dtData',
        'idMicroterminal',
        'vrUnitario',
        'vrTotal',
        'dtAlteracao',
        'idOperadorExcluiu',
    ];

    protected $casts = [
        'vrUnitario' => 'float',
        'vrTotal' => 'float',
    ];

    public function item(){
        return $this->hasOne(Product::class, 'idProduto', 'idProduto');
    }
}
