<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class OrderDeletedTab extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'mt_AtendimentosExcluidos';
    protected $primaryKey = 'idAtendimento';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idAtendimento',
        'idComanda',
        'dtFirstDate',
        'dtLastdate',
        'flReturn',
        'idOperadorCaixa',
        'idOperadorExcluiu',
        'dtAlteracao',
    ];
    protected $casts = [
        'flReturn' => 'boolean',
    ];

    protected $appends = [
        'vrTotal'
    ];

    public function items()
    {
        return $this->hasMany(OrderDeletedItem::class, 'idAtendimento');
    }

    public function getVrTotalAttribute(){
        $items = $this->items()->get();

        return $items->reduce(function($total, $item){
            return $total + $item->vrTotal;
        }, 0);
    }
}
