<?php

namespace App\Http\Controllers;


use App\Entities\Logs;
use App\Services\Nati\AdjustProductTaxService;
use Illuminate\Http\Request;

class AdjustProductsTaxController extends Controller
{
    protected $service;
    protected $user;
    public function __construct(AdjustProductTaxService $service)
    {
        $this->service = $service;
        $this->user = auth()->user();
    }
    public function getProductsTaxByCategory(Request $request)
    {
        $params['categoria'] = $request->all()['categoria'];
        $params['order'] = $request->all()['order'];
        $params['page'] = $request->all()['page'];
        $params['limit'] = $request->all()['limit'];
        try {
            $products = $this->service->getProductsWithTaxByCategory($params);
            return response()->json($products);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }
    public function getProductsTaxByFilter(Request $request)
    {
        $params['filter'] = $request->all()['filter'];
        $params['order'] = $request->all()['order'];
        $params['page'] = $request->all()['page'];
        $params['limit'] = $request->all()['limit'];
        try {
            $products = $this->service->getProductsWithTaxByFilter($params);
            return response()->json($products);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }
    public function updateProductsTax(Request $request)
    {
        $products = $request->all();
        try {
            $user = auth()->user();
            Logs::writeLog($user->stApelido, "ALIQUOTA", 'O USUARIO [' . $user->stApelido . '] ATUALIZOU A ALIQUOTA DOS PRODUTOS DA CATEGORIA ID [' . $products[0]['idCategoria'] . ']');
            $this->service->updateProductsTax($products);
            return response()->json([
                'error' => false,
                'message' => 'Produtos atualizados com sucesso!'
            ], 200);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }
}
