<?php


namespace App\Http\Controllers\Delivery;

use App\Services\Sales\SalesService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Services\Delivery\SatService;
use App\Services\Delivery\OrderService;
use Illuminate\Routing\Controller;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\Delivery\DispatchCreateRequest;
use Modules\Delivery\Http\Requests\OrderCreateRequest;

class OrderController extends Controller
{
    protected $service;
    protected $salesService;
    protected $satService;

    public function __construct(OrderService $service, SatService $satService, SalesService $salesService)
    {
        $this->service = $service;
        $this->satService = $satService;
        $this->salesService = $salesService;
    }

    public function index()
    {
        try {
            $response = $this->service->getAll();
            return response()->json($response);
        }catch (\Exception $e){
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    /** get pending orders */
    public function getPendingOrders()
    {
        try {
            $response = $this->service->getPendingOrders();
            return response()->json($response);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 500);
        }
    }

    public function concluded($idOrder)
    {
        try {
            $result = $this->salesService->fromDelivery($idOrder);
            return response()->json($result);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }

    }

    /** get order by id */
    public function show($id)
    {
        try {
            $response = $this->service->get($id);
            return response()->json($response, 200);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }


    public function create(){
        return view('delivery.create');
    }

    /**
     * Store a newly created resource in storage.
     * @param OrderCreateRequest $request
     * @return JsonResponse
     */
    public function store(OrderCreateRequest $request)
    {
        try {

            $data = $this->service->create($request->all());
            return response()->json($data);
        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }

    }


    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function requestCfe($idAtendimeno)
    {
        try {
            $response = $this->satService->transmite($idAtendimeno);
            return response()->json($response, 201);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function getCfe($id)
    {
        try {
            return response()->json($this->satService->getCfe($id));
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return JsonResponse
     */
    public function dispatchOrReceive(DispatchCreateRequest $request)
    {
        try {
            return response()->json($this->service->dispatchOrReceive($request->all()), 200);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }
}
