<?php

namespace App\Http\Controllers\Financeiro;

use App\Entities\Financeiro\Conta;
use App\Http\Controllers\Controller;
use App\Services\ContaService;
use Illuminate\Http\Request;
use App\Http\Requests;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\ContaCreateRequest;
use App\Http\Requests\ContaUpdateRequest;
use Yajra\Datatables\Datatables;



class ContasController extends Controller
{

    protected $service;

    public function __construct(ContaService $service)
    {
        $this->service  = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        $contas = $this->service->get();

        return response()->json(['data' => $contas]);

    }

    public function getSubGrupos($idConta){

    }

//    public function dataTable()
//    {
//        $contas = Conta::with('subGrupo')->where('idConta', '>', 0);
//
//        return Datatables::of($contas)->make(true);
//    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ContaCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(ContaCreateRequest $request)
    {
        try {
            $conta = $this->service->insert($request->all());
            return response()->json([
                'message' => 'conta created',
                'data' => $conta
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }

    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $conta = $this->service->getById($id);
        return response()->json(['data' => $conta]);
    }


    /**
     * Display the specified resource.
     *
     * @param  int $subId
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function showBySubGroup($subId)
    {
        $response = $this->service->getBySubId($subId);
        return response()->json($response);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  ContaUpdateRequest $request
     * @param  string            $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(ContaUpdateRequest $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'conta Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        $this->service->delete($id);
        return response()->json(['message' => 'Contas deleted']);
    }
}
