<?php

namespace App\Http\Controllers;


use App\Services\ItemsService;

class ItemsController extends Controller
{

    protected $service;


    public function __construct(ItemsService $service)
    {

        $this->service = $service;
    }

    public function getSale($id, $id_open)
    {
        try {
            $medidas = $this->service->getDetails($id, $id_open);

            return response()->json($medidas);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }


    public function delete($idComanda, $nrItem)
    {
        try {
            $item = $this->service->delete($idComanda, $nrItem);

            $response = [
                'message' => 'Item deletado.',
                'data' => $item,
            ];
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
}
