<?php

namespace App\Http\Controllers;

use App\Services\LogsService;
use Illuminate\Http\Request;


/**
 * Class LogsController.
 *
 * @package namespace App\Http\Controllers;
 */
class LogsController extends Controller
{
    protected $service;

    public function __construct(LogsService $service)
    {
        $this->service  = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        try {
            return response()->json($this->service->all($request->query()));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function show($id)
    {
        try {
            return response()->json($this->service->getById($id));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }
}
