<?php

namespace App\Http\Controllers;

use App\Services\ReceiptFormTempService;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class ReceiptFormTempController extends Controller
{
    protected $service;

    public function __construct(ReceiptFormTempService $service)
    {
        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     * @return void
     */
    public function index()
    {
        //TODO
    }

    /**
     * Show the specified resource.
     * @param Request $request
     * @return JsonResponse
     */
    public function show(Request $request)
    {
        try {
            return response()->json($this->service->getDetails($request->all()));
        } catch (Exception $exception) {
            return response()->json([
                "error" => true,
                "message" => $exception->getMessage()
            ], 400);
        }
    }
}
