<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\ComandaRepository;
use App\Entities\Comanda;
use App\Validators\ComandaValidator;

/**
 * Class ComandaRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class ComandaRepositoryEloquent extends BaseRepository implements ComandaRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Comanda::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return ComandaValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
