<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\EmitenteRepository;
use App\Entities\Emitente;
use App\Validators\EmitenteValidator;

/**
 * Class EmitenteRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class EmitenteRepositoryEloquent extends BaseRepository implements EmitenteRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Emitente::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return EmitenteValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
