<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\PontoDeliveryRepository;
use App\Entities\PontoDelivery;
use App\Validators\PontoDeliveryValidator;

/**
 * Class PontoDeliveryRepositoryEloquent
 * @package namespace App\Repositories;
 */
class PontoDeliveryRepositoryEloquent extends BaseRepository implements PontoDeliveryRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return PontoDelivery::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return PontoDeliveryValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
