<?php

namespace App\Services;

use App\Entities\Logs;
use App\Repositories\LogsRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


class LogsService
{
    protected $repository;
    protected $validator;

    public function __construct(LogsRepository $repository)
    {
        $this->repository = $repository;
    }

    public function all($request)
    {
        $fd = Carbon::createFromFormat('d/m/Y', $request['start'])->toDateString();
        $first_date = $fd . ' 00:00:00';
        $ld = Carbon::createFromFormat('d/m/Y', $request['end'])->toDateString();
        $last_date = $ld . ' 23:59:59';
        $order = !isset($request['order']) ? 'DESC' : Str::upper($request['order']);
        $sort = $request['sort'] == '' ? 'dtData' : $request['sort'];
//        $software = $request['stsoftware'];

        $query = Logs::select('*');
            if($request['software'] != 'Todos'){
                $query->where('stSoftware', $request['software']);
            }
            $response = $query->whereBetween(DB::raw('cast(dtData AS DATE)'), [$first_date, $last_date])
            ->orderBy($sort, $order)
            ->paginate($request['limit'], $request['page']);

        return $response;
    }

    public function getById($id)
    {
        $result = [];
        $logs = $this->repository->orderBy('created_at', 'ASC')->findWhere(['auditable_id' => $id]);

        foreach($logs as $log) {
            $date = Carbon::parse($log['created_at'])->format('d/m/Y');

            $filter = collect($logs)->filter(function($log) use($date) {
                return Carbon::parse($log['created_at'])->format('d/m/Y') == $date;
            })->values();

            if(!collect($result)->contains('date', $date)){
                array_push($result, collect([
                    'date' => $date,
                    'logs' => $filter
                ]));
            }
        }

       return $result;
    }
}
