<?php


namespace App\Services\Nati;


use App\Entities\Nati\Impressora;
use App\Repositories\Nati\ImpressoraRepository;
use App\Validators\Nati\ImpressoraValidator;
use Prettus\Validator\Contracts\ValidatorInterface;
use Carbon\Carbon;

class ImpressorasService
{
    private $repository;
    private $validator;
    private $fichaTecnicaService;

    public function __construct(ImpressoraRepository $repository, ImpressoraValidator $validator, FichaTecnicaService $fichaTecnicaService)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->fichaTecnicaService = $fichaTecnicaService;
    }

    public function getById($id)
    {
        return $this->repository->find($id);
    }

    public function all()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        return $this->repository->orderBy('idPrint')->all();
    }

    public function create($request)
    {
        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_CREATE);

        $impressoras = [
            "idPrint" => $this->getNextId(),
            "stPrint" => $request['stPrint'],
            "stLocalPrint" => $request['stLocalPrint'],
            "stCanal" => $request['stCanal'],
            "stModelo" => $request['stModelo'],
            "flAgruparItens" => $request['flAgruparItens'],
            "dtAlteracao" => Carbon::now(),
            "nrColunas" => intval($request['nrColunas']),
            "nrAvancos" => intval($request['nrAvancos']),
        ];

        return $this->repository->create($impressoras);
    }

    public function update($request, $id)
    {
        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($request, $id);
    }

    public function delete($id)
    {
        $this->fichaTecnicaService->deleteByPrinter($id);
        return $this->repository->delete($id);
    }

    private function getNextId()
    {
        return $impressoras = Impressora::max('idPrint') + 1;
    }
}
