<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFrnFornecedoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('frn_Fornecedores')) {
            Schema::create('frn_Fornecedores', function (Blueprint $table) {
                $table->unsignedInteger('idFornecedor');
                $table->string('stNomeFornecedor', 60);
                $table->string('stContato', 60);
                $table->string('stEndereco', 60);
                $table->string('stNumero', 6);
                $table->string('stComplemento', 20);
                $table->string('stBairro', 30);
                $table->string('stEstado', 2);
                $table->string('stPais', 20);
                $table->string('stFone1', 15);
                $table->string('stFone2', 15);
                $table->string('stFax', 15);
                $table->string('stCNPJ', 16);
                $table->string('stIE', 16);
                $table->boolean('flAtivo')->default(true);
                $table->dateTime('dtUltimaCompra');
                $table->string('stCidade', 20);
                $table->string('stCMSN', 50);
                $table->string('stCFone1', 15);
                $table->string('stCFone2', 15);
                $table->string('stCEmail', 50);
                $table->string('stRazaoSocial', 50);
                $table->string('stSite', 50);
                $table->string('stEmail', 50);
                $table->boolean('flTipoEstoque')->default(false);
                $table->boolean('flVisible');
                $table->text('stObservacao');
                $table->string('stBanco', 20);
                $table->string('stAgencia', 7);
                $table->string('stConta', 15);
                $table->string('stContatoBanco', 50);
                $table->string('stTelefoneBanco', 20);
                $table->string('stSenha', 35);
                $table->string('stFaturamento', 15);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
                $table->string('stCep', 8);
                $table->primary('idFornecedor');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('frn_Fornecedores');
    }
}
