<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class V51Migrations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
//        Schema::disableForeignKeyConstraints();
        $this->changeNatModulesTable();
//        $this->changeTableProdutos();
//        $this->droptOldTables();
//        $this->changeCxRecebimentosTable();
//        $this->disableTiposFormasPagamento();
//        $this->updateTriggerFechamento();
//        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('int_conciliation');
    }

    private function changeCxRecebimentosTable()
    {
        Schema::table('cx_FichaRecebimentos_Temp', function (Blueprint $table) {
            if (!Schema::hasColumn('cx_FichaRecebimentos_Temp', 'adiquirente')) {
                $table->string('adiquirente', 10)->default('0000000000');
            };
            if (!Schema::hasColumn('cx_FichaRecebimentos_Temp', 'bandeira')) {
                $table->string('bandeira', 20)->default('');
            };
            if (!Schema::hasColumn('cx_FichaRecebimentos_Temp', 'autorizacao')) {
                $table->string('autorizacao', 40)->default('');
            };
            if (!Schema::hasColumn('cx_FichaRecebimentos_Temp', 'parcelas')) {
                $table->integer('parcelas', false)->default(1);
            };
            if (!Schema::hasColumn('cx_FichaRecebimentos_Temp', 'bin')) {
                $table->bigInteger('bin', false)->default(0);
            };
            if (!Schema::hasColumn('cx_FichaRecebimentos_Temp', 'nsu')) {
                $table->bigInteger('nsu', false)->default(0);
            };
            if (!Schema::hasColumn('cx_FichaRecebimentos_Temp', 'tipo_pagamento')) {
                $table->string('tipo_pagamento', 2)->default('00');
            };
            if (!Schema::hasColumn('cx_FichaRecebimentos_Temp', 'modalidade_pagamento')) {
                $table->string('modalidade_pagamento', 2)->default('00');
            };
            if (!Schema::hasColumn('cx_FichaRecebimentos_Temp', 'flSentConciliacao')) {
                $table->boolean('flSentConciliacao')->default(false);
            }

        });

        Schema::table('cx_FichaPagamentos', function (Blueprint $table) {
            if (!Schema::hasColumn('cx_FichaPagamentos', 'adiquirente')) {
                $table->string('adiquirente', 10)->default('0000000000');
            }
            if (!Schema::hasColumn('cx_FichaPagamentos', 'bandeira')) {
                $table->string('bandeira', 20)->default('');
            }
            if (!Schema::hasColumn('cx_FichaPagamentos', 'autorizacao')) {
                $table->string('autorizacao', 20)->default('');
            }
            if (!Schema::hasColumn('cx_FichaPagamentos', 'parcelas')) {
                $table->integer('parcelas', false)->default(1);
            }
            if (!Schema::hasColumn('cx_FichaPagamentos', 'bin')) {
                $table->bigInteger('bin', false)->default(0);
            }
            if (!Schema::hasColumn('cx_FichaPagamentos', 'nsu')) {
                $table->bigInteger('nsu', false)->default(0);
            }
            if (!Schema::hasColumn('cx_FichaPagamentos', 'tipo_pagamento')) {
                $table->string('tipo_pagamento', 2)->default('00');
            }
            if (!Schema::hasColumn('cx_FichaPagamentos', 'modalidade_pagamento')) {
                $table->string('modalidade_pagamento', 2)->default('00');
            }
            if (!Schema::hasColumn('cx_FichaPagamentos', 'flSentConciliacao')) {
                $table->boolean('flSentConciliacao')->default(false);
            }
        });
    }

    private function changeNatModulesTable()
    {
        Schema::table('nat_modules', function (Blueprint $table) {
            if (!Schema::hasColumn('nat_modules', 'relatorios')) {
                $table->string('relatorios', 1000)->change();
            }
        });
    }

    private function changeTableProdutos()
    {
//        DB::statement("IF EXISTS (SELECT * FROM sys.foreign_keys where name = 'FK_prd_Produtosprd_AliquotasSubstituicaoTributaria')
//            BEGIN
//            ALTER TABLE [dbo].[prd_Produtos]  DROP CONSTRAINT [FK_prd_Produtosprd_AliquotasSubstituicaoTributaria]
//            END");
//        DB::statement("IF EXISTS (SELECT * FROM sys.foreign_keys where name = 'FK_prd_Produtossped_TipoItem')
//            BEGIN
//            ALTER TABLE [dbo].[prd_Produtos]  DROP CONSTRAINT [FK_prd_Produtossped_TipoItem]
//            END");

        Schema::table('prd_Produtos', function (Blueprint $table) {
            if (Schema::hasColumn('prd_Produtos', 'flReduzirIcmsST')) {
                $table->dropForeign('DF_prd_Produtos_flReduzirIcmsST');
                $table->dropColumn('flReduzirIcmsST');
            }
            if (Schema::hasColumn('prd_Produtos', 'stCodigoANP')) {
                $table->dropColumn('stCodigoANP');
            }
            if (Schema::hasColumn('prd_Produtos', 'stNatRec')) {
                $table->dropColumn('stNatRec');
            }
            if (Schema::hasColumn('prd_Produtos', 'nrTipoItemSped')) {
                $table->dropColumn('nrTipoItemSped');
            }
            if (Schema::hasColumn('prd_Produtos', 'stSituacaoTributaria')) {
                $table->dropColumn('stSituacaoTributaria');
            }
            if (Schema::hasColumn('prd_Produtos', 'stClassificacaoFiscal')) {
                $table->dropColumn('stClassificacaoFiscal');
            }
            if (Schema::hasColumn('prd_Produtos', 'idAliquotaSubstituicaoTributaria')) {
                Schema::disableForeignKeyConstraints();
                $table->dropColumn('idAliquotaSubstituicaoTributaria');
                Schema::enableForeignKeyConstraints();
            }
            if (Schema::hasColumn('prd_Produtos', 'flAlterarBomba')) {
                $table->dropForeign('DF_prd_Produtos_flAlterarBomba');
                $table->dropColumn('flAlterarBomba');
            }
            if (Schema::hasColumn('prd_Produtos', 'flTributarCOFINS')) {
                $table->dropForeign('DF_prd_Produtos_flTributarCOFINS');
                $table->dropColumn('flTributarCOFINS');
            }
            if (Schema::hasColumn('prd_Produtos', 'flTributarPIS')) {
                $table->dropForeign('DF_prd_Produtos_flTributarPIS');
                $table->dropColumn('flTributarPIS');
            }
            if (Schema::hasColumn('prd_Produtos', 'stCST_COFINS')) {
                $table->dropForeign('DF_prd_Produtos_stCST_COFINS');
                $table->dropColumn('stCST_COFINS');
            }
            if (Schema::hasColumn('prd_Produtos', 'stCST_PIS')) {
                $table->dropForeign('DF_prd_Produtos_stCST_PIS');
                $table->dropColumn('stCST_PIS');
            }
            if (Schema::hasColumn('prd_Produtos', 'vrAliquotaIpi')) {
                $table->dropForeign('DF_prd_Produtos_vrAliquotaIpi');
                $table->dropColumn('vrAliquotaIpi');
            }

            if (Schema::hasColumn('prd_Produtos', 'nrReducaoIcmsSubstituicaoTributaria')) {
                $table->dropForeign('DF_prd_Produtos_nrReducaoIcmsSubstituicaoTributaria');
                $table->dropColumn('nrReducaoIcmsSubstituicaoTributaria');
            }
            if (Schema::hasColumn('prd_Produtos', 'nrReducaoIcms')) {
                $table->dropForeign('DF_prd_Produtos_nrReducaoIcms');
                $table->dropColumn('nrReducaoIcms');
            };
        });
    }

    private function droptOldTables()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('prd_Afericoes');
        Schema::dropIfExists('prd_LiberacaoBicos');
        Schema::dropIfExists('prd_VinculoBicos');
        Schema::dropIfExists('prd_VinculoClasses');
        Schema::dropIfExists('prd_VinculosClasse');
        Schema::dropIfExists('com_ItensFormulacao');
        Schema::dropIfExists('com_Formulacao');
        Schema::dropIfExists('com_ItensPedido');
        Schema::dropIfExists('com_Pedidos');
        Schema::dropIfExists('com_Produtos');
        Schema::dropIfExists('cx_Abastecimentos');
        Schema::dropIfExists('cx_NFe');
        Schema::dropIfExists('dlv_clientes_conta_assinada');
        Schema::dropIfExists('entrada_saidas');
        Schema::dropIfExists('lmc_Itens');
        Schema::dropIfExists('lmc_Livro');
        Schema::dropIfExists('lmc_Livros');
        Schema::dropIfExists('nfe_Municipios');
        Schema::dropIfExists('prd_Encerrantes');
        Schema::dropIfExists('cx_BrowserConfig');
        Schema::dropIfExists('prd_Abastecimentos');
        Schema::dropIfExists('sped_ComparacaoOC_NF');
        Schema::dropIfExists('sped_LancamentoServico');
        Schema::dropIfExists('sped_OrdemCompra_Itens');
        Schema::dropIfExists('sped_OrdemCompra_Movimentacoes');
        Schema::dropIfExists('sped_OrdemCompra_NF');
        Schema::dropIfExists('sped_OrdemCompra');
        Schema::dropIfExists('sped_RegimeApuracao');
        Schema::dropIfExists('sped_Contabilista');
        Schema::dropIfExists('tbt_Categorias');
        Schema::dropIfExists('tbt_ItensAdd');
        Schema::dropIfExists('tbt_Produto');
        Schema::dropIfExists('tbt_GrupoAdd');
        Schema::dropIfExists('tmd_Telemed');
        Schema::dropIfExists('com_Produtos');
        Schema::dropIfExists('cx_ItensOrcamento');
        Schema::dropIfExists('cx_Orcamentos');
        Schema::dropIfExists('cx_Transportadoras');
        Schema::dropIfExists('prd_ExpedicaoItens');
        Schema::dropIfExists('prd_Expedicao');
        Schema::dropIfExists('prd_GruposClasse');
        Schema::dropIfExists('prd_ItensClasse');
        Schema::dropIfExists('prd_ItensPedidoProducao');
        Schema::dropIfExists('dlv_CategoriaFuncionario');
        Schema::dropIfExists('cx_TipoBaixaContraVale');
        Schema::dropIfExists('prd_AliquotasSubstituicaoTributaria');
        Schema::dropIfExists('Tmp_com_Produtos');
        Schema::dropIfExists('prd_Classes');

        if (Schema::hasTable('prd_VinculosClasse')) {
            Schema::table('prd_Classes', function (Blueprint $table) {
                $table->dropForeign('DF_prd_VinculosClasse_dtAlteracao');

            });
            Schema::dropIfExists('prd_VinculosClasse');
        }
    }



    private function disableTiposFormasPagamento()
    {
        DB::statement("update cx_TiposFormaPagamento set flAtivo = 0 where idTipoForma in(3,5,8,9,10,11,13,15,16,17,18,19,20)");
    }

    private function updateTriggerFechamento()
    {
        DB::statement("
                ALTER TRIGGER [dbo].[FECHAMENTO_CAIXA]
                ON [dbo].[cx_Gerenciador]
                AFTER UPDATE
                AS
                BEGIN
                DECLARE @ID INT
                DECLARE @ABERTO BIT
                DECLARE @CONF BIT

                IF EXISTS (SELECT * FROM INSERTED)
                BEGIN
                SET NOCOUNT ON
                SET @ID = (SELECT idAbertura FROM INSERTED)
                SET @ABERTO = (SELECT flAberto FROM INSERTED)
                SET @CONF = (SELECT flConferencia FROM INSERTED)

                IF @ABERTO = 0 AND @CONF = 1
                BEGIN
                SET NOCOUNT ON
                INSERT INTO cx_Vendas SELECT * FROM cx_Vendas_Temp WHERE idAbertura = @ID
                INSERT INTO cx_Itens SELECT * FROM cx_Itens_Temp WHERE idAbertura = @ID
                INSERT INTO cx_FichaPagamentos SELECT * FROM cx_FichaRecebimentos_Temp WHERE idAbertura = @ID

                BEGIN
                SET NOCOUNT ON
                INSERT INTO [dbo].[int_conciliation] ([id],[codigo_tipo_produto],[codigo_autorizacao], [data_venda],[data_vencimento],[valor_venda_parcela],[total_venda],[parcela],[total_parcelas],[nsu],[terminal],[meio_captura],[flConciliado],[venda_id],[abertura_id],[created_at])
                select (select NEWID())as id,'00' as [codigo_tipo_produto], REPLACE(STR(autorizacao, 6), SPACE(1), '0') as [codigo_autorizacao]	 ,dtdata as [data_venda],'1900-01-01' as [data_vencimento], vrFormaPagamento as [valor_venda_parcela],vrFormaPagamento as [total_venda],0 as [parcela],0 as [total_parcelas],REPLACE(STR(nsu, 6), SPACE(1), '0') as [nsu],1 as [terminal],1 as [meio_captura],'0' as [flConciliado],idVenda as  [venda_id],idAbertura as [abertura_id],GETDATE() as [created_at]
                from cx_FichaPagamentos fp
                inner join cx_FormasPagamento f on f.idFormaPagamento = fp.idFormaPagamento
                inner join cx_TiposFormaPagamento t on f.idTipo = t.idTipoForma
                where idAbertura = @ID and f.idTipo = 2 and f.flAtivo = 1 and fp.flSentConciliacao = 0

                update cx_FichaPagamentos set flSentConciliacao = 1 where idAbertura = @ID and flAtivo = 1


                DELETE FROM cx_Vendas_Temp WHERE idAbertura = @ID
                DELETE FROM cx_Itens_Temp WHERE idAbertura = @ID
                DELETE FROM cx_FichaRecebimentos_Temp WHERE idAbertura = @ID

                IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_Vendas' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_Vendas SET dtAlteracao = GETDATE() WHERE idAbertura = @ID
                IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_Itens' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_Itens SET dtAlteracao = GETDATE() WHERE idAbertura = @ID
                IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_FichaPagamentos' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_FichaPagamentos SET dtAlteracao = GETDATE() WHERE idAbertura = @ID
                END
                END
                END
                END
        ");
    }
}
