<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePosConfigTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('pos_config')) {
            Schema::create('pos_config', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('posId', false, true)->unique();
                $table->string('name', 50);
                $table->integer('userId', false, true);
                $table->boolean('flDesenfila');
                $table->integer('paymentId', false, true);
                $table->boolean('closeAtTime')->default(false);
                $table->time('closingTime')->default("14:00:00");

                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pos_config');
    }
}
