<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdDataValidadeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_DataValidade')) {

            DB::statement('CREATE TABLE [dbo].[prd_DataValidade](
                  [dtAlteracao] [datetime] NOT NULL,
                  [idDataValidade] [int] NOT NULL,
                  [idProduto] [int] NOT NULL,
                  [idOperador] [smallint] NOT NULL,
                  [stNotaFiscal] [nvarchar](20) NOT NULL,
                  [flVerificado] [bit] NOT NULL,
                  [dtVerificacao] [datetime] NOT NULL,
                  [dtValidade] [datetime] NOT NULL,
                  CONSTRAINT [PK_prd_DataValidade] PRIMARY KEY CLUSTERED
                    (
                      [idDataValidade] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_DataValidade');

    }
}
