<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class Ncms2TableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [['ncm' => '72259990', 'description' => 'Outros lamin.de outs.ligas acos,l>=600mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72261100', 'description' => 'Lamin.de ligas acos ao silicio,l<600mm,graos orient.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72261900', 'description' => 'Outros lamin.de ligas acos ao silicio,l<600mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72262010', 'description' => 'Lamin.de ligas acos de corte rapido, l<600mm,1mm<=e<=4mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72262090', 'description' => 'Outros lamin.de ligas acos de corte rapido, l<600mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72269100', 'description' => 'Lamin.de outs.ligas de acos,a quente,l<600mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72269200', 'description' => 'Lamin.de outs.ligas de acos,a frio,l<600mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72269900', 'description' => 'Outros lamin.de outs.ligas de acos,l<600mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72271000', 'description' => 'Fio-maquina de ligas de acos de corte rapido', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72272000', 'description' => 'Fio-maquina de ligas de acos silicio-manganes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72279000', 'description' => 'Outros fio-maquinas de outs.ligas de acos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72281010', 'description' => 'Barras de ligas acos de corte rapido,lamin.etc.a quente', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72281090', 'description' => 'Outros barras de ligas acos de corte rapido', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72282000', 'description' => 'Barras de ligas de acos silicio-manganes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72283000', 'description' => 'Barras de outs.ligas de acos,lamin.etc.a quente', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72284000', 'description' => 'Barras de outs.ligas de acos,forjadas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72285000', 'description' => 'Barras de outs.ligas de acos,obtidas/ acabadas a frio', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72286000', 'description' => 'Outros barras de outs.ligas de acos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72287000', 'description' => 'Perfis de outs.ligas de acos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72288000', 'description' => 'Barras ocas de ligas de acos, para perfuracao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72292000', 'description' => 'Fios de ligas de acos silicio-manganes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '72299000', 'description' => 'Fios de outs.ligas de acos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73011000', 'description' => 'Estacas-pranchas de ferro ou aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73012000', 'description' => 'Perfis de ferro ou aco,obtidos por soldadura', 'aliquota_federal' => 7.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73021010', 'description' => 'Trilhos de ferro fundido/ferro/aco, 25kg/m<=p<=57kg/m', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73021090', 'description' => 'Outs.trilhos de vias ferreas,de ferro fundido/ ferro/aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73023000', 'description' => 'Agulhas e outs.elem.cruzam/desvio,de ferro fundido,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73024000', 'description' => 'Talas de juncao/placa apoio,etc.de ferro fund/ferro/aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73029000', 'description' => 'Outs.elementos de vias ferreas,de ferro fund/ferro/aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73030000', 'description' => 'Tubos e perfis ocos,de ferro fundido', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73041100', 'description' => 'Tubos de acos inox.sem costura,p/oleodutos/ gasodutos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73041900', 'description' => 'Outs.tubos de ferro/aco,s/costura,p/oleodutos/ gasodutos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73042200', 'description' => 'Outs.tubos de ferro/aco,s/cost.p/perf.extr. petroleo/gas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73042310', 'description' => 'Tubos de acos n/lig.s/cost.p/perfur.extrac. petroleo/gas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73042390', 'description' => 'Outs.tubos de ferro/aco,s/cost.p/perf.extr. petroleo/gas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73042400', 'description' => 'Tubos de acos inox.s/cost.p/revestim.de pocos, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73042910', 'description' => 'Tubos de acos n/lig.s/cost.p/revestim.de pocos, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73042931', 'description' => 'Tubos de ligas acos,s/cost.p/revest.pocos,etc. d<=229mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73042939', 'description' => 'Outs.tubos ligas acos,n/rev.s/cost.p/revest. pocos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73042990', 'description' => 'Outs.tubos ferro fund/ferro/aco,s/cost. p/rev. pocos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73043110', 'description' => 'Tubos de ferro/aco n/lig.s/cost.sec.circ. lam.frio, n/rev', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73043190', 'description' => 'Outs.tubos de ferro/aco n/lig.s/cost.sec.circ. lam. frio', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73043910', 'description' => 'Tubos de ferro/aco n/lig.s/cost.sec.circ. n/rev. d<=229mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73043920', 'description' => 'Tubos de ferro/aco n/lig.s/cost.sec.circ.rev. d<=229mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73043990', 'description' => 'Outros tubos de ferro/aco n/lig.s/cost.sec. circ.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73044110', 'description' => 'Tubos capilares de diâmetro exterior interior ou igual a 3mm e diâmetro interior inferior ou igual a 0,2mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73044190', 'description' => 'Outros tubos de acos inox.s/cost.sec.circ. lamin.a frio', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73044900', 'description' => 'Outros tubos de acos inox.s/cost.sec.circ.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73045111', 'description' => 'Tubos capilares de diâmetro exterior interior ou igual a 3mm e diâmetro interior inferior ou igual a 0,2mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73045119', 'description' => 'Outros tubos outs.ligas acos,s/cost.sec. circ. lam.frio, d<=229mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73045190', 'description' => 'Outs.tubos de outs.ligas acos,s/cost.sec.circ. lam.frio', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73045910', 'description' => 'Tubos de diâmetro exterior inferior ou igual a 229 mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73045990', 'description' => 'Outros tubos de outs.ligas acos,s/cost.sec. circ.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '73049011', 'description' => 'Outs.tubos/perfis ocos,de acos inox.s/cost. d<=229mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73049019', 'description' => 'Outs.tubos/perfis ocos,de ferro/aco,s/cost. d<=229mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73049090', 'description' => 'Outros tubos/perfis ocos,de ferro/aco, s/cost.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73051100', 'description' => 'Tubos ferro/aco,sold.long.arco,sec.circ. d>406mm,p/oleod', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73051200', 'description' => 'Outs.tubos ferro/aco,sold.long.sec.circ. d>406mm,p/oleod', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73051900', 'description' => 'Outs.tubos ferro/aco,sold.etc.sec.circ. d>406mm,p/oleod.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73052000', 'description' => 'Tubos ferro/aco,sold.etc.sec.circ. d>406mm, p/rev.pocos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73053100', 'description' => 'Outs.tubos ferro/aco,sold.longit.sec. circ. d>406mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73053900', 'description' => 'Outros tubos ferro/aco,sold.sec. circ. d>406mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73059000', 'description' => 'Outros tubos ferro/aco,rebitados,sec.circ. d>406mm', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73061100', 'description' => 'Tubos aços inoxidáveis,soldados, p/oleoduto/ gasodutos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73061900', 'description' => 'Tubos ferro/aco,rebitad/agrafad. p/oleoduto/ gasod.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73062100', 'description' => 'Tubos de revestimento de poços, de suprimento ou de produção, dos tipos utilizados na extração de petróleo ou de gás soldados de aços inoxidáveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73062900', 'description' => 'Tubos de revestimento de poços, de suprimento ou de produção, dos tipos utilizados na extração de petróleo ou de gás de ferro e aço', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73063000', 'description' => 'Outros tubos de ferro/aco n/lig.sold.sec. circ.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73064000', 'description' => 'Outros tubos de acos inox.sold.sec.circ.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73065000', 'description' => 'Outros tubos de outs.ligas acos,sold.etc. sec.circ.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73066100', 'description' => 'Outros tubos de ferro/aco,sold.secão quadrada ou retangular', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73066900', 'description' => 'Outros tubos de ferro/aco,sold.seção.n/circ.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73069010', 'description' => 'Outs.tubos e perfis ocos,de ferro/aco n/lig.sold.etc.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73069020', 'description' => 'Outs.tubos e perfis ocos,de acos inox.sold/ rebitad.etc.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73069090', 'description' => 'Outs.tubos e perfis ocos,de ferro/aco,sold/ rebitad.etc.', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73071100', 'description' => 'Acessorios moldados p/tubos de ferro fund. n/maleavel', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73071910', 'description' => 'Acessorios moldados p/tubos de ferro fund. maleav.d>50mm', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73071920', 'description' => 'Acessorios moldados p/tubos de aco', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '73071990', 'description' => 'Outs.acessorios p/tubos,moldad.de ferro fund/ferro/aco', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73072100', 'description' => 'Flanges p/tubos,de acos inoxidaveis', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73072200', 'description' => 'Cotovelos,curvas e luvas,roscados,p/tubos,de acos inox.', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73072300', 'description' => 'Acessorios para soldar topo a topo,tubos de acos inox.', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73072900', 'description' => 'Outros acessorios p/tubos,de acos inox.', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73079100', 'description' => 'Outs.flanges p/tubos,de ferro fundido/ferro ou aco', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73079200', 'description' => 'Outs.cotovelos,curvas,etc.roscados,p/tubos de ferro/aco', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73079300', 'description' => 'Outs.acessorios p/soldar topo a topo,tubos de ferro/aco', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73079900', 'description' => 'Outs.acessorios p/tubos de ferro fundido,ferro ou aco', 'aliquota_federal' => 5.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73081000', 'description' => 'Pontes e elementos de pontes,de ferro fundido/ferro/aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73082000', 'description' => 'Torres e porticos,de ferro fundido,ferro ou aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73083000', 'description' => 'Portas e janelas,etc.de ferro fundido,ferro ou aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73084000', 'description' => 'Material p/andaimes,armacoes,etc.ferro fund/ferro/aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73089010', 'description' => 'Chapas,barras,etc.p/construcoes,de ferro fund/ferro/aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73089090', 'description' => 'Outs.construcoes e suas partes,de ferro fund/ferro/aco', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73089090', 'description' => 'Telhas de aço', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73090010', 'description' => 'Reservatorios,etc.ferro/aco,c>300l,p/armaz. graos,solid.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73090020', 'description' => 'Recipientes isotermicos refrigerados a nitrogenio liquido,utilizados para semen, sangue, tecidos biologicos, etc', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73090090', 'description' => 'Outs.reservatorios,etc.de ferro/aco,c>300l, s/disp.term.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73101010', 'description' => 'Recipientes isotermicos refrigerados a nitrogenio liquido,utilizados para semen, sangue, tecidos biologicos, etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73101090', 'description' => 'Reservatorios,etc.de ferro/aco,50<=c<=300l, s/disp.term.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73102110', 'description' => 'Latas de ferro/aco,fecham.p/sold.crav. c<50l, p/prod.alim', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73102190', 'description' => 'Outros latas de ferro/aco,fecham.p/sold. crav.c<50l', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73102910', 'description' => 'Outs.reservatorios,etc.de ferro/aco,c<50l, p/prods.alim.', 'aliquota_federal' => 22.54, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73102920', 'description' => 'Recipientes isotermicos refrigerados a nitrogenio liquido,utilizados para semen, sangue, tecidos biologicos, etc', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73102990', 'description' => 'Outros reservatorios,etc.de ferro/aco,c<50l', 'aliquota_federal' => 22.54, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '73110000', 'description' => 'Recipientes de ferro/aco,p/gases comprimidos/ liquefeit.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73121010', 'description' => 'Cordas e cabos,de fios aco,revest.bronze/latao, p/eletr.', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '73121090', 'description' => 'Outs.cordas e cabos,de ferro/aco,n/isol.p/uso eletr.', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73121090', 'description' => 'Cordoalha de aço para concreto protendido', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73129000', 'description' => 'Trancas/lingas,etc.de ferro/aco,n/isol.p/uso eletr.', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73130000', 'description' => 'Arame farpado e outs.de ferro ou aco,util.em cercas', 'aliquota_federal' => 5.91, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73141200', 'description' => 'Tela metalica tecida,de acos inox.continua, s/fim.p/maqs', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73141400', 'description' => 'Outros telas metal.tecid.de acos inoxidaveis', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73141900', 'description' => 'Outros telas metal.tecid.de ferro ou aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73142000', 'description' => 'Grades/redes,de fios ferro/aco,sold.pto.inters. s>=100m2', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73142000', 'description' => 'De aço, não revestidas, para estruturas ou obras de concreto armado ou argamassa  armada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73143100', 'description' => 'Grades/redes,de fios ferro/aco,sold.pto.inters. galvan.', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73143900', 'description' => 'Outs.grades/redes,de fios ferro/aco,sold.pto. intersec.', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73143900', 'description' => 'De aço, não revestidas, para estruturas ou obras de concreto armado ou argamassa  armada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73144100', 'description' => 'Outros telas metals.etc.de fios ferro/aco, galvan.', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73144200', 'description' => 'Outs.telas metals.etc.de fios ferro/aco,recob. plasticos', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73144900', 'description' => 'Outros telas metals.etc.de fios ferro/aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73145000', 'description' => 'Chapas e tiras,distendidas,de ferro/aco', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73151100', 'description' => 'Corrente de rolos,de ferro fundido,ferro ou aco', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73151210', 'description' => 'Corrente de transmissao,de ferro fundido,ferro ou aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73151290', 'description' => 'Outs.correntes de elos articulados,de ferro ou aco', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73151900', 'description' => 'Partes de correntes de elos articulados,de ferro ou aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73152000', 'description' => 'Correntes antiderrapantes,de ferro fundido, ferro ou aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73158100', 'description' => 'Correntes de elos c/suporte,de ferro fundido/ ferro/aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73158200', 'description' => 'Correntes de elos soldados,de ferro fundido/ ferro/aco', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73158900', 'description' => 'Outs.correntes e cadeias,de ferro fundido, ferro ou aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73159000', 'description' => 'Partes de outs.correntes e cadeias,de ferro ou aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73160000', 'description' => 'Ancoras e fateixas e suas partes,de ferro fundido,etc.', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73170010', 'description' => 'Tachas de ferro fundido/ferro/aco,incl.cabeca out.mater', 'aliquota_federal' => 7.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73170020', 'description' => 'Grampos de fio curvado,de ferro fundido,ferro ou aco', 'aliquota_federal' => 7.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73170030', 'description' => 'Pontas ou dentes,de ferro fund/ferro/aco, p/maqs.texteis', 'aliquota_federal' => 7.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73170090', 'description' => 'Pregos,percevejos,artefs.semelh.de ferro fund/ferro/aco', 'aliquota_federal' => 7.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73181100', 'description' => 'Tira-fundos (roscados),de ferro fundido,ferro ou aco', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73181200', 'description' => 'Outs.parafusos de ferro fundido,ferro ou aco,p/madeira', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73181300', 'description' => 'Ganchos e armelas (pitoes),de ferro fundido/ ferro/aco', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73181400', 'description' => 'Parafusos perfurantes,de ferro fundido,ferro ou aco', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73181500', 'description' => 'Outs.parafusos/pinos/pernos,de ferro fundido/ ferro/aco', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73181600', 'description' => 'Porcas de ferro fundido,ferro ou aco', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73181900', 'description' => 'Outs.artefatos roscados,de ferro fundido, ferro ou aco', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73182100', 'description' => 'Arruelas de pressao ou seguranca,de ferro fundido,etc.', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73182200', 'description' => 'Outros arruelas de ferro fundido,ferro ou aco', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73182300', 'description' => 'Rebites de ferro fundido,ferro ou aco', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73182400', 'description' => 'Chavetas/cavilhas,etc.de ferro fundido,ferro ou aco', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73182900', 'description' => 'Outros artefatos n/roscados,de ferro fundido, ferro ou a', 'aliquota_federal' => 7.02, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73194000', 'description' => 'Outros alfinetes de uso manual,de ferro ou aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73199000', 'description' => 'Outs. agulhas de costura, agulhas de tricô, agulhas-passadoras, agulhas de crochê, furadores para bordar e artefatos semelhantes, para uso manual, de ferro ou aço', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73201000', 'description' => 'Molas de folhas e suas folhas,de ferro ou aco', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73201000', 'description' => 'Para ônibus ou caminhões, com espessura da folha igual ou superior a 9 mm', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73202010', 'description' => 'Molas helicoidais cilindricas,de ferro ou aco', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73202090', 'description' => 'Outros molas helicoidais de ferro ou aco', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73209000', 'description' => 'Outros molas de ferro ou aco', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73211100', 'description' => 'Apars.p/cozinhar/aquecer,de ferro,etc. combustiv.gasoso', 'aliquota_federal' => 7.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73211100', 'description' => 'Fogões de cozinha', 'aliquota_federal' => 5.58, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73211200', 'description' => 'Apars.p/cozinhar/aquecer,de ferro,etc. combustiv.liquido', 'aliquota_federal' => 7.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73211200', 'description' => 'Fogões de cozinha', 'aliquota_federal' => 5.58, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '73211900', 'description' => 'Apars.p/cozinhar/aquecer,de ferro,etc. combustiv.solido', 'aliquota_federal' => 7.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73211900', 'description' => 'Fogões de cozinha', 'aliquota_federal' => 5.58, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73218100', 'description' => 'Outs.aquecedores,etc.de ferro/aco,a gas/outs. combustiv.', 'aliquota_federal' => 7.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73218200', 'description' => 'Outs.aquecedores,etc.de ferro/aco,a combustiv. liquidos', 'aliquota_federal' => 7.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73218900', 'description' => 'Outs.aquecedores,etc.de ferro/aco,a combustiv. solidos', 'aliquota_federal' => 7.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73219000', 'description' => 'Partes de apars.p/cozinhar,etc.de ferro/aco, n/eletricos', 'aliquota_federal' => 7.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73219000', 'description' => 'De fogões de cozinha', 'aliquota_federal' => 5.58, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73221100', 'description' => 'Radiadores p/aquec.central,n/eletr.partes,de ferro fund', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73221900', 'description' => 'Radiadores p/aquec.central,n/eletr.partes,de ferro/aco', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73229010', 'description' => 'Geradores,etc.n/eletr.e partes,de ferro fund/ferro/aco, ...utilizados em veículos automotores', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73229090', 'description' => 'Outros (geradores,etc.n/eletr.e partes,de ferro fund/ferro/aco)', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73231000', 'description' => 'Palhas,esponjas,etc.de ferro/aco,p/limpeza/ polimento', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73231000', 'description' => 'Esponja de lã de aço', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73239100', 'description' => 'Outs.artefs.domesticos,de ferro fund.n/esmalt.e partes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73239200', 'description' => 'Outs.artefs.domesticos,de ferro fund.esmaltad. e partes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73239300', 'description' => 'Outs.artefs.domesticos,de acos inoxidaveis,e partes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73239400', 'description' => 'Outros artefs.domesticos,de ferro/aco, esmaltados,e part', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73239900', 'description' => 'Outros artefs.domesticos,de ferro fund/ferro/ aco,e part', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73241000', 'description' => 'Pias e lavatorios,de acos inoxidaveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73242100', 'description' => 'Banheiras de ferro fundido,mesmo esmaltadas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73242900', 'description' => 'Outros banheiras de ferro ou aco', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73249000', 'description' => 'Outs.artefs.de higiene/toucador,de ferro/aco,e partes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73251000', 'description' => 'Outs.obras moldadas de ferro fundido,nao maleavel', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73259100', 'description' => 'Esferas,etc.moldadas,de ferro fund/ferro/ aco,p/moinhos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73259910', 'description' => 'Outros obras moldadas,de aco', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73259990', 'description' => 'Outros obras moldadas,de ferro fundido ou ferro', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73261100', 'description' => 'Esferas,etc.forjadas/estampadas,de ferro/aco, p/moinhos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73261900', 'description' => 'Outros obras forjadas/estampadas,de ferro ou aco', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73262000', 'description' => 'Obras de fios de ferro ou aco', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73269010', 'description' => 'Calotas elípticas de aço ao níquel, segundo norma asme sa 353, dos tipos utilizados na fabricação de recipientes para gases comprimidos ou liquefeitos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '73269090', 'description' => 'Outros obras de ferro ou aco', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74010000', 'description' => 'Mates de cobre, cobre de cementacao (precipitado de cobre)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74020000', 'description' => 'Cobre n/refinado e anodos de cobre p/refin. eletrolitica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74031100', 'description' => 'Catodos de cobre refinado/seus elementos,em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74031200', 'description' => 'Barras de cobre refinado,p/obtencao fios,em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74031300', 'description' => 'Palanquilhas de cobre refinado,em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74031900', 'description' => 'Outros prods.de cobre refinado,em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74032100', 'description' => 'Ligas de cobre-zinco (latao),em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74032200', 'description' => 'Ligas de cobre-estanho (bronze),em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74032900', 'description' => 'Outros ligas de cobre,em forma bruta (exceto ligas-mães da posição 74.05)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74040000', 'description' => 'Desperdicios e residuos,de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74050000', 'description' => 'Ligas-maes de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74061000', 'description' => 'Pos de cobre,de estrutura nao lamelar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74062000', 'description' => 'Pos de cobre,de estrutura lamelar e escamas de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74071010', 'description' => 'Barras de cobre refinado', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74071021', 'description' => 'Perfis ocos de cobre refinado', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74071029', 'description' => 'Outros perfis de cobre refinado', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74072110', 'description' => 'Barras de ligas de cobre-zinco (latao)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74072120', 'description' => 'Perfis de ligas de cobre-zinco (latao)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74072910', 'description' => 'Barras de ligas de cobre-niquel ou cobre-niquel-zinco', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74072921', 'description' => 'Perfis ocos a base de ligas de cobre', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74072929', 'description' => 'Outros perfis de ligas de cobre', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74081100', 'description' => 'Fios de cobre refinado,maior dimensao da sec. transv>6mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '74081900', 'description' => 'Outros fios de cobre refinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74082100', 'description' => 'Fios de ligas de cobre-zinco (latao)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74082200', 'description' => 'Fios de ligas de cobre-niquel ou cobre-niquel-zinco', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74082911', 'description' => 'Fios de ligas de cobre-estanho (bronze) fosforoso', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74082919', 'description' => 'Outros fios de ligas de cobre-estanho (bronze)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74082990', 'description' => 'Outros fios de ligas de cobre', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74091100', 'description' => 'Chapas e tiras,de cobre refinado,esp>0.15mm,em rolos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74091900', 'description' => 'Outros chapas e tiras,de cobre refinado, esp>0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74092100', 'description' => 'Chapas e tiras de ligas cobre-zinco, esp>0.15mm,em rolos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74092900', 'description' => 'Outs.chapas e tiras,de ligas de cobre-zinco, esp>0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74093111', 'description' => 'Chapas e tiras comuma camada intermediária de liga de cobre-estanho ou cobre-estanho-chumbo, aplicada pot sinterização,em rolos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74093119', 'description' => 'Outras chapas e tiras de ligas cobre-estanho, e>0.15mm,em rolos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74093190', 'description' => 'Outras', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74093900', 'description' => 'Outs.chapas e tiras,de ligas de cobre-estanho, e>0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74094010', 'description' => 'Chapas e tiras de ligas cobre-niquel,etc, e>0.15mm,rolos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74094090', 'description' => 'Outs.chapas e tiras,de ligas de cobre-niquel, esp>0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74099000', 'description' => 'Chapas e tiras,de outs.ligas de cobre,esp>0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74101112', 'description' => 'Folha de cobre ref.s/suport.de espessura inferior ou igual a 0,04mm e uma resistividade elétrica inferior ou igual a 0,017241ohm.mm²/m', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74101113', 'description' => 'Outras folha de cobre ref.s/suport.outras, de espessura inferior ou igual a 0,04mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74101119', 'description' => 'Outras folha de cobre ref.s/suport.e<=0.07mm, pureza>=99.85%', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74101190', 'description' => 'Outs.folhas/tiras,de cobre refin.s/suporte, e<=0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74101200', 'description' => 'Folha e tira,de ligas de cobre,s/suporte, e<=0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74102110', 'description' => 'Folha de cobre ref.c/suport.p/circuit.impress. e<=0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74102120', 'description' => 'Folha de cobre ref.c/suport.poliest.etc. 0.012<e<=0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74102130', 'description' => 'Folha de cobre ref.com suporte isolante de resina fenólica e papel, dos tipos utilizados para circuitos impressos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74102190', 'description' => 'Outs.folhas/tiras,de cobre refin.c/suporte, e<=0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74102200', 'description' => 'Folha e tira,de ligas de cobre,c/suporte, e<=0.15mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74111010', 'description' => 'Tubos de cobre refinado,nao aletados nem ranhurados', 'aliquota_federal' => 6.72, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74111090', 'description' => 'Outros tubos de cobre refinado', 'aliquota_federal' => 6.72, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74112110', 'description' => 'Tubos de ligas de cobre-zinco,n/aletados n/ranhurados', 'aliquota_federal' => 6.72, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74112190', 'description' => 'Outros tubos de ligas de cobre-zinco', 'aliquota_federal' => 6.72, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74112210', 'description' => 'Tubos de ligas cobre-niquel,etc.n/aletados n/ranhurados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74112290', 'description' => 'Outs.tubos de ligas de cobre-niquel/cobre-niquel-zinco', 'aliquota_federal' => 6.72, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74112910', 'description' => 'Tubos de outs.ligas de cobre,n/aletados n/ranhurados', 'aliquota_federal' => 6.72, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74112990', 'description' => 'Tubos de outs.ligas de cobre', 'aliquota_federal' => 6.72, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74121000', 'description' => 'Acessorios para tubos de cobre refinado', 'aliquota_federal' => 6.44, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74122000', 'description' => 'Acessorios para tubos de ligas de cobre', 'aliquota_federal' => 6.44, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74130000', 'description' => 'Cordas,cabos,trancas,etc.de cobre,n/isolad. p/uso eletr.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74151000', 'description' => 'Tachas,pregos,etc.de cobre/ferro/aco,c/cabeca de cobre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74152100', 'description' => 'Arruelas de cobre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74152900', 'description' => 'Outros artefatos nao roscados,de cobre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74153300', 'description' => 'Parafusos,pinos ou pernos e porcas,de cobre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74153900', 'description' => 'Outros artefatos roscados,de cobre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74181000', 'description' => 'Art.uso dom.e part.,esponjas,esfregao,luva, etc. p/lim.cobre', 'aliquota_federal' => 6.18, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74182000', 'description' => 'Artefatos de cobre,de higiene/toucador e suas partes', 'aliquota_federal' => 8.11, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74191000', 'description' => 'Correntes e cadeias,de cobre,e suas partes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74199100', 'description' => 'Outs.obras de cobre,vazadas,moldadas, estampadas,forjad.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74199910', 'description' => 'Telas metalicas,de fios de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74199920', 'description' => 'Grades e redes,de fios de cobre,chapas e tiras,de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74199930', 'description' => 'Molas de cobre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74199990', 'description' => 'Outras obras de cobre', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '74199990', 'description' => 'Aparelhos não elétricos, para cozinhar ou aquecer, dos tipos utilizados para uso doméstico, e suas partes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75011000', 'description' => 'Mates de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '75012000', 'description' => 'Sinters de oxido niquel/prods.intermed. metal. niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75021010', 'description' => 'Catodos de niquel nao ligado,em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75021090', 'description' => 'Outros formas brutas de niquel,nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75022000', 'description' => 'Ligas de niquel,em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75030000', 'description' => 'Desperdicios e residuos,de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75040010', 'description' => 'Pos e escamas,de niquel nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75040090', 'description' => 'Outros pos e escamas,de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75051110', 'description' => 'Barras de niquel nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75051121', 'description' => 'Perfis ocos de niquel nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75051129', 'description' => 'Outros perfis de niquel nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75051210', 'description' => 'Barras de ligas de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75051221', 'description' => 'Perfis ocos de ligas de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75051229', 'description' => 'Outros perfis de ligas de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75052100', 'description' => 'Fios de niquel nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75052200', 'description' => 'Fios de ligas de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75061000', 'description' => 'Chapas,tiras e folhas,de niquel nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75062000', 'description' => 'Chapas,tiras e folhas,de ligas de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75071100', 'description' => 'Tubos de niquel nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75071200', 'description' => 'Tubos de ligas de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75072000', 'description' => 'Acessorios para tubos de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75081000', 'description' => 'Telas metalicas e grades,de fios de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75089010', 'description' => 'Cilindros ocos de seção variável, obtidos por centrifugação, dos tipos utilizados em reformadores estequiométricos de gás natural', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '75089090', 'description' => 'Outros obras de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76011000', 'description' => 'Aluminio nao ligado em forma bruta', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76012000', 'description' => 'Ligas de aluminio em forma bruta', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76020000', 'description' => 'Desperdicios e residuos,de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76031000', 'description' => 'Pos de aluminio,de estrut.nao lamelar', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76032000', 'description' => 'Pos de aluminio,de estrut.lamelar/escamas de aluminio', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76041010', 'description' => 'Barras de aluminio nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76041021', 'description' => 'Perfis ocos de aluminio nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76041029', 'description' => 'Outros perfis de aluminio nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76042100', 'description' => 'Perfis ocos de ligas de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76042911', 'description' => 'Barras de ligas aluminio,forjad.sec.circ. 400<=d<=760mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76042919', 'description' => 'Outros barras de ligas de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76042920', 'description' => 'Outros perfis de ligas de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76051110', 'description' => 'Fios de aluminio n/lig.sec. transv>7mm,re<=0.0283ohm.mm2', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76051190', 'description' => 'Outros fios de aluminio n/lig.dim.sec.transv>7mm', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76051910', 'description' => 'Outs.fios de aluminio n/lig.resist.eletr<=0.283 ohm.mm2', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76051990', 'description' => 'Outros fios de aluminio,n/lig.', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76052110', 'description' => 'Fios de ligas aluminio,sec. transv>7mm, re<=0.0328ohm.mm2', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76052190', 'description' => 'Outros fios de ligas aluminio,dim.sec. transv>7mm', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76052910', 'description' => 'Outs.fios de ligas aluminio,resist.eletr <=0.0328ohm.mm2', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76052990', 'description' => 'Outros fios de ligas aluminio', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76061110', 'description' => 'Chapas/tiras,de aluminio n/lig.e>0.2mm, quadradas/ retang, c/ teores magnésio >=4% ... envernizadas em ambas as faces', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76061190', 'description' => 'Outras (chapas/tiras,de aluminio n/lig.e>0.2mm, quadradas/ retang)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76061210', 'description' => 'Chapas de ligas aluminio,0.2<e<=0.3mm,l>=1468mm, envern.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76061220', 'description' => 'Outs.chapas de aluminio n/lig.e>0.2mm,quadr.teor silic.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76061290', 'description' => 'Outros chapas e tiras,de ligas aluminio, esp>0.2mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76069100', 'description' => 'Outs.chapas e tiras,de aluminio nao ligado, esp>0.2mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76069200', 'description' => 'Outs.chapas e tiras,de ligas de aluminio, esp>0.2mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76071110', 'description' => 'Folhas/tiras,de aluminio,s/suporte,laminadas, e<=0.2mm, c/ teor em peso de silicio >= 0,05% ...', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76071190', 'description' => 'Outras (folhas/tiras,de aluminio,s/suporte,laminadas, e<=0.2mm)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76071910', 'description' => 'Folhas/tiras,de aluminio,s/suporte,gravad. e<=110microns', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '76071990', 'description' => 'Outs.folhas e tiras,de aluminio,s/suporte, esp<=0.2mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76072000', 'description' => 'Folhas/tiras,de aluminio,c/suporte,esp<=0.2mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76081000', 'description' => 'Tubos de aluminio nao ligado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76082010', 'description' => 'Sem costura, extrudados e trefilados, segundo norma astm b210, de seção circular, de liga aa 6061 (aluminium association), com limite elástico aparente de johnson (jael) superior a 3.000nm, segundo norma sae ae7, diâmetro externo superior ou igual a 8', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76082090', 'description' => 'Outs tubos de ligas de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76090000', 'description' => 'Acessorios para tubos de aluminio', 'aliquota_federal' => 5.15, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76101000', 'description' => 'Portas,janelas,seus caixilhos,alizares,etc.de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76109000', 'description' => 'Construcoes/outs.partes,chapas,barras,etc.de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76110000', 'description' => 'Reservatorios,etc.de aluminio,c>300l,s/disp. mecan/term.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76121000', 'description' => 'Recipientes tubul.flexiv.de aluminio,c<=300l, s/disp.mec', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76129011', 'description' => 'Recipientes tubul.de aluminio,c<=700cm3, p/aerossois', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76129012', 'description' => 'Recipientes isotermicos refrigerados a nitrogenio liquido,utilizados para semen, sangue, tecidos biologicos, etc', 'aliquota_federal' => 22.54, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76129019', 'description' => 'Outros recipientes tubulares,de aluminio,c<=300l', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76129090', 'description' => 'Outs.reservator.etc.de aluminio,c<=300l,s/ disp. mec.term', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76130000', 'description' => 'Recipientes p/gases comprimidos/liquefeitos,de aluminio', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76141010', 'description' => 'Cordas/cabos,de aluminio,c/alma de aco,n/isol. p/eletr.', 'aliquota_federal' => 9.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76141090', 'description' => 'Trancas,etc.de aluminio,c/alma de aco,n/isol. p/eletr.', 'aliquota_federal' => 9.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76149010', 'description' => 'Outros cabos de aluminio,n/isol.p/uso eletr.', 'aliquota_federal' => 9.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76149090', 'description' => 'Outros cordas,trancas,etc.n/isol.p/uso eletr.', 'aliquota_federal' => 9.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76151000', 'description' => 'Art.uso dom.e part.,esponjas,esfregao, luva.p/limpeza, de aluminio', 'aliquota_federal' => 6.18, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76152000', 'description' => 'Artefatos de aluminio,de higiene/toucador e suas partes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76161000', 'description' => 'Tachas,pregos,escapulas,parafusos,pinos,etc.de aluminio', 'aliquota_federal' => 5.93, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76169100', 'description' => 'Telas metalicas,grades e redes,de fios de aluminio', 'aliquota_federal' => 5.93, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '76169900', 'description' => 'Outros obras de aluminio', 'aliquota_federal' => 5.10, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78011011', 'description' => 'Chumbo refinado,eletrolitico,em lingotes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78011019', 'description' => 'Outs.formas brutas de chumbo refinado, eletrolitico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78011090', 'description' => 'Outros formas brutas de chumbo refinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78019100', 'description' => 'Chumbo c/antimonio como seg.elem.predom.em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78019900', 'description' => 'Outros formas brutas de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78020000', 'description' => 'Desperdicios e residuos,de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78041100', 'description' => 'Folhas e tiras,de chumbo,espessura<=0.2mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78041900', 'description' => 'Chapas e outs.folhas e tiras,de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78042000', 'description' => 'Pos e escamas de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78060010', 'description' => 'Barras,perfis e fios,de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78060020', 'description' => 'Tubos e seus acessorios,de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '78060090', 'description' => 'Outros obras de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79011111', 'description' => 'Zinco n/lig.cont.zinco>=99.99%, eletrolitico,em lingotes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79011119', 'description' => 'Outs.formas brutas de zinco n/lig. zinco>=99.99%, eletrol', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79011191', 'description' => 'Outros lingotes de zinco n/lig.cont. zinco>=99.99%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79011199', 'description' => 'Outs.formas brutas de zinco n/lig.cont. zinco>=99.99%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79011210', 'description' => 'Zinco n/lig.cont.zinco<99.99%,em lingotes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79011290', 'description' => 'Outs.formas brutas de zinco n/lig.cont. zinco<99,99%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79012010', 'description' => 'Ligas de zinco,em lingotes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79012090', 'description' => 'Outros formas brutas de ligas de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79020000', 'description' => 'Desperdicios e residuos,de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79031000', 'description' => 'Poeiras de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79039000', 'description' => 'Pos e escamas,de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79040000', 'description' => 'Barras,perfis e fios,de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79050000', 'description' => 'Chapas,folhas e tiras,de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79070010', 'description' => 'Tubos e seus acessorios,de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '79070090', 'description' => 'Outros obras,de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '80011000', 'description' => 'Estanho nao ligado,em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '80012000', 'description' => 'Ligas de estanho,em forma bruta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '80020000', 'description' => 'Desperdicios e residuos,de estanho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '80030000', 'description' => 'Barras,perfis e fios,de estanho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '80070010', 'description' => 'Chapas,folhas e tiras,de estanho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '80070020', 'description' => 'Pos e escamas,de estanho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '80070030', 'description' => 'Tubos e seus acessorios,de estanho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '80070090', 'description' => 'Outros obras de estanho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81011000', 'description' => 'Pos de tungstenio (volframio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81019400', 'description' => 'Tungstênio em formas brutas, incluídas as barras simplesmente obtidas por sinterização', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81019600', 'description' => 'Fios de tungstenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81019700', 'description' => 'Desperdícios ou resíduos de tungstenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81019910', 'description' => 'Obras de tungstenio,util.p/fabr.de contatos eletr.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81019990', 'description' => 'Outros obras de tungstenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81021000', 'description' => 'Pos de molibdenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81029400', 'description' => 'Molibdenio em forma bruta,incl.barra sinter,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81029500', 'description' => 'Barras e perfis/chapas/tiras/folhas,de molibdenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81029600', 'description' => 'Fios de molibdenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81029700', 'description' => 'Desperdicios ou residuos de molibdenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81029900', 'description' => 'Outros obras de molibdenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81032000', 'description' => 'Tantalo em forma bruta,incl.barra sinter.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81033000', 'description' => 'Desperdicios e residuos de tantalo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81039000', 'description' => 'Outros obras de tantalo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81041100', 'description' => 'Magnesio em forma bruta,cont.magnesio>=99.80%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81041900', 'description' => 'Outros formas brutas de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81042000', 'description' => 'Desperdicios e residuos,de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81043000', 'description' => 'Residuos de torno,granulos calibrados e pos de magnesio', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81049000', 'description' => 'Outros obras de magnesio', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81052010', 'description' => 'Cobalto em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81052021', 'description' => 'Pos de ligas à base de cobalto-cromo-tungstênio (volfrâmio) (estelites)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81052029', 'description' => 'Outros pos de cobalto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81052090', 'description' => 'Outs mates de cobalto,outs.prod.intermed. metal. cobalto,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81053000', 'description' => 'Desperdicios e residuos de cobalto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81059010', 'description' => 'Chapas,folhas,tiras,fios,hastes,etc.de cobalto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81059090', 'description' => 'Outros obras de cobalto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81060010', 'description' => 'Bismuto em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81060090', 'description' => 'Obras de bismuto,desperdicios e residuos,de bismuto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81072010', 'description' => 'Cadmio em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81072020', 'description' => 'Pos de cadmio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81073000', 'description' => 'Desperdicios e residuos do cadmio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81079000', 'description' => 'Obras de cadmio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81082000', 'description' => 'Titanio em forma bruta,pos de titanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81083000', 'description' => 'Desperd.resid.de titanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81089000', 'description' => 'Obras de titanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81092000', 'description' => 'Zirconio em forma bruta, pos de zirconio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81093000', 'description' => 'Desperd.resid.de zirconio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81099000', 'description' => 'Obras de zirconio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81101010', 'description' => 'Antimonio em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81101020', 'description' => 'Pós de antimonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81102000', 'description' => 'Desperdicios e residuos,de antimonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81109000', 'description' => 'Obras de antimonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81110010', 'description' => 'Manganes em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81110020', 'description' => 'Chapas,folhas,tiras,fios,hastes,etc.de manganes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81110090', 'description' => 'Outs.obras de manganes,desperd.e residuos de manganes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81121200', 'description' => 'Berilio em forma bruta, pos de berilio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '81121300', 'description' => 'Desperd.resid.de berilio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81121900', 'description' => 'Obras de berilio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81122110', 'description' => 'Cromo em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81122120', 'description' => 'Pós de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81122200', 'description' => 'Desperdicios e residuos,de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81122900', 'description' => 'Obras de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81125100', 'description' => 'Galio em bruto, pós de gálio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81125200', 'description' => 'Desperd.resid.de gálio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81125900', 'description' => 'Obras e outs.prods.do galio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81129200', 'description' => 'Germanio, vanadio, hafnio,indio,niobio,etc.em bruto,desperd.resid.po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81129900', 'description' => 'Obras de germanio, vanadio, hafnio,indio, niobio, renio e talio, etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81130010', 'description' => 'Chapas,folhas,tiras,fios,hastes.etc.de ceramais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '81130090', 'description' => 'Outs.obras de ceramais,desperd.e residuos de ceramais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82011000', 'description' => 'Pas de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82013000', 'description' => 'Alvioes,picaretas,enxadas,sachos,etc.de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82014000', 'description' => 'Machados,podoes e outs.ferram.c/gume,de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82015000', 'description' => 'Tesouras de podar,manipuladas c/1 mao,de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82016000', 'description' => 'Tesouras p/sebes,etc.manipul.c/2 maos,de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82019000', 'description' => 'Outs.ferram.manuais,p/agricultura,etc.de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82021000', 'description' => 'Serras manuais,de metais comuns', 'aliquota_federal' => 7.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82022000', 'description' => 'Folha de serras de fita,de metais comuns', 'aliquota_federal' => 7.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82023100', 'description' => 'Folha de serras circ.de metais comuns,parte operant.aco', 'aliquota_federal' => 7.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82023900', 'description' => 'Outs.folhas de serras circ.de metais comuns,incl.partes', 'aliquota_federal' => 7.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82024000', 'description' => 'Correntes cortantes de serras,de metais comuns', 'aliquota_federal' => 7.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82029100', 'description' => 'Folha de serras retil.de metais comuns,p/trabalh.metais', 'aliquota_federal' => 7.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82029910', 'description' => 'Folha de serras,reta,n/dent.de met.comuns,p/serr.pedras', 'aliquota_federal' => 7.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82029990', 'description' => 'Outros folhas de serras,de metais comuns', 'aliquota_federal' => 7.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82031010', 'description' => 'Limas e grosas,de metais comuns', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82031090', 'description' => 'Outs.ferram.manuais semelh.limas/grosas,de met.comuns', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82032010', 'description' => 'Alicates de metais comuns', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82032090', 'description' => 'Tenazes,pincas,ferram.manuais semelh.de metais comuns', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82033000', 'description' => 'Cisalhas p/metais,ferram.manuais semelh.de met.comuns', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82034000', 'description' => 'Corta-tubos e ferram.manuais semelh.de metais comuns', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82041100', 'description' => 'Chaves de porcas,manuais,de abert.fixa,de metais comuns', 'aliquota_federal' => 7.83, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82041200', 'description' => 'Chaves de porcas,manuais,de abert.variav.de met.comuns', 'aliquota_federal' => 7.83, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82042000', 'description' => 'Chaves de caixa intercambiav.incl.c/cabos,de met.comuns', 'aliquota_federal' => 7.83, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82051000', 'description' => 'Ferramentas manuais de furar/roscar,de metais comuns', 'aliquota_federal' => 7.09, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82052000', 'description' => 'Martelos e marretas,manuais,de metais comuns', 'aliquota_federal' => 7.09, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82053000', 'description' => 'Plaina/ferram.manuais cort.de met.comuns,p/trab.madeira', 'aliquota_federal' => 7.09, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82054000', 'description' => 'Chaves de fenda,manuais,de metais comuns', 'aliquota_federal' => 7.09, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82055100', 'description' => 'Outros ferramentas manuais,uso domestico,de metais comu', 'aliquota_federal' => 7.09, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82055900', 'description' => 'Outros ferramentas manuais,de metais comuns', 'aliquota_federal' => 7.09, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82056000', 'description' => 'Lamparinas/lampadas de soldar,e semelh.de metais comuns', 'aliquota_federal' => 7.09, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82057000', 'description' => 'Tornos de apertar,sargentos e semelh.de metais comuns', 'aliquota_federal' => 7.09, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82059000', 'description' => 'Outros incluidos os sortido de torno, bigorna,etc. manual/pedal,  de met.comuns', 'aliquota_federal' => 7.09, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82060000', 'description' => 'Sortido de serras,limas,etc.uso manual,de metais comuns', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82071300', 'description' => 'Ferramentas de perfur.de met.comuns,parte oper.ceramais', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82071900', 'description' => 'Outs.ferramentas de perfur.etc.de met.comuns.incl.parte', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '82072000', 'description' => 'Fieiras de met.comuns,de estiragem/extrusao p/metais', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82073000', 'description' => 'Ferramentas de embutir/estampar/puncionar,de met.comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '82074010', 'description' => 'Ferramentas de roscar interiormente,de metais comuns', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82074020', 'description' => 'Ferramentas de roscar exteriormente,de metais comuns', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82075011', 'description' => 'Brocas helicoidais,d<=52mm,de met.comuns, incl.diamantad', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '82075019', 'description' => 'Outros brocas de metais comuns,mesmo diamantadas', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82075090', 'description' => 'Outros ferramentas de furar,de metais comuns', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82076000', 'description' => 'Ferramentas de mandrilar ou de brochar,de metais comuns', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82077010', 'description' => 'Ferramentas de fresar de topo,de metais comuns', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82077020', 'description' => 'Ferramentas para cortar engrenagens,de metais comuns', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82077090', 'description' => 'Outros ferramentas de fresar,de metais comuns', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82078000', 'description' => 'Ferramentas de tornear,de metais comuns', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82079000', 'description' => 'Outs.ferramentas intercambiaveis,de metais comuns', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82081000', 'description' => 'Facas/laminas cort.de metais comuns,p/trab. metais', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82082000', 'description' => 'Facas/laminas cort.de metais comuns,p/trab. madeira', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82083000', 'description' => 'Facas/laminas cort.de metais comuns,p/apars. cozinha,etc', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82084000', 'description' => 'Facas/laminas cort.de met.comuns,p/maqs. agricultura,etc', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82084000', 'description' => 'Navalhas triangulares  faquinhas serrilhadas  de uso em colheitadeiras agrícolas', 'aliquota_federal' => 5.93, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82089000', 'description' => 'Outs.facas/laminas cort.de met.comuns,p/ maqs. apar.mecan', 'aliquota_federal' => 7.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82090011', 'description' => 'Plaquetas/pastilhas,intercamb.de ceramais, p/ferramentas', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82090019', 'description' => 'Outs.plaquetas/pastilhas,de ceramais, n/montad. p/ferram.', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82090090', 'description' => 'Varetas,pontas,etc.de ceramais,n/montados, p/ferramentas', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82100010', 'description' => 'Moinhos mecan.de acion.manual,p<=10kg, p/alimentos,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82100090', 'description' => 'Outs.apars.mecan.acion.manual,p<=10kg,p/alimentos,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82111000', 'description' => 'Facas de lamina cortante/serrilhad.e laminas,em sortido', 'aliquota_federal' => 9.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82119100', 'description' => 'Facas de mesa,de lamina fixa,de metais comuns', 'aliquota_federal' => 9.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82119210', 'description' => 'Facas de cozinha/acougue,de lamina fixa,de met.comuns', 'aliquota_federal' => 9.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82119220', 'description' => 'Facas para caca,de lamina fixa,de metais comuns', 'aliquota_federal' => 9.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82119290', 'description' => 'Outros facas de lamina fixa,de metais comuns', 'aliquota_federal' => 9.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82119310', 'description' => 'Facas podadeiras e suas partes,de metais comuns', 'aliquota_federal' => 9.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82119320', 'description' => 'Canivetes c/uma/varias laminas/outs.pecas,de met.comuns', 'aliquota_federal' => 9.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82119390', 'description' => 'Outros facas exc.de lamina fixa,de metais comuns', 'aliquota_federal' => 9.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82119400', 'description' => 'Laminas para facas,de metais comuns', 'aliquota_federal' => 8.65, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82119500', 'description' => 'Cabos de metais comuns p/facas de metais comuns', 'aliquota_federal' => 8.65, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82121010', 'description' => 'Navalhas de barbear,de metais comuns', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82121020', 'description' => 'Apars.de barbear,nao eletricos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82122010', 'description' => 'Laminas de barbear,de seguranca,de metais comuns', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82122020', 'description' => 'Esbocos de laminas,em tiras,de metais comuns', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82129000', 'description' => 'Outs.partes de navalhas/apars.de barbear,de met.comuns', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82130000', 'description' => 'Tesouras e suas laminas,de metais comuns', 'aliquota_federal' => 9.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82141000', 'description' => 'Espatulas,abre-cartas,etc.e suas laminas,de met.comuns', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82142000', 'description' => 'Utensil/sortido utensil.manicuro/pedicuro,de met.comuns', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82149010', 'description' => 'Maquinas de tosquiar e suas partes,de metais comuns', 'aliquota_federal' => 8.65, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82149090', 'description' => 'Outs.artigos de cutelaria de met.comuns,e suas partes', 'aliquota_federal' => 8.65, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82151000', 'description' => 'Sortido de colher,etc.de met.comuns,c>=1 prat/dour/plat', 'aliquota_federal' => 6.18, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82152000', 'description' => 'Outs.sortidos de colher,garfo,concha,etc.de met.comuns', 'aliquota_federal' => 6.18, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82159100', 'description' => 'Colher,garfo,concha,etc.de met.comuns,pratead/dour/plat', 'aliquota_federal' => 6.18, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82159910', 'description' => 'Colheres,garfos,conchas,escumadeiras,etc.de acos inox.', 'aliquota_federal' => 6.18, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '82159990', 'description' => 'Outs.colheres,garfos,conchas,etc.de metais comuns', 'aliquota_federal' => 6.18, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83011000', 'description' => 'Cadeados de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83012000', 'description' => 'Fechaduras de metais comuns,p/veiculos automoveis', 'aliquota_federal' => 13.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83013000', 'description' => 'Fechaduras de metais comuns,p/moveis', 'aliquota_federal' => 4.65, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83014000', 'description' => 'Outros fechaduras e ferrolhos,de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83015000', 'description' => 'Fechos e armacoes c/fecho,c/fechadura,de metais comuns', 'aliquota_federal' => 4.65, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83016000', 'description' => 'Partes de cadeados,fechaduras,etc.de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83017000', 'description' => 'Chaves de metais comuns,apresentadas isoladamente', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83021000', 'description' => 'Dobradicas de metais comuns,de qq.tipo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83022000', 'description' => 'Rodizios com armacao,de metais comuns', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '83023000', 'description' => 'Outs.guarnicoes,etc.de metais comuns,p/veics .automoveis', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83024100', 'description' => 'Outs.guarnicoes,etc.de metais comuns, p/construcoes', 'aliquota_federal' => 5.10, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83024200', 'description' => 'Outros guarnicoes,etc.de metais comuns, p/moveis', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83024900', 'description' => 'Outros guarnicoes,etc.de metais comuns', 'aliquota_federal' => 4.65, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83025000', 'description' => 'Pateras,porta-chapeus,cabides,etc.de metais comuns', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83026000', 'description' => 'Fechos automaticos de metais comuns, p/portas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83030000', 'description' => 'Cofres-fortes,portas blindadas,etc.de metais comuns', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83040000', 'description' => 'Classificadores/outs.artefs.de escritorio,de met.comuns', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83051000', 'description' => 'Ferragens p/encadern.de fls.moveis,etc.de metais comuns', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83052000', 'description' => 'Grampos em barretas,de metais comuns', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83059000', 'description' => 'Molas p/papeis,outs.objs.de escritorio,de metais comuns', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83061000', 'description' => 'Sinos,campainhas,gongos,etc.de metais comuns,n/eletr.', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83061000', 'description' => 'Sinos e carrilhões', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83062100', 'description' => 'Estatuetas/obj.ornament.de met.comuns,pratead/dour/plat', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83062900', 'description' => 'Outs.estatuetas/objetos de ornament.de metais comuns', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83063000', 'description' => 'Molduras p/fotografia,gravura,espelhos,de metais comuns', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83071010', 'description' => 'Tubos flexiveis de ferro ou aco,mesmo com acessorios, dos tipos utilizados na eploração sumarina depetróleo ou gás ...', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83071090', 'description' => 'Outros (tubos flexiveis de ferro ou aco,mesmo com acessorios)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83079000', 'description' => 'Tubos flexiveis de outs.metais comuns', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83081000', 'description' => 'Grampos/colchetes/ilhoses,de met.comuns, p/vestuario,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83082000', 'description' => 'Rebites tubulares ou de haste fendida,de metais comuns', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83089010', 'description' => 'Fivelas de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83089020', 'description' => 'Contas e lantejoulas,de metais comuns', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83089090', 'description' => 'Outs.fechos,etc.de met.comuns,p/vestuario,calcados,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83089090', 'description' => 'Partes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83091000', 'description' => 'Capsulas de coroa,de metais comuns, p/embalagem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83099000', 'description' => 'Rolhas,outs.tampas e acess.p/embalagem,de metais comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83100000', 'description' => 'Placas indicadoras,sinaliz.etc.de metais comuns,n/eletr', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83100000', 'description' => 'Triângulo de segurança', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83111000', 'description' => 'Eletrodos revest.exter.p/soldar a arco,de metais comuns', 'aliquota_federal' => 8.84, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83112000', 'description' => 'Fios revest.interiorm.p/soldar a arco,de metais comuns', 'aliquota_federal' => 8.84, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83113000', 'description' => 'Varetas e fios,revest.p/soldar a chama,de metais comuns', 'aliquota_federal' => 8.84, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '83119000', 'description' => 'Outs.fios,varetas,tubos,chapas,etc.de metais comuns', 'aliquota_federal' => 8.84, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84011000', 'description' => 'Reatores nucleares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84012000', 'description' => 'Maquinas e apars.p/separacao de isotopos,e suas partes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84013000', 'description' => 'Elementos combustiv.n/irradiados,p/reatores nucleares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84014000', 'description' => 'Partes de reatores nucleares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84021100', 'description' => 'Caldeiras aquatubulares,com producao de vapor>45t/hora', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84021200', 'description' => 'Caldeiras aquatubulares,com producao de vapor<=45t/hora', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84021900', 'description' => 'Outros caldeiras p/producao de vapor,incl.caldeira mist', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84022000', 'description' => 'Caldeiras denominadas de agua superaquecida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84029000', 'description' => 'Partes de caldeiras de vapor e de agua superaquecida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84031010', 'description' => 'Caldeiras p/aquecimento central,cap<=200000 kcal/hora', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84031090', 'description' => 'Outros caldeiras p/aquecimento central', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84039000', 'description' => 'Partes de caldeiras p/aquecimento central', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84041010', 'description' => 'Apars.auxiliares p/caldeiras de vapor/agua superaquec', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84041020', 'description' => 'Apars.auxiliares p/caldeiras de aquecimento central', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84042000', 'description' => 'Condensadores p/maquinas a vapor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84049010', 'description' => 'Partes de apars.auxiliares p/caldeiras de vapor,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84049090', 'description' => 'Partes de apars.auxiliares p/caldeiras aquecim.central', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84051000', 'description' => 'Geradores de gas de ar/gas de agua/de acetileno,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84059000', 'description' => 'Partes de geradores de gas de ar/gas de agua,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84061000', 'description' => 'Turbinas a vapor,p/propulsao de embarcacoes', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84068100', 'description' => 'Outros turbinas a vapor,de potencia>40mw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84068200', 'description' => 'Outros turbinas a vapor,de potencia<=40mw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84069011', 'description' => 'Rotores de turbinas a reacao,a vapor,de multipl.estag.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84069019', 'description' => 'Outs.rotores de turbinas a vapor', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84069021', 'description' => 'Palhetas fixas (de estator) de turbinas a vapor', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84069029', 'description' => 'Outs.palhetas de turbinas a vapor', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84069090', 'description' => 'Outs.partes de turbinas a vapor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84071000', 'description' => 'Motores de explosao,p/aviacao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84072110', 'description' => 'Motores de explosao,p/embarcacao, outboard,monocil.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84072190', 'description' => 'Outros motores de explosao,p/embarcacao, outboard', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84072910', 'description' => 'Outs.motores de explosao,p/embarcacao, monocilindricos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84072990', 'description' => 'Outros motores de explosao,p/embarcacao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84073110', 'description' => 'Motores de explosao,p/veic.do cap.87,ate 50cm3,monocil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84073190', 'description' => 'Outs.motores de explosao.p/veic.do cap.87,ate 50cm3', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84073200', 'description' => 'Motores de explosao,p/veic.cap.87,sup.50cm3 ate 250cm3', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84073310', 'description' => 'Motores de explosao,p/veic.cap.87, 250<cm3<=1000,monocil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84073390', 'description' => 'Outs.motores de explosao,p/veic.cap.87, 250<cm3<=1000', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84073410', 'description' => 'Motores de explosao,p/veic.cap.87,sup. 1000cm3,monocil.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84073490', 'description' => 'Outs.motores de explosao,p/veic.cap.87,sup. 1000cm3', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84079000', 'description' => 'Outros motores de explosao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84081010', 'description' => 'Motores diesel/semidiesel,p/embarcacao,tipo outboard', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84081090', 'description' => 'Outros motores diesel/semidiesel,para embarcacao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082010', 'description' => 'Motores diesel/semidiesel,p/veic.do cap.87,ate 1500cm3', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082020', 'description' => 'Motores diesel/semidiesel,p/veic.cap.87, 1500<cm3<=2500', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082020', 'description' => 'De ônibus ou caminhões, de potência igual ou superior a 125HP', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082020', 'description' => 'De tratores agrícolas, com até 2.600 rpm em potência máxima', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082030', 'description' => 'Motores diesel/semidiesel,p/veic.cap.87, 2500<cm3<=3500', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082030', 'description' => 'De ônibus ou caminhões, de potência igual ou superior a 125HP', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082030', 'description' => 'De tratores agrícolas, com até 2.600 rpm em potência máxima', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082090', 'description' => 'Outros (motores diesel/semidiesel,p/veic.cap.87)', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082090', 'description' => 'De ônibus ou caminhões, de potência igual ou superior a 125HP', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84082090', 'description' => 'De tratores agrícolas, com até 2.600 rpm em potência máxima', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84089010', 'description' => 'Estacionários, de potência normal iso superior a 412,5kw (550hp), segundo norma iso 3046/1', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84089090', 'description' => 'Outros motores diesel/semidiesel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84091000', 'description' => 'Partes de motores para aviacao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099111', 'description' => 'Bielas para motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099112', 'description' => 'Blocos de cilindros,cabecotes,etc.p/motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099113', 'description' => 'Carburadores para motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099114', 'description' => 'Valvulas de admissao ou de escape,p/motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099115', 'description' => 'Coletores de admissao ou escape,p/motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099116', 'description' => 'Aneis de segmento,para motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099117', 'description' => 'Guias de valvulas,para motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099118', 'description' => 'Outs carburadores', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099120', 'description' => 'Pistoes ou embolos,para motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099130', 'description' => 'Camisas de cilindro,para motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099140', 'description' => 'Injecao eletronica,para motores de explosao', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099190', 'description' => 'Outros partes para motores de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099912', 'description' => 'Blocos de cilindros,cabecotes,etc.p/motores diesel/semi', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099912', 'description' => 'De motores de ônibus ou caminhões, de potência igual ou superior a 125HP', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099914', 'description' => 'Valvulas de admissao ou de escape,p/motores diesel/semi', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099915', 'description' => 'Coletores de admissao ou escape,p/motores diesel/semi', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099917', 'description' => 'Guias de valvulas,p/motores diesel ou semidiesel', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099921', 'description' => 'Pistoes ou embolos, com diâmetro superior ou igual a 200mm, p/motores diesel ou semidiesel', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84099929', 'description' => 'Outros pistoes ou embolos,p/motores diesel ou semidiesel', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099930', 'description' => 'Camisas de cilindro,p/motores diesel ou semidiesel', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099941', 'description' => 'Bielas com peso superior ou igual a 30kg', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099941', 'description' => 'De motores de ônibus ou caminhões, de potência igual ou superior a 125HP', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099949', 'description' => 'Outras bielas', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099949', 'description' => 'De motores de ônibus ou caminhões, de potência igual ou superior a 125HP', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099951', 'description' => 'Cabeçotes com diâmetro superior ou igual a 200mm', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099951', 'description' => 'De motores de ônibus ou caminhões, de potência igual ou superior a 125HP', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099959', 'description' => 'Outros cabeçotes', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099959', 'description' => 'De motores de ônibus ou caminhões, de potência igual ou superior a 125HP', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099961', 'description' => 'Injetores (incluídos os bicos injetores) com diâmetro superior ou igual a 20mm', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099969', 'description' => 'Outros injetores (incluídos os bicos injetores)', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099971', 'description' => 'Anéis de segmento com diâmetro superior ou igual a 200mm', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099979', 'description' => 'Outros anéis de segmento', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099991', 'description' => 'Camisas de cilindro soldadas a cabeçotes, com diâmetros superior ou igual a 200mm', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099999', 'description' => 'Outras', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84099999', 'description' => 'Carcaças de motores de ônibus ou caminhões, de potência igual ou superior a 125HP', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84101100', 'description' => 'Turbinas e rodas hidraulicas,de potencia<=1000kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84101200', 'description' => 'Turbinas e rodas hidraulicas,1000kw<potencia<=10000kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84101300', 'description' => 'Turbinas e rodas hidraulicas,de potencia>10000kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84109000', 'description' => 'Partes de turbinas e rodas hidraulicas,incl. reguladores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84111100', 'description' => 'Turborreatores de empuxo<=25kn', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84111200', 'description' => 'Turborreatores de empuxo>25kn', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84112100', 'description' => 'Turbopropulsores de potencia<=1100kw', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84112200', 'description' => 'Turbopropulsores de potencia>1100kw', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84118100', 'description' => 'Outros turbinas a gas,de potencia<=5000kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84118200', 'description' => 'Outros turbinas a gas,de potencia>5000kw', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84119100', 'description' => 'Partes de turborreatores ou de turbopropulsores', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84119900', 'description' => 'Partes de outs.turbinas a gas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84121000', 'description' => 'Propulsores a reacao,exc.os turborreatores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84122110', 'description' => 'Cilindros hidraulicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84122190', 'description' => 'Outros motores hidráulicos de movimento retilíneo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84122900', 'description' => 'Outros motores hidraulicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84123110', 'description' => 'Cilindros pneumaticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84123190', 'description' => 'Outros motores pneumaticos,de movimento retilineo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84123900', 'description' => 'Outros motores pneumaticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84128000', 'description' => 'Outros motores e maquinas motrizes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84129010', 'description' => 'Partes de propulsores a reacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84129020', 'description' => 'Partes de maquinas a vapor,de movimento retilineo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84129080', 'description' => 'Partes de motores hidraul/pneumat.de movim.retilineo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84129090', 'description' => 'Partes de outs.motores e maquinas motrizes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84131100', 'description' => 'Bombas p/distrib.combustiv/lubrif.em postos servico,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84131900', 'description' => 'Outs.bombas p/liquidos c/disp.medidor/conceb. p/comport.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84132000', 'description' => 'Bombas p/liquidos,manuais', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84133010', 'description' => 'Bombas p/gasolina/alcool,p/motor de explosao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84133020', 'description' => 'Bombas injetoras de combustivel p/motor diesel/semi', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84133020', 'description' => 'Em linha , com elementos de injeção de diâmetro igual ou superior a 9,5 mm, para motores de potência igual ou superior a 125HP, próprios para ônibus ou caminhões', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84133030', 'description' => 'Bombas p/oleo lubrificante,p/motor explosao/diesel/semi', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84133090', 'description' => 'Outs.bombas p/combustiveis,etc.p/motor explosao/diesel/', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84134000', 'description' => 'Bombas p/concreto (betao)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84135010', 'description' => 'Bombas volumetricas alternativas,5hp<potencia<=600hp', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84135090', 'description' => 'Outros bombas volumetricas alternativas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84136011', 'description' => 'Bombas volumetr.rotativas,vazao<=300l/min. de engrenagem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84136019', 'description' => 'Outs.bombas volumetricas rotativas,de vazao<=300l/min.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84136090', 'description' => 'Outros bombas volumetricas rotativas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84137010', 'description' => 'Eletrobombas submersiveis', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84137080', 'description' => 'Outs.bombas centrifugas,de vazao <=300litros/minuto', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84137090', 'description' => 'Outros bombas centrifugas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84138100', 'description' => 'Outros bombas p/liquidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84138200', 'description' => 'Elevadores de liquidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84139110', 'description' => 'Hastes de bombeamento dos tipos utilizados para extração de petróleo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84139190', 'description' => 'Outras partes de bombas', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84139190', 'description' => 'De bombas injetoras em linha, com elementos de injeção de diâmetro igual ou superior a 9,5 mm, para motores de ignição por compressão de potência igual ou superior a 125HP, próprios para ônibus ou caminhões', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84139200', 'description' => 'Partes de elevadores de liquidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84141000', 'description' => 'Bombas de vacuo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84142000', 'description' => 'Bombas de ar,de mao ou de pe', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84143011', 'description' => 'Motocompressor hermetico,capacidade<4700 frigorias/hora', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84143019', 'description' => 'Outs.motocompressores hermeticos p/equipam.frigorificos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84143091', 'description' => 'Compressor p/equipam.frigorifico,cap<=16000 frigorias/h', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84143099', 'description' => 'Outros compressores p/equipamentos frigorificos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84144010', 'description' => 'Compressor de ar,de deslocamento alternativo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84144020', 'description' => 'Compressor de ar,de parafuso,mont. chassis/rebocaveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84144090', 'description' => 'Outs.compressores de ar,mont.chassis c/rodas/rebocaveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84145110', 'description' => 'Ventilador de mesa,c/motor eletrico,de potencia<=125w', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84145120', 'description' => 'Ventilador de teto,c/motor eletrico,de potencia<=125w', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84145190', 'description' => 'Outs.ventiladores c/motor eletrico,de potencia<=125w', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84145910', 'description' => 'Microventiladores c/area de carcaca<90cm2', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84145990', 'description' => 'Outros ventiladores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84146000', 'description' => 'Coifas c/dimensao horizontal maxima<=120cm', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84146000', 'description' => 'Do tipo doméstico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148011', 'description' => 'Outros compressores de ar,estacionarios,de pistao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148012', 'description' => 'Outros compressores de ar,de parafuso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148013', 'description' => 'Outs.compressores de ar,de lobulos paralelos (roots)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148019', 'description' => 'Outros compressores de ar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148021', 'description' => 'Outs.turboaliment.de ar,p<=50kg,p/motor explosao/diesel', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148022', 'description' => 'Outs.turboaliment.de ar,p>50kg,p/motor explosao/diesel', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148029', 'description' => 'Outros turbocompressores de ar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148031', 'description' => 'Outros compressores de gases,de pistao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148032', 'description' => 'Outros compressores de gases,de parafuso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148033', 'description' => 'Outs.compressores de gases,centrif.vazao max<22000 m3/h', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148038', 'description' => 'Outros compressores de gases,centrifugos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148039', 'description' => 'Outros compressores de gases', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84148090', 'description' => 'Outs.bombas de ar/coifas aspirantes p/extracao/reciclag', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84149010', 'description' => 'Partes de bombas de ar ou de vacuo', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84149020', 'description' => 'Partes de ventiladores ou coifas aspirantes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84149031', 'description' => 'Pistoes ou embolos,de compressores de ar/outs.gases', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84149032', 'description' => 'Aneis de segmento,para compressores de ar ou outs.gases', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84149033', 'description' => 'Blocos de cilindros/cabecotes/carteres, p/compressores', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84149034', 'description' => 'Valvulas de compressores de ar/outs.gases', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84149039', 'description' => 'Outros partes de compressores de ar/ outs.gases', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84151011', 'description' => 'Apars.de ar-condicionado do tipo split system (sistema c/ elementos separados), c<=30000f/h, p/paredes/janelas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84151011', 'description' => 'Com capacidade inferior a 7.500 frigorias/hora', 'aliquota_federal' => 30.13, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84151019', 'description' => 'Outs apars.de ar-condicionado,c<=30000f/h, p/paredes/janelas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84151090', 'description' => 'Outros apars.de ar condicionado,p/paredes/ janelas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84152010', 'description' => 'Apars.de ar-condicionado,c<=30000f/h,p/veic. automoveis', 'aliquota_federal' => 30.12, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84152090', 'description' => 'Outs.apars.de ar condicionado,p/veiculos automoveis', 'aliquota_federal' => 30.12, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84158110', 'description' => 'Outs.apars.ar cond.c/disp.refrig.e valv.inv.c<=30000f/h', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84158190', 'description' => 'Outs.apars.ar cond.c/disp.refrig.e valv. inv.cicl.term.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84158210', 'description' => 'Outs.apars.ar cond.c/disp.refrig. cap<=30000frigorias/h', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84158290', 'description' => 'Outros apars.ar cond.c/disp.refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84158300', 'description' => 'Outros apars.ar cond.s/disp.refrig.', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84159010', 'description' => 'Unid.evap.interna ar cond. split c/ cap<=30k frig/hora', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84159010', 'description' => 'Com capacidade inferior a 7.500 frigorias/hora', 'aliquota_federal' => 30.13, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84159020', 'description' => 'Unid.cond.externa ar cond. split c/ cap<=30k frig/hora', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84159020', 'description' => 'Com capacidade inferior a 7.500 frigorias/hora', 'aliquota_federal' => 30.13, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84159090', 'description' => 'Outras unidades de ar condicionado', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84161000', 'description' => 'Queimadores p/aliment.fornalhas,de combustiv. liquidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84162010', 'description' => 'Queimadores p/aliment.fornalhas,de gases', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84162090', 'description' => 'Outs.queimadores p/aliment.de fornalhas, incl.os mistos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84163000', 'description' => 'Fornalhas automaticas,incl.as antefornalhas, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84169000', 'description' => 'Partes de queimadores,fornalhas automativas, etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84171010', 'description' => 'Fornos industriais,n/eletr.p/fusao de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84171020', 'description' => 'Fornos industriais,n/eletr.p/tratam.termico de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84171090', 'description' => 'Outs.fornos n/eletr.p/ustulacao,etc.de minerios/metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84172000', 'description' => 'Fornos industriais,n/eletr.de padaria, pastelaria, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84178010', 'description' => 'Fornos industriais,n/eletr.p/ceramica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84178020', 'description' => 'Fornos industriais,n/eletr.p/fusao de vidro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84178090', 'description' => 'Outs.fornos industriais ou de laboratorio, n/eletricos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84179000', 'description' => 'Partes de fornos industriais ou de laboratorio, n/eletr.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84181000', 'description' => 'Refrigeradores combin.c/congeladores,porta ext.separada', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84181000', 'description' => 'Próprios para conservação de sangue humano, funcionando com temperatura estável entre 2°C e 6°C', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84182100', 'description' => 'Refrigeradores de compressao,de uso domestico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84182900', 'description' => 'Outros refrigeradores de uso domestico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84183000', 'description' => 'Congeladores (freezers) tipo cofre, capacidade<=800l', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84183000', 'description' => 'De capacidade não superior a 400 litros', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84184000', 'description' => 'Congeladores (freezers) tipo armario, capacidade<=900l', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84184000', 'description' => 'De capacidade não superior a 400 litros', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84185010', 'description' => 'Outros congeladores (freezers)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84185090', 'description' => 'Outs.refrigeradores,vitrinas,balcoes,etc.p/prod.de frio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186100', 'description' => 'Bombas de calor, exceto as máquinas e aparelhos de ar-condicionado da posição 84.15', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186910', 'description' => 'Maquinas p/preparacao de sorvetes, n/domesticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186920', 'description' => 'Resfriadores de leite', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186931', 'description' => 'Unidades fornecedoras de agua ou sucos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186931', 'description' => 'Bebedouros refrigerados', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186932', 'description' => 'Unidades fornecedoras de bebidas carbonatadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186940', 'description' => 'Grupos frigoríficos de compressão para refrigeração ou para ar condicionado, com capacidade inferior ou igual a 30.000 frigorias/hora', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186940', 'description' => 'Para ar-condicionado', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186991', 'description' => 'Resfriadores de água, de absorção por brometo de lítio', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186999', 'description' => 'Outs.materiais/maqs.apars.p/prod.frio,e bombas de calor', 'aliquota_federal' => 10.85, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186999', 'description' => 'Máquinas para produção de gelo em embarcações pesqueiras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186999', 'description' => 'Grupos de compressão, exceto para ar condicionado, ou de absorção', 'aliquota_federal' => 6.63, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186999', 'description' => 'Máquinas para produção de gelo em cubos ou escamas', 'aliquota_federal' => 6.63, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84186999', 'description' => 'Instalações frigoríficas industriais, formadas por elementos não reunidos em corpo único nem montados sobre base comum, com câmara frigorífica de capacidade superior a 30m³', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84189100', 'description' => 'Gabinetes/moveis p/receber equipamento p/prod.de frio', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84189900', 'description' => 'Outros partes de refrigeradores, congeladores,etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84189900', 'description' => 'Condensador frigorífico e evaporador frigorífico', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84191100', 'description' => 'Aquecedores de agua,de aquecimento instantaneo,a gas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84191100', 'description' => 'Para uso doméstico', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84191910', 'description' => 'Aquecedores solares de agua', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84191990', 'description' => 'Outs.aquecedores de agua,n/eletr.de aquecim.instant.etc', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84192000', 'description' => 'Esterilizadores medico-cirurgicos ou de laboratorio', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84193100', 'description' => 'Secadores p/produtos agricolas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84193200', 'description' => 'Secadores p/madeiras,pastas de papel,papeis ou cartoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84193900', 'description' => 'Outros secadores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84194010', 'description' => 'Apars.de destilacao de agua', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84194020', 'description' => 'Apars.de destilacao ou retificacao,de alcoois,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84194090', 'description' => 'Outros aparelhos de destilacao ou de retificacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84195010', 'description' => 'Trocadores (permutadores) de calor,de placas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84195021', 'description' => 'Trocadores (permutadores) de calor,tubulares,metalicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84195022', 'description' => 'Trocadores (permutadores) de calor,tubulares,de grafite', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84195029', 'description' => 'Outs.trocadores (permutadores) de calor, tubulares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84195090', 'description' => 'Outros trocadores (permutadores) de calor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84196000', 'description' => 'Apars.e dispositivos p/liquefacao do ar ou outs.gases', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198110', 'description' => 'Autoclaves p/prepar.de bebida quente/aquec. de alimento', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198190', 'description' => 'Outs.apars/dispositivos p/prepar.de bebidas quentes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198911', 'description' => 'Esterilizadores de aliment.uht,inj.vapor, cap>=6500 l/h', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198919', 'description' => 'Outros esterilizadores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198919', 'description' => 'Dos tipos utilizados em bares, restaurantes, cantinas e semelhantes', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198920', 'description' => 'Estufas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198930', 'description' => 'Torrefadores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198940', 'description' => 'Evaporadores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198991', 'description' => 'Recipiente refrigerador,c/disp.circul.fluido refriger.', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198999', 'description' => 'Outs.apars.e dispositivos p/trat.mater. c/modif.temperat', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84198999', 'description' => 'Torres de resfriamento de água', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84199010', 'description' => 'Partes de aquecedores de agua,n/eletr.aquecim. inst.etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84199020', 'description' => 'Partes de colunas de destilacao ou de retificacao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84199031', 'description' => 'Placa corrugada,de aco inox/aluminio,troca term.s>0.4m2', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84199039', 'description' => 'Outs.placas de trocadores (permutadores) de calor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84199040', 'description' => 'Partes de apars/disposit.p/prepar.de bebida quente,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84199090', 'description' => 'Outs.partes de apars/disposit.p/tratam. c/modif.temperat', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84201010', 'description' => 'Calandras e laminadores p/papel ou cartao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84201090', 'description' => 'Outros calandras e laminadores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84209100', 'description' => 'Cilindros p/calandras e laminadores', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84209900', 'description' => 'Outros partes p/calandras e laminadores', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84211110', 'description' => 'Desnatadeira centrifuga,cap.processam.leite >30000l/hora', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84211190', 'description' => 'Outros desnatadeiras centrifugas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84211210', 'description' => 'Secador de roupa,centrifugo,cap.de roupa seca<=6kg', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84211290', 'description' => 'Outros secadores de roupa,centrifugos', 'aliquota_federal' => 13.87, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84211910', 'description' => 'Centrifugador p/laborat.de analise,ensaio,pesq. cientif.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84211990', 'description' => 'Outros centrifugadores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84211990', 'description' => 'Centrifugadores para uso doméstico', 'aliquota_federal' => 23.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212100', 'description' => 'Apars.p/filtrar ou depurar agua', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212200', 'description' => 'Apars.p/filtrar ou depurar bebidas,exc.agua', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212300', 'description' => 'Apars.p/filtrar oleos minerais nos motores explosao,etc', 'aliquota_federal' => 20.86, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212300', 'description' => 'Filtro de óleo lubrificante, não descartável, equipado com elemento filtrante de papel  substituível , para uso em motores de ignição por compressão, de potência igual ou superior a 125HP, próprios para ônibus ou caminhões', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212300', 'description' => 'Filtro de óleo lubrificante, não descartável, equipado com elemento filtrante de papel  substituível , para uso em motores de ignição por compressão, com até 2.600 rpm em potência máxima, próprios para colheitadeiras ou tratores agrícolas', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212911', 'description' => 'Hemodialisador tipo capilar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212919', 'description' => 'Outros hemodialisadores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212920', 'description' => 'Apars.de osmose inversa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212930', 'description' => 'Filtros-prensas p/liquidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84212990', 'description' => 'Outros apars.p/filtrar ou depurar liquidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84213100', 'description' => 'Filtros de entrada de ar p/motores a explosao/diesel', 'aliquota_federal' => 20.86, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84213910', 'description' => 'Filtros eletrostaticos p/gases', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84213920', 'description' => 'Depurador por convers.catalitica de gases de escap.veic', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84213930', 'description' => 'Concentrador de oxigenio por depuracao do ar,c<=6l/min', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84213990', 'description' => 'Outros apars.p/filtrar ou depurar gases', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84219110', 'description' => 'Partes de secadores de roupa,centrifugos, cap.roupa<=6kg', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84219191', 'description' => 'Tambores rotativos c/pratos/discos separadores, p>300kg', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84219199', 'description' => 'Outros partes de centrifugadores', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84219910', 'description' => 'Partes de outs.apars.p/filtrar ou depurar gases', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84219920', 'description' => 'Partes de apars.utilizados em linhas de sangue para hemodiálise', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84219991', 'description' => 'Cartuchos de membrana de apars.de osmose inversa', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84219999', 'description' => 'Outs.partes de apars.p/filtrar ou depurar liquidos,etc.', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84221100', 'description' => 'Maqs.de lavar louca,do tipo domestico', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84221900', 'description' => 'Outros maqs.de lavar louca', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84221900', 'description' => 'Com capacidade de lavagem superior a 1000 pratos por hora', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84222000', 'description' => 'Maqs.e apars.p/limpar/secar garrafas/outs.recipientes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84223010', 'description' => 'Maqs.e apars.p/encher/fechar/arrolhar, etc.garrafas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84223021', 'description' => 'Maqs.e apars.p/encher caixas/sacos com po ou graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84223022', 'description' => 'Maqs.e apars.p/encher/fechar embalagem tetra pack,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84223023', 'description' => 'Maqs.e apars.p/encher/fechar bisnagas, cap>=100 unid/min', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84223029', 'description' => 'Maqs.e apars.p/encher/fechar latas,capsular vasos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84223030', 'description' => 'Maqs.e apars.p/gaseificar bebidas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84224010', 'description' => 'Maqs.e apars.horizont.p/empacotar massa alim.longa,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84224020', 'description' => 'Maqs.e apars.automat.p/embalar tubo/barra de metal,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84224030', 'description' => 'Maqs.e apars.p/empacot.embalag .papel/ cartao,cap>=5000/h', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84224090', 'description' => 'Outs.maqs.e apars.p/empacotar/embalar mercadorias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84229010', 'description' => 'Partes de maqs.p/lavar loucas,de uso domestico', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84229090', 'description' => 'Partes de maqs.e apars.p/limpar/secar/encher/fechar,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84231000', 'description' => 'Balancas para pessoas,incl.p/bebes e de uso domestico', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84231000', 'description' => 'De uso doméstico', 'aliquota_federal' => 4.70, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84232000', 'description' => 'Basculas de pesagem continua em transportadores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84233011', 'description' => 'Basculas dosadoras c/apars.perifericos c/unid.funcional', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84233019', 'description' => 'Outros basculas dosadoras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84233090', 'description' => 'Basculas de pesagem constante e basculas ensacadoras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84238110', 'description' => 'Apars.e instrum.pesagem,de mesa,c<=30kg,c/disp.reg.etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84238190', 'description' => 'Outros apars.e instrum.de pesagem, capacidade<=30kg', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84238200', 'description' => 'Apars.e instrum.pesagem,30kg< capacidade <=5000kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84238900', 'description' => 'Outros apars.e instrum.de pesagem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84239010', 'description' => 'Pesos p/balancas', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84239021', 'description' => 'Partes de balancas p/pessoas,incl.p/bebes/ uso domestico', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84239029', 'description' => 'Partes de outs.apars.e instrum.pesagem, incl.basculas', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84241000', 'description' => 'Extintores,mesmo carregados', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84242000', 'description' => 'Pistolas aerograficas e apars.semelhantes', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84243010', 'description' => 'Maqs.e apars.p/desobstrucao tubulacao,etc.de jato agua', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84243020', 'description' => 'Maqs.e apars.p/desgaste localiz.vestuario,de jato areia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84243030', 'description' => 'Maqs.e apars.perfuradoras por jato agua,pressao>=10mpa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84243090', 'description' => 'Outs.maqs.e apars.de jato de areia/jato de vapor,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84244100', 'description' => 'Pulverizadores portateis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '84244900', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '84248221', 'description' => 'Por aspersao', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84248229', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84248290', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '84248910', 'description' => 'Aparelhos de pulverização constituídos por botão de pressão com bocal (tampa “spray”), válvula do tipo aerossol, junta de estanqueidade (junta de canopla) e tubo de imersão, montados sobre um corpo metálico (canopla), dos tipos utilizados para serem monta', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84248920', 'description' => 'Aparelhos automáticos para projetar lubrificantes sobre pneumáticos, contendo uma estação de secagem por ar pré-aquecido e dispositivos para agarrar e movimentar os pneumáticos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84248990', 'description' => 'Outs.apars.mecanicos,p/projetar,etc.liquidos ou pos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84249010', 'description' => 'Partes de extintores/apars.p/pulverizar, etc. manuais', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84249090', 'description' => 'Partes de outs.apar.mecan.p/projetar.etc. liquido/po,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84251100', 'description' => 'Talhas,cadernais e moitoes,de motor eletrico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84251910', 'description' => 'Talhas,cadernais e moitoes,manuais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84251990', 'description' => 'Outros talhas,cadernais e moitoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84253110', 'description' => 'Guinchos e cabrestantes,de motor eletrico,cap<=100t', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84253190', 'description' => 'Outros guinchos e cabrestantes,de motor eletrico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84253910', 'description' => 'Outros guinchos e cabrestantes,cap<=100t', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84253990', 'description' => 'Outros guinchos e cabrestantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84254100', 'description' => 'Macacos elevadores fixos de veiculos, p/garagens', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84254200', 'description' => 'Macacos hidraulicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84254910', 'description' => 'Macacos manuais', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84254990', 'description' => 'Outros macacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84261100', 'description' => 'Pontes e vigas,rolantes,de suportes fixos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84261200', 'description' => 'Porticos moveis de pneumaticos e carros-porticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84261900', 'description' => 'Outros porticos e pontes-guindastes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84262000', 'description' => 'Guindastes de torre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84263000', 'description' => 'Guindastes de portico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84264110', 'description' => 'Maqs.e apars.autopropulsados,de pneumaticos, com deslocamento em sentido longitudinal, transversal e diagonal (tipo caranguejo) com capacidade de carga superior ou igual a 60t', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84264190', 'description' => 'Outs maqs.e apars.autopropulsados,de pneumaticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84264910', 'description' => 'Outras  maqs.e apars.autopropulsados, de esteiras, com capacidade de elevação >=70 toneladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84264990', 'description' => 'Outros maqs.e apars.autopropulsados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84269100', 'description' => 'Maqs.e apars.p/montagem em veiculos rodoviarios', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84269900', 'description' => 'Cabreas e outs.guindastes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84271011', 'description' => 'Empilhadeiras autopropulsoras,de motor eletr.cap>6.5t', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84271019', 'description' => 'Outs.empilhadeiras autopropulsoras,de motor eletrico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84271090', 'description' => 'Outros veic.p/movim.carga,autopropulsores,de motor elet', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84272010', 'description' => 'Outros empilhadeiras autopropulsoras,cap>6.5t', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84272090', 'description' => 'Outros veic.p/movim.carga,autopropulsores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84279000', 'description' => 'Outs.empilhadeiras/veic.p/movim.carga,c/disp.elevacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84281000', 'description' => 'Elevadores e monta-cargas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84282010', 'description' => 'Transportadores pneumat.tubulares moveis de motor>120hp', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84282090', 'description' => 'Outs.apars.elevadores/transportadores,pneumaticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84283100', 'description' => 'Apars.elevadores/transp.de mercadorias,p/uso subterran.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84283200', 'description' => 'Apars.elevadores/transp.de mercadorias,de cacamba', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84283300', 'description' => 'Apars.elevadores/transp.de mercadorias,de tira/correia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84283910', 'description' => 'Apars.elevadores/transp.de mercadorias,de correntes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84283920', 'description' => 'Apars.elevadores/transp.de mercadorias,de rolos motores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84283930', 'description' => 'Apars.elevadores/transp.de mercadorias,de pinças laterais p/transporte de jornais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84283990', 'description' => 'Outs.apars.elevador/transport.acao continua,p/mercad.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84284000', 'description' => 'Escadas e tapetes,rolantes', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84286000', 'description' => 'Telefericos e mecanismos de tracao p/funiculares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84286000', 'description' => 'Telecadeiras e telesquis', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84289010', 'description' => 'Maqs.e apars.p/desembarque de botes salva-vidas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84289020', 'description' => 'Transportadores- elevadores automáticos de deslocamento horizontal sobre guias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84289030', 'description' => 'Máq p/ formação de pilhas de jornais (...) >= 80000 exemplares/h', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84289090', 'description' => 'Outs.maqs.e apars.de elevacao,de carga,de descarga,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84291110', 'description' => 'Bulldozers e angledozers,de lagartas,pot>=520hp', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84291190', 'description' => 'Outros buldozers e angledozers,de lagartas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84291910', 'description' => 'Outros bulldozers de potencia no volante>=315hp', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84291990', 'description' => 'Outros bulldozers e angledozers', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84292010', 'description' => 'Motoniveladores articulados,potencia no volante>=275hp', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84292090', 'description' => 'Outros niveladores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84293000', 'description' => 'Raspo-transportadores,autopropulsores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84294000', 'description' => 'Compactadores e rolos/cilindros compressores,autopropul', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295111', 'description' => 'Carregadoras-transportadoras,util.minas substerraneas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295119', 'description' => 'Outs.carregadoras-transportadoras de carregam.frontal', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295121', 'description' => 'Infraestrutura motora,p/receber carregadoras,p>=609hp', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295129', 'description' => 'Infraestrutura motora,p/receber outs.carregadoras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295191', 'description' => 'Outs.carregadoras/pas-carregadoras,de carregam.frontal, de potência no volante superior ou igual a 297,5kw (399hp)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295192', 'description' => 'Outs.carregadoras/pas-carregadoras,de carregam.frontal, de potência no volante inferior ou igual a 43,99kw (59hp)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295199', 'description' => 'Outs.carregadoras/pas-carregadoras,de carregam.frontal', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295211', 'description' => 'Escavadeiras,cap.efet.rotacao=360graus,cap.carga>=19m3, de potência no volante superior ou igual a 484,7kw (650hp)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295212', 'description' => 'Escavadeiras,cap.efet.rotacao=360graus,cap.carga>=19m3, de potência no volante inferior ou igual a 40,3kw (54hp)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295219', 'description' => 'Escavadeiras,cap.efet.rotacao=360graus,cap.carga>=19m3', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295220', 'description' => 'Maqs.cuja superestrutura cap.efet. rotacao =360graus, infraestruturas motoras, próprias para receber equipamentos das subposições 8430.49, 8430.61 ou 8430.69, mesmo com dispositivo de deslocamento sobre trilhos,etc.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295290', 'description' => 'Outs.maqs.escavadoras,etc.cap.efet.rotacao=360graus', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84295900', 'description' => 'Outros pas mecanicas,escavadores, carregadoras,etc.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84301000', 'description' => 'Bate-estacas e arranca-estacas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84302000', 'description' => 'Limpa-neves', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84303110', 'description' => 'Cortadores de carvao ou de rochas, autopropulsores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84303190', 'description' => 'Maqs.p/perfuracao de tuneis e galerias, autopropulsoras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84303910', 'description' => 'Outros cortadores de carvao ou de rochas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84303990', 'description' => 'Outros maqs.p/perfuracao de tuneis e galerias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84304110', 'description' => 'Perfuratriz de percussao,autopropulsora', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84304120', 'description' => 'Perfuratriz rotativa,autopropulsora', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84304130', 'description' => 'Maqs.de sondagem,rotativas,autopropulsoras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84304190', 'description' => 'Outros maqs.de sondagem/perfuracao, autopropulsoras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84304910', 'description' => 'Outros perfuratrizes de percussao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84304920', 'description' => 'Outros maqs.de sondagem,rotativas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84304990', 'description' => 'Outros maqs.de sondagem/perfuracao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84305000', 'description' => 'Outs.maqs.e apars.de terraplanagem,etc. autopropulsores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84306100', 'description' => 'Maqs.de comprimir/compactar terra,etc.exc. autopropuls.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84306911', 'description' => 'Equipamentos frontais p/escavo-carregadoras,  etc.cap>4m3', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84306919', 'description' => 'Outs.equipamentos frontais p/carregad. etc.exc.autopuls.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84306990', 'description' => 'Outs.maqs.e apars.de terraplanagem,etc. exc.autopropuls.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84311010', 'description' => 'Partes de talhas,cadernais,moitoes manuais, guinchos,etc', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84311090', 'description' => 'Partes de outs.talhas,cadernais,moitoes, guinchos,etc.', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84312011', 'description' => 'Partes de empilhadeiras,autopropulsoras', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84312019', 'description' => 'Partes de outs.empilhadeiras', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84312090', 'description' => 'Partes de outs.veic.p/movim.carga,c/disposit.elevacao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84313110', 'description' => 'Partes de elevadores', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84313190', 'description' => 'Partes de monta-cargas/escadas rolantes', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84313900', 'description' => 'Partes de outs.maqs.e apars.de elevacao de carga,etc.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84314100', 'description' => 'Cacambas,pas,ganchos,etc.p/maqs.e apars.terraplanagem', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84314200', 'description' => 'Laminas p/bulldozers ou angledozers', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84314310', 'description' => 'Partes das maqs.de sondagem/perfuracao rotativas', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84314390', 'description' => 'Partes de outs.maqs.de sondagem/ perfuracao', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84314910', 'description' => 'Partes de guindastes,outs.maqs.apars.de carga/descarga', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84314921', 'description' => 'Cabinas para maqs.e aparelhos de terraplanagem,etc.', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84314922', 'description' => 'Lagartas de maquinas/aparelhos das posic. 8429 ou 8430', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84314923', 'description' => 'Outras partes de tanques de combustivel e demais reservatorios', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84314929', 'description' => 'Outras partes de outs.maqs.e aparelhos de terraplanagem,etc.', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84321000', 'description' => 'Arados e charruas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84322100', 'description' => 'Grades de discos,uso agricola,etc.p/prepar.do solo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84322900', 'description' => 'Outs.grades,escarificadores,cultivadores,enxadas,etc.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84323110', 'description' => 'Semeadores adubadores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84323190', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84323910', 'description' => 'Semeadores adubadores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84323990', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84324100', 'description' => 'Espalhadores de estrume', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84324200', 'description' => 'Distribuidores de adubos (fertilizantes)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84328000', 'description' => 'Outros maqs.e apars.agricolas,etc.p/prepar.do solo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84328000', 'description' => 'Rolos para gramados', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84329000', 'description' => 'Partes de maqs.e apars.agricolas,etc.p/prepar.do solo', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84331100', 'description' => 'Cortadores de grama,motoriz.disp.corte num plano horiz.', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84331900', 'description' => 'Outros cortadores de grama', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84332010', 'description' => 'Ceifeiras c/disp.acond.em fileiras,rotor de dedos/pente', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84332090', 'description' => 'Outs.ceifeiras,incl.barras de corte p/montag.em trator', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84333000', 'description' => 'Outros maqs.e apars.p/colher e dispor o feno', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84334000', 'description' => 'Enfardadeiras de palha/forragem,incl.com apanhadeiras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84335100', 'description' => 'Ceifeiras-debulhadoras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84335200', 'description' => 'Outros maqs.e apars.p/debulha', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84335300', 'description' => 'Maqs.p/colheita de raizes ou tuberculos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84335911', 'description' => 'Colhetadeira de algodão com capacidade p/trabalhar até 2 sulcos ...potência  <=80hp', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84335919', 'description' => 'Outras colhetadeiras de algodão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84335990', 'description' => 'Outros maqs.e apars.p/colheita', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84336010', 'description' => 'Selecionadores de frutas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84336021', 'description' => 'Maquinas p/limpar ou selecionar ovos,cap>=36000/hora', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84336029', 'description' => 'Outs.maquinas p/limpar ou selecionar ovos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84336090', 'description' => 'Maqs.p/limpar/selecionar ovos e outs.prods.agricolas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84339010', 'description' => 'Partes de cortadores de grama', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84339090', 'description' => 'Partes de outs.maqs.e apars.p/colheita,debulha,etc.', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84339090', 'description' => 'De colheitadeiras', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84341000', 'description' => 'Maqs.de ordenhar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84342010', 'description' => 'Maqs.e apars.p/tratamento do leite', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84342090', 'description' => 'Outros maqs.e apars.p/a ind.de laticinios', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84349000', 'description' => 'Partes de maqs.e apars.de ordenhar/ind.de laticinios', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84351000', 'description' => 'Maqs.e apars.p/fabr.de vinho,sidra,suco de frutas,etc.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84359000', 'description' => 'Partes de maqs.e apars.p/fabr.de vinho,sidra,etc.', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84361000', 'description' => 'Maqs.e apars.p/prepar.de alimentos ou racoes p/animais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84362100', 'description' => 'Chocadeiras e criadeiras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84362900', 'description' => 'Outros maqs.e apars.p/avicultura', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84368000', 'description' => 'Outs.maqs.e apars.p/agricultura, horticultura,etc.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84369100', 'description' => 'Partes de maqs.e apars.p/avicultura', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84369900', 'description' => 'Partes de maqs.e apars.p/agricultura, horticultura,etc.', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84371000', 'description' => 'Maqs.p/limpeza,selecao,etc.de graos,prods. hortic.secos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84378010', 'description' => 'Maqs.e apars.p/trituracao ou moagem de graos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84378090', 'description' => 'Outs.maqs.e apars.p/ind.de moagem,tratam.de cereais,etc', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84379000', 'description' => 'Partes de maqs.e apars.p/limpeza,selecao,etc. de graos', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84381000', 'description' => 'Maqs.e apars.p/ind.de panificacao,pastelaria,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84382011', 'description' => 'Maqs.e apars.p/fabr.bombons de chocolate por moldagem,cap>=150 kg/h', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84382019', 'description' => 'Outs.maquinas e aparelhos p/industrias de confeitaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84382090', 'description' => 'Maqs.e apars.p/ind.de cacau ou de chocolate', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84383000', 'description' => 'Maqs.e apars.p/ind.de acucar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84384000', 'description' => 'Maqs.e apars.p/ind.cervejeira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84385000', 'description' => 'Maqs.e apars.p/prepar.de carnes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84386000', 'description' => 'Maqs.e apars.p/prepar.de frutas ou prods.horticolas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84388010', 'description' => 'Maqs.p/extracao de oleo essencial de citricos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84388020', 'description' => 'Maqs.e apars.automat.p/descabecar,etc.pescado,c>350unid', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84388090', 'description' => 'Outs.maqs.e apars.p/prepar/fabr.indal.de alimentos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84389000', 'description' => 'Partes de maqs.e apars.p/prepar.fabr.de alimentos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84391010', 'description' => 'Maqs.e apars.p/trat.materia-prima,p/fabr.pasta celulose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84391020', 'description' => 'Classificadoras e depuradoras da pasta de celulose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84391030', 'description' => 'Refinadoras p/fabr.pasta de materia celulosica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84391090', 'description' => 'Outs.maqs.e apars.p/fabr.de pasta de materia celulosica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84392000', 'description' => 'Maqs.e apars.p/fabr.de papel ou cartao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84393010', 'description' => 'Bobinadoras-esticadoras p/acabamento de papel ou cartao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84393020', 'description' => 'Maqs.e apars.p/impregnar papel ou cartao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84393030', 'description' => 'Maqs.e apars.p/ondular papel ou cartao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84393090', 'description' => 'Outs.maqs.e apars.p/acabamento de papel ou cartao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84399100', 'description' => 'Partes de maqs.e apars.p/fabr.pasta de mater.celulosica', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84399910', 'description' => 'Rolos,corrugad/pressao,de maqs.ondular papel,l>=2500 mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84399990', 'description' => 'Outs.partes de maqs.apars.p/fabr/acabam.de papel/cartao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84401011', 'description' => 'Maqs.e apars.de costurar cadernos, c/aliment .automatica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84401019', 'description' => 'Outros maqs.e apars.de costurar cadernos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84401020', 'description' => 'Máquinas para fabricar capas de papelão, com dispositivo de colagem e capacidade de produção superior a 60 unidades por minuto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84401090', 'description' => 'Outros maqs.e apars.p/brochura ou encadernacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84409000', 'description' => 'Partes de maqs.e apars.p/brochura ou encadernacao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84411010', 'description' => 'Cortadeiras bobinadoras p/papel,cartao,etc.v>2000m/min', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84411090', 'description' => 'Outs.cortadeiras p/pasta de papel,papel ou cartao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84412000', 'description' => 'Maqs.p/fabr.de sacos ou envelopes de papel,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84413010', 'description' => 'Maqs.de dobrar e colar,p/fabr.de caixas de papel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84413090', 'description' => 'Outs.maqs.p/fabr.de caixas,tubos,tambores,de papel,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84414000', 'description' => 'Maqs.de moldar artigos de pasta de papel/papel/cartao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84418000', 'description' => 'Outs.maqs.e apars.p/trab.da pasta de papel/papel/cartao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84419000', 'description' => 'Partes de maqs.e apars.p/trab.pasta de papel,papel,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84423010', 'description' => 'Maqs.de compor por processo fotográfico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84423020', 'description' => 'Outs.maqs.apars.e material de compor caracteres tipográficos por outros processos, mesmo com dispositivo de fundir', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84423090', 'description' => 'Outs.maqs.apars.e material p/prepar/fabr.de cliches,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84424010', 'description' => 'Partes de maqs.de compor caract.proc.fotograf.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84424020', 'description' => 'Partes de outs.maqs.apars.etc.p/compor caract.tipograf.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84424090', 'description' => 'Partes de outs.maqs.apars.etc.p/prepar/ fabr.cliches,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84425000', 'description' => 'Caracteres tipograficos e outs.elementos de impressao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431110', 'description' => 'Maqs.e apars.impressao ofset,alim.por bobinas,para impressão multicolor de jornais (...)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431190', 'description' => 'Outras (maqs.e apars.impressao ofset,alim.por bobinas)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431200', 'description' => 'Maqs.e apars.impressao ofset,alim.fls.formato<=22x36cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431310', 'description' => 'Maqs.e apars.impressao ofset,multicol.de mat.plast.etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431321', 'description' => 'Maqs.apars.impressao ofsete,alimentados por folhas de formato inferior ou igual a 37,5cm x 51cm, com velocidade de impressão superior ou igual a 12.000 folhas por hora', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431329', 'description' => 'Outs.maqs.apars.impress.ofsete,alim.bobinas,fl<=37x51cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431390', 'description' => 'Outros maqs.e apars.de impressao por ofset', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431400', 'description' => 'Máquinas e aparelhos de impressão, tipográficos, alimentados por bobinas, exceto máquinas e aparelhos flexográficos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431500', 'description' => 'Máquinas e aparelhos de impressão, tipográficos, não alimentados por bobinas, exceto máquinas e aparelhos flexográficos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431600', 'description' => 'Máquinas e aparelhos de impressão, flexográficos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431710', 'description' => 'Máquinas e aparelhos de impressão, heliográficos, rotativas para heliogravura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431790', 'description' => 'Outros maqs.e apars.de impressao,heliograficos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431910', 'description' => 'Maqs.de impressao p/serigrafia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84431990', 'description' => 'Outros maqs.de impressao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433111', 'description' => 'Máquinas que executem pelo menos duas das seguintes funções impressão, cópia ou transmissão de telecópia (fax), capazes de ser conectadas a uma máquina automática para processamento de dados ou a uma rede (de jato de tinta líquida, com largura de impressã', 'aliquota_federal' => 14.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433112', 'description' => 'Máquinas que executem pelo menos duas das seguintes funções impressão, cópia ou transmissão de telecópia (fax), capazes de ser conectadas a uma máquina automática para processamento de dados ou a uma rede (de transferência térmica de cera sólida (por exem', 'aliquota_federal' => 14.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433113', 'description' => 'Máquinas que executem pelo menos duas das seguintes funções impressão, cópia ou transmissão de telecópia (fax), capazes de ser conectadas a uma máquina automática para processamento de dados ou a uma rede (a laser, led (diodos emissores de luz) ou lcs (si', 'aliquota_federal' => 14.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84433114', 'description' => 'Máquinas que executem pelo menos duas das seguintes funções impressão, cópia ou transmissão de telecópia (fax), capazes de ser conectadas a uma máquina automática para processamento de dados ou a uma rede (a “laser”, led (diodos emissores de luz) ou lcs (', 'aliquota_federal' => 14.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433115', 'description' => 'Máquinas que executem pelo menos duas das seguintes funções impressão, cópia ou transmissão de telecópia (fax), capazes de ser conectadas a uma máquina automática para processamento de dados ou a uma rede (a “laser”, led (diodos emissores de luz) ou lcs (', 'aliquota_federal' => 14.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433116', 'description' => 'Máquinas que executem pelo menos duas das seguintes funções impressão, cópia ou transmissão de telecópia (fax), capazes de ser conectadas a uma máquina automática para processamento de dados ou a uma rede (outras, com largura de impressão superior a 420mm', 'aliquota_federal' => 14.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433119', 'description' => 'Máquinas que executem pelo menos duas das seguintes funções impressão, cópia ou transmissão de telecópia (fax), capazes de ser conectadas a uma máquina automática para processamento de dados ou a uma rede (outras)', 'aliquota_federal' => 14.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433191', 'description' => 'Outras máquinas que executem pelo menos duas das seguintes funções impressão, cópia ou transmissão de telecópia (fax), capazes de ser conectadas a uma máquina automática para processamento de dados ou a uma rede (com impressão por sistema térmico)', 'aliquota_federal' => 14.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433199', 'description' => 'Outras máquinas que executem pelo menos duas das seguintes funções impressão, cópia ou transmissão de telecópia (fax), capazes de ser conectadas a uma máquina automática para processamento de dados ou a uma rede', 'aliquota_federal' => 14.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433221', 'description' => 'Impressoras de impacto,de linha', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433222', 'description' => 'Impressoras de impacto, de caracteres braille', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433223', 'description' => 'Impressoras de impacto, matriciais (por ponto)', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433229', 'description' => 'Outros impressoras de impacto', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433231', 'description' => 'Impressoras c/vi<30ppm,a jato de tinta liq.li<=420mm', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433232', 'description' => 'De transferência térmica de cera sólida (solid ink e dye sublimation, por exemplo)', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433233', 'description' => 'A “laser”, led (diodos emissores de luz) ou lcs (sistema de cristal líquido), monocromáticas, com largura de impressão inferior ou igual a 280mm', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433234', 'description' => 'A “laser”, led (diodos emissores de luz) ou lcs (sistema de cristal líquido), monocromáticas, com largura de impressão superior a 280mm e inferior ou igual a 420mm', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433235', 'description' => 'A “laser”, led (diodos emissores de luz) ou lcs (sistema de cristal líquido), policromáticas, com velocidade de impressão inferior ou igual a 20 páginas por minuto (ppm)', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433236', 'description' => 'A laser, led (diodos emissores de luz) ou lcs (sistema de cristal líquido), policromáticas, com velocidade de impressão superior a 20 páginas por minuto (ppm)', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433237', 'description' => 'Térmicas, dos tipos utilizados em impressão de imagens para diagnóstico médico em folhas revestidas com camada termossensível', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433238', 'description' => 'Outras, com largura de impressão superior a 420mm', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433239', 'description' => 'Outros impressoras c/velocidade de impressão <30ppm', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433240', 'description' => 'Outras impressoras alimentadas por folhas', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433251', 'description' => 'Tracadores graficos (ploters),por meio de penas', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433252', 'description' => 'Tracadores graficos (ploters), com largura de impressão superior a 580mm, exceto por meio de penas', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433259', 'description' => 'Outros tracadores graficos (ploters)', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433291', 'description' => 'Impressoras de código de barras postais, tipo 3 em 5, a jato de tinta fluorescente, com velocidade de até 4,5m/s e passo de 1,4mm', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433299', 'description' => 'Outros teleimpressores', 'aliquota_federal' => 15.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433910', 'description' => 'Maqs.de impressao de jato de tinta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433921', 'description' => 'Máquinas copiadoras eletrostáticas de reprodução da imagem do original sobre a cópia por meio de um suporte intermediário (processo indireto), monocromáticas, para cópias de superfície inferior ou igual a 1m2, com velocidade inferior a 100 cópias por minu', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433928', 'description' => 'Máquinas copiadoras eletrostáticas por processo indireto', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433929', 'description' => 'Outras máquinas copiadoras eletrostáticas', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433930', 'description' => 'Outras maquinas copiadoras', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84433990', 'description' => 'Outros maqs.e apars.de escritorio,bancario, etc.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439110', 'description' => 'Partes de maqs.apars.impressao ofset, alim.fls<=22x36cm', 'aliquota_federal' => 7.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439191', 'description' => 'Maqs.auxiliares de impressao,dobradoras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439192', 'description' => 'Maqs.auxiliares de mpressao,numeradores automaticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439199', 'description' => 'Outros maqs.auxiliares de impressao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439911', 'description' => 'Circuitos impressos com componentes elétricos ou eletrônicos montados para telecopiadoras (fax)', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439912', 'description' => 'Mecanismo de impressao a laser,etc.para telecopiadoras (fax)', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439919', 'description' => 'Outros partes p/ telecopiadoras', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439921', 'description' => 'Mecanismos completos de impressoras matriciais (por pontos) ou de impressoras ou traçadores gráficos (plotters), a jato de tinta, montados', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439922', 'description' => 'Mecanismos completos de impressoras a laser, led (diodos emissores de luz) ou lcs (sistema de cristal líquido), montados', 'aliquota_federal' => 7.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439923', 'description' => 'Cartuchos de tinta', 'aliquota_federal' => 7.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439929', 'description' => 'Outs.partes e acess.de impressoras/ tracadores  graficos', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439931', 'description' => 'Cilindros recobertos de matéria semicondutora fotoelétrica de selênio ou suas ligas, para os aparelhos de fotocópia eletrostático por processo indireto', 'aliquota_federal' => 7.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439932', 'description' => 'Cilindros recobertos de matéria semicondutora fotoelétrica (mecanismos de impressão a laser, a led (diodos emissores de luz) ou a lcs (sistema de cristal líquido)', 'aliquota_federal' => 7.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439933', 'description' => 'Cartuchos de revelador ou de produtos para viragem (toners)  (mecanismos de impressão a laser, a led (diodos emissores de luz) ou a lcs (sistema de cristal líquido)', 'aliquota_federal' => 7.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439939', 'description' => 'Partes e acess.p/ copiadoras', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439941', 'description' => 'Mecanismos de impressão, mesmo sem cabeça de impressão incorporada (mecanismos de impressão por sistema térmico)', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439942', 'description' => 'Cabeças de impressão (mecanismos de impressão por sistema térmico)', 'aliquota_federal' => 7.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439949', 'description' => 'Outros mecanismos de impressão por sistema térmico, suas partes e acessórios', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439950', 'description' => 'Outros mecanismos de impressão, suas partes e acessórios', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439960', 'description' => 'Circuitos impressos com componentes elétricos ou eletrônicos, montados', 'aliquota_federal' => 13.59, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439970', 'description' => 'Bandejas e gavetas, suas partes e acessórios', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84439980', 'description' => 'Mecanismos de alimentação ou de triagem de papéis ou documentos, suas partes e acessórios', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84439990', 'description' => 'Outros', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84440010', 'description' => 'Maqs.p/extrudar materias texteis sinteticas/ artificiais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84440020', 'description' => 'Maqs.p/corte/ruptura de fibras texteis sinteticas/artif', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84440090', 'description' => 'Outs.maqs.p/estirar,etc.materias texteis sintet/artif.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451110', 'description' => 'Cardas p/la', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451120', 'description' => 'Cardas p/prepar.de fibras texteis vegetais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451190', 'description' => 'Cardas p/prepar.de outs.materias texteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451200', 'description' => 'Penteadoras de materias texteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451300', 'description' => 'Bancas de estiramento (bancas de fusos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451910', 'description' => 'Maqs.p/prepar.da seda', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451921', 'description' => 'Maqs.p/recuper.cordas,etc.transform.fibras p/cardagem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451922', 'description' => 'Descarocadeiras e deslintadeiras de algodao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451923', 'description' => 'Maqs.p/desengordurar,lavar,etc.fibras texteis em massa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451924', 'description' => 'Abridoras de fibras de la', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451925', 'description' => 'Abridoras de outs.fibras texteis vegetais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451926', 'description' => 'Maqs.de carbonizar a la', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451927', 'description' => 'Maqs.p/estirar la', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84451929', 'description' => 'Outros maqs.p/prepar.de materia textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84452000', 'description' => 'Filatorios intermitentes p/fiacao de materia textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84453010', 'description' => 'Retorcedeiras de materia textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84453090', 'description' => 'Outros maqs.p/dobragem ou torcao de materia textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454011', 'description' => 'Bobinadeiras de trama de materia textil,automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454012', 'description' => 'Bobinadeiras p/fios elastanos,automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454018', 'description' => 'Outs.bobinadeiras de materia textil,c/atador automat.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454019', 'description' => 'Outros bobinadeiras de materia textil, automatica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454021', 'description' => 'Bobinadeiras de materia textil,n/automat. v>=4000m/min', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454029', 'description' => 'Outros bobinadeiras de materia textil, n/automat.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454031', 'description' => 'Meadeiras de materia textil,c/controle/atador automat.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454039', 'description' => 'Outros meadeiras de materia textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454040', 'description' => 'Noveleiras de materia textil,automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84454090', 'description' => 'Outros maqs.de bobinar ou de dobar,materia textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84459010', 'description' => 'Urdideiras de materia textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84459020', 'description' => 'Passadeiras p/lico e pente,de materia textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84459030', 'description' => 'Maqs.p/amarrar urdideiras de materia textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84459040', 'description' => 'Maqs.p/colocar lamelas de materia textil,automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84459090', 'description' => 'Outros maqs.e apars.p/fabr/prepar.de fios texteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84461010', 'description' => 'Teares p/tecido de larg<=30cm,c/mecanismo jacquard', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84461090', 'description' => 'Outros teares p/tecido de larg<=30cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84462100', 'description' => 'Teares p/tecido de l>30cm,de lancadeira,a motor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84462900', 'description' => 'Outros teares p/tecido de l>30cm,de lancadeira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84463010', 'description' => 'Teares p/tecido de l>30cm,s/lancadeira,a jato de ar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84463020', 'description' => 'Teares p/tecido de l>30cm,s/lancadeira,a jato de agua', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84463030', 'description' => 'Teares p/tecido de l>30cm,s/lancadeira,de projetil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84463040', 'description' => 'Teares p/tecido atoalhado,l>30cm,s/ lancadeira, de pincas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84463090', 'description' => 'Outros teares p/tecido,l>30cm,s/lancadeira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84471100', 'description' => 'Teares circulares,p/malhas,c/cilindro, diametro<=165mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84471200', 'description' => 'Teares circulares,p/malhas,c/cilindro, diametro>165mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84472010', 'description' => 'Teares retilineos,p/malhas,manuais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84472021', 'description' => 'Teares retilineos,motorizados,p/fabr.malha de urdidura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84472029', 'description' => 'Outros teares retilineos,motorizados,p/malhas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84472030', 'description' => 'Maqs.de costura por entrelacamento', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84479010', 'description' => 'Maqs.p/fabr.de redes,tules ou filos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84479020', 'description' => 'Maqs.p/bordar,automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84479090', 'description' => 'Outs.maqs.p/fabr.guipuras,rendas,etc.e inserir tufos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84481110', 'description' => 'Ratieras p/teares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84481120', 'description' => 'Mecanismos jacquard p/teares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84481190', 'description' => 'Redutores,perfuradores e copiadores de cartoes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84481900', 'description' => 'Outs.maqs.e apars.auxiliares p/trab.etc. materia textil', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84482010', 'description' => 'Fieiras p/extrusao de materia textil sintetica/ artif.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84482020', 'description' => 'Outs.partes e acess.de maqs.p/extrusao de mater.textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84482030', 'description' => 'Partes e acess.de maqs.p/corte/ruptura de fibra textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84482090', 'description' => 'Outs.partes e acess.de maqs.p/estirar,etc. mater.textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483100', 'description' => 'Guarnicoes de cardas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483211', 'description' => 'Chapeus (flats) de cardas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483219', 'description' => 'Outros partes e acessorios de cardas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483220', 'description' => 'Partes e acess.de penteadoras de materia textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483230', 'description' => 'Bancas de estiramento de materia textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483240', 'description' => 'Partes e acess.de maqs.p/prepar.da seda', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483250', 'description' => 'Partes e acess.de maqs.p/carbonizar la', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483290', 'description' => 'Outs.partes e acess.de maqs.p/prepar.de materia textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483310', 'description' => 'Cursores de fusos p/maqs.prepar.materia textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483390', 'description' => 'Fusos,suas aletas e aneis,p/maqs.prepar.materia textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483911', 'description' => 'Partes e acess.de filatorios intermitentes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483912', 'description' => 'Partes e acess.de maqs.tow-to-yarn p/fiacao mat.text.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483917', 'description' => 'Partes e acess.de outs.filatorios p/fiacao mater.textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483919', 'description' => 'Partes e acess.de maqs.p/dobragem,torcao de mat.textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483921', 'description' => 'Partes e acess.de bobinadeiras de trama', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483922', 'description' => 'Partes e acess.de bobinadeiras automat.p/fios elastanos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483923', 'description' => 'Partes e acess.de outs.bobinadeiras automaticas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483929', 'description' => 'Partes e acess.de outs.maqs.de bobinar ou de dobar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483991', 'description' => 'Partes e acess.de urdideiras', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483992', 'description' => 'Partes e acess.de passadeiras p/lico e pente', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84483999', 'description' => 'Partes e acess.de outs.maqs.e apars.p/trab.mater.textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84484200', 'description' => 'Pentes,licos e quadros de licos,de teares p/tecidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84484910', 'description' => 'Partes e acess.de maqs.e apars.auxiliares de teares', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84484920', 'description' => 'Partes e acess.de teares p/tecido l>30cm,jato agua,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84484990', 'description' => 'Outros partes e acess.de teares p/tecidos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84485110', 'description' => 'Platinas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84485190', 'description' => 'Outros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84485910', 'description' => 'Partes e acess.de teares circulares p/fabr.de malhas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84485921', 'description' => 'Partes e acess.de teares retilin.manuais, p/fabr.malhas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84485922', 'description' => 'Partes e acess.de teares retilin.p/fabr. malhas urdidura', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84485929', 'description' => 'Outros partes e acess.de outs.teares retilineos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84485930', 'description' => 'Partes e acess.de maqs.p/fabr.de redes,tules,filos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84485940', 'description' => 'Partes e acess.de maqs.p/fabr.guipuras, rendas,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84485990', 'description' => 'Outs.partes e acess.de outs.teares,maqs. costura entrel.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84490010', 'description' => 'Maqs.e apars.p/fabricacao ou acabamento de feltros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84490020', 'description' => 'Maqs.e apars.p/fabr.de falsos tecidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84490080', 'description' => 'Outros maqs.e apars.p/fabr.ou acabam.de chapeus de felt', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84490091', 'description' => 'Partes de maqs.e apars.p/fabr.de falsos tecidos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84490099', 'description' => 'Partes de maqs.e apars.p/fabr/acabam.de feltros,etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84501100', 'description' => 'Maqs.de lavar roupa,cap<=10kg,inteiramente automatica', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84501100', 'description' => 'De uso doméstico', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84501200', 'description' => 'Maqs.de lavar roupa,cap<=10kg,c/secad. centrifugo  incorp', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84501200', 'description' => 'De uso doméstico', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84501900', 'description' => 'Outs.maqs.de lavar roupa,capacidade<=10kg de roupa seca', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84501900', 'description' => 'De uso doméstico', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84502010', 'description' => 'Tuneis continuos de lavar roupa,cap>10kg de roupa seca', 'aliquota_federal' => 6.77, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84502090', 'description' => 'Outs.maqs.de lavar roupa,capacidade>10kg de roupa seca', 'aliquota_federal' => 13.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84502090', 'description' => 'De capacidade superior a 20Kg, em peso de roupa seca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84509010', 'description' => 'Partes de maqs.de lavar roupa,cap>10kg de roupa seca', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84509090', 'description' => 'Partes de maqs.de lavar roupa,cap<=10kg de roupa seca', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84511000', 'description' => 'Maqs.p/lavar roupa,a seco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84512100', 'description' => 'Maqs.p/secar roupa,capacidade<=10kg de roupa seca', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84512100', 'description' => 'De uso doméstico', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84512910', 'description' => 'Outs.maqs.p/secar roupa,por microondas, prod>=120 kg/h', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84512990', 'description' => 'Outras maquinas p/secar roupa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84513010', 'description' => 'Maqs.e prensas p/passar roupa,automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84513091', 'description' => 'Outs.(prensas p/passar de peso <= 14kg', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84513099', 'description' => 'Outs.maqs.e prensas p/passar roupa,incl.as fixadoras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84514010', 'description' => 'Maqs.p/lavar fios,tecidos ou obras de materias texteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84514021', 'description' => 'Maqs.p/tingir tecidos em rolos,por pressao estatica,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84514029', 'description' => 'Outros maqs.p/tingir ou branquear fios ou tecidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84514090', 'description' => 'Maqs.branquear ou tingir outs.materias texteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84515010', 'description' => 'Maqs.p/inspecionar tecidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84515020', 'description' => 'Maqs.p/enfestar ou cortar tecidos,automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84515090', 'description' => 'Outs.maqs.p/enrolar,desenrolar,dobrar,dentear tecidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84518000', 'description' => 'Outros maqs.e apars.p/trabalhar materias texteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84518000', 'description' => 'De uso doméstico', 'aliquota_federal' => 7.26, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84519010', 'description' => 'Partes de maqs.de secar,capacidade<=10kg de roupa seca', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84519090', 'description' => 'Partes de outs.maqs.e apars.p/trabalhar materia textil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84521000', 'description' => 'Maqs.de costura de uso domestico', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522110', 'description' => 'Maqs.p/costurar couros ou peles, automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522120', 'description' => 'Maqs.p/costurar tecidos,automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522190', 'description' => 'Maqs.p/costurar outs.materias,automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522910', 'description' => 'Maqs.p/costurar couros ou peles,nao automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522921', 'description' => 'Remalhadeiras p/costurar tecidos,nao automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522922', 'description' => 'Maqs.p/casear tecidos,nao automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522923', 'description' => 'Maqs.p/inserir elastico em tecido,zigue-zague,n/automat', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522924', 'description' => 'Outros maqs.p/costurar tecidos, de costura reta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522925', 'description' => 'Outros maqs.p/costurar tecidos, galoneiras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522929', 'description' => 'Outros maqs.p/costurar tecidos,nao automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84522990', 'description' => 'Outros maqs.de costura,nao automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84523000', 'description' => 'Agulhas para maqs.de costura', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84529020', 'description' => 'Moveis,bases e tampas,p/maqs.de costura,e suas partes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84529020', 'description' => 'Para máquinas de costura de uso doméstico', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84529081', 'description' => 'Guia-fios,lancadeiras,etc.p/maqs.de costura,domesticas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84529089', 'description' => 'Outros partes de maqs.de costura,de uso domestico', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84529091', 'description' => 'Guia-fios,lancadeiras,etc.p/outs.maqs.de costura', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84529092', 'description' => 'Partes p/remalhadeiras', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84529093', 'description' => 'Partes p/lancadeiras rotativas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84529094', 'description' => 'Corpos moldados por fundição (partes p/lancadeiras rotativas)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84529099', 'description' => 'Partes de outs.maqs.de costurar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84531010', 'description' => 'Maqs.p/dividir couros c/l<=3m,lamina s/fim,eletronicas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84531090', 'description' => 'Outs.maqs.e apars.p/prepar/curtir/trabalh.couros/peles', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84532000', 'description' => 'Maqs.e apars.p/fabr/conserto calcados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84538000', 'description' => 'Maqs.e apars.p/fabr/conserto outs.obras de couros/peles', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84539000', 'description' => 'Partes de maqs.e apars.p/prepar/curtir,etc.couros/peles', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84541000', 'description' => 'Conversores p/metalurgia,aciaria ou fundicao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84542010', 'description' => 'Lingoteiras de fundicao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84542090', 'description' => 'Cadinhos ou colheres de fundicao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84543010', 'description' => 'Maqs.de vazar (moldar) sob pressao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84543020', 'description' => 'Maqs.de vazar (moldar) por centrifugacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84543090', 'description' => 'Outs.maqs.de vazar (moldar),p/metalurgia,aciaria,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84549010', 'description' => 'Partes de maqs.de vazar (moldar) por centrifugacao', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84549090', 'description' => 'Partes de conversores,etc.p/metalurgia/aciaria/fundicao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84551000', 'description' => 'Laminador de metais,de tubo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84552110', 'description' => 'Laminador a quente e/ou frio,de metais,de cilindro liso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84552190', 'description' => 'Outros laminadores a quente e/ou frio,de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84552210', 'description' => 'Laminador a frio de metais,de cilindro liso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84552290', 'description' => 'Outros laminadores a frio de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84553010', 'description' => 'Cilindros de laminadores,fundidos,de aco/ferro nodular', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84553020', 'description' => 'Outros cilindros de laminadores de metais forjados, de aço de corte rápido, com um teor, em peso, de carbono superior ou igual a 0,80% e inferior ou igual a 0,90%, de cromo superior ou igual a 3,50% e inferior ou igual a 4%, de vanádio superior ou igual a', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84553090', 'description' => 'Outros cilindros de laminadores de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84559000', 'description' => 'Outros partes de laminadores de metais', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84561111', 'description' => 'Para corte de chapas metalicas de espessura superior a 8 mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84561119', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84561190', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84561211', 'description' => 'Para corte de chapas metalicas de espessura superior a 8 mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84561219', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84561290', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84562010', 'description' => 'Maqs.ferram.a ultra-som,de comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84562090', 'description' => 'Outros maqs.ferram.oper.por ultra-som', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84563011', 'description' => 'Maqs.ferram.a eletro-erosao,de comando numerico p/ texturizar superfícies cilindricas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84563019', 'description' => 'Outras (maqs.ferram.a eletro-erosao,de comando numerico)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84563090', 'description' => 'Outros maqs.ferram.oper.por eletro-erosao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84564000', 'description' => 'Que operem por jato de plasma', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84565000', 'description' => 'Maquinas de corte a jato de agua', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84569000', 'description' => 'Outs.maqs.ferram.oper.por proc. eletroquimicos, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84571000', 'description' => 'Centros de usinagem,p/trabalhar metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84572010', 'description' => 'Maqs.de sistema monostatico,p/trab.metais,de cmdo.numer', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84572090', 'description' => 'Outros maqs.de sistema monostatico,p/trab. metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84573010', 'description' => 'Maqs.de estacoes multiplas,p/trab.metais,de cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84573090', 'description' => 'Outros maqs.de estacoes multiplas,p/trab. metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84581110', 'description' => 'Tornos horiz.p/trab.metais,c/cmdo.numer.tipo revolver', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84581191', 'description' => 'Outros tornos horiz.p/trab.metais, c/cmdo.numer., de 6 ou mais fusos porta-peças', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84581199', 'description' => 'Outros tornos horiz.p/trab.metais, c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84581910', 'description' => 'Tornos horiz.p/trab.metais,s/cmdo.numer.tipo revolver', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84581990', 'description' => 'Outros tornos horiz.p/trab.metais,s/cmdo. numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84589100', 'description' => 'Outros tornos p/trab.metais,c/comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84589900', 'description' => 'Outros tornos p/trab.metais,s/comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84591000', 'description' => 'Maqs.ferram.p/furar,mandrilar,etc.metais,cabeca desliz.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84592110', 'description' => 'Maqs.ferram.p/furar metais,cmd.num.radiais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84592191', 'description' => 'Maqs.ferram.p/furar metais,cmd.num. cabecote >=1mono/mult', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84592199', 'description' => 'Outros maqs-ferram.p/furar metais,cmd.num.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84592900', 'description' => 'Outros maqs-ferram.p/furar metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84593100', 'description' => 'Outs.mandriladoras-fresadoras de metais, c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84593900', 'description' => 'Outs.mandriladoras-fresadoras de metais,s/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84594100', 'description' => 'De comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84594900', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84595100', 'description' => 'Maqs.ferram.p/fresar metais,c/console,c/ cmdo. numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84595900', 'description' => 'Maqs.ferram.p/fresar metais,c/console, s/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84596100', 'description' => 'Maqs.ferram.p/fresar metais,s/console, c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84596900', 'description' => 'Maqs.ferram.p/fresar metais,s/console, s/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84597000', 'description' => 'Outros maqs.ferram.p/roscar interior/ exteriormente metal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84601200', 'description' => 'De comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84601900', 'description' => 'Outs.maqs.ferram.p/retif.superf.plana de metais,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84602200', 'description' => 'Maquinas para retificar sem centro, de comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84602300', 'description' => 'Outras maquinas para retificar superficies cilindricas, de comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84602400', 'description' => 'Outras, de comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84602900', 'description' => 'Outs.maqs.ferram.p/retif.metais/ceramais,prec>=0.01mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84603100', 'description' => 'Maqs.ferram.p/afiar metais/ceramais, c/comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84603900', 'description' => 'Outros maqs.ferram.p/afiar metais/ceramais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84604011', 'description' => 'Brunidoras p/cilindros de metais,d<=312mm, c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84604019', 'description' => 'Outs.maqs.ferram.p/brunir metais/ceramais, c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84604091', 'description' => 'Outs.brunidoras p/cilindros de metais/ ceramais,d<=312mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84604099', 'description' => 'Outros maqs.ferram.p/brunir metais/ ceramais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84609011', 'description' => 'Outs.maqs.ferram.de polir, com cinco ou mais cabeças e porta - peças rotativo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84609012', 'description' => 'Outs.maqs.ferram de esmerilhar, com duas ou mais cabeças e porta- peças rotativo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84609019', 'description' => 'Outs.maqs.ferram.p/amolar,etc.metais/ceramais,c/cmd.num', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84609090', 'description' => 'Outros maqs.ferram.p/amolar,etc.metais/ceramais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84612010', 'description' => 'Maqs.ferram.p/escatelar engrenagens', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84612090', 'description' => 'Plainas-limadoras de engrenagens', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84613010', 'description' => 'Maqs.ferram.p/brochar engrenagens, c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84613090', 'description' => 'Outros maqs.ferram.p/brochar engrenagens', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84614010', 'description' => 'Denteadoras de engrenagens,com comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84614091', 'description' => 'Outros redondeadoras de dentes de engrenagens', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84614099', 'description' => 'Outros maqs.ferram.p/cortar/acabar engrenagens', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84615010', 'description' => 'Maqs.ferram.p/serrar/seccionar metais,de fitas sem fim', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84615020', 'description' => 'Maqs.ferram.p/serrar/seccionar metais,circulares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84615090', 'description' => 'Outros maqs.ferram.p/serrar/seccionar metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84619010', 'description' => 'Outs.maqs.ferram.oper.por elim.metal,etc. c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84619090', 'description' => 'Outros maqs.ferram.oper.por elim.metal,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84621011', 'description' => 'Maqs.ferram.p/estampar metais,c/comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84621019', 'description' => 'Maqs.ferram.p/forjar metais,martelos, etc.c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84621090', 'description' => 'Outs.maqs.ferram.p/forjar/estampar metais, martelos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84622100', 'description' => 'Maqs-ferram.p/enrolar,arquear,etc. metais,c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84622900', 'description' => 'Outs.maqs-ferram.p/enrolar,arquear, dobrar, etc.metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84623100', 'description' => 'Maqs.ferram.p/cisalhar metais,c/comando numerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84623910', 'description' => 'Maqs-ferram.p/cisalhar metais,tipo guilhotina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84623990', 'description' => 'Outros maqs.ferram.p/cisalhar metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84624100', 'description' => 'Maqs.ferram.p/puncionar/chanfrar metais, c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84624900', 'description' => 'Outros maqs.ferram.p/puncionar/chanfrar metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84629111', 'description' => 'Prensas hidraul.p/moldag.po metal.por sinter.c<=35000kn', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84629119', 'description' => 'Outs.prensas hidraul.p/metais/carbon.metal. c<=35000kn', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84629191', 'description' => 'Outs.prensas hidraul.p/moldag.po metal.por sinter.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84629199', 'description' => 'Outros prensas hidraul.p/metais/carbon. metal.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84629910', 'description' => 'Outros prensas p/moldag.de po metal.por sinter.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84629920', 'description' => 'Outs.prensas p/extrusao de metais/ carbonetos metalicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84629990', 'description' => 'Outs.prensas p/trabalhar metais/carbonetos metalicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84631010', 'description' => 'Bancas p/estirar tubos de metais/ceramais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84631090', 'description' => 'Bancas p/estirar barras,perfis,fios de metais/ceramais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84632010', 'description' => 'Maqs.ferram.p/fazer roscas por lamin.metais,c/cmd.numer', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84632091', 'description' => 'Outs.maqs.ferram.de pente plano,cap>=160 roscas/min.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84632099', 'description' => 'Outs.maqs.ferram.p/fazer roscas por lamin.de metais,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84633000', 'description' => 'Maqs.ferram.p/trabalhar arames e fios de metal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84639010', 'description' => 'Outs.maqs.ferram.p/trab.metais,s/elim.mater.c/cmd.numer', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84639090', 'description' => 'Outros maqs.ferram.p/trab.metais,s/elim.mater.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84641000', 'description' => 'Maqs.ferram.p/serrar pedra,prods.ceramicos,concreto,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84642010', 'description' => 'Maqs.ferram.p/esmerilar/polir vidro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84642021', 'description' => 'Maqs.ferram.p/polir placas,pavim.revestim.de ceramica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84642029', 'description' => 'Outs.maquinas ferram.p/esmerilar/polir ceramica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84642090', 'description' => 'Maqs.ferram.p/esmerilar/polir pedra, prods.ceramicos,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84649011', 'description' => 'Outs.maqs.ferram.p/retif.fresar,etc.vidro,c/cmd.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84649019', 'description' => 'Outros maqs.ferram.p/trab.a frio do vidro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84649090', 'description' => 'Outs.maqs.ferram.p/trab.pedra,prods.ceramicos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84651000', 'description' => 'Maqs.ferram.p/trab.madeira,etc.c/difer.operac.s/trocar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84652000', 'description' => 'Centros de usinagem (fabricacao*)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659110', 'description' => 'Maqs.ferram.de serrar madeira,cortica, etc.de fita s/fim', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659120', 'description' => 'Maqs.ferram.de serrar madeira,cortica, etc.circulares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659190', 'description' => 'Outs.maqs.ferram.de serrar madeira,cortica, osso,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659211', 'description' => 'Fresadoras de madeira,cortica,osso,etc. c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659219', 'description' => 'Maqs.ferram.p/desbastar,etc.madeira,etc.c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659290', 'description' => 'Outs.maqs.ferram.p/desbastar,etc.madeira,cortica,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659310', 'description' => 'Lixadeiras p/madeira,cortica,osso,borracha endurec.etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659390', 'description' => 'Outs.maqs.ferram.p/esmerilar/polir madeira, cortica,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659400', 'description' => 'Maqs.ferram.p/arquear/reunir madeira, cortica, osso,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659511', 'description' => 'Maqs.ferram.p/furar madeira,cortica,etc. c/cmdo.numer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659512', 'description' => 'Maqs.ferram.p/escatelar madeira,cortica,etc. c/cmdo.num.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659591', 'description' => 'Outs.maqs.ferram.p/furar madeira,cortica, osso,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659592', 'description' => 'Outs.maqs.ferram.p/escatelar madeira, cortica, osso,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659600', 'description' => 'Maqs.ferram.p/fender/seccionar/desenrolar madeira,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84659900', 'description' => 'Outs.maqs.ferram.p/trab.madeira,cortica,osso,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84661000', 'description' => 'Porta-ferramentas e fieiras de abertura automatica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84662010', 'description' => 'Porta-pecas p/tornos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84662090', 'description' => 'Porta-pecas p/outs.maqs.ferram.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84663000', 'description' => 'Dispositivos divisores/especiais p/maqs. ferram.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669100', 'description' => 'Partes e acess.de maqs.ferram.p/trab.pedra, concreto,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669200', 'description' => 'Partes e acess.de maqs.ferram.p/trab. madeira, osso,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669311', 'description' => 'Partes e acess.de maqs.ferram.oper.por ultra-som', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669319', 'description' => 'Partes e acess.de maqs.ferram.oper.por laser,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669320', 'description' => 'Partes e acess.de centros de usinagem, etc.p/trab.metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669330', 'description' => 'Partes e acess.de tornos p/metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669340', 'description' => 'Partes e acess.de maqs.ferram.p/furar, fresar,etc.metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669350', 'description' => 'Partes e acess.de maqs.ferram.p/afiar,amolar,etc.metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669360', 'description' => 'Partes e acess.de maqs.ferram.p/aplainar,etc.engrenagem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669410', 'description' => 'Partes e acess.de maqs.ferram.p/forjar, etc.metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669420', 'description' => 'Partes e acess.de maqs.ferram.p/enrolar, etc.metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669430', 'description' => 'Partes e acess.de prensas p/extrusao de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84669490', 'description' => 'Partes e acess.de outs.maqs.ferram.p/trab. metais,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84671110', 'description' => 'Furadeiras pneumaticas rotativas,de uso manual', 'aliquota_federal' => 6.63, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84671190', 'description' => 'Outs.ferramentas pneumaticas rotativas,de uso manual', 'aliquota_federal' => 6.63, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84671900', 'description' => 'Outros ferramentas pneumaticas,de uso manual', 'aliquota_federal' => 6.63, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84672100', 'description' => 'Furadeiras de todos os tipos, incluidas as perfuratrizes (perfuradoras0 rotativas, c/motor eletrico incorporado', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84672200', 'description' => 'Serras, c/ motor eletrico incorporado', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84672910', 'description' => 'Tesouras, c/ motor eletrico incorporado', 'aliquota_federal' => 7.98, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84672991', 'description' => 'Cortadoras de tecidos, c/ motor eletrico incorporado', 'aliquota_federal' => 7.98, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84672992', 'description' => 'Parafusadeiras e rosqueadeiras, c/ motor eletrico incorporado', 'aliquota_federal' => 7.98, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84672993', 'description' => 'Martelos com motor eletrico incorporado', 'aliquota_federal' => 7.98, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84672999', 'description' => 'Outras ferramentas com motor eletr.incorp.', 'aliquota_federal' => 7.98, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84678100', 'description' => 'Serras de corrente,de uso manual', 'aliquota_federal' => 7.98, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84678900', 'description' => 'Outros ferramentas hidraul/de motor n/eletr.de uso manu', 'aliquota_federal' => 7.98, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84679100', 'description' => 'Partes de serras de corrente,de uso manual', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84679200', 'description' => 'Partes de ferramentas pneumaticas,de uso manual', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84679900', 'description' => 'Partes de ferramentas hidraul/de motor n/eletr.manuais', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84681000', 'description' => 'Macaricos de uso manual', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84682000', 'description' => 'Outros maqs.e apars.a gas,p/tempera superficial', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84688010', 'description' => 'Maqs.e apars.p/soldar por friccao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84688090', 'description' => 'Outros maqs.e apars.p/soldar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84689010', 'description' => 'Partes de macaricos de uso manual', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84689020', 'description' => 'Partes de maqs.e apars.p/soldar por friccao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84689090', 'description' => 'Partes de outs.maqs.e apars.p/soldar,maqs.e apars.a gas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84701000', 'description' => 'Calculadoras eletrônicas capazes de funcionar sem fonte externa de energia elétrica e máquinas de bolso com função de cálculo incorporada que permitam gravar, reproduzir e visualizar informações', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84701000', 'description' => 'Calculadora equipada com sintetizador de voz', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84702100', 'description' => 'Maqs.de calcular,eletron.c/disposit. impressor incorpor.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84702900', 'description' => 'Outros maqs.de calcular,eletron.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84703000', 'description' => 'Outros maqs.de calcular', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84705011', 'description' => 'Caixas registradoras,eletron.com capacidade de comunicação bidirecional com computadores ou outras máquinas digitais', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84705019', 'description' => 'Outros caixas registradoras eletronicas', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84705090', 'description' => 'Outros caixas registradoras', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84709010', 'description' => 'Maqs.de franquear correspondencia', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84709090', 'description' => 'Outs.maqs.de contabilidade, franquear,emitir tiquetes e maqs.semelh.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84713011', 'description' => 'Maqs.dig.proc.dados,bater/eletr.portat.p<350g,t<=140cm2', 'aliquota_federal' => 11.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84713012', 'description' => 'Maqs.dig.proc.dados,bater/eletr.portat.p<3.5kg,t<560cm2', 'aliquota_federal' => 11.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84713019', 'description' => 'Outs.maqs.digit.p/proc.dados,bater/eletr.portat.p<=10kg', 'aliquota_federal' => 11.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84713090', 'description' => 'Outs.maqs.automat.digit.p/proc.dados,portat.p<=10kg,etc', 'aliquota_federal' => 11.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84714110', 'description' => 'Maqs.dig.proc.dados,de peso inferior a 750g, sem teclado, com reconhecimento de escrita, entrada de dados e de comandos por meio de uma tela de área inferior a 280cm2', 'aliquota_federal' => 13.33, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84714190', 'description' => 'Outs.maqs.digit.p/proc.dados,c/ucp,mesmo c/unid.e/s', 'aliquota_federal' => 13.33, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84714900', 'description' => 'Outs maqs.p/processam.de dados apresentadas sob a forma de sistemas', 'aliquota_federal' => 13.33, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84715010', 'description' => 'Unid.proc.digit.de pequena capacidade, baseadas em microprocessadores, com capacidade de instalação, dentro do mesmo gabinete, de unidades de memória da subposição 8471.70, podendo conter múltiplos conectores de expansão (slots), e valor fob inferior ou', 'aliquota_federal' => 12.94, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84715020', 'description' => 'Unid.proc.digit.med.cap.etc.us$12500<fob<=us$46000', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84715030', 'description' => 'Unid.proc.digit.gde.cap.etc.  us$46000<fob <=us$100000', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84715040', 'description' => 'Unid.proc.digit.muito gde.cap.etc.fob >us$100000', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84715090', 'description' => 'Outs.unid.proc.digit.com unid.memo e/ou 1 unid.e/s', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716052', 'description' => 'Teclados p/maqs.automat.proc.dados', 'aliquota_federal' => 12.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716052', 'description' => 'Com colmeia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716053', 'description' => 'Indicadores ou apontadores (“mouse” e “track-ball”, por exemplo)', 'aliquota_federal' => 12.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716053', 'description' => 'Indicador ou apontador  mouse  com entrada para acionador', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716053', 'description' => 'Acionador de pressão', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716054', 'description' => 'Mesas digitalizadoras,p/maqs.automat. proc.dados', 'aliquota_federal' => 12.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716059', 'description' => 'Outs.unidades de entrada,p/maqs.automat. proc.dados', 'aliquota_federal' => 12.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716061', 'description' => 'Apars.terminais c/teclado alfanumer.e video monocromat.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716062', 'description' => 'Apars.terminais c/teclado alfanumer.e video policromat.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716080', 'description' => 'Terminais de auto-atendimento bancario', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716090', 'description' => 'Outros unidades de entrada/saida,p/maqs. proc.dados', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84716090', 'description' => 'Linha Braille', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84717011', 'description' => 'Unidades de discos magneticos,p/discos flexiveis', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84717012', 'description' => 'Unidades de discos magneticos,p/discos rigidos, com um só conjunto cabeça-disco (hda-head disk assembly)', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84717019', 'description' => 'Outros unidades de discos magneticos', 'aliquota_federal' => 13.59, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84717021', 'description' => 'Unidades de discos opticos,exclusivamente  para leitura de dados', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84717029', 'description' => 'Outros unidades de discos opticos', 'aliquota_federal' => 10.75, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84717032', 'description' => 'Unidades de fitas magneticas,p/cartuchos', 'aliquota_federal' => 13.59, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84717033', 'description' => 'Unidades de fitas magneticas,p/cassetes', 'aliquota_federal' => 13.59, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84717039', 'description' => 'Outros unidades de fitas magneticas', 'aliquota_federal' => 13.59, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84717090', 'description' => 'Outros unidades de memoria', 'aliquota_federal' => 13.59, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84718000', 'description' => 'Outs.unidades de maqs.automats.p/ processamento  de dados', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84719011', 'description' => 'Leitores ou gravadores de cartoes magneticos', 'aliquota_federal' => 12.42, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84719012', 'description' => 'Leitores de codigos de barras', 'aliquota_federal' => 12.42, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84719013', 'description' => 'Leitores de caracteres magnetizaveis', 'aliquota_federal' => 12.42, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84719014', 'description' => 'Digitalizadores de imagens (scanners),p/maqs. automat.proc.dados', 'aliquota_federal' => 12.42, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84719014', 'description' => 'Equipados com sintetizador de voz', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84719019', 'description' => 'Outs.leitores ou gravadores,de processamento de dados', 'aliquota_federal' => 12.42, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84719090', 'description' => 'Outs.maqs.automats.p/processam.de dados e suas unidades', 'aliquota_federal' => 12.42, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84721000', 'description' => 'Duplicadores hectograficos ou a estencil,p/escritorio', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84721000', 'description' => 'Duplicador Braille', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84723010', 'description' => 'Maqs.automat.p/obliterar selos postais', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84723020', 'description' => 'Maqs.automat.p/selecao correspond.leit.opt.cod.post.etc', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84723030', 'description' => 'Maqs.automat.p/selecao encomendas,leit.opt. cod.post.etc', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84723090', 'description' => 'Outs.maqs.p/selecionar,dobrar,abrir,etc.correspondencia', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729010', 'description' => 'Distribuidores automat.papel-moeda,incl. efet.outs.oper.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729021', 'description' => 'Maqs.eletron.bancarias de autent.comun.c/ computador,etc', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729029', 'description' => 'Outros maqs.bancarias,c/disposit. p/autenticar', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729030', 'description' => 'Maqs.p/selecionar e contar moedas ou papel-moeda', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729040', 'description' => 'Maqs.de apontar lapis,perfuradores, grampeadores,etc.', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729051', 'description' => 'Classificadoras automat.docum.c/leit/grav. c>400doc/min', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729059', 'description' => 'Outros classificadoras automat.docum. c/leit/grav.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729091', 'description' => 'Maqs.p/imprimir enderecos,p/estampar placa de enderecos', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729099', 'description' => 'Outros maqs.e apars.de escritorio,bancario, etc.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84729099', 'description' => 'Outros maqs.e apars.de escritorio,bancario, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84732100', 'description' => 'Partes e acess.de maqs.de calcular eletronicas', 'aliquota_federal' => 4.76, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84732910', 'description' => 'Circuito impresso montado p/caixa registradora', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84732920', 'description' => 'Partes e acess.de outs.maqs.de calcular/ contabilidade', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84732990', 'description' => 'Partes e acess.de maqs.de franquear,emitir tiquetes,etc', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733011', 'description' => 'Gabinete c/fonte de aliment.p/maqs.automat. proc.dados', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733019', 'description' => 'Outros gabinetes p/maqs.automat.proc.dados', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733031', 'description' => 'Conjuntos cabeca-disco de unid.de disco rigido,montados', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733032', 'description' => 'Bracos posicion.de cabeca magnet.p/unid.de discos/fitas', 'aliquota_federal' => 5.34, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733033', 'description' => 'Cabecas magneticas p/unidades de discos ou de fitas', 'aliquota_federal' => 5.34, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733034', 'description' => 'Mecanismo bobinador p/unidades de fitas magneticas', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733039', 'description' => 'Outs.partes e acess.de unid.de discos/fitas magneticos', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733041', 'description' => 'Placas-mae montadas (circuitos impressos com componentes elétricos ou eletrônicos, montados)', 'aliquota_federal' => 11.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733042', 'description' => 'Placas de memoria,montadas,s<=50cm2,p/maqs. proc.dados', 'aliquota_federal' => 11.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733043', 'description' => 'Placas de microprocessamento com dispositivo de dissipação de calor, inclusive em cartuchos', 'aliquota_federal' => 5.34, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733049', 'description' => 'Outs.circuitos impressos p/maqs.automat. proc.dados', 'aliquota_federal' => 11.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733092', 'description' => 'Telas (displays) para máquinas automáticas para processamento de dados, portáteis', 'aliquota_federal' => 5.34, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84733099', 'description' => 'Outros partes e acess.p/maqs.automat. proc.dados', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84734010', 'description' => 'Circuito impresso montado p/maqs.e apars. escritorio', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84734070', 'description' => 'Outs.partes e acess.p/maqs.bancaria,distrib. papel-moeda', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84734090', 'description' => 'Outs.partes e acess.p/maqs.e apars.de escritorio,etc.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84734090', 'description' => 'Outs.partes e acess.p/maqs.e apars.de escritorio,etc.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84735010', 'description' => 'Circuito impresso montado util.em 2/mais dif.maqs.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84735040', 'description' => 'Cabecas magneticas,util.2/mais dif.maqs.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84735050', 'description' => 'Placas de memoria,superf<=50cm2,util.2/mais dif.maqs.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84735090', 'description' => 'Outros partes e acess.util.2/mais dif.maqs.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84741000', 'description' => 'Maqs.e apars.p/selecionar,etc.subst.miner. solida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84742010', 'description' => 'Maqs.e apars.p/esmagar,etc.subst. miner. solida,de bolas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84742090', 'description' => 'Outs.maqs.e apars.p/esmagar,etc.subst. miner.solida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84743100', 'description' => 'Betoneiras e apars.p/amassar cimento', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84743200', 'description' => 'Maqs.p/misturar materias minerais c/betume', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84743900', 'description' => 'Outs.maqs.e apars.p/misturar/amassar subst.miner.solida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84748010', 'description' => 'Maqs.e apars.p/fabr.de moldes de areia p/fundicao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84748090', 'description' => 'Maqs.p/aglomerar/moldar combustiveis miner.solidos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84749000', 'description' => 'Partes de maqs.e apars.p/selecionar,etc. subst.minerais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84751000', 'description' => 'Maqs.p/montag.de lampadas/tubos/valvulas, eletricos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84752100', 'description' => 'Maqs.p/fabr.de fibras opticas e seus esbocos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84752910', 'description' => 'Maqs.p/fabr.de recipientes de vidro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84752990', 'description' => 'Outs.maqs.p/fabr/trab.a quente,de vidro e suas obras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84759000', 'description' => 'Partes de maqs.p/fabr/trab.a quente,de vidro e s/obras', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84762100', 'description' => 'Maqs.automat.de venda de bebidas,c/disp. aquec/refrig.', 'aliquota_federal' => 19.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84762900', 'description' => 'Outros maqs.automat.de venda de bebidas', 'aliquota_federal' => 19.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84768100', 'description' => 'Maqs.automat.de venda de alimentos,c/disp .aquec/refrig.', 'aliquota_federal' => 19.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84768910', 'description' => 'Maqs.automat.de venda de selos postais', 'aliquota_federal' => 19.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84768990', 'description' => 'Maqs.automat.de venda de outros produtos', 'aliquota_federal' => 19.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84769000', 'description' => 'Partes de maqs.automat.de venda de produtos', 'aliquota_federal' => 19.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84771011', 'description' => 'Maqs.de moldar termopl.p/inj<=5kg,horiz.cmd. num.monocol', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84771019', 'description' => 'Outs.maqs.de moldar borracha/plast.p/inj. horiz.cmd.num.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84771021', 'description' => 'Outs.maqs.de moldar termopl.p/inj<=5kg, horiz.monocol.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84771029', 'description' => 'Outros maqs.de moldar borracha/plast. p/inj. horiz.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84771091', 'description' => 'Outs.maqs.de moldar borracha/plast. p/inj. cmd.num.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84771099', 'description' => 'Outros maqs.de moldar borracha/plast.p/inj.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84772010', 'description' => 'Extrusoras p/materiais termoplasticos,diam. rosca<=300mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84772090', 'description' => 'Outros extrusoras p/borracha ou plastico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84773010', 'description' => 'Maqs.p/fabr.recip.termopl.c<=5l,prod<=1000u/h,p/insufl.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84773090', 'description' => 'Outs.maqs.de moldar borracha/plast.por insuflacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84774010', 'description' => 'Maqs.de moldar a vacuo poliestireno expand/polipropilen', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84774090', 'description' => 'Outs.maquinas de moldar a vacuo ou de termoformar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84775100', 'description' => 'Maqs.p/moldar/recauchutar pneumat.e moldar camara-de-ar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84775911', 'description' => 'Prensas p/moldar borracha/plast. cap <=30000kn', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84775919', 'description' => 'Outros prensas p/moldar borracha/plast.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84775990', 'description' => 'Outros maqs.e apars.p/moldar borracha/plast.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84778010', 'description' => 'Máquina de unir lâminas de borracha entre si ou com tecidos com borracha, para fabricação de pneumáticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84778090', 'description' => 'Outs.maqs.e apars.p/trab.borracha/plast.ou fabr.s/prods', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84779000', 'description' => 'Partes de maqs.e apars.p/trab.borracha/ plast. fabr.prods', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84781010', 'description' => 'Batedoras-separadoras automat.de talos/ folhas de fumo', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84781090', 'description' => 'Outros maqs.e apars.p/preparar/transformar fumo', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84789000', 'description' => 'Partes de maqs.e apars.p/preparar/ transformar  fumo', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84791010', 'description' => 'Maqs.e apars.automotrizes p/espalhar,etc. pavim. betumin.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84791090', 'description' => 'Outs.maqs.e apars.p/obras publicas, construcao civil,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84792000', 'description' => 'Maqs.e apars.p/extracao,etc.de oleo/gordura animal/veg.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84793000', 'description' => 'Prensas p/fabr.painel de particulas,fibras madeira,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84794000', 'description' => 'Maqs.p/fabr.de cordas/cabos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84795000', 'description' => 'Robos industriais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84796000', 'description' => 'Apars.de evaporacao para arrefecimento do ar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84797100', 'description' => 'Pontes de embarque para passageiros dos tipos usados em aeroportos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84797900', 'description' => 'Outras pontes de embarque para passageiros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798110', 'description' => 'Diferenciadores das tensões de tração de entrada e saída da chapa em instalações de galvanoplastia (maqs.e apars.p/tratam.de metais)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84798190', 'description' => 'Outras (maqs.e apars.p/tratam.de metais)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798210', 'description' => 'Outros misturadores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798290', 'description' => 'Outs.maqs.e apars.p/amassar,esmagar,moer, separar,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798911', 'description' => 'Outros prensas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798912', 'description' => 'Outs.distribuidores/doseadores de solidos/ liquidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798921', 'description' => 'Maqs.e apars.p/cestaria/espartaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798922', 'description' => 'Maqs.e apars.p/fabr.de pinceis/broxas/ escovas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798931', 'description' => 'Limpadores de para-brisas eletricos, p/aeronaves', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798932', 'description' => 'Acumuladores hidraulicos p/aeronaves', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798940', 'description' => 'Silos metalicos p/cereais,fixos,incl.as baterias,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798991', 'description' => 'Apars.p/limpar pecas por ultra-som', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798992', 'description' => 'Maqs.de leme p/embarcacoes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84798999', 'description' => 'Outros maqs.e apars.mecanicos c/funcao propria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84799010', 'description' => 'Partes de limpadores de para-brisas,etc. p/aeronaves', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84799090', 'description' => 'Outs.partes de maqs.e apars.mecanicos c/funcao propria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84801000', 'description' => 'Caixas de fundicao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84802000', 'description' => 'Placas de fundo p/moldes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84803000', 'description' => 'Modelos p/moldes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84804100', 'description' => 'Moldes p/moldagem de metais,etc.por injecao/compressao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84804910', 'description' => 'Coquilhas p/metais/carbonetos metalicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84804990', 'description' => 'Outros moldes p/metais/carbonetos metalicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84805000', 'description' => 'Moldes p/vidros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84806000', 'description' => 'Moldes p/materias minerais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84807100', 'description' => 'Moldes p/moldagem de borrracha/plastico,por injecao,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84807910', 'description' => 'Para vulcanização de pneumáticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84807990', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84811000', 'description' => 'Valvulas redutoras de pressao', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84812011', 'description' => 'Valvulas rotativas,de caixas de direcao hidraulica, com pinhão', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84812019', 'description' => 'Outras valvulas rotativas,de caixas de direcao hidraulica', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84812090', 'description' => 'Outs.valvulas p/transmissoes oleo-hidraulicas/pneumat.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84813000', 'description' => 'Valvulas de retencao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84814000', 'description' => 'Valvulas de seguranca ou de alivio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818011', 'description' => 'Valvulas p/escoamento,util.em banheiros/ cozinhas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818019', 'description' => 'Outros dispositivos util.em banheiros/cozinhas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818021', 'description' => 'Valvulas de expansao termostaticas/ pressostaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818029', 'description' => 'Outros dispositivos util.em refrigeracao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818029', 'description' => 'Do tipo gaveta ou do tipo esfera, de ferro ou aço ou de cobre e suas ligas, e do tipo globo, do tipo borboleta, do tipo agulha ou do tipo diafragma, de ferro ou aço', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818031', 'description' => 'Válvulas dos tipos utilizados em equipamentos de gás, próprias para aparelhos domésticos', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818039', 'description' => 'Outras válvulas dos tipos utilizados em equipamentos de gás', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818091', 'description' => 'Valvulas tipo aerosol', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818092', 'description' => 'Valvulas solenoides', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818093', 'description' => 'Valvulas tipo gaveta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818094', 'description' => 'Valvulas tipo globo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818095', 'description' => 'Valvulas tipo esfera', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818096', 'description' => 'Torneiras e outs.dispositivos p/canalizacoes, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818097', 'description' => 'Valvulas tipo borboleta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84818099', 'description' => 'Torneiras e outs.dispositivos p/canalizacoes, etc.', 'aliquota_federal' => 14.83, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84819010', 'description' => 'Partes de valvulas tipo aerosol/disp.util. banheiros,etc', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84819010', 'description' => 'Dos dispositivos do item 8481.80.1', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84819090', 'description' => 'Partes de torneiras,outs.dispositiv.p/ canalizacoes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84821010', 'description' => 'Rolamentos de esferas,de carga radial', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84821090', 'description' => 'Outros rolamentos de esferas', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84822010', 'description' => 'Rolamentos de roletes conicos,de carga radial', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '84822090', 'description' => 'Outros rolamentos de roletes conicos', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84823000', 'description' => 'Rolamentos de roletes em forma de tonel', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84824000', 'description' => 'Rolamentos de agulhas', 'aliquota_federal' => 7.26, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84825010', 'description' => 'Rolamentos de roletes cilindricos,de carga radial', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84825090', 'description' => 'Outros rolamentos de roletes cilindricos', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84828000', 'description' => 'Outs.rolamentos de roletes,incl.rolamentos combinados', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84829111', 'description' => 'Esferas de aco calibradas p/carga de canetas esferograf', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84829119', 'description' => 'Outros esferas de aco calibradas,p/ rolamentos', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84829120', 'description' => 'Roletes cilindricos p/rolamentos', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84829130', 'description' => 'Roletes conicos p/rolamentos', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84829190', 'description' => 'Outros esferas,roletes e agulhas p/rolamentos', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84829910', 'description' => 'Selos, capas e porta-esferas de aço (partes de rolamentos)', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84829990', 'description' => 'Outros partes de rolamentos', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84831011', 'description' => 'Virabrequins (cambotas), forjados, de peso superior ou igual a 900kg e comprimento superior ou igual a 2.000mm', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84831019', 'description' => 'Outros - virabrequins (cambotas)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84831019', 'description' => 'Para motores de ignição por compressão de potência igual ou superior a 125HP, próprios para ônibus ou caminhões', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84831020', 'description' => 'Arvores de cames para comando de valvulas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84831030', 'description' => 'Veios flexiveis de transmissao', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84831040', 'description' => 'Manivelas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84831050', 'description' => 'Árvores de transmissão  (...)', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84831090', 'description' => 'Outros arvores (veios) de transmissao', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84832000', 'description' => 'Mancais (chumaceiras) c/rolamentos incorporados', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84833010', 'description' => 'Mancais s/rolam.montados c/bronzes de metal antifriccao', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84833021', 'description' => 'Bronzes, com diâmetro interno superior ou igual a 200mm', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84833029', 'description' => 'Bronzes - outros', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84833090', 'description' => 'Outros mancais sem rolamentos', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84834010', 'description' => 'Caixas de transmissao,redutores,etc.de velocidade', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84834090', 'description' => 'Engrenagens e rodas de friccao,eixos de esferas/roletes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '84835010', 'description' => 'Polias exc.as de rolamentos reguladores de tensao', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84835090', 'description' => 'Volantes e outs.polias', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84836011', 'description' => 'Embreagens de friccao', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84836019', 'description' => 'Outros embreagens', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84836090', 'description' => 'Dispositivos de acoplamento,incl.juntas de articulacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84839000', 'description' => 'Partes de arvores de transmissao,manivelas, mancais,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84841000', 'description' => 'Juntas metaloplasticas', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84842000', 'description' => 'Juntas de vedacao,mecanicas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84849000', 'description' => 'Jogos/sortidos de juntas,em bolsas, envelopes,etc.', 'aliquota_federal' => 14.91, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84861000', 'description' => 'Máquinas e aparelhos para fabricação de esferas (boules) ou de plaquetas (wafers)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84862000', 'description' => 'Máquinas e aparelhos para fabricação de dispositivos semicondutores ou de circuitos integrados eletrônicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84863000', 'description' => 'Máquinas e aparelhos para fabricação de dispositivos de visualização de tela plana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84864000', 'description' => 'Máquinas e aparelhos especificados na nota 9 c) do presente capítulo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84869000', 'description' => 'Partes e acess.p/máquinas e aparelhos dos tipos utilizados exclusiva ou principalmente na fabricação de esferas “(boules”) ou de plaquetas (“wafers”), de dispositivos semicondutores, de circuitos integrados eletrônicos ou de dispositivos de visualização', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84871000', 'description' => 'Helices p/embarcacoes e suas pas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '84879000', 'description' => 'Outras partes de máquinas ou de aparelhos, não especificadas nem compreendidas em outras posições do presente capítulo, que não contenham conexões elétricas, partes isoladas eletricamente, bobinas, contactos nem quaisquer outros elementos com característi', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85011011', 'description' => 'Motor eletr.de corrente continua, pot<=37.5w, passo<=1.8g', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85011011', 'description' => 'Próprios para utilização em brinquedos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85011019', 'description' => 'Outros motores eletr.de corrente continua, p<=37.5w', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85011021', 'description' => 'Motor eletr.de corrente alternada, pot<=37.5w,sincrono', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85011029', 'description' => 'Outs.motores eletr.de corrente alternada, pot<=37.5w', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85011030', 'description' => 'Motor eletr.universal,pot<=37.5w', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85012000', 'description' => 'Motor eletr.universal,pot>37.5w', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85013110', 'description' => 'Motor eletr.de corrente continua, 37.5w<pot<=750w', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85013120', 'description' => 'Gerador eletr.de corrente continua,pot<=750w', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85013210', 'description' => 'Motor eletr.de corrente continua, 750w<pot<=75kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85013220', 'description' => 'Gerador eletr.de corrente continua, 750w<pot<=75kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85013310', 'description' => 'Motor eletr.de corrente continua, 75kw<pot<=375kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85013320', 'description' => 'Gerador eletr.de corrente continua, 75kw<pot<=375kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85013411', 'description' => 'Motor eletr.de corrente continua, 375kw<pot<=3000kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85013419', 'description' => 'Outs.motores eletr.de corrente continua, pot>375kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85013420', 'description' => 'Gerador eletr.de corrente continua, pot>375kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85014011', 'description' => 'Motor eletr.de corr.altern.monof. 37.5w<p<=15kw,sincrono', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85014019', 'description' => 'Outs.motores eletr.de corr.altern.monof. 37.5w<p<=15kw', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85014021', 'description' => 'Motor eletr.de corr.altern.monof. pot>15kw,sincrono', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85014029', 'description' => 'Outros motores eletr.de corr.altern.monof. pot>15kw', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015110', 'description' => 'Motor eletr.corr.altern.trif. 37.5w<p<=750w, rotor gaiola', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015110', 'description' => 'De alto rendimento, segundo norma NBR 17094', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015120', 'description' => 'Motor eletr.corr.altern.trif. 37.5w<p<=750w, rotor aneis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015190', 'description' => 'Outs.motores eletr.de corr.altern.polif. 37.5w<p<=750w', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015210', 'description' => 'Motor eletr.corr.altern.trif.750w<p<=75kw, rotor gaiola', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015220', 'description' => 'Motor eletr.corr.altern.trif.750w<p<=75kw, rotor aneis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015290', 'description' => 'Outs.motores eletr.de corr.altern.polif. 750w<pot<=75kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015310', 'description' => 'Motor eletr.corr.altern.trif.75kw<pot<=7500kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015320', 'description' => 'Motor eletr.corr.altern.trif. 7500kw<pot<=30000kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015330', 'description' => 'Outros motores de corrente alternada, trifasicos, de potencia superior a 30.000kw mas não superior a 50.000kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85015390', 'description' => 'Outs.motores eletr.de corr.altern.polifasicos, pot>75kw', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85016100', 'description' => 'Geradores de corrente alternada,pot<=75kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85016200', 'description' => 'Geradores de corrente alternada, 75kva<pot<=375kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85016300', 'description' => 'Geradores de corrente alternada, 375kva<pot<=750kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85016400', 'description' => 'Geradores de corrente alternada,pot>750kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85021110', 'description' => 'Grupo eletrog.p/motor diesel,p<=75kva, corr.altern.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85021190', 'description' => 'Outros grupos eletrog.p/motor diesel, pot<=75kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85021210', 'description' => 'Grupo eletrog.p/motor diesel,75<p<=375kva, corr.altern.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85021290', 'description' => 'Outs.grupos eletrog.p/motor diesel, 75kva<p<375kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85021311', 'description' => 'Grupo eletrog.p/motor diesel,375<p<=430kva, corr.altern.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85021319', 'description' => 'Outs.grupos eletrog.p/motor diesel,p>375kva, corr.altern', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85021390', 'description' => 'Outros grupos eletrog.p/motor diesel,p>375kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85022011', 'description' => 'Grupo eletrog.p/motor explosao,corr. altern. p<=210kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85022019', 'description' => 'Outs.grupos eletrog.p/motor explosao,corr. altern.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85022090', 'description' => 'Outros grupos eletrog.p/motor explosao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85023100', 'description' => 'Outros grupos eletrog.de energia eolica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85023900', 'description' => 'Outros grupos eletrog.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85024010', 'description' => 'Conversores rotativos eletricos,de frequencia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85024090', 'description' => 'Outros conversores rotativos eletricos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85030010', 'description' => 'Partes de motores/geradores de pot<=75kva', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85030090', 'description' => 'Partes de outs.motores/geradores/grupos eletrog.etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85030090', 'description' => 'Partes utilizadas exclusiva ou principalmente em aerogeradores classificados no código 8502.31.00', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85041000', 'description' => 'Reatores p/lampadas/tubos de descargas', 'aliquota_federal' => 6.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85042100', 'description' => 'Transformador de dieletrico liquido, pot<=650kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85042200', 'description' => 'Transformador de dieletrico liquido, 650<pot<=10000kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85042300', 'description' => 'Transformador de dieletrico liquido, pot>10000kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043111', 'description' => 'Transformador eletr.pot<=1kva,p/freq<=60hz,de corrente', 'aliquota_federal' => 8.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043119', 'description' => 'Outs.transformadores eletr. pot<=1kva,p/freq<=60hz', 'aliquota_federal' => 8.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043191', 'description' => 'Transformador eletr.pot<=1kva,saida horiz.t>18kv,etc.', 'aliquota_federal' => 6.44, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043192', 'description' => 'Transformador eletr.pot<=1kva,de fi,deteccao, foco,etc.', 'aliquota_federal' => 12.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043199', 'description' => 'Outros transformadores eletr.pot<=1kva', 'aliquota_federal' => 8.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043199', 'description' => 'Transformadores de deflexão  “yokes” , para tubos de raios catódicos', 'aliquota_federal' => 12.03, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85043211', 'description' => 'Transformador eletr.1kva<pot<=3kva, p/freq<=60hz', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043219', 'description' => 'Outros transformadores eletr.1kva<pot<=3kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043221', 'description' => 'Transformador eletr.3kva<pot<=16kva, p/freq<=60hz', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043229', 'description' => 'Outros transformadores eletr. 3kva<pot<=16kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043300', 'description' => 'Transformador eletr.16kva<pot<=500kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85043400', 'description' => 'Transformador eletr.pot>500kva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85044010', 'description' => 'Carregadores de acumuladores (conv.eletr.)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85044021', 'description' => 'Retificadores de cristal (semicondutores) (conv.eletr.)', 'aliquota_federal' => 6.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85044022', 'description' => 'Retificador eletrolitico (conversor eletr.)', 'aliquota_federal' => 6.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85044029', 'description' => 'Outros retificadores (conv.eletr.)', 'aliquota_federal' => 6.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85044030', 'description' => 'Conversores eletricos de corrente continua', 'aliquota_federal' => 10.33, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85044040', 'description' => 'Equipamento de aliment.ininterrupta de energia eletr.', 'aliquota_federal' => 10.33, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85044050', 'description' => 'Conversores eletronicos de freq.p/var.vel. motor eletr.', 'aliquota_federal' => 10.33, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85044060', 'description' => 'Aparelhos eletronicos de alimentação de energia dos tipos utilizados para iluminação de emergencia', 'aliquota_federal' => 10.33, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85044090', 'description' => 'Outros conversores eletricos estaticos', 'aliquota_federal' => 10.33, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85045000', 'description' => 'Outros bobinas de reatancia e de auto-inducao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85049010', 'description' => 'Nucleos de po ferromagnetico', 'aliquota_federal' => 8.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85049020', 'description' => 'Partes de reatores p/lampadas/tubos de descarga', 'aliquota_federal' => 8.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85049030', 'description' => 'Partes de transformadores de dieletr.liq.ou pot>16kva', 'aliquota_federal' => 8.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85049040', 'description' => 'Partes de conversores eletricos estaticos', 'aliquota_federal' => 8.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85049090', 'description' => 'Outs.partes de outs.transformadores, conversores,etc.', 'aliquota_federal' => 8.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85051100', 'description' => 'Imas permanentes de metal,e artefs. magnetizav. p/imas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85051910', 'description' => 'Imas permanentes de ferrita,e artefs. magnetizav. p/imas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85051990', 'description' => 'Outros imas permanentes e artefs. magnetizav. p/imas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85052010', 'description' => 'Freios eletromagnet.por corr.foucaut,p/veic. automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85052090', 'description' => 'Acoplamentos,embreagens,etc.eletromagneticos', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85052090', 'description' => 'Embreagem eletromagnética para colheitadeiras', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85059010', 'description' => 'Eletroimas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85059080', 'description' => 'Placas,mandris e dispositivos magneticos, etc.de fixacao', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85059090', 'description' => 'Partes de aclopamentos,embreagens,etc. eletromagneticos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85061011', 'description' => 'De tensão igual a 1,5 V, cilíndricas, do tipo LR14 (C)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85061012', 'description' => 'De tensão igual a 1,5 V, cilíndricas, do tipo LR20 (D)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85061019', 'description' => 'Outras', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85061020', 'description' => 'Outros pilhas eletricas,de bioxido de manganes', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85061031', 'description' => 'Alcalinas, de tensão igual a 9 V', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85061032', 'description' => 'Alcalinas, de tensão igual a 12 V', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85061039', 'description' => 'Outras', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85063010', 'description' => 'Pilhas/baterias eletr.de oxido de mercurio, vol<=300cm3', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85063090', 'description' => 'Outros pilhas/baterias eletr.de oxido de mercurio', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85064010', 'description' => 'Pilhas/baterias eletr.de oxido de prata, vol<=300cm3', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85064090', 'description' => 'Outros pilhas/baterias eletricas,de oxido de prata', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85065010', 'description' => 'Pilhas/baterias eletr.de litio,vol<=300cm3', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85065090', 'description' => 'Outros pilhas/baterias eletr.de litio', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85066010', 'description' => 'Pilhas/baterias eletr.de ar-zinco,vol<=300cm3', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85066090', 'description' => 'Outros pilhas/baterias eletr.de ar-zinco', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85068010', 'description' => 'Outros pilhas/baterias eletr.vol<=300cm3', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85068090', 'description' => 'Outros pilhas/baterias eletr.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85069000', 'description' => 'Partes de pilhas/baterias de pilhas,eletricas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85071010', 'description' => 'Acumuladores eletr.de chumbo,p/arranque de motor pistao, de capacidade inferior ou igual a 20ah e tensão inferior ou igual a 12v', 'aliquota_federal' => 26.49, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85071090', 'description' => 'Outros acumuladores eletr.de chumbo,p/arranque de motor pistao', 'aliquota_federal' => 26.49, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85071090', 'description' => 'Do tipo utilizado para o arranque dos motores de ignição por compressão, com intensidade de corrente igual ou superior a 90 Ah', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85072010', 'description' => 'Outros acumuladores eletr.de chumbo, peso<=1000kg', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85072090', 'description' => 'Outros acumuladores eletr.de chumbo', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85073011', 'description' => 'Acumuladores eletr.de niquel-cadmio, p<=2500kg,cap<=15ah', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85073019', 'description' => 'Outs.acumuladores eletr.de niquel-cadmio, p<=2500kg', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85073090', 'description' => 'Outros acumuladores eletr.de niquel-cadmio', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85074000', 'description' => 'Acumuladores eletr.de niquel-ferro', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85075010', 'description' => 'De tensão igual a 1,2 V, cilíndricos do tipo HR6 (AA)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85075020', 'description' => 'De tensão igual a 1,2 V, cilíndricos do tipo HR03 (AAA)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85075090', 'description' => 'Outros', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85076000', 'description' => 'Outros acumuladores eletr. de íon de lítio', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85078000', 'description' => 'Outros acumuladores eletr.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85079010', 'description' => 'Separadores p/acumuladores eletr.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85079020', 'description' => 'Recipientes p/acumuladores eletr.de plastico,tampas,etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85079090', 'description' => 'Outros partes p/acumuladores eletr.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85081100', 'description' => 'Aspiradores de po,com motor eletrico, de potência não superior a 1.500w e cujo volume do reservatório não exceda 20 litros', 'aliquota_federal' => 9.75, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85081900', 'description' => 'Outros aspiradores de po,com motor eletrico', 'aliquota_federal' => 9.75, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85086000', 'description' => 'Outros aspiradores de po', 'aliquota_federal' => 9.75, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85087000', 'description' => 'Partes de apars.eletromecan.c/motor eletr.uso domestico', 'aliquota_federal' => 9.75, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85094010', 'description' => 'Liquidificador de alimentos,c/motor eletr.uso domestico', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85094020', 'description' => 'Batedeiras de alimentos,c/motor eletr.uso domestico', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85094030', 'description' => 'Moedores de carne,c/motor eletr.uso domestico', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85094040', 'description' => 'Extrator centrifugo de sucos,c/motor eletr.domestico', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85094050', 'description' => 'Apars.de funcoes multiplas,p/process.alim. c/motor eletr', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85094090', 'description' => 'Outs.trituradores,etc.p/alim.c/motor eletr.domestico', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85098010', 'description' => 'Enceradeiras de piso,c/motor eletr.uso domestico', 'aliquota_federal' => 7.93, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85098090', 'description' => 'Outs.apars.eletromecanicos,c/motor eletr.uso domestico', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85099000', 'description' => 'Partes de apars.eletromecan.c/motor eletr.uso domestico', 'aliquota_federal' => 9.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85101000', 'description' => 'Apars.ou maqs.de barbear,com motor eletrico', 'aliquota_federal' => 12.37, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85102000', 'description' => 'Maqs.de cortar o cabelo/tosquiar,c/motor eletr.', 'aliquota_federal' => 12.37, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85103000', 'description' => 'Apars.de depilar,com motor eletrico', 'aliquota_federal' => 8.65, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85109011', 'description' => 'Laminas de apars.ou maqs.de barbear,c/motor eletr.', 'aliquota_federal' => 12.37, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85109019', 'description' => 'Outs.partes de apars.ou maqs.de barbear, c/motor eletr.', 'aliquota_federal' => 12.37, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85109020', 'description' => 'Pentes e contrapentes para máquinas de tosquiar', 'aliquota_federal' => 12.37, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85109090', 'description' => 'Partes de maqs.de cortar cabelo/tosquiar, c/motor eletr.', 'aliquota_federal' => 12.37, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85111000', 'description' => 'Velas de ignicao p/motor explosao/diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85112010', 'description' => 'Magnetos p/motor explosao/diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85112090', 'description' => 'Dinamos-magnetos/volante magnet.p/motor explosao/diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85113010', 'description' => 'Distribuidores p/motor explosao/diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85113020', 'description' => 'Bobinas de ignicao p/motor explosao/diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85114000', 'description' => 'Motores de arranque p/motor explosao/diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85114000', 'description' => 'Para sistema elétrico em 24V, com potência igual ou superior a 3kW', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85115010', 'description' => 'Dinamos e alternadores p/motor explosao/ diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85115010', 'description' => 'Para sistema elétrico em 24V, exceto para uso em aeronáutica', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85115090', 'description' => 'Outros geradores p/motor explosao/diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85118010', 'description' => 'Velas de aquecimento p/motor explosao/diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85118020', 'description' => 'Regulador de voltagem p/motor explosao/ diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85118030', 'description' => 'Ignicao eletronica digital p/motor explosao/ diesel', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85118090', 'description' => 'Outs.apars.e disp.eletr.ignicao,etc.p/motor explosao/', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85119000', 'description' => 'Partes de apars.disp.eletr.ignicao,etc.p/motor explosao', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85121000', 'description' => 'Apars.de iluminacao/sinaliz.visual util.em bicicletas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85122011', 'description' => 'Farois p/automoveis e outs.ciclos', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85122011', 'description' => 'Para colheitadeiras ou tratores agrícolas', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85122019', 'description' => 'Outs.apars.eletr.de iluminacao p/automoveis/ outs.ciclos', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85122021', 'description' => 'Luzes fixas p/automoveis e outs.ciclos', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85122021', 'description' => 'Lanternas para tratores agrícolas', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85122022', 'description' => 'Luzes indicadoras de manobras p/automoveis/ outs.ciclos', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85122023', 'description' => 'Caixas de luzes combinadas p/automoveis/ outs.ciclos', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85122029', 'description' => 'Outs.apars.eletr.de sinaliz.visual p/automoveis, etc.', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85123000', 'description' => 'Apars.de sinalizacao acustica util.em ciclos/ automoveis', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85124010', 'description' => 'Limpadores de para-brisas p/automoveis', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85124020', 'description' => 'Degeladores e desembacadores p/automoveis', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85129000', 'description' => 'Partes de apars.eletr.ilumin/sinaliz.p/ automoveis, etc.', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85131010', 'description' => 'Lanternas manuais', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85131090', 'description' => 'Outros lanternas eletr.portateis,de pilhas,etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85139000', 'description' => 'Partes de lanternas eletr.portateis,de pilhas,etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85141010', 'description' => 'Fornos de resistencia,industriais (aquecim.indireto)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85141090', 'description' => 'Fornos de resistencia,de laboratorio (aquecim.indireto)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85142011', 'description' => 'Fornos de inducao,industriais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85142019', 'description' => 'Fornos de inducao,de laboratorio', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85142020', 'description' => 'Fornos de perdas dieletricas,industriais/de laboratorio', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85142020', 'description' => 'Industriais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85143011', 'description' => 'Fornos de resistencia,industriais (aquecim.direto)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85143019', 'description' => 'Fornos de resistencia,de laboratorio (aquecim.direto)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85143021', 'description' => 'Fornos de arco voltaico,industriais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85143029', 'description' => 'Fornos de arco voltaico,de laboratorio', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85143090', 'description' => 'Outros fornos eletr.industriais ou de laboratorio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85144000', 'description' => 'Outs.apars.de inducao/perdas dieletr.p/trat.term.mater.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85149000', 'description' => 'Partes de fornos eletr.industriais/de laboratorio,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85151100', 'description' => 'Ferros e pistolas p/soldadura forte ou fraca', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85151900', 'description' => 'Outros maqs.e apars.p/soldadura forte ou fraca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85152100', 'description' => 'Maqs.e apars.p/soldar metais,de resistencia, automaticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85152900', 'description' => 'Outros maqs.e apars.p/soldar metais,de resistencia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85153110', 'description' => 'Robôs para soldar, por arco, em atmosfera inerte (mig -“metal inert gas”) ou atmosfera ativa (mag -“metal active gas”), de comando numérico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85153190', 'description' => 'Outs.maqs.apars.soldar metais,de arco/jato plasma,autom', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85153900', 'description' => 'Outs.maqs.e apars.p/soldar metais,de arco/jato plasma', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85158010', 'description' => 'Maqs.e apars.p/soldar a laser', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85158090', 'description' => 'Outs.maqs.e apars.p/soldar,eletr.por outs.processos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '85159000', 'description' => 'Partes de maqs.e apars.p/soldar,eletr.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85161000', 'description' => 'Aquecedores eletricos de agua,incl.os de imersao', 'aliquota_federal' => 11.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85161000', 'description' => 'Chuveiro elétrico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85162100', 'description' => 'Radiadores de acumulacao,p/aquecim.de ambientes,etc.', 'aliquota_federal' => 13.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85162900', 'description' => 'Outros apars.eletr.p/aquecim.de ambientes.etc', 'aliquota_federal' => 13.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85163100', 'description' => 'Secadores de cabelo,eletrotermicos', 'aliquota_federal' => 12.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85163200', 'description' => 'Outros apars.p/arranjos do cabelo, eletrotermicos', 'aliquota_federal' => 9.53, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85163300', 'description' => 'Apars.p/secar as maos,eletrotermicos', 'aliquota_federal' => 13.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85164000', 'description' => 'Ferros eletr.de passar', 'aliquota_federal' => 9.11, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85165000', 'description' => 'Fornos de microondas', 'aliquota_federal' => 18.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85166000', 'description' => 'Outros fornos, fogões de cozinha, fogareiros (incluídas as chapas de cocção), grelhas e assadeiras', 'aliquota_federal' => 9.99, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85166000', 'description' => 'Fogões de cozinha', 'aliquota_federal' => 6.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85167100', 'description' => 'Apars.p/preparacao de cafe ou de cha, eletrotermicos', 'aliquota_federal' => 9.99, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85167200', 'description' => 'Torradeiras de pao,eletrotermicas', 'aliquota_federal' => 9.99, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85167910', 'description' => 'Panelas eletrotermicas', 'aliquota_federal' => 9.99, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85167920', 'description' => 'Fritadoras eletrotermicas', 'aliquota_federal' => 9.99, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85167990', 'description' => 'Outros apars.eletrotermicos,uso domestico', 'aliquota_federal' => 11.24, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85168010', 'description' => 'Resistencias de aquecimento p/apars.eletr/ eletrotermico', 'aliquota_federal' => 9.11, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85168090', 'description' => 'Outros resistencias de aquecimento', 'aliquota_federal' => 9.11, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85169000', 'description' => 'Partes de aquecedores eletr/apars.eletr.p/ aquecim.etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85169000', 'description' => 'De fogões de cozinha', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85171100', 'description' => 'Aparelhos telefônicos por fio com unidade auscultador-microfone sem fio', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171211', 'description' => 'Telefones para redes celulares e para outras redes sem fio de radiotelefonia, analógicos portáteis (por exemplo walkie talkie e handle talkie)', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171212', 'description' => 'Telefones para redes celulares e para outras redes sem fio de radiotelefonia, analógicos fixos, sem fonte própria de energia, monocanais', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171213', 'description' => 'Telefones para redes celulares e para outras redes sem fio de radiotelefonia, analógicos móveis, do tipo dos utilizados em veículos automóveis', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171219', 'description' => 'Outros telefones para redes celulares e para outras redes sem fio de radiotelefonia, analógicos', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171221', 'description' => 'Telefones para redes celulares e para outras redes sem fio de sistema troncalizado (trunking), portáteis', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171222', 'description' => 'Telefones para redes celulares e para outras redes sem fio de sistema troncalizado (trunking), fixos, sem fonte própria de energia', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171223', 'description' => 'Telefones para redes celulares e para outras redes sem fio de sistema troncalizado (trunking), do tipo dos utilizados em veículos automóveis', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171229', 'description' => 'Outs.apars.transmiss.recept.de sistema troncalizado', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171231', 'description' => 'Telefones para redes celulares e para outras redes sem fio, exceto por satélite portáteis', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171232', 'description' => 'Telefones para redes celulares e para outras redes sem fio, exceto por satélite fixos, sem fonte própria de energia', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171233', 'description' => 'Telefones para redes celulares e para outras redes sem fio, exceto por satélite do tipo dos utilizados em veículos automóveis', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171239', 'description' => 'Outros apars.transmiss.recept.de telefonia celular', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171241', 'description' => 'Aparelhos telefonicos (telefones)  para redes celulares e para outras redes sem fio, de telecomunicações por satélite digitais, operando em banda c, ku, l ou s', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171249', 'description' => 'Outros aparelhos telefonicos (telefones)  para redes celulares e para outras redes sem fio, de telecomunicações por satélite digitais', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171290', 'description' => 'Outs.apars.transmissores c/aparelho recept.incorporado', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171810', 'description' => 'Interfones', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171820', 'description' => 'Telefones publicos', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171891', 'description' => 'Outs.apars.telefonicos,n/combinados c/outs. apars.', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85171899', 'description' => 'Outros apars.telefonicos', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176111', 'description' => 'Apars.transm/recep.de radiotelef.dig (para estação base de sistema bidirecional de radiomensagem....) de taxa de transmissão inferior ou igual a 112kbits/s', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176119', 'description' => 'Outs.apars.transmiss.recept.digit.p/radiotelef.f<15ghz', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176120', 'description' => 'Apars.transm/recep.de sistema troncal. p/estacao central', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176130', 'description' => 'Apars.transm/recep.de telefonia celular, p/estacao base', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176141', 'description' => 'Apars.transm/recep.de telecom.satelite, p/estacao terren', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176142', 'description' => 'Apars.transm/recep.de telecom.satelite, p/estacao vsat', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176143', 'description' => 'Apars.transm/recep.de voz/dados,dig.de telecom.satelite (c ku, l ou s)', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176149', 'description' => 'Outros apars.transmiss.recept.de telecom. satelite', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176191', 'description' => 'Outs.apars.transmiss.recept.digit.p/radiotelef.etc. de frequencia <= 23 ghz ...', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176192', 'description' => 'Outs.apars.transm/recep.radiotelef.radiotelegraf.digit.', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176199', 'description' => 'Apars.transm/recep.de radiotelef.', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176211', 'description' => 'Multiplexador por divisao de frequencia', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176212', 'description' => 'Multiplexadores por divisão de tempo, digitais síncronos, com velocidade de transmissão igual ou superior a 155mbits/s', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176213', 'description' => 'Outros multiplexadores por divisao de tempo', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176213', 'description' => 'Moduladores OFDM  “Orthogonal Frequency Division Multiplex” , com sintaxe MPEG-TS  “MPEG-Transport Stream” , para sistemas de televisão digital terrestre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176213', 'description' => 'Multiplexadores de sinais de áudio, vídeo e dados para sistemas de televisão digital terrestre, com entrada ASI e saída TS  “Transport Stream” ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176214', 'description' => 'Concentradores de linhas de assinantes (terminais de central ou terminal remoto)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176219', 'description' => 'Outs.apars.p/telecom.corrente portadora/ telecom.digital', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176221', 'description' => 'Centrais automáticas públicas, para comutação eletrônica, incluídas as de trânsito', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176222', 'description' => 'Centrais automáticas privadas, de capacidade inferior ou igual a 25 ramais', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176223', 'description' => 'Centrais automáticas privadas, de capacidade superior a 25 ramais e inferior ou igual a 200 ramais', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176224', 'description' => 'Centrais automáticas privadas, de capacidade superior a 200 ramais', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176229', 'description' => 'Outros centrais automat.comut.linha telef.', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176231', 'description' => 'Centrais automáticas para comutação por pacote com velocidade de tronco superior a 72kbits/s e de comutação superior a 3.600 pacotes por segundo, sem multiplexação determinística', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176232', 'description' => 'Outras centrais automáticas para comutação por pacote', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176233', 'description' => 'Centrais automáticas de sistema troncalizado (trunking)', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176239', 'description' => 'Outs.apars.eletr.de comutacao p/telefonia/ telegrafia', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176241', 'description' => 'Roteadores digitais, em redes com ou sem fio com capacidade de conexão sem fio', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176248', 'description' => 'Outros roteadores digitais, em redes com ou sem fio com velocidade de interface serial de pelo menos 4mbits/s, próprios para interconexão de redes locais com protocolos distintos', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176249', 'description' => 'Outros roteadores digitais, em redes com ou sem fio', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176251', 'description' => 'Equipam.terminal/repetidor em linhas metalicas', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176252', 'description' => 'Terninais sobre linhas de fibras ópticas, com velocidade de transmissão superior a 2,5gbits/s', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176253', 'description' => 'Terminais de texto que operem com código de transmissão baudot, providos de teclado alfanumérico e visor (display), mesmo com telefone incorporado', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85176254', 'description' => 'Distribuidores de conexões para redes (hubs)', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176255', 'description' => 'Moduladores/demoduladores digitais (modens)', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176259', 'description' => 'Outros aparelhos para transmissão ou recepção de voz, imagem ou outros dados em rede com fio', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176261', 'description' => 'Aparelhos emissores com receptor incorporado de sistema troncalizado (“trunking”)', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176262', 'description' => 'Aparelhos emissores com receptor incorporado de tecnologia celular', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176264', 'description' => 'Apar.transmiss.recept.p/satélite, digit.oper banda c,ku', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176265', 'description' => 'Outros apar.transmiss.recept.p/satélite', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176271', 'description' => 'Terminais portáteis de sistema bidirecional de radiomensagens, de taxa de transmissão inferior ou igual a 112kbits/s', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176272', 'description' => 'Outros aparelhos emissores com receptor incorporado, digitais de frequência inferior a 15ghz e de taxa de transmissão inferior ou igual a 34mbits/s, exceto os de sistema bidirecional de radiomensagens de taxa de transmissão inferior ou igual a 112kbits/s', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176277', 'description' => 'Outros aparelhos emissores com receptor incorporado, digitais de frequência inferior a 15ghz', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176278', 'description' => 'Outros aparelhos emissores com receptor incorporado, digitais de freqüência superior ou igual a 15ghz, mas inferior ou igual a 23ghz e taxa de transmissão inferior ou igual a 8mbit/s', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176279', 'description' => 'Outros aparelhos emissores com receptor incorporado, digitais', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176291', 'description' => 'Aparelhos transmissores (emissores)', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176292', 'description' => 'Receptores pessoais de radiomensagens com apresentação alfanumérica da mensagem em visor (display)', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176293', 'description' => 'Outros receptores pessoais de radiomensagens', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176294', 'description' => 'Tradutores (conversores) de protocolos para interconexão de redes (“gateways”)', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176295', 'description' => 'Terminais fixos, analógicos, sem fonte própria de energia, monocanais', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176296', 'description' => 'Outs.apars.transmiss.recept.analog.p/radiotelef.etc.', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176299', 'description' => 'Outs.aparelhos de recepção, conversão e transmissão ou regeneração de voz, imagens ou outros dados', 'aliquota_federal' => 9.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85176900', 'description' => 'Outros aparelhos para transmissão ou recepção de voz, imagens ou outros dados', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85177010', 'description' => 'Circuito impresso montado p/apars.transmiss. recept.', 'aliquota_federal' => 8.37, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85177021', 'description' => 'Antenas p/telefones celulares portat.exc. telescopicas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85177029', 'description' => 'Outs.antenas e refletores de antenas,e suas partes', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85177091', 'description' => 'Gabinetes, bastidores e armações p/apars.transmissores/ receptores', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85177092', 'description' => 'Registradores/seletores p/centrais automat. telefon.etc', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85177099', 'description' => 'Outros partes p/apars.transmissores/ receptores', 'aliquota_federal' => 7.11, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85181010', 'description' => 'Microfones e seus suportes, piezelétricos próprios para aparelhos telefônicos', 'aliquota_federal' => 6.25, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85181090', 'description' => 'Outros microfones e seus suportes', 'aliquota_federal' => 9.81, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85182100', 'description' => 'Alto-falante unico montado no seu proprio receptaculo', 'aliquota_federal' => 9.81, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85182200', 'description' => 'Alto-falantes multiplos montados no mesmo receptaculo', 'aliquota_federal' => 9.81, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85182910', 'description' => 'Outros alto-falantes piezelétricos próprios para aparelhos telefônicos', 'aliquota_federal' => 6.25, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85182990', 'description' => 'Outros alto-falantes', 'aliquota_federal' => 9.81, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85183000', 'description' => 'Fones de ouvido, mesmo combinados com microfone, e conjuntos ou sortidos constituídos por um microfone e um ou mais alto-falantes', 'aliquota_federal' => 9.81, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85184000', 'description' => 'Amplificador eletrico de audiofrequencia', 'aliquota_federal' => 9.81, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85185000', 'description' => 'Apars.eletr.de amplificacao de som', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85189010', 'description' => 'Partes de alto-falantes', 'aliquota_federal' => 9.81, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85189090', 'description' => 'Partes de microfones,fones de ouvido, amplificadores,etc', 'aliquota_federal' => 9.81, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85192000', 'description' => 'Aparelhos que funcionem por introdução de moedas, papel-moeda, cartões de banco, fichas ou por outros meios de pagamento', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85193000', 'description' => 'Toca-discos, sem dispositivos de amplificação de som', 'aliquota_federal' => 16.89, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85195000', 'description' => 'Secretarias eletronicas (atendedores automaticos)', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85198110', 'description' => 'Apars.de reprod.de som,c/sist.de leit.optica por laser', 'aliquota_federal' => 10.78, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85198120', 'description' => 'Gravadores de som de cabines de aeronaves', 'aliquota_federal' => 9.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85198190', 'description' => 'Outs.apars.de gravacao/reprod.som', 'aliquota_federal' => 9.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85198190', 'description' => 'Aparelho gravador de som para cinema, utilizando fita magnética em rolo aberto ou cartucho selado, registrando ao mesmo tempo, em pista de som auxiliar, um sinal de referência de sincronismo para possibilitar a reprodução sincrônica, em tempo real', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85198190', 'description' => 'Toca-fitas', 'aliquota_federal' => 10.78, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85198190', 'description' => 'Aparelhos de gravação e de reprodução de som, de fitas magnética', 'aliquota_federal' => 10.78, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85198900', 'description' => 'Outs.apars.de gravacao/reprod.som', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85198900', 'description' => 'Aparelhos cinematográficos de reprodução de som', 'aliquota_federal' => 12.59, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85211010', 'description' => 'Gravador-reprodutor de fita magnet. s/sintonizador', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85211081', 'description' => 'Apars.videofon.de grav/reprod.p/fitas cassetes,l=12mm', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85211089', 'description' => 'Outs.apars.videofon.grav/reprod.fita magnet.l<19.05mm', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85211090', 'description' => 'Outs.apars.videofon.grav/reprod.fita magnet.l>=19.05mm', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85219010', 'description' => 'Gravador-reprodutor e editor de imagem e som, em discos, por meio magnético, óptico ou optomagnético', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85219090', 'description' => 'Outros apars.videofon.grav/reprod.', 'aliquota_federal' => 11.86, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85219090', 'description' => 'Aparelho de gravação ou reprodução, e edição, de imagem e som de televisão em disco rígido, por meio magnético, óptico ou optomagnético', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85219090', 'description' => 'Aparelhos de reprodução de imagem e som em disco por meio óptico ou optomagnético', 'aliquota_federal' => 15.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85221000', 'description' => 'Fonocaptores p/apars.de gravacao/reproducao', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85229010', 'description' => 'Agulhas c/ponta de pedra preciosa,p/apars.de reproducao', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85229020', 'description' => 'Gabinetes p/apars.de gravacao/reproducao', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85229030', 'description' => 'Chassis ou suportes p/apars.de gravacao/reproducao', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85229040', 'description' => 'Leitores de som,magneticos p/apars.de reproducao', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85229050', 'description' => 'Mecanismos toca-discos,mesmo c/cambiador, p/apars.reprod', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85229090', 'description' => 'Outs.partes e acess.p/apars.de gravacao/ reproducao', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232110', 'description' => 'Cartoes magnet.n/grav.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232120', 'description' => 'Cartoes magnet.gravados', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232911', 'description' => 'Discos magnet.n/grav.p/unidades de discos rigidos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232919', 'description' => 'Outros discos magnet.n/grav.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232921', 'description' => 'Fitas magnet.n/grav.l<=4mm,em cassetes', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232922', 'description' => 'Fitas magnet.n/grav.4mm<l<=6.5mm', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232923', 'description' => 'Fitas magnet.n/grav.6.5<l<=50.8mm,em rolos/carreteis', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232924', 'description' => 'Fitas magnet.l>6.5mm,em cassetes,p/grav.de video', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232929', 'description' => 'Outros fitas magnet.n/grav.', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232931', 'description' => 'Fitas magnet.gravadas,p/reprod.de fenom. diferentes de som/imagem', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232932', 'description' => 'Fitas magnet.gravadas,l<=4mm,em cartuchos/cassetes', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232932', 'description' => 'Gravadas com matéria didática', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232932', 'description' => 'Para gravação simultânea de imagem e som, próprias para televisão  vídeo-tape , gravadas com matéria de natureza científica ou educativa', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232933', 'description' => 'Outros fitas magnet.gravadas,l>6.5mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232933', 'description' => 'Gravadas com matéria didática, em cartuchos ou cassetes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232933', 'description' => 'Para gravação simultânea de imagem e som, próprias para televisão  vídeo-tape , gravadas com matéria de natureza científica ou educativa, em cartuchos, cassetes e semelhantes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232939', 'description' => 'Outros fitas magnet.gravadas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232939', 'description' => 'Gravadas com matéria didática, apresentadas em artefatos semelhantes a cartuchos ou cassetes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232939', 'description' => 'Gravadas com matéria didática, em cartuchos ou cassetes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232939', 'description' => 'Para gravação simultânea de imagem e som, próprias para televisão  vídeo-tape , gravadas com matéria de natureza científica ou educativa, apresentadas em artefatos semelhantes a cartuchos ou cassetes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85232990', 'description' => 'Outs.suportes p/gravacao de som/semelhs. n/gravados', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85234110', 'description' => 'Discos p/sist.leit.raio laser,possib.grav.1 vez (cd-r)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85234190', 'description' => 'Outs.suportes p/gravacao de som/semelhs. n/gravados', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85234910', 'description' => 'Suportes gravados,p/leit.raio laser,reprod. apenas do som', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85234920', 'description' => 'Suportes gravados,p/leit.raio laser,de fenom. dif.som/imag', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85234990', 'description' => 'Outros suportes gravados,p/leitura por raio laser', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85235110', 'description' => 'Dispositivos de armazenamento não-volátil de dados à base de semicondutores - cartões de memóris (memory cards)', 'aliquota_federal' => 11.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85235110', 'description' => 'Das máquinas da posição 84.71', 'aliquota_federal' => 9.11, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85235110', 'description' => 'Que possam ser utilizados indiferentemente com as máquinas ou aparelhos de duas ou mais das posições 84.69 a 84.72', 'aliquota_federal' => 5.26, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85235190', 'description' => 'Outros - dispositivos de armazenamento não-volátil de dados à base de semicondutores', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85235210', 'description' => 'Cartões e etiquetas de acionamento por aproximação', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85235290', 'description' => 'Outros', 'aliquota_federal' => 5.06, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85235900', 'description' => 'Outros', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85238000', 'description' => 'Discos fonograficos,gravados', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 5.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85255011', 'description' => 'Apars.transm.de radio em am,c/modul.larg. pulso,pot>10kw', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85255012', 'description' => 'Apars.transm.de radio em fm,c/etapa saida valv.pot>30kw', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85255019', 'description' => 'Outros apars.transmissores de radiodifusao', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85255021', 'description' => 'Apars.transm.de televisao,frequencia>7ghz', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85255022', 'description' => 'Apars.transm.de televisao,banda uhf 2/2.7ghz,10w<p<100w', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85255023', 'description' => 'Apars.transm.de televisao,banda uhf,pot>10kw', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85255024', 'description' => 'Apars.transm.de televisao,banda vhf,pot>=20kw', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85255029', 'description' => 'Outros apars.transmissores de televisao', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85255029', 'description' => 'Transmissores digitais de televisão, em VHF ou UHF, com potência maior ou igual a 1 kW e intermodulação maior que 36 dB', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85255029', 'description' => 'Sistema irradiante configurável, dedicado à transmissão de sinais de televisão digitais na faixa de freqüência de VHF e/ou UHF, com potências irradiadas de até 1MW RMS e constituídos por: antenas, cabos e/ou linhas rígidas de alimentação, combinad', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85256010', 'description' => 'Apars.transm/recep.de radiodifusao', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85256010', 'description' => 'Transmissores-receptores  transceptores  de rádio digital para televisão digital terrestre, com interfaces digitais “DVB-ASI” e/ou “ISDB-T clock data”', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85256020', 'description' => 'Apars.transm/recep.de televisao, frequencia>7ghz', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85256020', 'description' => 'Transmissores-receptores  transceptores  de sinal de televisão digital através de fibra ótica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85256090', 'description' => 'Outros apars.transmiss.recept.de televisao', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85256090', 'description' => 'Equipamento de sinalização, controle e/ou corte  “slicer”  do fluxo de dados MPEG', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85258011', 'description' => 'Cameras de televisao c/3 ou mais captadores de imagem', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85258012', 'description' => 'Cameras de televisao c/sensor imag.ccd,etc. ilum<0.20lux', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85258013', 'description' => 'Cameras de televisao c/sensor de imagem etc<=14 microns', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85258019', 'description' => 'Outros cameras de televisao', 'aliquota_federal' => 9.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85258019', 'description' => 'Lupa eletrônica do tipo utilizado por pessoas com deficiência visual', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85258021', 'description' => 'Câmeras fotográficas digitais e câmeras de vídeo c/ tres ou mais captores de imagem', 'aliquota_federal' => 11.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85258022', 'description' => 'Outs cameras de video de imagens fixas e outs.cameras video etc <= 14 microsn (sistema integrado etc)', 'aliquota_federal' => 11.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85258029', 'description' => 'Outras câmeras fotográficas digitais e câmeras de vídeo', 'aliquota_federal' => 11.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85261000', 'description' => 'Apars.de radiodeteccao e de radiossondagem (radar)', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85269100', 'description' => 'Apars.de radionavegacao', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85269200', 'description' => 'Apars.de radiotelecomando', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85271200', 'description' => 'Radio toca-fitas (radio-cassetes),de bolso', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85271300', 'description' => 'Outros aparelhos combinados com um aparelho de gravaçao ou de reproduçao de som', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85271910', 'description' => 'Apars.recept.de radio c/relogio,a pilha/ eletricidade', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85271990', 'description' => 'Outros apars.recep.radiodif.pilha/eletr.etc.', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85272100', 'description' => 'Aparelhos receptores de radiodifusao, que so funcionem com fonte externa de energia, combinados com um aparelho de gravaçao ou de reproduçao de som', 'aliquota_federal' => 22.54, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85272900', 'description' => 'Outros apars.recep.radiodif.p/veic.automoveis, etc.', 'aliquota_federal' => 22.54, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85279100', 'description' => 'Outros aparelhos receptores para radiodifusao, combinados com um aparelho de gravaçao ou de reproduçao de som', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85279200', 'description' => 'Apars.recept.de radio c/relogio,a eletricidade', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85279910', 'description' => 'Amplificador com sintonizador (receiver)', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85279990', 'description' => 'Outros apars.recep.radiodif.etc.', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85284210', 'description' => 'Monocromaticos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85284220', 'description' => 'Policromaticos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85284910', 'description' => 'Monitores de video,em preto e branco ou outs.monocromos', 'aliquota_federal' => 15.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85284921', 'description' => 'Monitores de video,a cores, com dispositivos de seleção de varredura (under-scanning) e de retardo de sincronismo horizontal ou vertical (h/v delay ou pulse cross)', 'aliquota_federal' => 15.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85284929', 'description' => 'Outros (monitores de video,a cores)', 'aliquota_federal' => 15.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85285210', 'description' => 'Monocromaticos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85285220', 'description' => 'Policromaticos', 'aliquota_federal' => 14.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85285910', 'description' => 'Monitores de video,em preto e branco ou outs.monocromos', 'aliquota_federal' => 15.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85285920', 'description' => 'Outros (monitores de video,a cores)', 'aliquota_federal' => 15.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85286200', 'description' => 'Capazes de serem conectados diretamente a uma maquina automatica para processamento de dados da posicao 8471 e concebidos para serem utilizados com esta maquina', 'aliquota_federal' => 12.68, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85286910', 'description' => 'Outros projetores de vídeo com tecnologia de dispositivo digital de microespelhos (“digital micromirror device” - dmd)', 'aliquota_federal' => 15.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85286990', 'description' => 'Outros projetores de vídeo', 'aliquota_federal' => 15.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85287111', 'description' => 'Receptor-decodif.integr.sinais digit.video codif.cores, sem saída de radiofrequencia (rf( modulada (...) c/ saída de áudio balanceada (...)', 'aliquota_federal' => 7.34, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85287119', 'description' => 'Outros (receptor-decodif.integr.sinais digit.video codif.cores)', 'aliquota_federal' => 7.34, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85287190', 'description' => 'Outs.apars.recep.televisao cores,mesmo c/apars.som/imag', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85287200', 'description' => 'Outs.apars.recep.televisao cores,mesmo c/apars.som/imag', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85287300', 'description' => 'Apars.recept.de tv em preto/branco,mesmo com radio,etc.', 'aliquota_federal' => 15.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85291011', 'description' => 'Antenas com refletor parabolico,exc.p/ telefone  celular', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85291019', 'description' => 'Outros antenas exc.p/telefones celulares', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85291090', 'description' => 'Outs.antenas e refletores de antenas,e suas partes', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85299011', 'description' => 'Gabinetes e bastidores p/apars.transmissores/ receptores', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85299012', 'description' => 'Circuito impresso montado p/apars.transmiss. recept.', 'aliquota_federal' => 4.59, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85299019', 'description' => 'Outros partes p/apars.transmissores/ receptores', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85299019', 'description' => 'Codificadores para sinais de áudio, vídeo de alta definição MPEG-2 e/ou MPEG-4  protocolo H.264  para sistema de transmissão de sinais de televisão digital terrestre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85299020', 'description' => 'Outs.partes p/apars.recept.radiodifusao, televisao,etc.', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85299030', 'description' => 'Outs.partes p/apars.radiodeteccao e radiossondagem', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85299040', 'description' => 'Outros partes p/apars.radionavegacao', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85299090', 'description' => 'Outs.partes p/apars.radiotelecomando/ cameras tv/video', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85301010', 'description' => 'Apars.eletr.digit.p/controle de trafego de vias ferreas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85301090', 'description' => 'Outs.apars.eletr.de sinalizacao,etc.p/vias ferreas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85308010', 'description' => 'Apars.eletr.digit.p/controle de trafego de automotores', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85308090', 'description' => 'Outs.apars.eletr.sinalizacao,etc.p/vias terrestres,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85309000', 'description' => 'Partes de apars.eletr.de sinaliz.etc.p/vias ferreas,etc', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85311010', 'description' => 'Alarmes contra incendio ou sobreaquecimento', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85311090', 'description' => 'Outs.apars.eletr.de alarme,p/protecao contra roubo', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85312000', 'description' => 'Painéis indicadores com dispositivos de cristais líquidos (lcd) ou de diodos emissores de luz (led)', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85312000', 'description' => 'Quadro de sinalização, próprio para dar informações relativas à venda de mercadorias, constituído de painel eletrônico e respectivos dispositivos de comando e controle  unidade funcional ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85318000', 'description' => 'Outs.apars.eletr.de sinalizacao acustica ou visual', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85319000', 'description' => 'Partes de apars.eletr.de sinalizacao acustica ou visual', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85321000', 'description' => 'Condensadores fixos concebidos para linhas elétricas de 50/60hz e capazes de absorver uma potência reativa igual ou superior a 0,5kvar (condensadores de potência)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322111', 'description' => 'Condensador fixo eletr.de tantalo,montag. superf.t<=125v', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322119', 'description' => 'Outs.condensad.fixos eletr.de tantalo, p/montag. superf.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322120', 'description' => 'Próprios para montagem por inserção (PHP - Pin Through Hole)', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322190', 'description' => 'Outros condensadores fixos eletr.de tantalo', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322200', 'description' => 'Condensador fixo eletrolitico,de aluminio', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322310', 'description' => 'Condensador fixo c/dieletr.ceram.1 camada,montag.superf', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322390', 'description' => 'Outs.condensadores fixos c/dieletr.ceram.1 camada', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322410', 'description' => 'Outs.condensadores fixos c/dieletr.ceram. montag.superf.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322420', 'description' => 'Próprios para montagem por inserção (PHP - Pin Through Hole)', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322490', 'description' => 'Outros condensadores fixos c/dieletr.ceram.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322510', 'description' => 'Condensador fixo c/dieletr.papel/plast. p/montag.superf.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322590', 'description' => 'Outros condensadores fixos c/dieletr. papel/plast.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322910', 'description' => 'Outs.condensadores fixos eletr.p/montag.em superf.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85322990', 'description' => 'Outros condensadores fixos eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85323010', 'description' => 'Condensadores variaveis/ajustav.eletr. p/montag.superf.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85323090', 'description' => 'Outros condensadores variaveis/ajustav.eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85329000', 'description' => 'Partes de condensadores eletr.fixos/variaveis/ ajustav.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85331000', 'description' => 'Resistências fixas de carbono, aglomeradas ou de camada', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85332110', 'description' => 'Resistencias eletr.fixas,p/pot<=20w,de fio', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85332120', 'description' => 'Resistencias eletr.fixas,p/pot<=20w,p/montag.em superf.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85332190', 'description' => 'Outros resistencias eletr.fixas,p/pot<=20w', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85332900', 'description' => 'Outros resistencias eletr.fixas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85333110', 'description' => 'Potenciometros p/pot<=20w', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85333190', 'description' => 'Outs.resistencias eletr.variaveis bobinadas p/pot<=20w', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85333910', 'description' => 'Outros potenciometros', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85333990', 'description' => 'Outros resistencias eletr.variaveis bobinadas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85334011', 'description' => 'Termistores', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85334012', 'description' => 'Varistores', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85334013', 'description' => 'Outros varistores', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85334019', 'description' => 'Outs.resistencias eletr.variav.n/lineares semicondut.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85334091', 'description' => 'Potenciômetro de carvão, do tipo dos utilizados para determinar o ângulo de abertura da borboleta, em sistemas de injeção de combustível controlados eletronicamente', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85334092', 'description' => 'Outros potenciômetros de carvão', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85334099', 'description' => 'Outros resistencias eletr.variav.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85339000', 'description' => 'Partes de resistencias eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340011', 'description' => 'Circuito impresso simples face rig.c/isolante res.fenol./papel celulos', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340012', 'description' => 'Circuito impresso simples face rig.c/isolante res.epoxi./papel celulos', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340013', 'description' => 'Circuito impresso simples face rig.c/isolante res.expox./tec.fib.vidro', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340019', 'description' => 'Outros circuitos impressos simples face rigidos', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85340020', 'description' => 'Circuito impresso simples face flexiveis', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340031', 'description' => 'Circuito impresso dupla face rig.c/isolante res.fenol./papel celulos', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340032', 'description' => 'Circuito impresso dupla face rig.c/isolante res.epoxi./papel celulos', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340033', 'description' => 'Circuito impresso dupla face rig.c/isolante res.epoxi./tec.fib.vidro', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340039', 'description' => 'Outros circuitos impressos dubla face rigidos', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340040', 'description' => 'Circuito impresso dupla face flexiveis', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340051', 'description' => 'Circuito impresso multicamada c/ isolante res.epoxida/tec fibra vidro', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85340059', 'description' => 'Outros circuitos impressos multicamada', 'aliquota_federal' => 4.47, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85351000', 'description' => 'Fusiveis/corta-circuito de fusiveis, p/tensao>1000 volts', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85352100', 'description' => 'Disjuntores,p/tensao sup.1 kv e inferior a 72,5 kv', 'aliquota_federal' => 6.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85352900', 'description' => 'Outs.disjuntores p/tensao igual ou superior a 72,5 kv', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85353013', 'description' => 'Interruptores a vácuo, sem dispositivo de acionamento (ampolas a vácuo)', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85353017', 'description' => 'Outs.seccionadores/interruptores,t>1kv,corrente<=1600a com dispositivo de acionamento não automático', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85353018', 'description' => 'Outs.seccionadores/interruptores,t>1kv,corrente<=1600a, com dispositivo de acionamento automático, exceto os de contatos imersos em meio líquido', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85353019', 'description' => 'Outs.seccionadores/interruptores,t>1kv,corrente<=1600a', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85353023', 'description' => 'Interrup.vacuo s/disp.acionamento automatico >1600a', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85353027', 'description' => 'Interrup.vacuo s/disp.acionamento automatico >1600a, com dispositivo de acionamento não automático', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85353028', 'description' => 'Interrup.vacuo s/disp.acionamento automatico >1600a, com dispositivo de acionamento automático, exceto os de contatos imersos em meio líquido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85353029', 'description' => 'Outs.seccionadores/interruptores,t>1kv,corrente>1600a', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85354010', 'description' => 'Para-raios p/prot.linhas transmiss. eletricidade, t>1kv', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85354090', 'description' => 'Limitadores de tensao/eliminadores de onda eletr.t>1kv', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85359000', 'description' => 'Outs.apars.p/interrupcao,etc.de circuitos eletr.t>1kv', 'aliquota_federal' => 6.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85361000', 'description' => 'Fusiveis e corta-circuitos de fusiveis, p/tensao<=1kv', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85362000', 'description' => 'Disjuntores p/tensao<=1kv', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85363010', 'description' => 'Centelhador a gás', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85363090', 'description' => 'Outros', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85363090', 'description' => 'Dispositivos de transientes de tensão, para proteção de transmissores, de potência igual ou superior a 20kW ', 'aliquota_federal' => 6.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85364100', 'description' => 'Reles p/tensao<=60volts', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85364900', 'description' => 'Outros reles,60volts<tensao<=1000volts', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85365010', 'description' => 'Unidade chavead.de conversor p/telecom. satelite,t<=1kv', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85365020', 'description' => 'Unidade chavead.de amplif.hpa p/telecom. satelite,t<=1kv', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85365030', 'description' => 'Comutadores codificadores digitais, próprios p/ montagem em circuitos impressos', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85365090', 'description' => 'Outs.interruptores,etc.de circuitos eletr.p/tensao<=1kv', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85365090', 'description' => 'Interruptor de embutir ou sobrepor, rotativo ou de alavanca, para sistema elétrico em 24V, próprio para ônibus ou caminhões', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85365090', 'description' => 'Chaves de faca', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85365090', 'description' => 'Do tipo utilizado em residências', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85366100', 'description' => 'Suporte p/lampadas,p/tensao<=1kv', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85366910', 'description' => 'Tomada polarizada e tomada blindada, p/tensao<=1kv', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85366990', 'description' => 'Outros tomadas de corrente,p/tensao<=1kv', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85367000', 'description' => 'Conectores para fibras ópticas, feixes ou cabos de fibras ópticas', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85369010', 'description' => 'Conectores p/cabos planos de condutor paralelo,t<=1kv', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85369020', 'description' => 'Tomadas de contato deslizante em condutor aereo,t<=1kv', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85369030', 'description' => 'Soquetes p/microestruturas eletronicas, p/tensao<=1kv', 'aliquota_federal' => 9.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85369040', 'description' => 'Conectores p/circuito impresso,p/tensao<=1kv', 'aliquota_federal' => 9.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85369050', 'description' => 'Terminais de conexão para capacitores, mesmo montado em suporte isolante', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85369060', 'description' => 'Conector de corrente elétrica para acoplamento através da carcaça, do tipo utilizado em motocompressores herméticos de refrigeração ', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85369090', 'description' => 'Outs.apars.p/interrupcao,etc.p/circuitos eletr.t<=1kv', 'aliquota_federal' => 11.50, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85371011', 'description' => 'Quadros, paineis, consoles, etc, com processador e barramento de 32 bits ou superior, incorporando recursos graficos e execuçao de macros, resoluçao inferior ou igual a 1 micrometro e capacidade de conexao digital para servo-acionamento, com monitor polic', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85371019', 'description' => 'Outs.quadros,paineis,etc.c/apars.cmd.num.comput.t<=1kv', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85371020', 'description' => 'Quadros c/apars.control.programaveis, t<=1kv', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85371030', 'description' => 'Quadros c/apars.control.demanda de energia eletr.t<=1kv', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85371090', 'description' => 'Outs.quadros,etc.c/apars.interrup.circuito eletr.t<=1kv', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85372010', 'description' => 'Substacoes isoladas a gas(gis ou his), p/tensao>52kv', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85372090', 'description' => 'Outs quadros etc.c/apar interrup circuito eletr t>52kv', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85381000', 'description' => 'Quadros,paineis,etc.s/apars.interrup.circuito eletr.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85389010', 'description' => 'Circuito impresso montado p/apars.interrup. circ.eletr.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85389020', 'description' => 'Partes de disjuntores, p/ tensão >= 72,5 kv', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85389090', 'description' => 'Outros partes p/apars.interrup.circuito eletr.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85391010', 'description' => 'Farois e projetores em unidades seladas, p/tensao<=15v', 'aliquota_federal' => 15.67, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85391090', 'description' => 'Outros farois e projetores em unidades seladas', 'aliquota_federal' => 15.67, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392110', 'description' => 'Lampadas/tubos incandesc.halogenos,de tungstenio,t<=15v', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392110', 'description' => 'Lâmpadas dicróicas', 'aliquota_federal' => 7.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392190', 'description' => 'Outs.lampadas/tubos incandesc.halogenos,de tungstenio', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392190', 'description' => 'Lâmpadas dicróicas', 'aliquota_federal' => 7.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392200', 'description' => 'Outros lampadas/tubos incandesc. pot<=200w,t>100v', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392200', 'description' => 'Lâmpadas incandescentes, de tensão superior a 100V', 'aliquota_federal' => 7.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392910', 'description' => 'Outros lampadas/tubos incandesc.t<=15v', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392910', 'description' => 'Para iluminação e projeção, de temperatura de cor superior a 3.000°K, exclusivamente para cinematografia, cinema e atividades semelhantes, em qualquer base', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392990', 'description' => 'Outros lampadas/tubos incandesc.', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392990', 'description' => 'Para iluminação e projeção, de temperatura de cor superior a 3.000°K, exclusivamente para cinematografia, cinema e atividades semelhantes, em qualquer base', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85392990', 'description' => 'Lâmpadas incandescentes, de tensão superior a 100V', 'aliquota_federal' => 7.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85393100', 'description' => 'Lampadas/tubos descarga,fluorescente,de catodo quente', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85393100', 'description' => 'De descarga em baixa pressão, de base única, com ou sem reator eletrônico incorporado, com eficiência superior a 40 lúmens/W  lâmpada fluorescente compacta ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85393200', 'description' => 'Lampadas de vapor de mercurio/sodio ou halogeneto metal', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85393200', 'description' => 'De vapor de sódio, de alta pressão', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85393900', 'description' => 'Outros lampadas/tubos de descarga', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85393900', 'description' => 'Lâmpadas mistas', 'aliquota_federal' => 9.48, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85394110', 'description' => 'Lampadas de arco, de potência superior ou igual a 1.000w', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85394190', 'description' => 'Outras lampadas de arco', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85394900', 'description' => 'Lampadas/tubos de raios ultravioleta ou infravermelhos', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85395000', 'description' => 'Lampadas e tubos de diodos emissores de luz (led)', 'aliquota_federal' => 5.75, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85399010', 'description' => 'Eletrodos p/lampadas/tubos eletr.de incandescencia,etc.', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85399020', 'description' => 'Bases p/lampadas/tubos eletr.de incandescencia,etc.', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85399090', 'description' => 'Outs.partes p/lampadas/tubos eletr. incandescencia,etc.', 'aliquota_federal' => 6.42, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85401100', 'description' => 'Tubos catodicos p/recept.de televisao a cores,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85401200', 'description' => 'Tubos catodicos p/recept.televisao em preto/branco,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85402011', 'description' => 'Tubos p/cameras de televisao em preto e branco,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85402019', 'description' => 'Outros tubos p/cameras de televisao', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85402020', 'description' => 'Tubos conversores/intensificadores imagens,de raios x', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85402090', 'description' => 'Outs.tubos conversores/intensificadores de imagens,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85404000', 'description' => 'Tubos de visualização de dados gráficos, em monocromos, tubos de visualização de dados gráficos, a cores (policromo), com uma tela fosfórica de espaçamento entre os pontos inferior a 0,4 mm', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85406010', 'description' => 'Outs.tubos catodicos,de visualiz.dados graf.a cores,etc', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85406090', 'description' => 'Outros tubos catodicos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85407100', 'description' => 'Tubos p/microondas,magnetrons', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85407900', 'description' => 'Outros tubos p/microondas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85408100', 'description' => 'Tubos de recepcao ou de amplificacao', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85408910', 'description' => 'Valvulas de potencia p/transmissores', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85408990', 'description' => 'Outros lampadas,tubos e valvulas,eletronicos, etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85409110', 'description' => 'Bobinas de deflexao (yokes) p/tubos catodicos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85409120', 'description' => 'Nucleos de po ferromagnetico p/bobinas de deflexao', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85409130', 'description' => 'Canhoes eletronicos p/tubos catodicos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85409140', 'description' => 'Painel de vidro,mascara,etc.reunidos,p/tubos tricromat.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85409190', 'description' => 'Outros partes p/tubos catodicos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85409900', 'description' => 'Partes p/lampadas,outs.tubos e valvulas, eletron. etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411011', 'description' => 'Diodos nao montados,zener', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411012', 'description' => 'Diodos nao montados,de intensidade de corrente<=3a', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85411019', 'description' => 'Outros diodos nao montados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411021', 'description' => 'Diodos montados p/montag.superf.zener', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411022', 'description' => 'Diodos montados p/montag.superf.intensid. corrente<=3a', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411029', 'description' => 'Outros diodos montados p/montag.em superficie', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411031', 'description' => 'Zener', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411032', 'description' => 'Outros, de intensidade de corrente inferior ou igual a 3 A 2', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411039', 'description' => 'Outros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411091', 'description' => 'Outros diodos zener', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411092', 'description' => 'Outros diodos de intensidade de corrente<=3a', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85411099', 'description' => 'Outros diodos exc.fotodiodos e diodos emissores de luz', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85412110', 'description' => 'Transistores c/cap.dissip.<1w,nao montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85412120', 'description' => 'Transistores c/cap.dissip.<1w,montados, p/montag.superf.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85412191', 'description' => 'Outs.transistores c/cap.dissip.<1w,exc. fototransistores, de efeito de campo, c/ junção heterogênea (hjfet ou hemt)', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85412199', 'description' => 'Outs.transistores c/cap.dissip.<1w,exc.fototransistores', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85412910', 'description' => 'Outs.transistores,nao montados, exc.fototransistores', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85412920', 'description' => 'Outros transistores,montados,exc. fototransistores', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85413011', 'description' => 'Tiristores,diacs,etc.n/montados,intensid.corrente<=3a', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85413019', 'description' => 'Outros tiristores,diacs,triacs,n/montados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85413021', 'description' => 'Tiristores,diacs,etc.montados,intensid.corrente<=3a', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85413029', 'description' => 'Outros tiristores,diacs,triacs,montados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414011', 'description' => 'Diodos emissores de luz (led) n/montados, exc.laser', 'aliquota_federal' => 5.01, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414012', 'description' => 'Diodos laser nao montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414013', 'description' => 'Fotodiodos nao montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414014', 'description' => 'Fototransitores nao montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414015', 'description' => 'Fototiristores nao montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414016', 'description' => 'Celulas solares nao montadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414019', 'description' => 'Outs.dispositivos fotossensiveis semicondut. n/montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414021', 'description' => 'Diodos emissores de luz (led) montados, exc.laser', 'aliquota_federal' => 4.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414022', 'description' => 'Outros diodos emissores de luz (led) montados, exc.laser', 'aliquota_federal' => 4.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414023', 'description' => 'Diodod laser c/ comprimento de onda de 1300nmm ou 1500nm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414024', 'description' => 'Outros diodos laser', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414025', 'description' => 'Fotodiodos, fototransistores e fototiristores montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414026', 'description' => 'Fotorresistores montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414027', 'description' => 'Acopladores óticos montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414029', 'description' => 'Outs.dispositivos fotossensiveis semicondut.montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414031', 'description' => 'Fotodiodos em modulos ou paineis', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414032', 'description' => 'Celulas solares em modulos ou paineis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85414039', 'description' => 'Outros celulas fotovoltaicas em modulos ou paineis', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85415010', 'description' => 'Outros dispositivos semicondutores nao montados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85415020', 'description' => 'Outros dispositivos semicondutores montados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85416010', 'description' => 'Cristais piezoeletr.montados,de quartzo, 1<=freq<=100mhz', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85416090', 'description' => 'Outros cristais piezoeletricos montados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85419010', 'description' => 'Suporte-conector em tiras,diodos, etc. semicondutores', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85419020', 'description' => 'Coberturas p/encapsulamento (capsulas)', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85419090', 'description' => 'Outs.partes de diodos,transistores,etc. semicondutores', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423110', 'description' => 'Circuitos integrados eletrônicosprocessadores e controladores, mesmo combinados com memórias, conversores, circuitos lógicos, amplificadores, circuitos temporizadores e de sincronização, ou outros circuitos, não montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423110', 'description' => 'Obtidos por tecnologia bipolar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423120', 'description' => 'Circuitos integrados eletrônicosprocessadores e controladores, mesmo combinados com memórias, conversores, circuitos lógicos, amplificadores, circuitos temporizadores e de sincronização, ou outros circuitos, montados, próprios para montagem em superfície', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423190', 'description' => 'Outros microcontroladores montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423210', 'description' => 'Memorias não montadas', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423210', 'description' => 'Obtidos por tecnologia bipolar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423221', 'description' => 'Memorias montados,p/montagem em superficie dos tipos ram estáticas (sram) com tempo de acesso inferior ou igual a 25ns, eprom, eeprom, prom, rom e flash', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423229', 'description' => 'Outras memórias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85423291', 'description' => 'Outs.memorias dos tipos ram estáticas (sram) com tempo de acesso inferior ou igual a 25ns, eprom, eeprom, prom, rom e flash', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423299', 'description' => 'Outras memórias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423299', 'description' => 'De óxido metálico', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423311', 'description' => 'Amplificadores integrado hibrido,espessura de camada<=1micron c/ frequencia de operação >= 800 mhz', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423319', 'description' => 'Outros amplificadores hibridos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423320', 'description' => 'Outros amplificadores nao montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423390', 'description' => 'Outros amplificadores', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423911', 'description' => 'Outros circuitos integrados hibridos de espessura de camada inferior ou igual a 1 micrômetro (mícron) com freqüência de operação superior ou igual a 800mhz', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423919', 'description' => 'Outros circuitos integr.hibridos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423920', 'description' => 'Outros circuitos integr.nao montados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423920', 'description' => 'Obtidos por tecnologia bipolar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423931', 'description' => 'Outros circuitos integr.montados do tipo chip-set', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423939', 'description' => 'Outros circuitos integrados montados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423991', 'description' => 'Outs.circuitos integrados  do tipo chip-set', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85423999', 'description' => 'Outs.circuitos integrados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85429010', 'description' => 'Suporte-conector em tiras,p/circuito integr.etc.eletron', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85429020', 'description' => 'Coberturas p/encapsulamento,p/circuito integr.eletron.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85429090', 'description' => 'Outs.partes p/circuito integr.e microconj.eletron.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85431000', 'description' => 'Aceleradores de particulas,eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85432000', 'description' => 'Geradores de sinais,eletr.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85432000', 'description' => 'Geradores de sinais de teste e referência de vídeo nos padrões SDI e HD-SDI, com capacidade de geração de diferentes sinais de teste, dentre eles o “color bars” e “zoneplate”', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85433010', 'description' => 'De eletrólise, com células de membrana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85433090', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437011', 'description' => 'Amplificador radiofreq.p/transm.sinal microonda,hpa,etc', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437011', 'description' => 'De média ou de alta freqüência', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437012', 'description' => 'Amplificador radiofreq.p/recep.sinal microonda,lna,etc', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437012', 'description' => 'De média ou de alta freqüência', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437013', 'description' => 'Amplificador radiofreq.p/distrib.de sinais de televisao', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437013', 'description' => 'De média ou de alta freqüência', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437014', 'description' => 'Outs.amplificad.radiofreq.p/recep.sinais microondas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437014', 'description' => 'De média ou de alta freqüência', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437015', 'description' => 'Outs.amplificad.radiofreq.p/transm.sinais microondas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437015', 'description' => 'De média ou de alta freqüência', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437019', 'description' => 'Outros amplificad.radiofreq.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437019', 'description' => 'De média ou de alta freqüência', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437020', 'description' => 'Apars.p/eletrocutar insetos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437031', 'description' => 'Geradores de efeitos espec.manip.2/3 dimens.etc.p/video', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437032', 'description' => 'Geradores de caracteres,digitais,p/video', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437033', 'description' => 'Sincronizador de quadro armazen.etc.base tempo,p/video', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437034', 'description' => 'Controladores de edicao,p/video', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437035', 'description' => 'Misturador digital,em tempo real de entrada>=8,p/video', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437036', 'description' => 'Roteador-comutador (routing switcher) de mais de 20 entradas e mais de 16 saídas, de áudio ou de vídeo', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437036', 'description' => 'Roteadores-comutadores  “trouting switcher” , contendo mais de 20 entradas e mais de 16 saídas de áudio e/ou vídeo, com interface de entrada de vídeo SDI e HD-SDI e saídas em SDI e HD-SDI, entradas de áudio analógico e/ou digital ou capacidade par', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437039', 'description' => 'Outros maqs.e apars.auxiliares,p/video', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437040', 'description' => 'Transcodificador ou conversor de padroes de televisao', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437050', 'description' => 'Simulador de antenas para transmissores com potência igual ou superior a 25kw (carga fantasma)', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437091', 'description' => 'Terminais de texto que operem com código de transmissão baudot, providos de teclado alfanumérico e visor (display), para acoplamento exclusivamente acústico a telefone', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437092', 'description' => 'Eletrificadores de cercas', 'aliquota_federal' => 4.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437099', 'description' => 'Outros maqs.e apars.eletr.c/funcao propria', 'aliquota_federal' => 6.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85437099', 'description' => 'Amplificadores seriais digitais para distribuição de sinais de vídeo, com retemporizador', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85439010', 'description' => 'Partes de maqs.e apars.amplificad.radiofreq. video,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85439090', 'description' => 'Partes de outs.maqs.e apars.eletr.c/funcao propria', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85441100', 'description' => 'Fios de cobre p/bobinar,isolados p/uso eletr.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '85441910', 'description' => 'Fios de aluminio p/bobinar,isolados p/uso eletr.', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85441990', 'description' => 'Outros fios p/bobinar,isolados p/uso eletr.', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85442000', 'description' => 'Cabos coaxiais e outs.condutores eletr.coaxiais', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85443000', 'description' => 'Jogos de fios p/velas de ignicao e outs.fios p/veiculos', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85443000', 'description' => 'Para sistema elétrico em 24 V', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85444200', 'description' => 'Outs.condutores eletr.munidos pecas conexao, para tensão não superior a 1000v', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85444900', 'description' => 'Outros condutores eletr.80v<tensao<=1.000v', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85444900', 'description' => 'Para tensão não superior a 80 V', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85446000', 'description' => 'Outros condutores eletr.p/tensao>1000v', 'aliquota_federal' => 7.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85447010', 'description' => 'Cabos de fibras opticas com rev.ext.de material dieletr.', 'aliquota_federal' => 11.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85447020', 'description' => 'Cabos de fibras opticas com rev.ext.de aco proprio p/inst.submarina', 'aliquota_federal' => 11.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85447030', 'description' => 'Cabos de fibras opticas rev.ext.de aluminio', 'aliquota_federal' => 11.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85447090', 'description' => 'Outros cabos de fibras opticas', 'aliquota_federal' => 11.90, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85451100', 'description' => 'Eletrodos de carvao p/uso em fornos eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85451910', 'description' => 'Eletrodos de grafita,teor carbono>=99.9%,p/uso eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85451920', 'description' => 'Blocos de grafite, dos tipo utilizados como cátodos em cubas eletrolíticas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85451990', 'description' => 'Outros eletrodos de carvao,p/uso eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85452000', 'description' => 'Escovas de carvao,p/uso eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85459010', 'description' => 'Carvoes p/pilhas eletricas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85459020', 'description' => 'Resistencias aquecedoras desprov.de revestim/terminais', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85459030', 'description' => 'Suporte de conexao (nipples) p/eletrodos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85459090', 'description' => 'Outs.carvoes e artigos de grafita/carvao p/uso eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85461000', 'description' => 'Isoladores de vidro p/uso eletrico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85462000', 'description' => 'Isoladores de ceramica p/uso eletrico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85469000', 'description' => 'Isoladores de outs.materias p/uso eletrico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85471000', 'description' => 'Pecas isolantes de ceramica p/maqs.apars.e instal.eletr', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85472010', 'description' => 'Tampões, vedadores para capacitores, com perfurações para terminais (de plastico)', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85472090', 'description' => 'Pecas isolantes de plastico p/maqs.apars.e instal.eletr', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85479000', 'description' => 'Outs.pecas/tubos isolantes p/maqs.apars.e instal.eletr.', 'aliquota_federal' => 8.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85481010', 'description' => 'Desperdícios e resíduos de acumuladores elétricos de chumbo, acumuladores elétricos de chumbo, inservíveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85481010', 'description' => 'Acumuladores inservíveis', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85481090', 'description' => 'Desperdicios/resids.de pilhas/bateria pilhas eletr.etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85481090', 'description' => 'Desperdícios e resíduos, à base de cádmio, exceto seus compostos químicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85481090', 'description' => 'Desperdícios e resíduos, contendo compostos químicos de níquel, cádmio, mercúrio ou de lítio', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85481090', 'description' => 'Pilhas, baterias de pilhas e acumuladores elétricos, inservíveis, exceto acumuladores de chumbo', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85489010', 'description' => 'Termopares utiliz.em dispos. termele. de apar. a gas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '85489090', 'description' => 'Partes eletricas de outras maquinas e aparelhos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86011000', 'description' => 'Locomotivas e locotratores,de fonte ext.de eletricidade', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86012000', 'description' => 'Locomotivas e locotratores,de acumuladores eletricos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86021000', 'description' => 'Locomotivas diesel-eletricas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86029000', 'description' => 'Outros locomotivas e locotratores,e tenderes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86031000', 'description' => 'Litorinas (automotoras),de fonte ext.de eletricidade', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86039000', 'description' => 'Outros litorinas (automotoras)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86040010', 'description' => 'Veics.autopropuls.batedor balastro,alinhad.vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86040090', 'description' => 'Outs.veiculos p/inspecao/manutencao de vias ferreas,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86050010', 'description' => 'Vagoes de passageiros p/vias ferreas/semelhs.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86050090', 'description' => 'Furgoes p/bagagem,vagoes-postais,etc.p/vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86061000', 'description' => 'Vagoes-tanques/semelhs.p/transp.mercad.em vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86063000', 'description' => 'Vagoes de descarga automat.mercadorias em vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86069100', 'description' => 'Vagoes cobertos/fechados,p/transp.mercad.vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86069200', 'description' => 'Vagoes abertos/paredes fixas,altura>60cm p/vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86069900', 'description' => 'Outs.vagoes p/transporte de mercadorias em vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86071110', 'description' => 'Truques (bogies) de tracao de veiculos p/vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '86071120', 'description' => 'Bisseis de tracao de veiculos p/vias ferreas/semelhs.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86071200', 'description' => 'Outs.bogies e bisseis de veiculos p/vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86071911', 'description' => 'Mancais de veiculos p/vias ferreas, c/ rolamento incorporado ...', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86071919', 'description' => 'Outros (mancais de veiculos p/vias ferreas)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.80, 'aliquota_municipal' => 0.00],
            ['ncm' => '86071990', 'description' => 'Eixos,rodas e suas partes de veiculos p/vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86072100', 'description' => 'Freios a ar comprim.suas partes de veic.p/vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86072900', 'description' => 'Outs.freios e suas partes,de veiculos p/vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86073000', 'description' => 'Ganchos,para-choques,etc.de veiculos p/vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86079100', 'description' => 'Outros partes de locomotivas ou de locotratores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86079900', 'description' => 'Outros partes de veiculos p/vias ferreas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86080011', 'description' => 'Apars.mecanicos de sinalizacao,etc.p/vias ferreas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86080012', 'description' => 'Apars.eletromecan.de sinalizacao,etc.p/vias ferreas,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86080090', 'description' => 'Material fixo de vias ferreas/semelhs.e suas partes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '86090000', 'description' => 'Conteineres (contentores) incl.de transp.fluidos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87011000', 'description' => 'Tratores motocultores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87012000', 'description' => 'Tratores rodoviarios p/semi-reboques', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87013000', 'description' => 'Tratores de lagartas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019100', 'description' => 'Nao superior a 18 kw', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019100', 'description' => 'Nao superior a 18 kw', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019200', 'description' => 'Superior a 18 kw, mas nao superior a 37 kw', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019200', 'description' => 'Superior a 18 kw, mas nao superior a 37 kw', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019300', 'description' => 'Superior a 37 kw, mas nao superior a 75 kw', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019300', 'description' => 'Superior a 37 kw, mas nao superior a 75 kw', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019410', 'description' => 'Tratores especialmente concebidos para arrastar troncos (log skidders)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019490', 'description' => 'Outros', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019490', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019510', 'description' => 'Tratores especialmente concebidos para arrastar troncos (log skidders)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019590', 'description' => 'Outros', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87019590', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87021000', 'description' => 'Veiculos automoveis p/transp>=10 pessoas,c/motor diesel', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87021000', 'description' => 'Com volume interno de habitáculo, destinado a passageiros e motorista, superior a 6m³, mas inferior a 9m³', 'aliquota_federal' => 19.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87021000', 'description' => 'Com volume interno de habitáculo, destinado a passageiros e motorista, igual ou superior a 9m³', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87022000', 'description' => 'Equipados para propulsao, simultaneamente, com um motor de pistao de ignicao por compressao (diesel ou semidiesel) e um motor eletrico', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87022000', 'description' => 'Equipados para propulsao, simultaneamente, com um motor de pistao de ignicao por compressao (diesel ou semidiesel) e um motor eletrico', 'aliquota_federal' => 19.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87022000', 'description' => 'Equipados para propulsao, simultaneamente, com um motor de pistao de ignicao por compressao (diesel ou semidiesel) e um motor eletrico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87023000', 'description' => 'Equipados para propulsao, simultaneamente, com um motor de pistao alternativo de ignicao por centelha (faisca*) e um motor eletrico', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87023000', 'description' => 'Equipados para propulsao, simultaneamente, com um motor de pistao alternativo de ignicao por centelha (faisca*) e um motor eletrico', 'aliquota_federal' => 19.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87023000', 'description' => 'Equipados para propulsao, simultaneamente, com um motor de pistao alternativo de ignicao por centelha (faisca*) e um motor eletrico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87024010', 'description' => 'Trolebus', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87024090', 'description' => 'Outros', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87024090', 'description' => 'Outros', 'aliquota_federal' => 19.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87024090', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87029000', 'description' => 'Outros', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87029000', 'description' => 'Outros', 'aliquota_federal' => 19.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87029000', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87031000', 'description' => 'Veiculos automoveis p/deslocam.na neve,campo golfe,etc.', 'aliquota_federal' => 22.30, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87032100', 'description' => 'Automoveis c/motor explosao,cil<=1000cm3', 'aliquota_federal' => 18.03, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87032210', 'description' => 'Automoveis c/motor explosao,1000<cm3<=1500, ate 6 passag', 'aliquota_federal' => 21.50, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87032290', 'description' => 'Automoveis c/motor explosao,1000<cm3<=1500, sup.6 passag', 'aliquota_federal' => 21.50, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87032310', 'description' => 'Automoveis c/motor explosao,1500<cm3<=3000, ate 6 passag', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87032310', 'description' => 'De cilindrada superior a 1.500 cm³, mas não superior a 2.000 cm³', 'aliquota_federal' => 21.50, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87032390', 'description' => 'Automoveis c/motor explosao,1500<cm3<=3000, sup.6 passag', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87032390', 'description' => 'De cilindrada superior a 1.500 cm³, mas não superior a 2.000 cm³', 'aliquota_federal' => 21.50, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '87032410', 'description' => 'Automoveis c/motor explosao,cm3>3000,ate 6 passageiros', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87032490', 'description' => 'Automoveis c/motor explosao,cm3>3000,sup.6 passageiros', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87033110', 'description' => 'Automoveis c/motor diesel,cm3<=1500,ate 6 passageiros', 'aliquota_federal' => 19.15, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87033190', 'description' => 'Automoveis c/motor diesel,cm3<=1500,sup.6 passageiros', 'aliquota_federal' => 19.15, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87033210', 'description' => 'Automoveis c/motor diesel,1500<cm3<=2500,ate 6 passag.', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87033290', 'description' => 'Automoveis c/motor diesel,1500<cm3<=2500,sup.6 passag.', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87033310', 'description' => 'Automoveis c/motor diesel,cm3>2500,ate 6 passageiros', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87033390', 'description' => 'Automoveis c/motor diesel,cm3>2500,sup.6 passageiros', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87034000', 'description' => 'Outros veiculos, equipados para propulsao, simultaneamente, com um motor de pistao alternativo de ignicao por centelha (faisca*) e um motor eletrico, exceto os suscetiveis de serem carregados por conexao a uma fonte externa de energia eletrica', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87035000', 'description' => 'Outros veiculos, equipados para propulsao, simultaneamente, com um motor de pistao de ignicao por compressao (diesel ou semidiesel) e um motor eletrico, exceto os suscetiveis de serem carregados por conexao a uma fonte externa de energia eletrica', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87036000', 'description' => 'Outros veiculos, equipados para propulsao, simultaneamente, com um motor de pistao alternativo de ignicao por centelha (faisca*) e um motor eletrico, suscetiveis de serem carregados por conexao a uma fonte externa de energia eletrica', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87037000', 'description' => 'Outros veiculos, equipados para propulsao, simultaneamente, com um motor de pistao de ignicao por compressao (diesel ou semidiesel) e um motor eletrico, suscetiveis de serem carregados por conexao a uma fonte externa de energia eletrica', 'aliquota_federal' => 27.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87038000', 'description' => 'Outros veiculos, equipados unicamente com motor eletrico para propulsao', 'aliquota_federal' => 19.15, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87039000', 'description' => 'Outs.automoveis de passageiros,incl.de uso misto,etc.', 'aliquota_federal' => 19.15, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87041010', 'description' => 'Dumpers p/transp.mercadoria>=85t,util.fora de rodovias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87041090', 'description' => 'Outs.dumpers p/transp.mercadoria,util.fora de rodovias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042110', 'description' => 'Chassis c/motor diesel e cabina,p/carga<=5t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042110', 'description' => 'De camionetas, furgões, “pick-ups” e semelhantes', 'aliquota_federal' => 18.64, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042120', 'description' => 'Veic.automov.c/motor diesel/caixa bascul.p/carga<=5t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042120', 'description' => 'De camionetas, furgões, “pick-ups” e semelhantes', 'aliquota_federal' => 16.14, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042130', 'description' => 'Veic.automov.frigorif.etc.c/motor diesel,carga<=5t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042130', 'description' => 'De camionetas, furgões, “pick-ups” e semelhantes', 'aliquota_federal' => 16.14, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042190', 'description' => 'Outs.veiculos automoveis c/motor diesel,p/carga<=5t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042190', 'description' => 'De camionetas, furgões, “pick-ups” e semelhantes', 'aliquota_federal' => 18.64, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042190', 'description' => 'Carro-forte para transporte de valores', 'aliquota_federal' => 19.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042210', 'description' => 'Chassis c/motor diesel e cabina,5t<carga<=20t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042220', 'description' => 'Veic.automov.c/motor diesel/caixa bascul.5t<carga<=20t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042230', 'description' => 'Veic.automov.frigorif.etc.c/motor diesel,5t<carga<=20t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042290', 'description' => 'Outs.veiculos automoveis c/motor diesel,5t<carga<=20t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042310', 'description' => 'Chassis c/motor diesel e cabina,carga>20t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042320', 'description' => 'Veic.automov.c/motor diesel/caixa bascul.carga>20t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042330', 'description' => 'Veic.automov.frigorif.etc.c/motor diesel,carga>20t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042340', 'description' => 'Veículos de chassis articulado, para o transporte de troncos (forwarder), com grua incorporada, de potência máxima igual ou superior a 126 kW (170 HP)', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042390', 'description' => 'Outs.veiculos automoveis c/motor diesel,carga>20t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87042390', 'description' => 'Veículo automóvel para transporte de toras de madeira, denominado comercialmente “trator florestal” e, tecnicamente, “forwarder”', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043110', 'description' => 'Chassis c/motor explosao e cabina,carga<=5t', 'aliquota_federal' => 19.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043110', 'description' => 'De caminhão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043120', 'description' => 'Veic.automov.c/motor explosao/caixa bascul.carga<=5t', 'aliquota_federal' => 16.14, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043120', 'description' => 'Caminhão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043130', 'description' => 'Veic.automov.frigorif.etc.c/motor explosao,carga<=5t', 'aliquota_federal' => 16.14, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043130', 'description' => 'Caminhão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043190', 'description' => 'Outs.veiculos automoveis c/motor explosao,carga<=5t', 'aliquota_federal' => 18.64, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043190', 'description' => 'Caminhão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043210', 'description' => 'Chassis c/motor explosao e cabina,carga>5t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043220', 'description' => 'Veic.automov.c/motor explosao/caixa bascul. carga>5t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043230', 'description' => 'Veic.automov.frigorif.etc.c/motor explosao, carga>5t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87043290', 'description' => 'Outs.veiculos automoveis c/motor explosao, carga>5t', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87049000', 'description' => 'Outs.veiculos automoveis p/transporte de mercadorias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87051010', 'description' => 'Caminhoes-guindastes com haste telescópica de altura máxima superior ou igual a 42m, capacidade máxima de elevação superior ou igual a 60t, segundo a norma din 15019, parte 2, e com 4 ou mais eixos de rodas direcionáveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87051090', 'description' => 'Outros caminhoes-guindastes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87052000', 'description' => 'Torres (derricks) automoveis,p/sondagem/ perfuracao', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87053000', 'description' => 'Veiculos automoveis de combate a incendios', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87054000', 'description' => 'Caminhoes-betoneiras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '87059010', 'description' => 'Caminhões p/ determinação de parâmetros físicos característicos (perfilagem) de poços petrolíferos', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87059090', 'description' => 'Outros veiculos automoveis p/usos especiais', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87060010', 'description' => 'Chassis c/motor p/veic.automov.transporte>=10 pessoas', 'aliquota_federal' => 19.15, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87060010', 'description' => 'De veículos dos Ex 01 e 02 dos códigos 8702.10.00 e 8702.90.90', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87060020', 'description' => 'Chassis c/motor p/tratores e dumpers,exc. rodoviarios', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87060090', 'description' => 'Outs.chassis c/motor p/automoveis de passag/ mercadorias', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87060090', 'description' => 'De caminhões', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87071000', 'description' => 'Carrocarias p/automoveis de passageiros,incl. as cabinas', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87079010', 'description' => 'Carrocarias p/tratores e dumpers,incl.as cabinas', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87079090', 'description' => 'Carrocarias p/veic.automov.transp>=10pessoas ou p/carga', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87079090', 'description' => 'De veículos dos Ex 01 e 02 dos códigos 8702.10.00 e 8702.90.90', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87081000', 'description' => 'Para-choques e suas partes p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082100', 'description' => 'Cintos de seguranca p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082911', 'description' => 'Para-lamas p/tratores e dumpers,exc. rodoviarios', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082912', 'description' => 'Grades de radiadores p/tratores e dumpers,exc. rodov.', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082913', 'description' => 'Portas p/tratores e dumpers,exc.rodoviarios', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082914', 'description' => 'Paineis de instrumentos p/tratores e dumpers exc.rodov', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082919', 'description' => 'Outs.partes e acess.de carrocarias p/tratores/ dumpers', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082991', 'description' => 'Para-lamas p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082992', 'description' => 'Grades de radiadores p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082993', 'description' => 'Portas p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082994', 'description' => 'Paineis de instrumentos p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082995', 'description' => 'Geradores de gás para acionar retratores de cintos de segurança', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87082999', 'description' => 'Outs.partes e acess.de carrocarias p/veic.automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87083011', 'description' => 'Guarnicoes de freios,montadas,p/tratores e dumpers', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87083019', 'description' => 'Guarnicoes de freios,montadas,p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87083090', 'description' => 'Outs.freios e suas partes,p/tratores/veic. automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87084011', 'description' => 'Caixas de marchas servo-assistidas, próprias para torques de entrada superiores ou iguais a 750nm', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87084019', 'description' => 'Outras (caixas de marchas p/tratores e  dumpers, exc. rodoviario)', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87084080', 'description' => 'Caixas de marchas p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87084090', 'description' => 'Peças para caixas de marchas p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87085011', 'description' => 'Eixos de transmissao c/diferenc.p/dumpers, carga>=14t', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87085012', 'description' => 'Outs.eixos e suas partes,p/tratores/dumpers, exc.rodov', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87085019', 'description' => 'Outs.eixos e suas partes', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87085080', 'description' => 'Eixos de transmissao c/diferencial p/veic. automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87085091', 'description' => 'Partes de eixos não motores para dumpers, tratores e veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87085099', 'description' => 'Partes e acess.de outros eixos p/tratores e veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87087010', 'description' => 'Rodas de eixos propulsor.e partes,p/tratores/ dumpers/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87087090', 'description' => 'Outs.rodas,suas partes e acess.p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '87088000', 'description' => 'Sistemas de suspensão e suas partes (incluídos os amortecedores de suspensão)', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87088000', 'description' => 'Amortecedores de suspensão de veículos das posições 87.02, 87.04  exceto a subposição 8704.10  e 87.05 e da subposição 8701.20', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87088000', 'description' => 'Outros amortecedores de suspensão', 'aliquota_federal' => 17.38, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089100', 'description' => 'Radiadores p/tratores e veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089200', 'description' => 'Silenciosos e tubos de escape p/tratores/veic. automov.', 'aliquota_federal' => 17.38, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089200', 'description' => 'De veículos das posições 87.01, 87.02, 87.04 e 87.05  exceto partes ', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089200', 'description' => 'Partes', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089300', 'description' => 'Embreagens e suas partes p/tratores/veiculos automoveis', 'aliquota_federal' => 17.38, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089300', 'description' => 'De veículos das posições 87.01, 87.02, 87.04 e 87.05', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089411', 'description' => 'Volantes de direcao p/tratores/dumpers, exc rodoviarios', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089412', 'description' => 'Barras de direcao p/tratores/dumpers, exc.rodoviarios', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089413', 'description' => 'Caixas de direcao p/tratores/dumpers, exc.rodoviarios', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089481', 'description' => 'Volantes de direcao p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089482', 'description' => 'Barras de direcao p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '87089483', 'description' => 'Caixas de direcao p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089490', 'description' => 'Peças para volantes, barras e caixas de direcao p/veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089510', 'description' => 'Bolsas infláveis de segurança com sistema de insuflação (“airbags)', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089521', 'description' => 'Bolsas inflaveis para airbags', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089522', 'description' => 'Sistema de insuflação', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089529', 'description' => 'Outras partes para bolsas infláveis de segurança com sistema de insuflação (“airbags)', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089910', 'description' => 'Dispositivos para comando de acelerador, freio, embreagem, direção ou caixa de marchas mesmo os de adaptação dos preexistentes, do tipo dos utilizados por pessoas incapacitadas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87089990', 'description' => 'Outs.partes e acess.p/tratores e veiculos automoveis', 'aliquota_federal' => 14.81, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87091100', 'description' => 'Veiculos automov.eletr.s/disp.elev.util.em fabricas,etc', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87091900', 'description' => 'Outs.veiculos automov.s/disp.elev.util.em fabricas,etc.', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87099000', 'description' => 'Partes de veic.automov.s/disp.elev.util.em fabricas,etc', 'aliquota_federal' => 9.21, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87100000', 'description' => 'Veiculos e carros blindados de combate e suas partes', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87111000', 'description' => 'Motocicletas,etc.c/motor pistao alternat.cil<=50cm3', 'aliquota_federal' => 24.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87112010', 'description' => 'Motocicletas c/motor pistao alternat.50cm3<cil<=125cm3', 'aliquota_federal' => 24.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87112020', 'description' => 'Motocicletas c/motor pistao alternat.125cm3<cil<=250cm3', 'aliquota_federal' => 24.96, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87112090', 'description' => 'Outs.ciclos c/motor pistao alternat.50cm3<cil<=250cm3', 'aliquota_federal' => 24.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87113000', 'description' => 'Motocicletas,etc.c/motor pistao alternat.250<c<=500cm3', 'aliquota_federal' => 24.96, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87114000', 'description' => 'Motocicletas,etc.c/motor pistao alternat.500<c<=800cm3', 'aliquota_federal' => 24.96, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87115000', 'description' => 'Motocicletas,etc.c/motor pistao alternat.cil>800cm3', 'aliquota_federal' => 24.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87116000', 'description' => 'Com motor eletrico para propulsao', 'aliquota_federal' => 24.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87119000', 'description' => 'Outs.motocicletas/ciclos c/motor auxil.carros laterais', 'aliquota_federal' => 24.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87120010', 'description' => 'Bicicletas sem motor', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87120090', 'description' => 'Outros ciclos sem motor,incl.triciclos', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87131000', 'description' => 'Cadeiras de rodas,etc.sem mecanismo de propulsao', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87139000', 'description' => 'Outs.cadeiras de rodas e outs.veiculos p/invalidos', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87141000', 'description' => 'Partes e acess.p/motocicletas incl. ciclomotores', 'aliquota_federal' => 10.91, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87142000', 'description' => 'Partes e acess.p/cadeiras de rodas/outs.veic.p/invalido', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149100', 'description' => 'Quadros,garfos e suas partes p/bicicletas e outs.ciclos', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149200', 'description' => 'Aros e raios para bicicletas e outs.ciclos', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149310', 'description' => 'Cubos, exceto de freios (travões)', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149320', 'description' => 'Outs.pinhoes de rodas livres p/bicibletas,etc.', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149410', 'description' => 'Cubos de freios p/bicicletas e outs.ciclos', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149490', 'description' => 'Outs.freios e suas partes p/bicicletas e outs.ciclos', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149500', 'description' => 'Selins de bicicletas e outs.ciclos', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149600', 'description' => 'Pedais,pedaleiros e suas partes,p/bicicletas,etc.', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149910', 'description' => 'Cãmbio de velocidades', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87149990', 'description' => 'Outros partes e acess.p/bicicletas e outs.ciclos', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87150000', 'description' => 'Carrinhos,veic.semelh.e suas partes,p/transp. criancas', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87161000', 'description' => 'Reboques/semi-reboques p/habitacao/acampar trailer', 'aliquota_federal' => 10.44, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87162000', 'description' => 'Reboques/semi-reboques autocarregaveis, etc.uso agricola', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87163100', 'description' => 'Reboques-cisternas p/transporte de mercadorias', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87163900', 'description' => 'Outs.reboques e semi-reboques p/transp.de mercadorias', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87164000', 'description' => 'Outros reboques e semi-reboques', 'aliquota_federal' => 9.21, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87168000', 'description' => 'Outros veiculos nao autopropulsores', 'aliquota_federal' => 9.21, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87168000', 'description' => 'Carrinhos de tração manual, de ferro, para construção', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87168000', 'description' => 'Veículos de tração animal', 'aliquota_federal' => 7.85, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87169010', 'description' => 'Chassis de reboques e semi-reboques', 'aliquota_federal' => 9.21, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '87169090', 'description' => 'Outs.partes de reboques/semi-reboques/ veic. n/autopropul', 'aliquota_federal' => 9.21, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88010000', 'description' => 'Balões e dirigíveis, planadores, asas voadoras e outros veículos aéreos, não concebidos para propulsão com motor.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88021100', 'description' => 'Helicopteros de peso<=2000kg,vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88021210', 'description' => 'Helicopteros de 2000kg<peso<=3500kg,vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88021290', 'description' => 'Outros helicopteros de peso>3500kg,vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88022010', 'description' => 'Avioes a helice,etc.peso<=2000kg,vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '88022021', 'description' => 'Avioes a turboelice,etc.monomotores, p<=2000kg,vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88022022', 'description' => 'Avioes a turboelice,etc.multimotores, p<=2000kg, vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88022090', 'description' => 'Outros avioes/veiculos aereos,peso<=2000kg, vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88023010', 'description' => 'Avioes a helice,etc.2000kg<peso<=15000kg,vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '88023021', 'description' => 'Avioes a turboelice,etc.multimotores,2t<peso<=7t, vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88023029', 'description' => 'Outros avioes a turboelice,etc.7t<peso<=15t, vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88023031', 'description' => 'Avioes a turbojato,etc.2000kg<peso<=7000kg, vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88023039', 'description' => 'Outs.avioes a turbojato,etc.7000kg<peso<=15000kg, vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88023090', 'description' => 'Outs.avioes/veiculos aereos, 2000kg<peso<=15000kg, vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88024010', 'description' => 'Avioes a turboelice,etc.peso>15000kg,vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88024090', 'description' => 'Outros avioes/veiculos aereos,peso>15000kg, vazios', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88026000', 'description' => 'Veiculos espaciais e seus veiculos de lancamento,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88031000', 'description' => 'Helices,rotores e suas partes,p/veiculos aereos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '88032000', 'description' => 'Trens de aterrissagem e suas partes,p/veic. aereos, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '88033000', 'description' => 'Outros partes p/avioes ou helicopteros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '88039000', 'description' => 'Outros partes p/veiculos aereos/espaciais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '88040000', 'description' => 'Para-quedas/para-quedas giratorios,suas partes e acess.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88051000', 'description' => 'Apars.e dispositivos p/lancam.de veic.aereo, etc.partes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88052100', 'description' => 'Apars.simuladores de combate aereo e suas partes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '88052900', 'description' => 'Apars.simuladores de voo em terra e suas partes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89011000', 'description' => 'Transatlânticos, barcos de excursão e embarcações semelhantes principalmente concebidas para o transporte de pessoas, ferry-boats', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89012000', 'description' => 'Navios-tanque', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89013000', 'description' => 'Barcos frigorificos,exc.os navios-tanque', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89019000', 'description' => 'Outs.embarcacoes p/transp.mercadorias ou pessoas/mercad', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89020010', 'description' => 'Barcos de pesca,navios-fabricas,etc. comprimento>=35m', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89020090', 'description' => 'Outros barcos de pesca,navios-fabricas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89031000', 'description' => 'Barcos inflaveis', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89039100', 'description' => 'Barcos a vela,mesmo c/motor auxiliar', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89039200', 'description' => 'Barcos a motor,exc.com motor fora-de-borda', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89039900', 'description' => 'Outs.barcos/embarcacoes de recreio/esporte, incl.canoas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89040000', 'description' => 'Rebocadores e barcos p/empurrar outs. embarcacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89051000', 'description' => 'Dragas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89052000', 'description' => 'Plataformas de perfuracao/exploracao, flutuantes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89059000', 'description' => 'Barcos-farois/quindastes/docas/diques flutuantes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89059000', 'description' => 'Docas flutuantes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89061000', 'description' => 'Navios de guerra', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89069000', 'description' => 'Outros embarcacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89071000', 'description' => 'Balsas inflaveis', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89079000', 'description' => 'Outros estruturas flutuantes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89080000', 'description' => 'Embarcacoes e outs.estruturas flutuantes p/demolicao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '89080000', 'description' => 'Estruturas flutuantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90011011', 'description' => 'Fibras opticas,diametro de nucleo<11microns', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90011019', 'description' => 'Outros fibras opticas', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90011020', 'description' => 'Feixes e cabos de fibras opticas', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90012000', 'description' => 'Materias polarizantes,em folhas e placas', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90013000', 'description' => 'Lentes de contato', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90014000', 'description' => 'Lentes de vidro,p/oculos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90015000', 'description' => 'Lentes de outs.materias,p/oculos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90019010', 'description' => 'Outros lentes n/montadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90019090', 'description' => 'Prismas,espelhos e outs.elementos de optica, n/montados', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90021110', 'description' => 'Lentes objetiv.montadas,p/cameras fotograf. projetor,etc', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90021110', 'description' => 'Para câmeras cinematográficas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90021120', 'description' => 'Lentes objetiv.montadas,aproxim>=20,p/cameras televisao', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '90021190', 'description' => 'Outs.lentes objetiv.montadas,p/cameras, apars.fotograf.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90021900', 'description' => 'Outros lentes objetiv.montadas', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90022010', 'description' => 'Filtros polarizantes,montados', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90022090', 'description' => 'Outros filtros opticos,montados', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90029000', 'description' => 'Outs.lentes,prismas e elementos de optica, montados', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90031100', 'description' => 'Armacoes de plasticos,para oculos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90031910', 'description' => 'Armacoes de metais comuns,p/oculos,mesmo folheado,etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90031990', 'description' => 'Armacoes de outs.materias,para oculos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90039010', 'description' => 'Charneiras p/armacoes de oculos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90039090', 'description' => 'Outs.partes p/armacoes de oculos e artigos semelhs.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90041000', 'description' => 'Oculos de sol', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90049010', 'description' => 'Oculos p/correcao', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90049020', 'description' => 'Oculos de seguranca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90049090', 'description' => 'Outs.oculos p/protecao ou outs.fins e artigos semelhs.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90051000', 'description' => 'Binoculos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90058000', 'description' => 'Lunetas e outs.instrum.de astronomia e suas armacoes', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90059010', 'description' => 'Partes e acess.de binoculos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90059090', 'description' => 'Partes e acess.de lunetas e outs.instrum.de astronomia', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90063000', 'description' => 'Câmeras fotográficas especialmente concebidas para fotografia submarina ou aérea, para exame médico de órgãos internos, para laboratórios de medicina legal ou para investigação judicial', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90064000', 'description' => 'Câmaras fotograf.p/filmes de revelacao/ copiagem instantan', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90065100', 'description' => 'Câmaras .fotograf.c/visor reflex.p/pelic.em rolos,l<=35mm', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90065200', 'description' => 'Outros câmaras fotograf.p/peliculas,em rolos,l<35mm', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90065310', 'description' => 'Câmaras .fotograf.de foco fixo,p/peliculas,em rolos,l=35mm', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90065320', 'description' => 'Câmaras .fotograf.de foco ajustav.p/pelic.em rolos,l=35mm', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90065930', 'description' => 'Fotocompositoras a laser para preparacao de cliches', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90065940', 'description' => 'Outras, de foco fixo', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90065951', 'description' => 'Para obtencao de negativos de 45 mm x 60 mm ou de dimensoes superiores', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90065959', 'description' => 'Outras', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90065959', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90066100', 'description' => 'Apars.de tubo de descarga,p/producao de luz-relampago', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90066900', 'description' => 'Outros apars.e dispositivos p/fotografia', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90066900', 'description' => 'Lâmpadas de luz relâmpago  “flash” ', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90069110', 'description' => 'Corpos p/ camaras fotograficas', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90069190', 'description' => 'Outros partes e acess.p/camaras fotograficas', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90069900', 'description' => 'Outs.partes e acess.p/apars.e dispositivos p/fotografia', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90071000', 'description' => 'Cameras cinematograficas', 'aliquota_federal' => 10.78, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90071000', 'description' => 'Para filmes de 16 mm de largura ou de largura não inferior a 35 mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90072020', 'description' => 'Projetores para filmes, largura>=35mm, mas <=70mm', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90072090', 'description' => 'Outros projetores cinematograficos', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90079100', 'description' => 'Partes e acess.p/cameras cinematograficas', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90079200', 'description' => 'Partes e acess.p/projetores cinematograficos', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90085000', 'description' => 'Projetores e aparelhos fotográficos de ampliacao ou de reducao', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90089000', 'description' => 'Partes e acess.p/apars.de projecao fixa,etc.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90101010', 'description' => 'Cubas e cubetas automat.progr.eletron.p/ revel. peliculas', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90101020', 'description' => 'Ampliadoras-copiadoras automat.p/papel fotograf>1000c/h', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90101090', 'description' => 'Outs.apars.e mater.p/revel.automat.pelic. fotograf.etc.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90105010', 'description' => 'Processadores fotográficos para o tratamento eletrônico de imagens, mesmo com saída digital', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90105020', 'description' => 'Aparelhos para revelação automática de chapas de fotopolímeros com suporte metálico', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90105090', 'description' => 'Outs.apars.e mater.p/laborat.fotograf. cinematograf.etc.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90105090', 'description' => 'Moviolas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90106000', 'description' => 'Telas p/projecao fotografica/cinematografica', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90109010', 'description' => 'Partes e acess.p/apars.revel.automat. pelic. fotograf.etc', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90109090', 'description' => 'Partes e acess.p/outs.apars.util.laborat. fotograf.etc.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '90111000', 'description' => 'Microscopios opticos estereoscopicos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90112010', 'description' => 'Microscopios p/fotomicrografia', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90112020', 'description' => 'Microscopios p/cinefotomicrografia', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90112030', 'description' => 'Microscopios p/microprojecao', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90118010', 'description' => 'Microscopios opticos binoculares de platina movel', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90118090', 'description' => 'Outros microscopios opticos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90119010', 'description' => 'Partes e acess.p/microscopios p/ fotomicrografia, etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90119090', 'description' => 'Partes e acess.p/microscopios opticos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90121010', 'description' => 'Microscopios eletronicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90121090', 'description' => 'Outros microscopios e difratografos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90129010', 'description' => 'Partes e acess.p/microscopios eletronicos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90129090', 'description' => 'Partes e acess.p/outs.microscopios e difratografos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90131010', 'description' => 'Miras telescopicas p/armas', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90131090', 'description' => 'Periscopios,lunetas p/maqs.apars.e instrumentos opticos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90132000', 'description' => 'Lasers exc.os diodos laser', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90138010', 'description' => 'Dispositivos de cristais liquidos (lcd)', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90138090', 'description' => 'Outros dispositivos,apars.e instrumentos opticos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90138090', 'description' => 'Conta-fios', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90139000', 'description' => 'Partes e acess.de miras telescopicas, periscopios,etc.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90141000', 'description' => 'Bussolas incl.as agulhas de marear', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90142010', 'description' => 'Altimetros para navegacao aerea ou espacial', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90142020', 'description' => 'Pilotos automaticos p/navegacao aerea/ espacial', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90142030', 'description' => 'Inclinometros p/navegacao aerea/espacial', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90142090', 'description' => 'Outs.instrumentos e apars.p/navegacao aerea/espacial', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90148010', 'description' => 'Sondas acusticas ou de ultra-sons p/navegacao', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90148090', 'description' => 'Outros apars.e instrumentos p/navegacao', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90149000', 'description' => 'Partes e acess.p/instrumentos e apars.p/ navegacao', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90151000', 'description' => 'Telemetros', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90152010', 'description' => 'Teodolitos e taqueometros,leit.por prisma,etc. prec=1seg', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90152090', 'description' => 'Outros teodolitos e taqueometros', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90153000', 'description' => 'Niveis', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90154000', 'description' => 'Instrumentos e apars.de fotogrametria', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90158010', 'description' => 'Molinetes hidrometricos', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90158090', 'description' => 'Outs.instrumentos e apars.de geodesia, topografia,etc.', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90159010', 'description' => 'Partes e acess.de instrumentos e apars.de fotogrametria', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90159090', 'description' => 'Partes e acess.de instrumentos e apars.de geodesia,etc.', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90160010', 'description' => 'Balancas sensiveis a pesos<=0.2mg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90160090', 'description' => 'Balancas sensiveis a 0.2mg<pesos<=50mg, com/ sem pesos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90171010', 'description' => 'Mesas e maqs.de desenhar,automaticas', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90171090', 'description' => 'Outros mesas e maqs.de desenhar', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90172000', 'description' => 'Outs.instrumentos de desenho,de tracado ou de calculo', 'aliquota_federal' => 9.03, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90173010', 'description' => 'Micrometros (instrum.de medida manual de distancias)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90173020', 'description' => 'Paquimetros (instrum.de medida manual de distancias)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90173090', 'description' => 'Calibres e semelhs.(instrum.medida manual de distancias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90178010', 'description' => 'Metros (instrum.de medida manual de distancias)', 'aliquota_federal' => 9.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90178090', 'description' => 'Outros instrumentos de medida manual de distancias', 'aliquota_federal' => 9.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90179010', 'description' => 'Partes e acess.de mesas e maqs.de desenhar, automaticas', 'aliquota_federal' => 9.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90179090', 'description' => 'Partes e acess.de outs.instrum.de desenho, medida,etc.', 'aliquota_federal' => 9.03, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181100', 'description' => 'Eletrocardiografos', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181210', 'description' => 'Ecografos c/analise espectral doppler', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181290', 'description' => 'Outs.apars.de eletrodiagnost.por varredura ultra-sonica', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181300', 'description' => 'Apars.de diagnostico por visualiz.de ressonancia magnet', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181410', 'description' => 'Scanner de tomografia por emissao de positrons', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '90181420', 'description' => 'Camaras gama', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181490', 'description' => 'Outs.aparelhos de cintilografia', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181910', 'description' => 'Endoscopios', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181920', 'description' => 'Audiometros', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181980', 'description' => 'Outros apars.de eletrodiagnostico', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90181990', 'description' => 'Partes de apars.de eletrodiagnostico', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90182010', 'description' => 'Apars.de raios ultravioleta ou infravermelhos, p/ cirurgias, que operam por laser', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90182020', 'description' => 'Apars.operando por laser p/tratamento bucal', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90182090', 'description' => 'Outros (apars.de raios ultravioleta ou infravermelhos)', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183111', 'description' => 'Seringas de plastico,mesmo c/agulhas, capacidade <=2cm3', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183119', 'description' => 'Outros seringas de plastico,mesmo c/agulhas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183190', 'description' => 'Seringas de outs.materias,mesmo c/agulhas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183211', 'description' => 'Agulhas tubulares de metal,gengivais', 'aliquota_federal' => 6.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183212', 'description' => 'Agulhas tubulares de aco cromo-niquel/bisel trifacetado (...), utilizadas com bolsas de sangue', 'aliquota_federal' => 6.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183213', 'description' => 'Agulhas ponta de lápis, do tipo das utilizadas em anestesia epidural ou raquidiana', 'aliquota_federal' => 6.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183219', 'description' => 'Outros agulhas tubulares de metal', 'aliquota_federal' => 6.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183220', 'description' => 'Agulhas para suturas', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183910', 'description' => 'Outros agulhas', 'aliquota_federal' => 6.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183921', 'description' => 'Sondas,cateteres e canulas,de borracha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183922', 'description' => 'Cateter de policloreto vinila,p/embolectomia arterial', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183923', 'description' => 'Cateter de policloreto vinila,p/termodiluicao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183924', 'description' => 'Cateteres intravenosos periféricos, de poliuretano ou copolímero de etilwno-tetrafluoretileno (etfe)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183929', 'description' => 'Outros sondas,cateteres e canulas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183930', 'description' => 'Lancetas p/acinacao e cauterios', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183991', 'description' => 'Artigo para fístula arteriovenosa, composto de agulha, base de fixação tipo borboleta, tubo plástico com conector e obturador', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183999', 'description' => 'Outs.instrumentos semelh.seringas,agulhas, cateteres,etc', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90183999', 'description' => 'Para transfusão de sangue ou infusão intravenosa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90184100', 'description' => 'Apars.dentarios de brocar mesmo c/outs. equip.dentarios', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90184911', 'description' => 'Brocas p/odontologia,de carboneto de tungstenio', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90184912', 'description' => 'Brocas p/odontologia,de aco-vanadio', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90184919', 'description' => 'Brocas p/odontologia,de outs.materias', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90184920', 'description' => 'Limas p/odontologia', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90184940', 'description' => 'Apars.operando por proj.cinet.de partic.p/tratam.bucal', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90184991', 'description' => 'Apars.p/desenho/constr.peca ceram.dentaria, computadoriz', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90184999', 'description' => 'Outros instrumentos e apars.p/odontologia', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90184999', 'description' => 'Cadeiras de dentista equipadas com aparelhos de odontologia', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90185010', 'description' => 'Microscopios binoculares,util.cirurgia oftalmologica', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90185090', 'description' => 'Outs.instrumentos e aparelhos de oftalmologia', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189010', 'description' => 'Instrumentos e apars.p/transfusao de sangue,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189021', 'description' => 'Bisturis eletricos', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189029', 'description' => 'Outros bisturis', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189031', 'description' => 'Litotritores por onda de choque', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189039', 'description' => 'Litotomos e outs.litotritores', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189040', 'description' => 'Rins artificiais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189050', 'description' => 'Apars.de diatermia', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189091', 'description' => 'Incubadora p/bebes', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189092', 'description' => 'Apars.p/medida da pressao arterial', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189093', 'description' => 'Apars.p/terapia intra-uretral p/microondas, computadoriz', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189094', 'description' => 'Endocoscopios', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189095', 'description' => 'Grampos,clipes,aplicador,extrator p/apars.medicina,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189096', 'description' => 'Desfibriladores externos que operem unicamente em modo automático (“aed – automatic external defibrillator”)', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189099', 'description' => 'Outs.instrumentos e apars.p/medicina,cirurgia,etc.', 'aliquota_federal' => 6.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189099', 'description' => 'Conjunto descartável de circulação assistida e conjunto descartável de balão intra-aórtico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '90189099', 'description' => 'Máquinas cicladoras para diálise peritoneal e seus acessórios', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90189099', 'description' => 'Equipamento de drenagem, cápsula protetora do adaptador de titânio, equipamentos de transferência ou similar e equipamento cassete cicladora, para diálise peritoneal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90191000', 'description' => 'Apars.de mecanoterapia,de massagem ou de psicotecnica', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90192010', 'description' => 'Apars.de oxigenoterapia', 'aliquota_federal' => 4.76, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90192020', 'description' => 'Apars.de aerossolterapia', 'aliquota_federal' => 4.76, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90192030', 'description' => 'Respiratorios de reanimacao', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90192040', 'description' => 'Respiradores automaticos (pulmoes de aco)', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90192090', 'description' => 'Apars.de ozonoterapia e outs.de terapia respiratoria', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90200010', 'description' => 'Mascaras contra gases', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90200090', 'description' => 'Outros apars.respiratorios', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90211010', 'description' => 'Artigos e apars.ortopedicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90211020', 'description' => 'Artigos e apars.para fraturas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90211091', 'description' => 'Partes e acess.de artigos e apars.ortopedia,articulares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90211099', 'description' => 'Outs.partes e acess.de proteses articul/apars.ortoped.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90212110', 'description' => 'Dentes artificiais de acrilico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90212190', 'description' => 'Outros dentes artificiais exc.de acrilico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90212900', 'description' => 'Outros artigos e apars.de protese dentaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213110', 'description' => 'Proteses articulares,femurais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213120', 'description' => 'Proteses articulares,mioletricas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213190', 'description' => 'Outros proteses articulares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213911', 'description' => 'Valvulas cardiacas mecanicas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213919', 'description' => 'Outros valvulas cardiacas,exc.mecanicas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213920', 'description' => 'Lentes intraoculares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213930', 'description' => 'Proteses de arterias vasculares revestidas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213940', 'description' => 'Proteses mamarias nao implantaveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213980', 'description' => 'Outros artigos e apars.de protese', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213991', 'description' => 'Partes de proteses modulares subst.membros super.infer.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90213999', 'description' => 'Partes e acess.de outs.artigos e apars.de protese', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90214000', 'description' => 'Apars.p/facilitar a audicao de surdos,exc.partes/acess.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90215000', 'description' => 'Marca-passos cardiacos,exc.partes e acess.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90219011', 'description' => 'Cardiodesfibrilador automatico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90219019', 'description' => 'Outs.apars.implant.organ.p/compensar defeito/incapacid.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90219091', 'description' => 'Partes e acess.de marca-passos cardiacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90219092', 'description' => 'Partes e acess.de apars.p/facilitar audicao dos surdos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90219099', 'description' => 'Partes e acess.de artigos/apars.p/compensar deficiencia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221200', 'description' => 'Apars.de tomografia computadorizada', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221311', 'description' => 'Apars.de raios x,de diagnost.de tomada maxilar panoram.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221319', 'description' => 'Outros apars.de raios x,p/diagnost.de odontologia', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221390', 'description' => 'Outros apars.de raios x,p/odontologia', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221411', 'description' => 'Apars.de raios x,de diagnost.p/mamografia', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221412', 'description' => 'Apars.de raios x,de diagnost.p/angiografia', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221413', 'description' => 'Apars.computadoriz.de diagnostico, p/densitometria ossea', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221419', 'description' => 'Outs.apars.de raios x,p/diagnost.medico, cirurgico,etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221490', 'description' => 'Outs.apars.de raios x,p/uso medico,cirurgico, veterinar.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221910', 'description' => 'Espectrometros ou espectrografos,de raios x', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221991', 'description' => 'Outs.apars.de raios x,radiofotografia ou radioterapia dos tipos utilizados para inspeção de bagagens, com túnel de altura inferior ou igual a 0,4m, largura inferior ou igual a 0,6m e comprimento inferior ou igual a 1,2m', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90221999', 'description' => 'Outs.apars.de raios x,radiofotografia ou radioterapia', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90222110', 'description' => 'Apars.de radiocobalto (bomba de cobalto),uso medico,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90222120', 'description' => 'Apars.de gamaterapia p/uso medico, cirurgico,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90222190', 'description' => 'Outs.apars.de radiacao alfa,beta,gama,p/ uso medico,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90222910', 'description' => 'Apars.raios gama,p/detec.nivel enchim/tampa lata bebida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90222990', 'description' => 'Outros aparelhos de radiacao alfa,beta ou gama', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90223000', 'description' => 'Tubos de raios x', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '90229011', 'description' => 'Geradores de tensao,p/apars.de raios x/ outs. radiacoes', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90229012', 'description' => 'Telas radiologicas p/apars.de raios x/outs. radiacoes', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90229019', 'description' => 'Outros apars.geradores de raios x', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90229080', 'description' => 'Outros dispositivos geradores de raios x', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90229090', 'description' => 'Partes e acess.p/apars.de raios x/outs. radiacoes, etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90230000', 'description' => 'Instrumentos,apars.e modelos p/demonstracao ensino,etc.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90230000', 'description' => 'Lâmina preparada  preparação microscópica ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90230000', 'description' => 'Modelos de anatomia para ensino', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90241010', 'description' => 'Maqs.e apars.p/ensaios de tracao/compressao de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90241020', 'description' => 'Maqs.e apars.p/ensaios de dureza de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90241090', 'description' => 'Maqs.e apars.p/outs.ensaios de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90248011', 'description' => 'Maqs.e apars.p/ensaios de texteis,automaticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90248019', 'description' => 'Outros maqs.e apars.p/ensaios de texteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90248021', 'description' => 'Máquinas para ensaio de pneumáticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90248029', 'description' => 'Maqs.e apars.p/ensaios de papeis,cartao, linoleo,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90248090', 'description' => 'Outs.maqs.e apars.p/ensaios de dureza,etc.de materiais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90249000', 'description' => 'Partes e acess.de maqs.e apars.p/ensaios de dureza,etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90251110', 'description' => 'Termometros clinicos,de liquido,de leitura direta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90251190', 'description' => 'Outros termometros, de liquido,de leitura direta', 'aliquota_federal' => 7.46, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90251910', 'description' => 'Pirometros opticos', 'aliquota_federal' => 8.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90251990', 'description' => 'Outros termometros e pirometros', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90258000', 'description' => 'Densimetros,areometros,higrometros e outs. instrumentos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90259010', 'description' => 'Partes e acess.de termometros', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90259090', 'description' => 'Partes e acess.de densimetros e outs. instrumentos', 'aliquota_federal' => 7.46, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90261011', 'description' => 'Medidor-transmissor eletron.induc. eletromagnet. de vazao', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90261019', 'description' => 'Outs.instrumentos e apars.p/medida/controle de vazao', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90261021', 'description' => 'Instrumentos e apars.p/medida/controle do nivel, de metais, mediante corentes parasitas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90261029', 'description' => 'Outros (instrumentos e apars.p/medida/controle do nivel)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90262010', 'description' => 'Manometros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90262090', 'description' => 'Outs.instrumentos e apars.p/medida/controle da pressao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90268000', 'description' => 'Outs.instrumentos e apars.p/medida/controle de liq.etc.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90269010', 'description' => 'Partes e acess.p/instrum.e apars.medida/ controle nivel', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90269020', 'description' => 'Partes e acess.p/manometros', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90269090', 'description' => 'Partes e acess.p/outs.instrum.e apars.de medida/control', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90271000', 'description' => 'Analisadores de gases ou de fumaca (fumo)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90272011', 'description' => 'Cromatografos de fase gasosa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90272012', 'description' => 'Cromatografos de fase liquida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90272019', 'description' => 'Outros cromatografos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90272021', 'description' => 'Sequenciadores automaticos de adn mediante eletroforese capilar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90272029', 'description' => 'Outs apars.de eletroforese', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90273011', 'description' => 'Espectrometros e espectrografos de emissao optica (emissao atomica),', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90273019', 'description' => 'Outros espectrometros, outros espectrografos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90273020', 'description' => 'Espectrofotometros de radiacoes uv,visiveis e iv', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90275010', 'description' => 'Colorimetros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90275020', 'description' => 'Fotometros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90275030', 'description' => 'Refratometros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90275040', 'description' => 'Sacarimetros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90275050', 'description' => 'Citometro de fluxo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90275090', 'description' => 'Outs.instrumentos e apars.que utiliz.radiacoes opticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90278011', 'description' => 'Calorimetros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90278012', 'description' => 'Viscosimetros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90278013', 'description' => 'Densitometros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90278014', 'description' => 'Apars.medidores de ph', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '90278020', 'description' => 'Espectrometros de massa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90278030', 'description' => 'Polarografos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90278091', 'description' => 'Exposímetros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90278099', 'description' => 'Outs.instrumentos e apars.p/analise/ensaio/ medida, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90279010', 'description' => 'Microtomos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90279091', 'description' => 'Partes e acess.p/espectrometros e de espectrografos de emissao optica', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90279093', 'description' => 'Partes e acess.p/polarografos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90279099', 'description' => 'Partes e acess.p/outs.instrum.e apars.p/analise,etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90281011', 'description' => 'Contadores de gas natural comprimido,eletronicos, dos tipos utilizados em postos (estações) de serviço ou garagens', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90281019', 'description' => 'Outros (contadores de gas natural comprimido,eletronicos)', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90281090', 'description' => 'Outros contadores de gases', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90282010', 'description' => 'Contadores de liquidos,peso<=50kg', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90282020', 'description' => 'Contadores de liquidos,peso>50kg', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90283011', 'description' => 'Contadores monofasicos,p/corr.eletr.alternada,digitais', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90283019', 'description' => 'Outs.contadores monofasicos,p/corr.eletr.alternada', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90283021', 'description' => 'Contadores bifasicos de eletricidade,digitais', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90283029', 'description' => 'Outros contadores bifasicos de eletricidade', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90283031', 'description' => 'Contadores trifasicos de eletricidade,digitais', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90283039', 'description' => 'Outros contadores trifasicos de eletricidade', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90283090', 'description' => 'Outros contadores de eletricidade', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90289010', 'description' => 'Partes e acess.p/contadores de eletricidade', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90289090', 'description' => 'Partes e acess.p/contadores de gases/liquidos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90291010', 'description' => 'Contadores de voltas ou de producao/horas de trabalho', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90291090', 'description' => 'Taximetros,totalizadores de caminho percorrido,etc.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90292010', 'description' => 'Indicadores de velocidade e tacometros', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90292010', 'description' => 'Para veículos com sistema elétrico em 24V', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90292020', 'description' => 'Estroboscopios', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90299010', 'description' => 'Partes e acess.p/indicadores de velocidade/tacometros', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90299090', 'description' => 'Partes e acess.p/outs.contadores/estroboscopios', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90301010', 'description' => 'Medidores de radioatividade', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90301090', 'description' => 'Outs.instrumentos e apars.p/medida radiacoes ionizantes', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90302010', 'description' => 'Osciloscopios digitais', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90302021', 'description' => 'Osciloscopios catodicos analogicos, frequencia>=60mhz', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90302022', 'description' => 'Vetorscopio (osciloscopios catodicos analogicos)', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90302029', 'description' => 'Outros osciloscopios catodicos analogicos', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90302030', 'description' => 'Oscilografos', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90303100', 'description' => 'Multimetros sem dispositivo registrador', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90303200', 'description' => 'Multimetros com dispositivo registrador', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90303311', 'description' => 'Voltimetros digitais,sem dispositivo registrador', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90303319', 'description' => 'Outros voltimetros sem dispositivo registrador', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90303321', 'description' => 'Amperimetros sem disposit.registrador, p/veic.automoveis', 'aliquota_federal' => 14.78, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90303329', 'description' => 'Outros amperimetros s/dispositivo registrador', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90303390', 'description' => 'Outs.apars.e instrum.p/medida/controle tensao, intensidade, resistência ou da potência', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90303910', 'description' => 'Apars.de teste de contin.de circuit.impresso, c/disp.reg', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90303990', 'description' => 'Outs.instrum.e apars.p/medida/controle eletr.c/disp.reg', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90304010', 'description' => 'Analisadores de protocolo,para telecomunicacao', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90304020', 'description' => 'Analisadores de nivel seletivo,para telecomunicacao', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90304030', 'description' => 'Analisadores digitais de transmissao,p/telecomunicacao', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90304090', 'description' => 'Outros instrumentos e apars.p/telecomunicacao', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90308210', 'description' => 'Instrumentos e apars.p/testes de circuitos integrados', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90308290', 'description' => 'Outs.instrumentos e apars.p/medida/controle discos,etc.', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90308410', 'description' => 'Apars.de teste automat.circuit.impresso,mont. c/disp.reg', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90308420', 'description' => 'Apars.de medidas de parâmetros característicos de sinais de televisão ou de vídeo', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '90308490', 'description' => 'Outs.instrum.e apars.p/medida/controle eletr.c/disp.reg', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90308910', 'description' => 'Analisadores logicos de circuitos digitais', 'aliquota_federal' => 5.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90308920', 'description' => 'Analisadores de espectro de frequencia', 'aliquota_federal' => 5.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90308930', 'description' => 'Frequencimetros', 'aliquota_federal' => 5.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90308940', 'description' => 'Fasimetros', 'aliquota_federal' => 5.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90308990', 'description' => 'Outs.instrum.e apars.p/medida/controle eletr.etc.', 'aliquota_federal' => 5.63, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90309010', 'description' => 'Partes e acess.p/apars.de medida,etc.radiacao ionizante', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90309090', 'description' => 'Partes e acess.p/apars.de medida,etc.eletr. s/disp.reg.', 'aliquota_federal' => 5.53, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90311000', 'description' => 'Maqs.de equilibrar pecas mecanicas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90312010', 'description' => 'Bancos de ensaio p/motores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90312090', 'description' => 'Outros bancos de ensaio,exc.p/motores', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90314100', 'description' => 'Instrumentos e apars.opticos,p/controle de discos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90314910', 'description' => 'Instrums.e apars.raios laser,p/medir dim.fibra celulose', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90314920', 'description' => 'Instrums.e apars.raios laser,p/medir esp.pneumaticos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90314990', 'description' => 'Outros instrumentos e aparelhos opticos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90314990', 'description' => 'Projetores de perfis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90318011', 'description' => 'Dinamometros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90318012', 'description' => 'Rugosimetros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90318020', 'description' => 'Maqs.p/medicao tridimensional', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90318030', 'description' => 'Metros padroes', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90318040', 'description' => 'Apars.digitais util.em automoveis (computador de bordo)', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90318050', 'description' => 'Apars.p/analise de texteis,computadorizados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90318060', 'description' => 'Celulas de carga', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90318091', 'description' => 'Outs.instrumentos,apars.e maqs para controle dimensional de pneumáticos, em condições de carga', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90318099', 'description' => 'Outs.instrumentos,apars.e maqs.de medida/ controle', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90319010', 'description' => 'Partes e acess.p/bancos de ensaio', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90319090', 'description' => 'Partes e acess.p/outs.instrum.e apars.medida/ controle', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90321010', 'description' => 'Termostatos automaticos,de expansao de fluidos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90321090', 'description' => 'Outros termostatos automaticos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90322000', 'description' => 'Manostatos automaticos (pressostatos)', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328100', 'description' => 'Instrumentos e apars.hidraulicos/ pneumaticos, automat.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328911', 'description' => 'Reguladores eletronicos,de voltagem, automaticos', 'aliquota_federal' => 13.72, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328919', 'description' => 'Outros reguladores de voltagem,automaticos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328921', 'description' => 'Controladores eletron.p/sist.antibloq.de freio,automat.', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328922', 'description' => 'Controladores eletron.p/sist.de suspensao, automaticos', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328923', 'description' => 'Controladores eletron.p/sist.de transmissao, automaticos', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328924', 'description' => 'Controladores eletron.p/sist.de ignicao, automaticos', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328925', 'description' => 'Controladores eletron.p/sist.de injecao, automaticos', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328929', 'description' => 'Outs.controladores eletron.automat.p/veic. automoveis', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328930', 'description' => 'Equipamento digital automat.p/controle de veic.ferrov.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328981', 'description' => 'Instrumentos e apars.automat.p/controle de pressao', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328982', 'description' => 'Instrumentos e apars.automat.p/controle de temperatura', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328983', 'description' => 'Instrumentos e apars.automat.p/controle de umidade', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328984', 'description' => 'Instrumentos e apars.automat.p/controle velocid.motores', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328989', 'description' => 'Outs.instrum.e apars.automat.p/controle grandez.n/eletr', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90328990', 'description' => 'Outs.instrums.e apars.automat.p/regulacao/ controle', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90329010', 'description' => 'Circuito impresso montado,p/apars.automat. regulacao,etc', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90329091', 'description' => 'Partes e acess.p/termostatos automaticos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90329099', 'description' => 'Partes e acess.p/outs.apars.automat.p/ regulacao,etc.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '90330000', 'description' => 'Partes e acess.p/outs.maqs.apars.instrum.de optica,etc.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91011100', 'description' => 'Relogio de pulso,cx.met.prec.func.eletr. mostr.mecan.', 'aliquota_federal' => 9.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91011900', 'description' => 'Outs.relogios de pulso,cx.de metal prec.etc. func. eletr.', 'aliquota_federal' => 9.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91012100', 'description' => 'Relogio de pulso,cx.met.prec.etc.corda automat.', 'aliquota_federal' => 9.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '91012900', 'description' => 'Outros relogios de pulso,cx.metal prec.etc.', 'aliquota_federal' => 9.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91019100', 'description' => 'Relogio de bolso,semelh.cx.met.prec.etc. func.eletr.', 'aliquota_federal' => 9.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91019900', 'description' => 'Outros relogios de bolso,semelh.cx.metal prec.etc.', 'aliquota_federal' => 9.90, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91021110', 'description' => 'Relogio de pulso,cx.met.comum,func.eletr. mostr.mecan.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91021190', 'description' => 'Outros relogios de pulso,func.eletr.mostr. mecan.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91021210', 'description' => 'Relogio de pulso,cx.met.comum,func.eletr. mostr. optoelet', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91021220', 'description' => 'Relogio de pulso,cx.plastico,func.eletr. mostr.optoeletr', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91021290', 'description' => 'Outs.relogios de pulso,func.eletr.mostr. optoeletr.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91021900', 'description' => 'Outros relogios de pulso,func.eletr.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91022100', 'description' => 'Relogio de pulso,de corda automat.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91022900', 'description' => 'Outros relogio de pulso', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91029100', 'description' => 'Relogio de bolso,semelh.func.eletr.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91029100', 'description' => 'Com caixa de metal comum, mesmo dourado, prateado ou platinado', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91029100', 'description' => 'Com caixa de plásticos sem carga ou reforço de fibras de vidro', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91029900', 'description' => 'Outros relogios de bolso,semelh.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91031000', 'description' => 'Despertadores e outs.relogios,maquin.peq.vol. func.eletr', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91039000', 'description' => 'Outros despertadores/outs.relogios,maquin. peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91040000', 'description' => 'Relogios p/paineis de instrum.p/automoveis e outs.veics', 'aliquota_federal' => 17.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91051100', 'description' => 'Outs.despertadores func.eletr.exc.maquin. peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91051900', 'description' => 'Outros despertadores exc.maquin.peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91052100', 'description' => 'Pendulas/relogios parede,func.eletr.exc.maquin. peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91052900', 'description' => 'Outs.pendulas e relogios de parede,exc.maquin. peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91059100', 'description' => 'Outs.apars.de relojoaria,func.eletr.exc.maquin. peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91059900', 'description' => 'Outros apars.de relojoaria,exc.maquin.peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91061000', 'description' => 'Relogios de ponto,relog.datadores e contadores de horas', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91069000', 'description' => 'Outros apars.de controle/contadores de tempo,etc.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91070010', 'description' => 'Interruptores horarios', 'aliquota_federal' => 10.59, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91070090', 'description' => 'Outs.apars.p/acionar mecanismo em tempo determinado,etc', 'aliquota_federal' => 10.59, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91081110', 'description' => 'Maquinismo montado p/relog.pulso,func.eletr. mostr.mecan', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91081190', 'description' => 'Maquinismo montado p/outs.relog.peq.vol.f. eletr. m.mecan', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91081200', 'description' => 'Maquinismo montado p/relog.pulso,func.eletr. mostr.optoe', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91081900', 'description' => 'Maquinismo montado p/outs.relog.peq.vol.f. eletr. m.optoe', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91082000', 'description' => 'Maquinismo montado p/relogio peq.vol.de corda automat.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91089000', 'description' => 'Outs.maquinismos montados peq.vol.compl.p/ outs.relogios', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91091000', 'description' => 'Maquinismo montado exc.peq.vol.p/relog. func.eletr.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91099000', 'description' => 'Maquinismo montado exc.peq.vol.p/outs.apars. relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91101110', 'description' => 'Maquinismo n/montado compl.p/relogio de pulso,bolso,etc', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91101190', 'description' => 'Maquinismo n/montado compl.p/outs.relogios de peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91101200', 'description' => 'Maquinismo montado incompl.p/apars.relojoaria peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91101900', 'description' => 'Esbocos de maquinismos p/apars.relojoaria de peq.vol.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91109000', 'description' => 'Maquinismo n/montado compl.p/apars.relojoar. exc.peq.vol', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91111000', 'description' => 'Caixas p/relogio de pulso/bolso,de metal precioso,etc.', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91112010', 'description' => 'Caixas p/relogio de pulso/bolso,de latao,em esboco', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91112090', 'description' => 'Caixas p/relogio de pulso/bolso,de outs.metais comuns', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91118000', 'description' => 'Caixas p/relogio de pulso/bolso,de outs. materias', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91119010', 'description' => 'Fundos p/caixa de relogio de pulso/bolso,de metal comum', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91119090', 'description' => 'Outros partes p/caixa de relogio de pulso/ bolso', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91122000', 'description' => 'Caixas e semelh.p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91129000', 'description' => 'Partes p/caixas e semelh.p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91131000', 'description' => 'Pulseiras p/relogios,de metal precioso, folheado,etc.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91132000', 'description' => 'Pulseiras p/relogios,de metal comum', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91139000', 'description' => 'Pulseiras p/relogios,de outs.mater.e partes p/pulseiras', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91141000', 'description' => 'Molas p/apars.de relojoaria,incl.as espirais', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '91143000', 'description' => 'Quadrantes p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91144000', 'description' => 'Platinas e pontes p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91149010', 'description' => 'Coroas p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91149020', 'description' => 'Ponteiros p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91149030', 'description' => 'Hastes p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91149040', 'description' => 'Basculas p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91149050', 'description' => 'Eixos e pinhoes p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91149060', 'description' => 'Rodas p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91149070', 'description' => 'Rotores p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '91149090', 'description' => 'Outros partes e acess.p/apars.de relojoaria', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92011000', 'description' => 'Pianos verticais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92012000', 'description' => 'Pianos de cauda', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92019000', 'description' => 'Outs.pianos,cravos e outs.instrum.de cordas, c/teclado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92021000', 'description' => 'Instrumentos musicais de cordas,tocados c/auxilio arco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92029000', 'description' => 'Outros instrumentos musicais de cordas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92051000', 'description' => 'Instrumentos musicais de sopro denominados metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92059000', 'description' => 'Outros instrumentos musicais de sopro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92060000', 'description' => 'Instrumentos musicais de percussao (tambores,etc.)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92071010', 'description' => 'Sintetizadores (instrumentos musicais de teclado)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92071090', 'description' => 'Outros instrumentos musicais de teclado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92079010', 'description' => 'Guitarra e contrabaixo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92079090', 'description' => 'Outros instrumentos musicais c/som amplif.por meio elet', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92081000', 'description' => 'Caixas de musica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92089000', 'description' => 'Orgaos mecanicos de feira e outs.instrum. musicais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92093000', 'description' => 'Cordas p/instrumentos musicais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92099100', 'description' => 'Partes e acess.p/pianos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92099200', 'description' => 'Partes e acess.p/instrumentos musicais de cordas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92099400', 'description' => 'Partes e acess.p/instrum.musicais som amplif.meio eletr', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '92099900', 'description' => 'Partes e acess.p/outs.instrumentos musicais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93011000', 'description' => 'Peças de artilharia (p.ex. canhões, obuses, morteiros)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93012000', 'description' => 'Lança-foguetes, lança-chamas, laça-granadas, tubos lança-torpedos e lançadores similares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93019000', 'description' => 'Outras armas de guerra,exc.revolveres, pistolas e armas brancas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93020000', 'description' => 'Revolveres e pistolas', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93031000', 'description' => 'Armas de fogo carregaveis exclusivamente pela boca', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93032000', 'description' => 'Espingardas/carabinas p/caca/tiro-ao-alvo,cano liso>=1', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93033000', 'description' => 'Outros espingardas/carabinas p/caca/tiro-ao-alvo', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93039010', 'description' => 'Lançadores do tipo utilizado com cartuchos dos itens 9306.21.10, 9306.21.20 ou 9306.21.30 ', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93039090', 'description' => 'Outros', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93039090', 'description' => 'Ex 01 - Pistolas de sinalização', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93040010', 'description' => 'Recipientes do tipo aerossol que contenham produtos químicos ou oleorresina deCapsicum, com fins irritantes', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93040090', 'description' => 'Outras', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93051000', 'description' => 'Partes e acess.p/revolveres/pistolas', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93052000', 'description' => 'Partes e acess.para espingardas/carabinas de fogo', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93059100', 'description' => 'Partes e acess.p/armas de guerra', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93059900', 'description' => 'Partes e acess.p/outs.armas', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93062110', 'description' => 'Que contenham produtos químicos ou oleorresina de Capsicum, com fins irritantes', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93062120', 'description' => 'Outros, que produzem efeitos fumígenos, de iluminação, de som ou de identificação mediante tintas ou corantes', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93062130', 'description' => 'Outros, com um ou mais projéteis de elastômeros', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93062190', 'description' => 'Outros', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93062900', 'description' => 'Chumbos p/carabinas de ar comprimido,partes p/cartuchos', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93062900', 'description' => 'Partes de cartuchos', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93063000', 'description' => 'Outros cartuchos e suas partes', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93063000', 'description' => 'Cartuchos sem projétil ou carga de chumbo, para uso técnico, e suas partes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '93063000', 'description' => 'Para pistolas de rebitar ou de usos semelhantes ou para pistolas de êmbolo cativo para abate de animais', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '93070000', 'description' => 'Sabres,espadas,baionetas,outs.armas brancas,suas partes e bainhas', 'aliquota_federal' => 35.23, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94011010', 'description' => 'Assentos ejetaveis,para veiculos aereos', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94011090', 'description' => 'Outros assentos p/veiculos aereos,exc. ejetaveis', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94012000', 'description' => 'Assentos para veiculos automoveis', 'aliquota_federal' => 17.17, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94012000', 'description' => 'De ônibus', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94012000', 'description' => 'De caminhões', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94012000', 'description' => 'De tratores agrícolas ou de colheitadeiras', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94012000', 'description' => 'De ferro ou aço, dos tipos usados em colheitadeiras', 'aliquota_federal' => 14.55, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94013010', 'description' => 'Assentos giratorios,de altura ajustav.de madeira', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94013090', 'description' => 'Assentos giratorios,de altura ajustav.de outs.materias', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94014010', 'description' => 'Assentos transformaveis em camas,de madeira', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94014090', 'description' => 'Assentos transformaveis em camas,de outs.materias', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94015200', 'description' => 'De bambu', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94015300', 'description' => 'De rotim', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94015900', 'description' => 'Assentos de cana,vime ou de materias semelhantes', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94016100', 'description' => 'Assentos estofados,com armacao de madeira', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94016900', 'description' => 'Outros assentos c/armacao de madeira', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94017100', 'description' => 'Assentos estofados,com armacao de metal', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94017900', 'description' => 'Outros assentos c/armacao de metal', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94018000', 'description' => 'Outros assentos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94019010', 'description' => 'Partes p/assentos,de madeira', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94019090', 'description' => 'Partes p/assentos,de outs.materias', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94021000', 'description' => 'Cadeiras de dentista/saloes de cabeleireiro,etc. partes', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94029010', 'description' => 'Mesas p/operacao cirurgica', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94029020', 'description' => 'Camas dotadas de mecanismos p/usos clinicos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94029090', 'description' => 'Outs.mobiliarios p/medicina,cirurgia, odontologia, etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94031000', 'description' => 'Moveis de metal p/escritorios', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94032000', 'description' => 'Outros moveis de metal', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94033000', 'description' => 'Moveis de madeira p/escritorios', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94034000', 'description' => 'Moveis de madeira p/cozinhas', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94035000', 'description' => 'Moveis de madeira p/quartos de dormir', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94036000', 'description' => 'Outros moveis de madeira', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94037000', 'description' => 'Moveis de plasticos', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94038200', 'description' => 'De bambu', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94038300', 'description' => 'De rotim', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94038900', 'description' => 'Moveis de outs.materias,incl.vime, etc.', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94039010', 'description' => 'Partes p/moveis,de madeira', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94039090', 'description' => 'Partes p/moveis,de outs.materias', 'aliquota_federal' => 5.56, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94041000', 'description' => 'Suporte elastico p/camas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94042100', 'description' => 'Colchoes de borracha/plasticos alveolares, mesmo rocob.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94042900', 'description' => 'Colchoes de outs.materias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94043000', 'description' => 'Sacos de dormir', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94049000', 'description' => 'Ededroes,almofadas,pufes,travesseiros e artigos semelh.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94051010', 'description' => 'Lampadas escialiticas', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94051091', 'description' => 'Lustres e apars.ilumin.eletr.de pedra,p/teto/ parede', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94051092', 'description' => 'Lustres e apars.ilumin.eletr.de vidro,p/teto/ parede', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94051093', 'description' => 'Lustres e apars.ilumin.eletr.de met.comum,p/ teto/ parede', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94051099', 'description' => 'Lustres e apars.ilumin.eletr.de out.mater.p/ teto/parede', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94052000', 'description' => 'Abajures de cabeceira ou de escritorio,etc. eletricos', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94053000', 'description' => 'Guirlandas eletricas p/arvores de natal', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94054010', 'description' => 'Outros apars.eletr.de iluminacao de metais comuns', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94054090', 'description' => 'Outros apars.eletr.de iluminacao de outs.materias', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '94054090', 'description' => 'Refletores  projetores  de lâmpadas halógenas ou HMI, abertos ou com lentes de Fresnel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94055000', 'description' => 'Apars.nao eletricos de iluminacao', 'aliquota_federal' => 6.34, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94056000', 'description' => 'Anuncios,cartazes e placas indicadoras, luminosos,etc.', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94059100', 'description' => 'Partes p/apars.de iluminacao,de vidro', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94059200', 'description' => 'Partes p/apars.de iluminacao,de plasticos', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94059900', 'description' => 'Partes p/apars.de iluminacao,de outs.materias', 'aliquota_federal' => 10.07, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94061010', 'description' => 'Estufas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 5.60, 'aliquota_municipal' => 0.00],
            ['ncm' => '94061090', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94069010', 'description' => 'Estufas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94069020', 'description' => 'Com estrutura de ferro ou aco e paredes exteriores constituidas principalmente dessas materias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '94069090', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030010', 'description' => 'Triciclos, patinetes, carros de pedais e outros brinquedos semelhantes com rodas, carrinhos para bonecos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030021', 'description' => 'Bonecos de figura humana, mesmo vestidos, c/mecanismo a corda/eletr.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030022', 'description' => 'Outros bonecos ,mesmo vestidos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030029', 'description' => 'Outros partes e acess.p/bonecos de figura humana', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030031', 'description' => 'Brinquedos c/enchimento,de figura animal ou nao-humana', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030039', 'description' => 'Outros brinquedos de figura animal ou nao humana', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030040', 'description' => 'Trens eletr.de brinquedo,incl.trilhos/sinais/ outs.acess', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030050', 'description' => 'Modelos reduzidos,de brinquedo,em conj.p/montagem', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030060', 'description' => 'Outros conjuntos e brinquedos,p/construcao', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030070', 'description' => 'Quebra-cabecas (puzzles)', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030080', 'description' => 'Outros brinquedos em sortidos ou em panoplias', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030091', 'description' => 'Instrumentos e apars.musicais,de brinquedo', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030097', 'description' => 'Outros brinquedos e modelos,motorizados, eletricos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030098', 'description' => 'Outros brinquedos de friccao,de corda ou de mola', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95030099', 'description' => 'Outros brinquedos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95042000', 'description' => 'Bilhares e seus acess.', 'aliquota_federal' => 32.77, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95042000', 'description' => 'Gizes', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95043000', 'description' => 'Outs.jogos acionados por ficha/moeda,exc. jogos balizas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95044000', 'description' => 'Cartas de jogar', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95045000', 'description' => 'Consoles e maq.de jogos de video(exc.da subpos.9504.30)', 'aliquota_federal' => 22.49, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95045000', 'description' => 'Partes e acessórios dos consoles e das máquinas de jogos de vídeo cujas imagens são reproduzidas numa tela de um receptor de televisão, num monitor ou noutra tela ou superfície externa', 'aliquota_federal' => 19.72, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95045000', 'description' => 'Máquinas de jogos de vídeo com tela incorporada, portáteis ou não, e suas partes e acessórios', 'aliquota_federal' => 13.03, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95049010', 'description' => 'Boliches automáticos', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95049090', 'description' => 'Outros artigos p/jogos de salao', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95049090', 'description' => 'Dados e copos para dados', 'aliquota_federal' => 32.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95049090', 'description' => 'Ficha, marca  escore  ou tento', 'aliquota_federal' => 32.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95051000', 'description' => 'Artigos para festas de natal', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95059000', 'description' => 'Artigos para outs.festas,carnaval ou outs. divertimentos', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95061100', 'description' => 'Esquis p/neve', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95061200', 'description' => 'Fixadores p/esquis', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95061900', 'description' => 'Outros equipamentos p/esquiar na neve', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95062100', 'description' => 'Pranchas a vela', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95062900', 'description' => 'Esquis aquaticos e outs.equipam.p/esportes aquaticos', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95063100', 'description' => 'Tacos completos p/golfe', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95063200', 'description' => 'Bolas p/golfe', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95063900', 'description' => 'Outros equipamentos p/golfe', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95064000', 'description' => 'Artigos e equipamentos p/tenis de mesa', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95065100', 'description' => 'Raquetes de tenis,mesmo nao encordoadas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95065900', 'description' => 'Raquetes de badminton e raquetes semelh.', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95066100', 'description' => 'Bolas p/tenis,exc.tenis de mesa', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95066200', 'description' => 'Bolas inflaveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95066900', 'description' => 'Outros bolas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '95067000', 'description' => 'Patins p/gelo e patins de rodas,incl.fixados em calcado', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95069100', 'description' => 'Artigos e equipamentos p/cultura fisica, ginastica,etc.', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95069900', 'description' => 'Artigos e equipamentos p/outs.esportes e piscinas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95071000', 'description' => 'Varas (canas) de pesca', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95072000', 'description' => 'Anzois,mesmo montados em sedelas (terminais)', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95073000', 'description' => 'Molinetes (carretos) de pesca', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95079000', 'description' => 'Outs.artigos p/pesca a linha,pucas,redes,iscas, caca,etc', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95081000', 'description' => 'Circos e coleções de animais ambulante', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95081000', 'description' => 'Coleções de animais de zoológicos, de circos ou de outras atrações itinerantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089011', 'description' => 'Com percurso igual ou superior a 300 m', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089012', 'description' => 'Vagonetes com capacidade igual ou superior a 6 pessoas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089019', 'description' => 'Outras', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089021', 'description' => 'Carrosséis, mesmo dotados de dispositivo de elevação, de diâmetro igual ou superior a 16 m', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089022', 'description' => 'Carrosséis, mesmo dotados de dispositivo de elevação, de diâmetro inferior a 16 m', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089023', 'description' => 'Balanços e recreações giratórias', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089041', 'description' => 'Carrinhos de choque (batebate)', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089042', 'description' => 'Simuladores de movimentos e cinemas dinâmicos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089043', 'description' => 'Equipamentos recreativos para parques aquáticos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089049', 'description' => 'Outros', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089050', 'description' => 'Instalações de tiro ao alvo e outras diversões de parques e feiras ', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '95089060', 'description' => 'Teatros ambulantes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96011000', 'description' => 'Marfim trabalhado e obras de marfim', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96019000', 'description' => 'Outs.materias animais p/entalhar,trabalhados e obras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96020010', 'description' => 'Capsulas de gelatinas digeriveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96020020', 'description' => 'Colmeias artificiais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96020090', 'description' => 'Outs.materias veget/miner.de entalhar,trabalh. obras,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96031000', 'description' => 'Vassouras e escovas,de materias vegetais em feixes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96032100', 'description' => 'Escovas de dentes,incl.as escovas p/dentaduras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96032900', 'description' => 'Escovas e pinceis de barba,escovas p/cabelos, cilios,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96033000', 'description' => 'Pinceis e escovas p/artistas,p/prods. cosmeticos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96034010', 'description' => 'Rolos p/pintura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96034090', 'description' => 'Escovas e pinceis p/pintar,caiar,envernizar,etc. bonecas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96035000', 'description' => 'Outs.escovas constit.partes de maqs.apars.ou veiculos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96039000', 'description' => 'Outs.vassouras,escovas,pinceis,espanadores,rodos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96040000', 'description' => 'Peneiras e crivos,manuais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96050000', 'description' => 'Sortidos de viagem,p/toucador,p/costura/ limpeza roupas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96061000', 'description' => 'Botoes de pressao e suas partes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96062100', 'description' => 'Botoes de plastico,n/recob.de materias texteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96062200', 'description' => 'Botoes de metais comuns,n/recob.de materias texteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96062900', 'description' => 'Outros botoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96063000', 'description' => 'Formas e outs.partes de botoes e esbocos de botoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96071100', 'description' => 'Fechos ecler c/grampos de metal comum', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96071900', 'description' => 'Outros fechos ecler', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96072000', 'description' => 'Partes de fechos ecler', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96081000', 'description' => 'Canetas esferograficas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96082000', 'description' => 'Canetas e marcadores,c/ponta de feltro/pontas porosas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96083000', 'description' => 'Canetas-tinteiro e outras canetas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96084000', 'description' => 'Lapiseiras', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96085000', 'description' => 'Sortidos de canetas com lapiseiras', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96086000', 'description' => 'Cargas c/ponta,p/canetas esferograficas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96089100', 'description' => 'Penas (aparos) e suas pontas,p/canetas-tinteiro', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96089981', 'description' => 'Pontas porosas,p/canetas e marcadores', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96089989', 'description' => 'Outros partes p/canetas,lapiseiras,etc.', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '96089990', 'description' => 'Estiletes p/duplicadores,porta-lapis e artigos semelhs.', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96091000', 'description' => 'Lapis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96092000', 'description' => 'Minas p/lapis/lapiseiras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96099000', 'description' => 'Pasteis,carvoes,gizes p/escrever/desenhar e de alfaiate', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96100000', 'description' => 'Lousas e quadros p/escrever/desenhar,mesmo emoldurados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96110000', 'description' => 'Carimbos,datadores,numeradores,sinetes e artigos semelh', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96121011', 'description' => 'Fitas de plastico,c/tinta magnetiz.p/impressao caracter', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96121012', 'description' => 'Fitas de plastico,corretivas,p/maqs.de escrever', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96121013', 'description' => 'Outs.fitas de plastico,em cartuchos,p/maqs.de escrever', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96121019', 'description' => 'Outros fitas impressoras de plastico', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96121090', 'description' => 'Outros fitas impressoras de outs.materias', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96122000', 'description' => 'Almofadas de carimbo', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96131000', 'description' => 'Isqueiros de bolso,a gas,n/recarregaveis', 'aliquota_federal' => 12.35, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96132000', 'description' => 'Isqueiros de bolso,a gas,recarregaveis', 'aliquota_federal' => 12.35, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96138000', 'description' => 'Outros isqueiros e acendedores', 'aliquota_federal' => 12.35, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96139000', 'description' => 'Partes de isqueiros e outs.acendedores', 'aliquota_federal' => 12.35, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96140000', 'description' => 'Cachimbos (incluídos os seus fornilhos) e piteiras para charutos e para cigarros, e suas partes.', 'aliquota_federal' => 10.78, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96151100', 'description' => 'Pentes e travessas p/cabelo,de borracha endur/plastico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96151900', 'description' => 'Outs.pentes e travessas p/cabelo,de outs.materias', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96159000', 'description' => 'Grampos p/cabelo,pincas e outs.artigos p/penteados', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96161000', 'description' => 'Vaporizadores de toucador,armacoes e suas cabecas', 'aliquota_federal' => 8.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96162000', 'description' => 'Borlas/esponjas p/pos/outs.cosmeticos/prods. de toucador', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96170010', 'description' => 'Garrafa termica/outs.recip.isoterm.montados,isol.vacuo', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96170020', 'description' => 'Partes de garrafas termicas e outs.recips. isotermicos', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96180000', 'description' => 'Manequim,automato e cenas animadas p/vitrine/mostruario', 'aliquota_federal' => 8.55, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96190000', 'description' => 'Absorventes e tampoes higienicos,cueiro e fralda p/bebe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96190000', 'description' => 'Artigos de vestuário, de plástico', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96190000', 'description' => 'Outros artigos higiênicos, de plástico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '96200000', 'description' => 'Monopés, bipés, tripés e artigos semelhantes.', 'aliquota_federal' => 7.92, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '97011000', 'description' => 'Quadros,pinturas e desenhos,feitos a mao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '97019000', 'description' => 'Colagens e quadros decorativos semelh.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '97019000', 'description' => 'De flores, botões de flores ou de outras partes de plantas naturais, ervas, musgos e líquens', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '97020000', 'description' => 'Gravuras,estampas e litografias,originais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '97030000', 'description' => 'Produções originais de arte estatuária ou de escultura, de quaisquer matérias.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '97040000', 'description' => 'Selos postais, selos fiscais, marcas postais, envelopes de primeiro dia (f.d.c. – “first-day cover”), inteiros postais e semelhantes, obliterados, ou não obliterados, exceto os artigos da posição 49.07.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '97050000', 'description' => 'Coleções e espécimes para coleções, de zoologia, botânica, mineralogia, anatomia, ou apresentando interesse histórico, arqueológico, paleontológico, etnográfico ou numismático.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '97060000', 'description' => 'Antiguidades com mais de 100 anos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '101011000', 'description' => 'Serviços de construção de edificações residenciais de um e dois pavimentos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101012000', 'description' => 'Serviços de construção de edificações residenciais com mais de dois pavimentos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101021000', 'description' => 'Serviços de construção de edificações industriais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101022000', 'description' => 'Serviços de construção de edificações comerciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101029000', 'description' => 'Outros serviços de construção de edificações não residenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.20],
            ['ncm' => '101031000', 'description' => 'Serviços de construção de autoestradas (exceto autoestradas elevadas), ruas e estradas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '101032000', 'description' => 'Serviços de construção de estradas férreas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '101033000', 'description' => 'Serviços de construção de pistas de pouso e decolagem em aeroportos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '101034000', 'description' => 'Serviços de construção de infraestrutura aeroportuária', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '101040000', 'description' => 'Serviços de construção de pontes, autoestradas elevadas e túneis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101051100', 'description' => 'Serviços de construção de guias-corrente, espigões, quebra-mares, canais de acesso, bacias de evolução, balizamento e sinalização, derrocagens e dragagens.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '101051900', 'description' => 'Outros serviços de construção de infraestrutura de proteção e acesso aquaviário', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '101052100', 'description' => 'Serviços de construção de ancoradouros, docas, cais, pontes, dolfins e píeres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '101052900', 'description' => 'Outros serviços de construção de infraestrutura de acostagem aquaviária', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '101053100', 'description' => 'Serviços de construção de armazéns, inclusive os especiais, silos, pátios e vias de circulação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101053900', 'description' => 'Outros serviços de construção de infraestrutura terrestre nos portos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '101061000', 'description' => 'Serviços de construção de barragens e adutoras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101062100', 'description' => 'Serviços de construção de sistemas de irrigação  ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101062200', 'description' => 'Serviços de construção de sistemas de esgotos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101062300', 'description' => 'Serviços de construção de sistemas de unidades para tratamento e purificação de água  ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101069000', 'description' => 'Outros serviços de construção de sistemas hídricos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101071100', 'description' => 'Serviços de construção de dutos de longo curso para o transporte de petróleo, seus derivados, e gás', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101071200', 'description' => 'Serviços de construção de dutos de longo curso para o transporte e escoamento de águas e esgotos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101071900', 'description' => 'Serviços de construção de outros dutos de longo curso', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101072100', 'description' => 'Serviços de construção de linhas de comunicação de longo curso', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101072210', 'description' => 'Serviços de construção de linhas de transmissão de alta tensão em corrente contínua', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101072220', 'description' => 'Serviços de construção de linhas de transmissão de alta tensão em corrente alternada', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101081000', 'description' => 'Serviços de construção de dutos locais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101082110', 'description' => 'Serviços de construção de linhas locais de transmissão de baixa e média tensão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101082120', 'description' => 'Serviços de construção de linhas locais de comunicação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101082900', 'description' => 'Outros serviços de construção relacionados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101091000', 'description' => 'Serviços de construção de usinas de geração de energia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101092000', 'description' => 'Serviços de construção de subestações de força', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101101000', 'description' => 'Serviços de construção de minas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101102000', 'description' => 'Serviços de construção de unidades industriais relacionadas à mineração', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101110000', 'description' => 'Serviços de construção de instalações para recreação e atividades desportivas ao ar livre', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101120000', 'description' => 'Outros serviços de construção civil não classificados  nas posições anteriores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101130000', 'description' => 'Serviços de demolição', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101140000', 'description' => 'Serviços de preparação de terrenos e construção de canteiros de obras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.28],
            ['ncm' => '101150000', 'description' => 'Serviços de escavação e remoção de terra', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101161000', 'description' => 'Serviços de perfuração de poços de água', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101162000', 'description' => 'Serviços de instalação de sistemas sépticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101170000', 'description' => 'Serviços de montagem e edificação de construções pré-fabricadas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101181000', 'description' => 'Serviços de estaqueamento', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '101182000', 'description' => 'Serviços de fundação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '101191000', 'description' => 'Serviços de construção de estruturas de prédios', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101192000', 'description' => 'Serviços de construção de estruturas de telhados e coberturas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101200000', 'description' => 'Serviços de construção de telhados e coberturas e serviços de impermeabilização', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.23],
            ['ncm' => '101210000', 'description' => 'Serviços de concretagem', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.29],
            ['ncm' => '101220000', 'description' => 'Serviços de estruturas de aço estrutural', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101230000', 'description' => 'Serviços de alvenaria', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101240000', 'description' => 'Serviços de andaimes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101250000', 'description' => 'Outros serviços especializados de construção', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101261000', 'description' => 'Serviços de instalação de fiação elétrica e componentes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101262000', 'description' => 'Serviços de instalação de alarmes contra incêndio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101263000', 'description' => 'Serviços de instalação de sistemas de alarmes antifurto', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101264000', 'description' => 'Serviços de instalação de antenas residenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101269000', 'description' => 'Outros serviços de instalação elétrica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101271000', 'description' => 'Serviços de tubulação para fornecimento de água', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101272000', 'description' => 'Serviços de tubulação de escoamento de água', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101281000', 'description' => 'Serviços de instalação de aquecimento', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101282000', 'description' => 'Serviços de instalação de ventilação e ar condicionado', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101290000', 'description' => 'Serviços de instalação de gás', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101300000', 'description' => 'Serviços de isolamento', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101311000', 'description' => 'Serviços de instalação de elevadores, esteiras e escadas rolantes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101319000', 'description' => 'Outros serviços de instalação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '101320000', 'description' => 'Serviços de vidraçaria', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.34],
            ['ncm' => '101330000', 'description' => 'Serviços de gesso', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.34],
            ['ncm' => '101340000', 'description' => 'Serviços de pintura', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.34],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '101350000', 'description' => 'Serviços de assentamento de revestimentos em paredes e pisos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.27],
            ['ncm' => '101360000', 'description' => 'Outros serviços de cobertura de pisos e paredes e papel de parede', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.34],
            ['ncm' => '101370000', 'description' => 'Serviços de carpintaria  e serralheria, inclusive suas instalações e monstagens', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '101380000', 'description' => 'Serviços de instalação de cercas e grades', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.34],
            ['ncm' => '101390000', 'description' => 'Outros serviços de acabamento das construções', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.34],
            ['ncm' => '102010000', 'description' => 'Serviços de agentes de distribuição de mercadorias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.13],
            ['ncm' => '102020000', 'description' => 'Comércio atacadista', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '102030000', 'description' => 'Comércio varejista', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '102041000', 'description' => 'Serviços de despachante aduaneiro na importação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '102042000', 'description' => 'Serviços de despachante aduaneiro na exportação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '102050000', 'description' => 'Serviços de agentes na comercialização de energia elétrica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '103011000', 'description' => 'Fornecimento de refeições acompanhado de serviços de restaurante', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103012100', 'description' => 'Fornecimento de refeições pelo sistema de autoserviço (self-service)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103012200', 'description' => 'Fornecimento de comidas do tipo “comidas rápidas” (fast-food)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103012900', 'description' => 'Outros fornecimentos de refeições com serviços limitados de restaurante', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103013100', 'description' => 'Fornecimento de alimentação, para eventos, sob contrato', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '103013200', 'description' => 'Fornecimento de alimentação, incluindo refeições para operadoras de transportes (comissaria ou catering)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103013900', 'description' => 'Outros fornecimentos de alimentação, incluindo refeições, sob contrato', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103019000', 'description' => 'Outros fornecimentos de alimentação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '103020000', 'description' => 'Fornecimento de bebidas em bares, cervejarias e outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103031100', 'description' => 'Serviços de quarto ou de unidades de hospedagem para visitantes, com serviços diários de faxina', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103031200', 'description' => 'Serviços de quarto ou de unidades de hospedagem para visitantes, sem serviços diários de faxina', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103031300', 'description' => 'Serviços de quarto ou de unidades de hospedagem para visitantes, em propriedades partilhadas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103031400', 'description' => 'Serviços de quarto ou de unidades de hospedagem para visitantes, em quartos de múltipla ocupação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103032000', 'description' => 'Serviços de acampamentos turísticos (camping)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '103039000', 'description' => 'Outros serviços de hospedagem para visitantes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '103041000', 'description' => 'Serviços de quarto ou de unidades de hospedagem para estudantes em residências estudantis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103042000', 'description' => 'Serviços de quarto ou de unidades de hospedagem para trabalhadores em hotéis ou campos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '103049000', 'description' => 'Outros serviços de quarto ou de unidades de hospedagem', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '104011110', 'description' => 'Serviços prestados única e exclusivamente por meio de ônibus', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104011190', 'description' => 'Serviços prestados por meio de outros veículos rodoviários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104011200', 'description' => 'Serviços de transporte rodoviário de passageiros nas áreas metropolitanas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104011300', 'description' => 'Serviços de transporte ferroviário urbano ou rural, inclusive nas áreas metropolitanas, de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104011400', 'description' => 'Serviços de transporte metroviário (metrô) de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104011500', 'description' => 'Serviços de transporte integrado urbano ou rural, inclusive nas áreas metropolitanas, de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104011600', 'description' => 'Serviços de taxi', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104011700', 'description' => 'Serviço de aluguel de carros com motorista', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104011910', 'description' => 'Serviços de transporte escolar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104011990', 'description' => 'Outros serviços terrestres de transporte de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104012100', 'description' => 'Serviços de transporte por navegação interior de passageiros por embarcações para travessia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104012200', 'description' => 'Serviços de transporte por navegação interior de passageiros por embarcações para cruzeiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104012900', 'description' => 'Outros serviços de transporte por navegação interior de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104019000', 'description' => 'Outros serviços de transporte de passageiros em áreas urbanas ou rurais, inclusive metropolitanas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104021100', 'description' => 'Serviços de transporte rodoviário para passeios turísticos (sightseeing)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104021200', 'description' => 'Serviços de transporte ferroviário para passeios turísticos (sightseeing)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104021300', 'description' => 'Serviços de transporte aquaviário para passeios turísticos (sightseeing)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104021400', 'description' => 'Serviços de transporte aéreo para passeios turísticos (sightseeing)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104021900', 'description' => 'Outros serviços transporte para passeios turísticos (sightseeing)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104022100', 'description' => 'Serviços de fretamento contínuo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104022200', 'description' => 'Serviços de fretamento eventual ou turístico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104022900', 'description' => 'Outros serviços de fretamento, exceto aéreo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104031110', 'description' => 'Serviços prestados única e exclusivamente por meio de ônibus', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104031190', 'description' => 'Serviços prestados por meio de outros veículos rodoviários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '104031200', 'description' => 'Serviços de transporte ferroviário interestadual, inclusive interestadual semiurbano, de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104031900', 'description' => 'Outros serviços terrestres de transporte interestadual, inclusive interestadual semiurbano, não classificados em outra posição, e de transporte internacional de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104032100', 'description' => 'Serviços de transporte interestadual, inclusive interestadual semiurbano, por navegação interior, de passageiros por embarcações para travessia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104032200', 'description' => 'Serviços de transporte interestadual, inclusive interestadual semiurbano, por navegação interior, de passageiros por embarcações para cruzeiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104032300', 'description' => 'Serviços de transporte internacional, de passageiros por embarcações para cruzeiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104032900', 'description' => 'Outros serviços de transporte aquaviário interestadual, inclusive interestadual semiurbano de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104039000', 'description' => 'Outros serviços de transporte interestadual, inclusive interestadual semiurbano e internacional de passageiros, exceto serviços de transporte aéreo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '104041100', 'description' => 'Serviços de transporte aéreo doméstico de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104041200', 'description' => 'Serviços de transporte aéreo internacional de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104042000', 'description' => 'Serviços de transporte aéreo por fretamento', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104049100', 'description' => 'Serviços de táxi aéreo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104049900', 'description' => 'Outros serviços de transporte aéreo de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '104900000', 'description' => 'Outros serviços de transporte de passageiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '105011110', 'description' => 'Serviços de transporte rodoviário de cargas sólidas a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011120', 'description' => 'Serviços de transporte rodoviário de cargas líquidas ou liquefeitas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011130', 'description' => 'Serviços de transporte rodoviário de cargas gasosas a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011200', 'description' => 'Serviços de transporte rodoviário de cargas vivas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011310', 'description' => 'Serviços de transporte rodoviário de carga solta, não unitizada.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011320', 'description' => 'Serviços de transporte rodoviário de carga unitizada, exceto em contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011410', 'description' => 'Serviços de transporte rodoviário de cargas em contêineres frigorificados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011490', 'description' => 'Serviços de transporte rodoviário de cargas em outros tipos de contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011500', 'description' => 'Serviços de transporte rodoviário de mudanças domésticas, e de mobília e outros objetos de escritório', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011600', 'description' => 'Serviços de transporte rodoviário de cargas especiais e de grande porte', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011700', 'description' => 'Serviços de transporte rodoviário de veículos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011810', 'description' => 'Serviços de transporte rodoviário de combustíveis, lubrificantes e glp, inclusive apresentado em botijões metálicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011820', 'description' => 'Serviços de transporte rodoviário de produtos químicos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011890', 'description' => 'Serviços de transporte rodoviário de  outros produtos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105011900', 'description' => 'Serviços de transporte rodoviário de outros tipos de carga', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012110', 'description' => 'Serviços de transporte ferroviário de cargas sólidas a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012120', 'description' => 'Serviços de transporte ferroviário de cargas líquidas ou liquefeitas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012130', 'description' => 'Serviços de transporte ferroviário de cargas gasosas a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012200', 'description' => 'Serviços de transporte ferroviário de cargas vivas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012310', 'description' => 'Serviços de transporte ferroviário de carga solta, não unitizada ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012320', 'description' => 'Serviços de transporte ferroviário de carga unitizada, exceto de em contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012330', 'description' => 'Serviços de transporte ferroviário de bens e valores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012410', 'description' => 'Serviços de transporte ferroviário de cargas em contêineres frigorificados  climatizados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012490', 'description' => 'Serviços de transporte ferroviário de cargas em outros tipos de contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012510', 'description' => 'Serviços de transporte ferroviário de combustíveis, lubrificantes e glp, inclusive apresentado em botijões metálicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012520', 'description' => 'Serviços de transporte ferroviário de produtos químicos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012530', 'description' => 'Serviços de transporte ferroviário de armamentos militares e munições', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012540', 'description' => 'Serviços de transporte ferroviário de fundidos em estado líquido', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012550', 'description' => 'Serviços de transporte ferroviário de material radioativo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012590', 'description' => 'Serviços de transporte ferroviário de outros produtos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105012900', 'description' => 'Serviços de transporte ferroviário de outros tipos de carga', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105013100', 'description' => 'Serviços de transporte de petróleo, gás natural e combustível', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105013200', 'description' => 'Serviços de transporte de minérios', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105013900', 'description' => 'Serviços de transporte de outras mercadorias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021110', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de cargas sólidas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021120', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de cargas líquidas ou liquefeitas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021130', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de cargas gasosas a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021200', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso  de cargas vivas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021310', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de carga solta, não unitizada', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021320', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso  de carga unitizada, exceto de em contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '105021410', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso  de cargas em contêineres frigorificados ou climatizados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021490', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso  de cargas em outros tipos de contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021500', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de mudanças domésticas, e de mobília e outros objetos de escritório', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021600', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de cargas especiais e de grande porte', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021700', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de veículos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021810', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de combustíveis, lubrificantes e glp, inclusive apresentado em botijões metálicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021820', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de produtos químicos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021890', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de outros produtos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105021900', 'description' => 'Serviços de transporte aquaviário de navegação de cabotagem e de longo curso de outros tipos de carga', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022110', 'description' => 'Serviços de transporte aquaviário por navegação interior de cargas sólidas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022120', 'description' => 'Serviços de transporte aquaviário por navegação interior de cargas líquidas ou liquefeitas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022130', 'description' => 'Serviços de transporte aquaviário por navegação interior de cargas gasosas a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022200', 'description' => 'Serviços de transporte aquaviário por navegação interior  de cargas vivas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022310', 'description' => 'Serviços de transporte aquaviário por navegação interior de carga solta, não unitizada', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022320', 'description' => 'Serviços de transporte aquaviário por navegação interior de carga unitizada, exceto em contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022410', 'description' => 'Serviços de transporte aquaviário por navegação interior de cargas  em contêineres frigorificados ou climatizados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022490', 'description' => 'Serviços de transporte aquaviário por navegação interior de cargas em outros tipos de contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022500', 'description' => 'Serviços de transporte aquaviário por navegação interior de mudanças domésticas, e de mobília e de outros objetos de escritório', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022600', 'description' => 'Serviços de transporte aquaviário por navegação interior  de cargas especiais e de grande porte', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022700', 'description' => 'Serviços de transporte aquaviário por navegação interior de veículos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022810', 'description' => 'Serviços de transporte aquaviário por navegação interior de combustíveis, lubrificantes e glp, inclusive apresentado em botijões metálicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022820', 'description' => 'Serviços de transporte aquaviário por navegação interior de produtos químicos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022890', 'description' => 'Serviços de transporte aquaviário por navegação interior  de  outros produtos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105022900', 'description' => 'Serviços de transporte aquaviário por navegação interior de outros tipos de carga', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105023100', 'description' => 'Serviços de navegação de apoio portuário', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.59],
            ['ncm' => '105023200', 'description' => 'Serviços de navegação de apoio marítimo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.59],
            ['ncm' => '105031000', 'description' => 'Serviços de transporte aéreo de cargas postais, remessas expressas e cargas congêneres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '105032010', 'description' => 'Serviços de transporte aéreo de cargas em contêineres frigorificados ou climatizados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105032090', 'description' => 'Serviços de transporte aéreo de outros tipos de cargas em contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105033010', 'description' => 'Serviços de transporte aéreo de produtos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105033020', 'description' => 'Serviços de transporte aéreo de animais vivos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105033030', 'description' => 'Serviços de transporte aéreo de máquinas e veículos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105033040', 'description' => 'Serviços de transporte aéreo de perecíveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105033050', 'description' => 'Serviços de transporte aéreo de cargas frágeis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105033060', 'description' => 'Serviços de transporte aéreo de cargas controladas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105033070', 'description' => 'Serviços de transporte aéreo de valores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105033090', 'description' => 'Serviços de transporte aéreo de outras cargas especiais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105039000', 'description' => 'Serviços de transporte aéreo de outros tipos de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105041010', 'description' => 'Serviços de transporte multimodal de cargas sólidas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105041020', 'description' => 'Serviços de transporte multimodal de cargas líquidas ou liquefeitas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105041030', 'description' => 'Serviços de transporte multimodal de cargas gasosas a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105042000', 'description' => 'Serviços de transporte multimodal de cargas vivas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105043010', 'description' => 'Serviços de transporte multimodal de cargas soltas, não unitizadas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105043020', 'description' => 'Serviços de transporte multimodal de cargas unitizadas, exceto em contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105044010', 'description' => 'Serviços de transporte multimodal de cargas em contêineres frigorificados ou climatizados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105044090', 'description' => 'Serviços de transporte multimodal de cargas em outros tipos de contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105045000', 'description' => 'Serviços de transporte multimodal de mudanças domésticas, e de mobília e outros objetos de escritório', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105046000', 'description' => 'Serviços de transporte multimodal de cargas especiais e de grande porte', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105047000', 'description' => 'Serviços de transporte multimodal de veículos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105048010', 'description' => 'Serviços de transporte multimodal de combustíveis, lubrificantes e glp, inclusive apresentado em botijões metálicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105048020', 'description' => 'Serviços de transporte multimodal de produtos químicos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105048090', 'description' => 'Serviços de transporte multimodal de outros produtos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105049000', 'description' => 'Serviços de transporte multimodal de outros tipos de carga', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '105051010', 'description' => 'Serviços de transporte intermodal de cargas sólidas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105051020', 'description' => 'Serviços de transporte intermodal de cargas líquidas ou liquefeitas, a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105051030', 'description' => 'Serviços de transporte intermodal de cargas gasosas a granel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105052000', 'description' => 'Serviços de transporte intermodal de cargas vivas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105053010', 'description' => 'Serviços de transporte intermodal de cargas soltas, não unitizadas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105053020', 'description' => 'Serviços de transporte intermodal de cargas unitizadas, exceto em contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105054010', 'description' => 'Serviços de transporte intermodal de cargas em contêineres frigorificados ou climatizados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105054090', 'description' => 'Serviços de transporte intermodal de outros tipos de cargas em contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105055000', 'description' => 'Serviços de transporte intermodal de mudanças domésticas, e de mobília e de outros objetos de escritório', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105056000', 'description' => 'Serviços de transporte intermodal de cargas especiais e de grande porte', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105057000', 'description' => 'Serviços de transporte intermodal de veículos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105058010', 'description' => 'Serviços de transporte intermodal de combustíveis, lubrificantes e glp, inclusive apresentado em botijões metálicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105058020', 'description' => 'Serviços de transporte intermodal de produtos químicos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105058090', 'description' => 'Serviços de transporte intermodal de outros produtos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '105059000', 'description' => 'Serviços de transporte intermodal de outros tipos de carga', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106011000', 'description' => 'Serviços de manuseio de contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106019000', 'description' => 'Outros serviços de manuseio de cargas e bagagens', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106021000', 'description' => 'Serviços de armazenagem frigorífica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.33],
            ['ncm' => '106022010', 'description' => 'Serviços de armazenagem de petróleo e seus derivados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106022020', 'description' => 'Serviços de armazenagem de combustíveis, lubrificantes e glp, inclusive apresentado em botijões metálicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106022030', 'description' => 'Serviços de armazenagem de produtos químicos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106022090', 'description' => 'Serviços de armazenagem de outros produtos perigosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106023010', 'description' => 'Serviços de armazenagem de granéis sólidos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106023020', 'description' => 'Serviços de armazenagem de granéis líquidos ou liquefeitos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106023030', 'description' => 'Serviços de armazenagem de granéis gasosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106029000', 'description' => 'Outros serviços de armazenagem em depósitos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106030000', 'description' => 'Serviços de apoio para transportes ferroviários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106041000', 'description' => 'Serviços de estações rodoviárias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106042010', 'description' => 'Serviços de operação de autoestradas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106042020', 'description' => 'Serviços de operação de pontes e túneis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106042030', 'description' => 'Serviços de exploração de pedágios', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.62],
            ['ncm' => '106043000', 'description' => 'Serviços de estacionamentos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.31],
            ['ncm' => '106044000', 'description' => 'Serviços de reboque para veículos particulares e comerciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106049000', 'description' => 'Outros serviços de apoio ao transporte rodoviário', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.23],
            ['ncm' => '106051000', 'description' => 'Serviços de operação de portos e canais, exceto manuseio de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106052000', 'description' => 'Serviços de praticagem e de docas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106053000', 'description' => 'Serviços de salvamento de embarcações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106059000', 'description' => 'Outros serviços de apoio ao transporte aquaviário, exceto os serviços de navegação de apoio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.23],
            ['ncm' => '106061000', 'description' => 'Serviços de operação de aeroportos, exceto manuseio de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106062000', 'description' => 'Serviços de controle de tráfego aéreo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106069000', 'description' => 'Outros serviços de apoio ao transporte aéreo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.61],
            ['ncm' => '106071000', 'description' => 'Serviços de agências de fretamento de transporte e outros serviços de fretamento de transportes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106079000', 'description' => 'Outros serviços de apoio aos transportes, exceto serviços de apoio ao transporte multimodal e intermodal de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '106081000', 'description' => 'Serviços de coleta e entrega do transporte multimodal e intermodal de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106082000', 'description' => 'Serviços de unitização ou desunitização do transporte multimodal e intermodal de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106083000', 'description' => 'Serviços de movimentação do transporte multimodal e intermodal de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106084000', 'description' => 'Serviços de consolidação ou desconsolidação documental do transporte multimodal e intermodal de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '106089000', 'description' => 'Outros serviços de apoio ao transporte multimodal e intermodal de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '107010000', 'description' => 'Serviços postais e de telegrama', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.31],
            ['ncm' => '107020000', 'description' => 'Serviços de coleta, remessa ou entrega de documentos (exceto cartas) ou de pequenos objetos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.31],
            ['ncm' => '107030000', 'description' => 'Serviços de remessas expressas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.31],
            ['ncm' => '108011100', 'description' => 'Serviços de transmissão de eletricidade', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '108011200', 'description' => 'Serviços de distribuição de eletricidade', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '108012000', 'description' => 'Serviços de distribuição de gás canalizado', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '108021000', 'description' => 'Serviços de distribuição de água por meio de tubulações, exceto vapor de água e água quente', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '108022000', 'description' => 'Serviços de distribuição de vapor de água, água quente e ar condicionado por meio de tubulações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '108023000', 'description' => 'Serviços de distribuição de água, exceto através de tubulações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '109011000', 'description' => 'Serviços de banco central', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109012100', 'description' => 'Serviços de depósito para pessoas jurídicas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.80],
            ['ncm' => '109012200', 'description' => 'Serviços de depósito para pessoas físicas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.81],
            ['ncm' => '109012900', 'description' => 'Outros serviços de depósito', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.78],
            ['ncm' => '109013100', 'description' => 'Serviços de financiamentos imobiliários residenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.75],
            ['ncm' => '109013200', 'description' => 'Serviços de financiamentos imobiliários não-residenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '109013300', 'description' => 'Serviços de empréstimos e financiamentos, pessoais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '109013400', 'description' => 'Serviços de empréstimos e financiamentos, comerciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '109013500', 'description' => 'Serviços de empréstimos e financiamentos, industriais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '109013600', 'description' => 'Serviços de empréstimos e financiamentos, agropecuários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '109013900', 'description' => 'Outros serviços de concessão de crédito', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.81],
            ['ncm' => '109014000', 'description' => 'Serviços de cartão de crédito', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '109021000', 'description' => 'Serviços de valoração de ativos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109022000', 'description' => 'Serviços de subscrição de valores mobiliários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109023000', 'description' => 'Serviços de fusões e aquisições ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109024000', 'description' => 'Serviços de capital de risco e finanças corporativas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109029000', 'description' => 'Outros serviços relacionados a bancos de investimentos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109031100', 'description' => 'Serviços de seguros de vida', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109031200', 'description' => 'Serviços de previdência complementar aberta', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109031300', 'description' => 'Serviços de previdência complementar fechada', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109032000', 'description' => 'Serviços de seguros saúde e de acidentes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '109039100', 'description' => 'Serviços de seguros de veículos rodoviários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109039200', 'description' => 'Serviços de seguros de veículos e equipamentos para transporte ferroviário, aquaviário e aéreo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109039300', 'description' => 'Serviços de seguros de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109039400', 'description' => 'Serviços de seguros de outras propriedades', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109039500', 'description' => 'Serviços de seguros por responsabilidade civil', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109039600', 'description' => 'Serviços de seguros de crédito e de caução', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109039700', 'description' => 'Serviços de seguro de viagem', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '109039900', 'description' => 'Outros serviços de seguros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.04],
            ['ncm' => '109041000', 'description' => 'Serviços de resseguros de vida', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109042000', 'description' => 'Serviços de resseguros saúde e de acidentes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109043100', 'description' => 'Serviços de resseguros de veículos rodoviários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.56],
            ['ncm' => '109043200', 'description' => 'Serviços de resseguros de veículos e equipamentos para transporte ferroviário, aquaviário e aéreo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.56],
            ['ncm' => '109043300', 'description' => 'Serviços de resseguros de cargas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.56],
            ['ncm' => '109043400', 'description' => 'Serviços de resseguros de outras propriedades', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.56],
            ['ncm' => '109043500', 'description' => 'Serviços de resseguros de responsabilidade civil', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.56],
            ['ncm' => '109043600', 'description' => 'Serviços de resseguros de crédito e caução', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.56],
            ['ncm' => '109043900', 'description' => 'Outros serviços de resseguros e serviços de retrocessão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.56],
            ['ncm' => '109051100', 'description' => 'Serviços de corretagem de títulos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109051200', 'description' => 'Serviços de corretagem de derivativos e commodities', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109051300', 'description' => 'Serviços de compensação de transações financeiras, inclusive com ativos financeiros (clearinghouse)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109052000', 'description' => 'Serviços de gestão e administração de carteiras de ativos, exceto fundos de pensão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109053000', 'description' => 'Serviços de guarda e custódia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109054000', 'description' => 'Serviços relacionados à administração de mercados financeiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109059100', 'description' => 'Serviços de consultoria financeira', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109059200', 'description' => 'Serviços de câmbio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.71],
            ['ncm' => '109059300', 'description' => 'Serviços de classificação de risco (rating)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109059400', 'description' => 'Serviços fiduciários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109059900', 'description' => 'Outros serviços auxiliares aos serviços financeiros não classificados em outra posição', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '109061100', 'description' => 'Serviços de agenciamento e corretagem de seguros e previdência complementar, exceto de seguros saúde', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109061200', 'description' => 'Serviços de corretagem de seguros saúde', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109062000', 'description' => 'Serviços de perícia e avaliação de seguros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109063000', 'description' => 'Serviços atuariais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109064000', 'description' => 'Serviços de gestão de fundos de previdência complementar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109069000', 'description' => 'Outros serviços auxiliares a seguros, e previdência complementar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109070000', 'description' => 'Securitização de recebíveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '109080000', 'description' => 'Fomento comercial (factoring)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '110011100', 'description' => 'Serviços de administração e locação de imóveis residenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '110011210', 'description' => 'Serviços de administração de locação, sublocação, arrendamento, direito de passagem ou permissão de uso, compartilhado ou não, de ferrovia, rodovia, postes, cabos, dutos e condutos de qualquer natureza', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.23],
            ['ncm' => '110011290', 'description' => 'Outros serviços de administração e locação de imóveis não residenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '110012100', 'description' => 'Compra e venda de imóveis residenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '110012200', 'description' => 'Compra e venda de imóveis não-residenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '110013000', 'description' => 'Serviços de avaliação de imóveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '110014000', 'description' => 'Serviços de consultoria imobiliária', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '110015000', 'description' => 'Serviços de assessoria de gestão condominial (condomínios, edifícios residenciais e mistos)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '110900000', 'description' => 'Outros serviços imobiliários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '111011100', 'description' => 'Arrendamento mercantil operacional ou locação de veículos rodoviários automotores para o transporte de até oito passageiros, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '111011200', 'description' => 'Arrendamento mercantil operacional ou locação de veículos rodoviários automotores para o transporte de mercadorias, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '111011300', 'description' => 'Arrendamento mercantil operacional ou locação de veículos e equipamentos ferroviários, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '111011400', 'description' => 'Arrendamento mercantil operacional ou locação de outros equipamentos de transporte terrestre, inclusive de veículos de uso misto, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '111011500', 'description' => 'Arrendamento mercantil operacional ou locação de navios e outras embarcações, sem tripulação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '111011600', 'description' => 'Arrendamento mercantil operacional ou locação de aeronaves, sem tripulação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '111011700', 'description' => 'Arrendamento mercantil operacional ou locação de contêineres', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '111012100', 'description' => 'Arrendamento mercantil operacional ou locação de máquinas e equipamentos agrícolas, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111012200', 'description' => 'Arrendamento mercantil operacional ou locação de máquinas e equipamentos de construção, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111012300', 'description' => 'Arrendamento mercantil operacional ou locação de máquinas e equipamentos para escritórios, exceto computadores, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111012400', 'description' => 'Arrendamento mercantil operacional ou locação de computadores, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111012500', 'description' => 'Arrendamento mercantil operacional ou locação de equipamentos de telecomunicação, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111012900', 'description' => 'Arrendamento mercantil operacional ou locação de máquinas e equipamentos, não classificados em outra posição, sem operador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111021000', 'description' => 'Arrendamento mercantil operacional ou locação de televisão e outros eletroeletrônicos domésticos, bem como seus acessórios', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111022000', 'description' => 'Arrendamento mercantil operacional ou locação de mídias gravadas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111023000', 'description' => 'Arrendamento mercantil operacional ou locação de móveis e eletrodomésticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111024000', 'description' => 'Arrendamento mercantil operacional ou locação de equipamentos para diversão e lazer', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111025000', 'description' => 'Arrendamento mercantil operacional ou locação de artigos de cama, mesa e banho', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111026000', 'description' => 'Arrendamento mercantil operacional ou locação de roupas e calçados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111029000', 'description' => 'Arrendamento mercantil operacional ou locação de outras mercadorias não classificadas em outra posição', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111031000', 'description' => 'Licenciamento de direitos de obras literárias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.46],
            ['ncm' => '111032100', 'description' => 'Licenciamento de direitos de produção, distribuição ou comercialização de programas de computador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.11],
            ['ncm' => '111032200', 'description' => 'Licenciamento de direitos de uso de programas de computador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.11],
            ['ncm' => '111032900', 'description' => 'Licenciamento de outros direitos sobre programas de computador ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.11],
            ['ncm' => '111033100', 'description' => 'Licenciamento de direitos de autor de obras cinematográficas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111033200', 'description' => 'Licenciamento de direitos de autor de obras jornalísticas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111033300', 'description' => 'Licenciamento de direitos de autor de obras publicitárias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111033400', 'description' => 'Licenciamento de direitos conexos de artistas intérpretes ou executantes em obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111033500', 'description' => 'Licenciamento de direitos conexos de produtores de obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111034100', 'description' => 'Licenciamento de direitos de autor de obras musicais ou literomusicais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111034200', 'description' => 'Licenciamento de direitos conexos de artistas intérpretes ou executantes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111034300', 'description' => 'Licenciamento de direitos conexos de produtores de fonogramas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111035000', 'description' => 'Licenciamento de direitos relacionados à radiodifusão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111039100', 'description' => 'Licenciamento de outros direitos de autor', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111039200', 'description' => 'Licenciamento de outros direitos conexos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111041000', 'description' => 'Cessão temporária de direitos de obras literárias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '111042000', 'description' => 'Cessão temporária de direitos sobre programas de computador ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111043100', 'description' => 'Cessão temporária de direitos de autor de obras cinematográficas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111043200', 'description' => 'Cessão temporária de direitos de autor de obras jornalísticas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111043300', 'description' => 'Cessão temporária de direitos de autor de obras publicitárias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111043400', 'description' => 'Cessão temporária de direitos conexos de artistas intérpretes ou executantes em obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111043500', 'description' => 'Cessão temporária de direitos conexos de produtores de obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111044100', 'description' => 'Cessão temporária de direitos de autor de obras musicais e literomusicais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111044200', 'description' => 'Cessão temporária de direitos conexos de artistas intérpretes ou executantes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111044300', 'description' => 'Cessão temporária de direitos conexos de produtores de fonogramas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111045000', 'description' => 'Cessão temporária de direitos relacionados à radiodifusão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111049100', 'description' => 'Cessão temporária de outros direitos de autor', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111049200', 'description' => 'Cessão temporária de outros direitos conexos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.18],
            ['ncm' => '111051000', 'description' => 'Licenciamento de direitos sobre patentes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111052000', 'description' => 'Licenciamento de direitos sobre marcas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111053000', 'description' => 'Licenciamento de direitos sobre desenho industrial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111059000', 'description' => 'Licenciamento de outros direitos sobre a propriedade industrial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111060000', 'description' => 'Licenciamento de direitos sobre cultivares', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111070000', 'description' => 'Licenciamento de direitos sobre topografias de circuitos integrados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111080000', 'description' => 'Licenciamento de direitos relativos à informação não divulgada', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111090000', 'description' => 'Licenciamento de outros direitos de propriedade intelectual não classificados em nenhuma das posições anteriores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111101000', 'description' => 'Contratos de prestação de serviços de assistência técnica e científica, combinadamente ou não, com qualquer modalidade de transferência de tecnologia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '111102000', 'description' => 'Contratos de fornecimento de tecnologia (know-how)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '111103000', 'description' => 'Contratos de franquia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '111109000', 'description' => 'Outros contratos de transferência de tecnologia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '111111000', 'description' => 'Licenciamento de direitos de  de recursos vegetais, inclusive florestais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.29],
            ['ncm' => '111112000', 'description' => 'Licenciamento de direitos de explotação de recursos minerais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.29],
            ['ncm' => '111119000', 'description' => 'Licenciamento de direitos de exploração de outros recursos naturais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '111121000', 'description' => 'Licenciamento de direitos sobre conhecimento tradicional associado a recursos genéticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111129000', 'description' => 'Licenciamento de direitos sobre outros conhecimentos tradicionais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111130000', 'description' => 'Licenciamento de direitos relativos ao acesso a recursos genéticos, exceto os decorrentes do conhecimento tradicional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '111900000', 'description' => 'Outras formas de licenciamento e de cessões para exploração de direitos não classificadas nas posições anteriores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '112011100', 'description' => 'Serviços de pesquisa e desenvolvimento em física', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112011200', 'description' => 'Serviços de pesquisa e desenvolvimento em química e biologia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.08],
            ['ncm' => '112011900', 'description' => 'Serviços de pesquisa e desenvolvimento em outras ciências naturais e exatas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112012100', 'description' => 'Serviços de pesquisa e desenvolvimento em biotecnologia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112012200', 'description' => 'Serviços de pesquisa e desenvolvimento em tecnologia da informação e comunicação (tic)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112012300', 'description' => 'Serviços de pesquisa e desenvolvimento em nanotecnologia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112012400', 'description' => 'Serviços de pesquisa e desenvolvimento em engenharia e tecnologia nucleares', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112012500', 'description' => 'Serviços de pesquisa e desenvolvimento em engenharia e tecnologia em microondas de potência', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112012900', 'description' => 'Serviços de pesquisa e desenvolvimento em outros ramos da  engenharia e tecnologia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112013000', 'description' => 'Serviços de pesquisa e desenvolvimento em  ciências médica, odontológica e farmacêutica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112014000', 'description' => 'Serviços de pesquisa e desenvolvimento em ciências agrárias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112019100', 'description' => 'Pesquisa tecnológica utilizando documentos de patentes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112019900', 'description' => 'Outros serviços de pesquisa e desenvolvimento em ciências naturais e engenharia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112021100', 'description' => 'Serviços de pesquisa e desenvolvimento em psicologia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112021200', 'description' => 'Serviços de pesquisa e desenvolvimento em ciências econômicas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112021300', 'description' => 'Serviços de pesquisa e desenvolvimento em direito', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112021900', 'description' => 'Serviços de pesquisa e desenvolvimento em outras ciências sociais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112022000', 'description' => 'Serviços de pesquisa e desenvolvimento em humanidades', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '112030000', 'description' => 'Serviços de pesquisa e desenvolvimento interdisciplinar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '113011000', 'description' => 'Serviços de representação e consultoria jurídica criminal', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '113012000', 'description' => 'Serviços de representação e consultoria jurídica em outras áreas do direito', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '113013000', 'description' => 'Serviços de documentação e certificação, exceto os serviços notariais e de registro', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '113014100', 'description' => 'Serviços de arbitragem, conciliação e mediação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '113014900', 'description' => 'Outros serviços jurídicos não classificados em outra posição', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.00],
            ['ncm' => '113021100', 'description' => 'Serviços de auditoria contábil', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '113021900', 'description' => 'Outros serviços de auditoria', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '113022100', 'description' => 'Serviços de contabilidade', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '113022200', 'description' => 'Serviços de escrituração mercantil', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '113022300', 'description' => 'Serviços de folha de pagamento', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '113022900', 'description' => 'Outros serviços de contabilidade e escrituração mercantil', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '113031000', 'description' => 'Serviços de consultoria tributária para pessoas jurídicas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '113032000', 'description' => 'Serviços de consultoria tributária para pessoas físicas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '113040000', 'description' => 'Serviços notariais e de registro', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '114011100', 'description' => 'Serviços de consultoria gerencial estratégica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.23],
            ['ncm' => '114011200', 'description' => 'Serviços de consultoria gerencial financeira', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '114011300', 'description' => 'Serviços de consultoria gerencial em recursos humanos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114011400', 'description' => 'Serviços de consultoria gerencial em marketing', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114011500', 'description' => 'Serviços de consultoria gerencial operacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.67],
            ['ncm' => '114011600', 'description' => 'Serviços de consultoria gerencial em energia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114011700', 'description' => 'Serviços de consultoria em logística', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114011800', 'description' => 'Serviços gerenciais em processos de negócios', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.06],
            ['ncm' => '114011900', 'description' => 'Outros serviços gerenciais e de consultoria gerencial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.05],
            ['ncm' => '114012000', 'description' => 'Serviços de relações públicas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114013100', 'description' => 'Serviços de assessoria de imprensa', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.15],
            ['ncm' => '114013900', 'description' => 'Outros serviços de comunicação social', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.15],
            ['ncm' => '114021100', 'description' => 'Serviços de consultoria em arquitetura', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114021200', 'description' => 'Serviços arquitetônicos para projetos de construções residenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114021300', 'description' => 'Serviços arquitetônicos para projetos de construções não residenciais ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114021400', 'description' => 'Serviços arquitetônicos para restauração de prédios históricos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114021500', 'description' => 'Serviços de arquitetura relativos ao acompanhamento e fiscalização da execução de projetos arquitetônicos e urbanísticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '114022100', 'description' => 'Serviços de planejamento urbano', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114022200', 'description' => 'Serviços de planejamento de áreas rurais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114023100', 'description' => 'Serviços de consultoria de paisagismo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114023200', 'description' => 'Serviços arquitetônicos de paisagismo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114029000', 'description' => 'Outros serviços de arquitetura, de planejamento urbano e de áreas rurais e de paisagismo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '114031000', 'description' => 'Serviços de consultoria de engenharia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032110', 'description' => 'Serviços de engenharia de projetos de construção residencial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032120', 'description' => 'Serviços de engenharia de projetos de construção não residencial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032200', 'description' => 'Serviços de engenharia de projetos industriais e de fabricação, exceto para projetos de energia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032300', 'description' => 'Serviços de engenharia para projetos de transportes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032410', 'description' => 'Serviços de engenharia para projetos de exploração de petróleo e gás', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032420', 'description' => 'Serviços de engenharia para projetos de refino de petróleo e petroquímica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032430', 'description' => 'Serviços de engenharia para projetos de unidades de produção de biocombustíveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032440', 'description' => 'Serviços de engenharia para projetos de energia elétrica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032490', 'description' => 'Outros serviços de engenharia para projetos de energia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032500', 'description' => 'Serviços de engenharia de projetos de radiodifusão e televisão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032600', 'description' => 'Serviços de engenharia de projetos de gerenciamento de resíduos (perigosos e não perigosos) ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032700', 'description' => 'Serviços de engenharia de projetos de distribuição de água e redes de esgotos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032800', 'description' => 'Serviços de engenharia de projetos de telecomunicação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032910', 'description' => 'Serviços de engenharia de projetos aeroespaciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114032920', 'description' => 'Serviços de engenharia para projetos de embarcações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '114032990', 'description' => 'Outros serviços de engenharia de projetos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114033000', 'description' => 'Serviços de gerenciamento de projetos de construção', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114039000', 'description' => 'Outros serviços de engenharia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '114041100', 'description' => 'Serviços de  consultoria geológica e geofísica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '114041200', 'description' => 'Serviços geofísicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114041300', 'description' => 'Serviços geoquímicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114041400', 'description' => 'Serviços de informações para avaliação e exploração de recursos naturais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114041900', 'description' => 'Outros serviços de prospecção', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114042100', 'description' => 'Serviços topográficos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '114042200', 'description' => 'Serviços cartográficos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '114043000', 'description' => 'Serviços meteorológicos e de previsão do tempo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.51],
            ['ncm' => '114044100', 'description' => 'Serviços de análise e de exames técnicos sobre pureza e composição', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '114044200', 'description' => 'Serviços de análise e de exames técnicos de propriedades físicas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '114044300', 'description' => 'Serviços de análise e de exames técnicos de sistemas elétricos e mecânicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '114044400', 'description' => 'Serviços de inspeção técnica de veículos de transporte rodoviários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '114044900', 'description' => 'Outros serviços de análise e de exames técnicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '114051010', 'description' => 'Serviços hospitalares, com ou sem internação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.18],
            ['ncm' => '114051090', 'description' => 'Outros serviços veterinários para animais domésticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.18],
            ['ncm' => '114052010', 'description' => 'Serviços hospitalares, com ou sem internação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.18],
            ['ncm' => '114052090', 'description' => 'Outros serviços veterinários para animais de corte', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.19],
            ['ncm' => '114053000', 'description' => 'Serviços funerários, de cremação e de embalsamamento de animais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.19],
            ['ncm' => '114059100', 'description' => 'Serviços de bancos de órgãos, sangue, sêmen, tecidos, óvulos e outros materiais biológicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.48],
            ['ncm' => '114059200', 'description' => 'Serviços de unidades de atendimento, assistência ou tratamento móvel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.27],
            ['ncm' => '114059300', 'description' => 'Planos de atendimento e assistência médico-veterinária', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.24],
            ['ncm' => '114059400', 'description' => 'Serviços de guarda, tratamento, adestramento, embelezamento e alojamento (hotel veterinário)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.24],
            ['ncm' => '114059900', 'description' => 'Outros serviços veterinários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.19],
            ['ncm' => '114061100', 'description' => 'Serviços de campanhas publicitárias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.06],
            ['ncm' => '114061200', 'description' => 'Serviços de marketing direto e mala direta', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.06],
            ['ncm' => '114061900', 'description' => 'Outros serviços de propaganda', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.13],
            ['ncm' => '114062000', 'description' => 'Aquisição ou venda de espaço ou tempo para propaganda, sob comissão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.06],
            ['ncm' => '114063100', 'description' => 'Venda de espaço para propaganda em mídia impressa, exceto sob comissão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.06],
            ['ncm' => '114063200', 'description' => 'Venda de tempo para propaganda em rádio e televisão, exceto sob comissão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.06],
            ['ncm' => '114063300', 'description' => 'Venda de espaço para propaganda na rede mundial de computadores, exceto sob comissão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.06],
            ['ncm' => '114063900', 'description' => 'Venda de espaço ou tempo para propaganda em outros meios de comunicação publicitária, exceto sob comissão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.06],
            ['ncm' => '114070000', 'description' => 'Pesquisas de mercado e serviços de pesquisa de opinião pública', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114081100', 'description' => 'Serviços fotográficos de retratos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.13],
            ['ncm' => '114081200', 'description' => 'Serviços fotográficos para propaganda', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.22],
            ['ncm' => '114081300', 'description' => 'Serviços fotográficos e videográficos de eventos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.22],
            ['ncm' => '114081400', 'description' => 'Serviços fotográficos especiais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.35],
            ['ncm' => '114081900', 'description' => 'Outros serviços fotográficos e videográficos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.22],
            ['ncm' => '114082000', 'description' => 'Serviços de processamento de fotografias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '114091110', 'description' => 'Serviços de projetos (design) de espaços comerciais e públicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114091190', 'description' => 'Outros serviços de projeto (design) de interiores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114091200', 'description' => 'Serviços de desenho industrial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.23],
            ['ncm' => '114091310', 'description' => 'Serviços de projetos (design) de marcas, imagens, objetos gráficos e digitais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114091320', 'description' => 'Serviços de projetos (design) de embalagens, expositores de loja e objetos promocionais para comunicação e vendas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114091330', 'description' => 'Serviços de projetos (design) de produtos, utensílios, equipamentos, vestuário, calçados, ornamentos, jóias joias e objetos pessoais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114091340', 'description' => 'Serviços de projetos (design) de máquinas, equipamentos, acessórios e objetos de uso industrial de qualquer natureza', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114091390', 'description' => 'Outros serviços projetos (design) originais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.22],
            ['ncm' => '114091900', 'description' => 'Outros serviços especializados de projeto (design)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.22],
            ['ncm' => '114092100', 'description' => 'Serviços de consultoria ambiental', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '114092900', 'description' => 'Outros serviços de consultoria técnica e científica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114093000', 'description' => 'Compilação e coletânea de fatos e informações originais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114094000', 'description' => 'Serviços de tradução e de intérpretes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '114095000', 'description' => 'Serviços para registros de marcas comerciais e de franquias empresariais, exceto as licenças de uso de direito', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '114099000', 'description' => 'Outros serviços profissionais, técnicos e gerenciais não classificados nas subposições anteriores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '115011000', 'description' => 'Serviços de consultoria em tecnologia da informação (ti)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '115012000', 'description' => 'Serviços de segurança em tecnologia da informação (ti)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '115013000', 'description' => 'Serviços de suporte em tecnologia da informação (ti) ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.70],
            ['ncm' => '115021000', 'description' => 'Serviços de projeto, desenvolvimento e instalação de aplicativos e programas não personalizados (não customizados)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115022000', 'description' => 'Serviços de projeto e desenvolvimento, adaptação e instalação de aplicativos personalizados (customizados)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115023000', 'description' => 'Serviços de projeto e desenvolvimento de estruturas e conteúdo de páginas eletrônicas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '115024000', 'description' => 'Serviços de projeto e desenvolvimento de estruturas e conteúdo de bancos de dados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115025000', 'description' => 'Serviços de integração de sistemas em tecnologia da informação (ti) ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115029000', 'description' => 'Outros serviços de projeto e desenvolvimento de aplicativos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.30],
            ['ncm' => '115030000', 'description' => 'Serviços de projeto e desenvolvimento de redes em tecnologia da informação (ti) ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115040000', 'description' => 'Serviços de projeto e desenvolvimento de topografias de circuitos integrados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115050000', 'description' => 'Serviços de projeto de circuitos integrados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115061000', 'description' => 'Serviços de hospedagem de sítios na rede mundial de computadores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115062000', 'description' => 'Serviços de hospedagem de aplicativos e programas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115069000', 'description' => 'Outros serviços de infraestrutura para hospedagem em tecnologia da informação (ti)  ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115071000', 'description' => 'Serviços de gerenciamento de redes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115072000', 'description' => 'Serviços de gerenciamento de sistemas computacionais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115079000', 'description' => 'Outros serviços de gerenciamento de infraestrutura de tecnologia da informação (ti)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115080000', 'description' => 'Serviços de manutenção de aplicativos e programas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115090000', 'description' => 'Serviços auxiliares de processamento de dados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '115900000', 'description' => 'Outros serviços de tecnologia da informação (ti)  ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '117011110', 'description' => 'Local', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117011120', 'description' => 'Nacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117011130', 'description' => 'Internacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117011210', 'description' => 'Local', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117011220', 'description' => 'Nacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117011230', 'description' => 'Internacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117011300', 'description' => 'Serviços de valor adicionado sobre serviços de telecomunicações fixos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117011400', 'description' => 'Serviços de gerência de redes fixas e administração de seus usuários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117011500', 'description' => 'Serviços de interconexão pelo uso da rede fixa', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117011900', 'description' => 'Outros serviços de telecomunicações fixas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012110', 'description' => 'Local', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012120', 'description' => 'Nacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012130', 'description' => 'Internacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012210', 'description' => 'Local', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012220', 'description' => 'Nacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012230', 'description' => 'Internacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012300', 'description' => 'Serviços de valor adicionado sobre serviços de telecomunicações móveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012400', 'description' => 'Serviços de gerência das redes móveis e administração de seus usuários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012500', 'description' => 'Serviços de interconexão pelo uso de rede móvel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012610', 'description' => 'Serviços de usuário visitante nacional (roaming nacional)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012620', 'description' => 'Serviços de usuário visitante internacional (roaming internacional)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012700', 'description' => 'Serviços nomádicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117012900', 'description' => 'Outros serviços de telecomunicações móveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117013010', 'description' => 'Serviços fixos de redes privativas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117013020', 'description' => 'Serviços móveis, nomádicos de uso privativo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117013031', 'description' => 'Serviços de interesse restrito de abrangência local', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117013032', 'description' => 'Serviços de interesse restrito de abrangência nacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117013033', 'description' => 'Serviços de interesse restrito de abrangência internacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117013040', 'description' => 'Serviços de valor adicionado sobre serviços de redes privadas ou de serviços de interesse restrito', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117014010', 'description' => 'Serviços de transmissão de dados local, nacional ou internacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117014020', 'description' => 'Serviços de exploração de linha dedicada local, nacional ou internacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117015010', 'description' => 'Serviços de distribuição de pacotes básicos de programação de televisão por assinatura', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117015020', 'description' => 'Serviços de distribuição de grades de programação especiais de televisão por assinatura', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '117015030', 'description' => 'Serviços de distribuição de programação através do sistema “pague e assista” (pay-per-view) de televisão por assinatura', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117015090', 'description' => 'Outros serviços de distribuição de programação de televisão por assinatura, inclusive os “pacotes combinados”', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117019000', 'description' => 'Outros serviços de telecomunicações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117021000', 'description' => 'Serviços de fornecimento de infraestrutura de acesso (backbone) à rede mundial de computadores ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117022100', 'description' => 'Serviços de acesso à rede mundial de computadores por conexão discada', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117022200', 'description' => 'Serviços de acesso à rede mundial de computadores por banda larga', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117029000', 'description' => 'Outros serviços na rede mundial de computadores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117031000', 'description' => 'Serviços de oferta de livros, jornais, periódicos, diretórios e listas de postagem de acesso imediato (on-line)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117032000', 'description' => 'Serviços de oferta de áudio, inclusive de conteúdo contínuo (streaming), de acesso imediato (on-line)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117033000', 'description' => 'Serviços de oferta de filmes e vídeos, inclusive de conteúdo contínuo (streaming), de acesso imediato (on-line) ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117034000', 'description' => 'Serviços de oferta de conteúdos que combinem duas ou mais mídias de acesso imediato (on-line)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117035000', 'description' => 'Serviços de conteúdo de portais de busca na rede mundial de computadores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117039000', 'description' => 'Outros serviços de conteúdos de acesso imediato (on-line) ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117041000', 'description' => 'Serviços de agências de notícias para jornais e periódicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '117042000', 'description' => 'Serviços de agências de notícias em mídia audiovisual', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '117049000', 'description' => 'Outros serviços de agências de notícias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '117051000', 'description' => 'Serviços de biblioteca', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '117052000', 'description' => 'Serviços de arquivo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '117061100', 'description' => 'Serviços de difusão de programas originais de rádio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117061210', 'description' => 'Serviços de difusão de programas originais para televisão aberta', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117061220', 'description' => 'Serviços de difusão de programas originais para televisão por assinatura', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117062100', 'description' => 'Serviços de programação dos canais de rádio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117062200', 'description' => 'Serviços de programação dos canais de televisão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117063000', 'description' => 'Serviços de distribuição de sinais de rádio e televisão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117064000', 'description' => 'Serviços de distribuição de programas de televisão aberta', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '117069000', 'description' => 'Outros serviços de difusão, programação e distribuição de programas de radio e televisão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '118011000', 'description' => 'Serviços de busca de empregos e encaminhamento de pessoal', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '118012100', 'description' => 'Serviços de fornecimento de mão de obra efetiva', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.17],
            ['ncm' => '118012200', 'description' => 'Serviços de fornecimento de mão de obra temporária', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.17],
            ['ncm' => '118019000', 'description' => 'Outros serviços de recrutamento e seleção de pessoal', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.17],
            ['ncm' => '118021000', 'description' => 'Serviços de investigação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.04],
            ['ncm' => '118022000', 'description' => 'Serviços de consultoria em segurança', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.04],
            ['ncm' => '118023000', 'description' => 'Serviços de sistemas de segurança', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.04],
            ['ncm' => '118024000', 'description' => 'Serviços de transporte de valores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.31],
            ['ncm' => '118025000', 'description' => 'Serviços de guarda e escolta armada', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.40],
            ['ncm' => '118029000', 'description' => 'Outros serviços de segurança', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.26],
            ['ncm' => '118031000', 'description' => 'Serviços de desinfecção e extermínio de pragas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.15],
            ['ncm' => '118032000', 'description' => 'Serviços gerais de limpeza', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '118033000', 'description' => 'Serviços especializados de limpeza', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '118041100', 'description' => 'Serviços de reservas em transportes aéreos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '118041900', 'description' => 'Outros serviços de planejamento e reserva em transportes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '118042100', 'description' => 'Serviços de reservas de hospedagem', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '118042200', 'description' => 'Serviços de reservas em cruzeiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '118042300', 'description' => 'Serviços de reservas de pacotes turísticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '118043000', 'description' => 'Outros serviços de reservas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '118044000', 'description' => 'Serviços de operadoras de turismo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '118045000', 'description' => 'Serviços de guias turísticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '118046100', 'description' => 'Serviços de promoção turística', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '118046200', 'description' => 'Serviços de informação a visitantes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '118051000', 'description' => 'Serviços de informação cadastral para fins de crédito', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.68],
            ['ncm' => '118052000', 'description' => 'Serviços de cobrança', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.84],
            ['ncm' => '118053100', 'description' => 'Serviços de telemarketing, incluindo serviços de atendimento ao cliente', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '118053900', 'description' => 'Outros serviços de apoio por meio de telefone', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '118054000', 'description' => 'Serviços combinados de escritório e apoio administrativo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '118055100', 'description' => 'Serviços de fotocópia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '118055200', 'description' => 'Serviços de execução de mala direta e de elaboração de listas de endereços', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '118055300', 'description' => 'Serviços de preparação de documentos e outros serviços especializados de apoio a escritórios', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '118056100', 'description' => 'Serviços de assistência e organização de convenções', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.30],
            ['ncm' => '118056200', 'description' => 'Serviços de assistência e organização de feiras de negócios', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.30],
            ['ncm' => '118056300', 'description' => 'Serviços de exploração de centros de convenções, escritórios virtuais, estandes de qualquer natureza, auditórios e os demais assemelhados para realização de eventos ou negócios de qualquer natureza', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.36],
            ['ncm' => '118056900', 'description' => 'Outros serviços de assistência e organização de feiras de negócios e convenções', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.30],
            ['ncm' => '118057000', 'description' => 'Serviços de jardinagem', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.39],
            ['ncm' => '118059011', 'description' => 'Serviços de leitura de medidores de eletricidade', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '118059012', 'description' => 'Serviços de leitura de medidores de gás', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '118059013', 'description' => 'Serviços de leitura de medidores de água', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '118059020', 'description' => 'Serviços de agências de modelos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.99],
            ['ncm' => '118059030', 'description' => 'Serviços de distribuição e venda de bilhetes e demais produtos de loteria, cartões, pules ou cupons de apostas, sorteios, prêmios, inclusive os decorrentes de títulos de capitalização e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.47],
            ['ncm' => '118059090', 'description' => 'Outros serviços de apoio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '119011000', 'description' => 'Serviços de apoio à agricultura', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.37],
            ['ncm' => '119012000', 'description' => 'Serviços de apoio à pecuária', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.37],
            ['ncm' => '119013000', 'description' => 'Serviços de apoio à produção florestal (silvicultura)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.37],
            ['ncm' => '119014000', 'description' => 'Serviços de apoio à pesca', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.37],
            ['ncm' => '119015000', 'description' => 'Serviços de apoio à aquicultura', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.37],
            ['ncm' => '119021000', 'description' => 'Serviços de apoio à extração de petróleo e gás', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.29],
            ['ncm' => '119029000', 'description' => 'Outros serviços de apoio à mineração', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.29],
            ['ncm' => '119031100', 'description' => 'Serviços de apoio à transmissão de eletricidade', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '119031200', 'description' => 'Serviços de apoio à distribuição de eletricidade', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '119032000', 'description' => 'Serviços de apoio à distribuição de gás por meio de tubulações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '119033000', 'description' => 'Serviços de apoio à distribuição de água', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '119034000', 'description' => 'Serviços de apoio à distribuição de ar condicionado, água quente e vapor por meio de tubulações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '120011000', 'description' => 'Serviços de manutenção e reparação de produtos metálicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '120012000', 'description' => 'Serviços de manutenção e reparação de computadores e seus periféricos e maquinário de escritório', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.70],
            ['ncm' => '120013100', 'description' => 'Serviços de manutenção e reparação de veículos automotores rodoviários', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '120013200', 'description' => 'Serviços de manutenção e reparação de reboques (trailers), semirreboques (semi-trailers) e outros veículos não motorizados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '120013300', 'description' => 'Serviços de manutenção e reparação de veículos militares', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '120013929', 'description' => 'Outros serviços de manutenção e reparação de embarcações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '120015100', 'description' => 'Serviços de manutenção e reparação de aparelhos eletro-eletrônicos domésticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.86],
            ['ncm' => '120015200', 'description' => 'Serviços de manutenção e reparação de equipamentos e aparelhos de telecomunicações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.86],
            ['ncm' => '120015300', 'description' => 'Serviços de manutenção e reparação de instrumentos e equipamentos médico-hospitalares, odontológicos, óticos e de precisão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.86],
            ['ncm' => '120015400', 'description' => 'Serviços de manutenção e reparação de equipamentos militares', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.86],
            ['ncm' => '120015910', 'description' => 'Serviços de manutenção e reparação de turbinas industriais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '120015990', 'description' => 'Outros serviços de manutenção e reparação de maquinário e equipamentos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '120021000', 'description' => 'Serviços de manutenção e reparação de produtos de couro, calçados, malas e bolsas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.87],
            ['ncm' => '120022000', 'description' => 'Serviços de manutenção e reparação de relógios e jóias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.05],
            ['ncm' => '120023000', 'description' => 'Serviços de manutenção e reparação de móveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '120029000', 'description' => 'Outros serviços de manutenção e reparação de outros bens de consumo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '120031000', 'description' => 'Serviços de instalação de produtos metálicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '120032100', 'description' => 'Serviços de montagem sob encomenda de turbinas industriais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '120032900', 'description' => 'Outros serviços de instalação de maquinário e equipamentos, industriais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '120033000', 'description' => 'Serviços de instalação de computadores e seus periféricos e maquinário de escritório', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.70],
            ['ncm' => '120034000', 'description' => 'Serviços de instalação de equipamentos e aparelhos de comunicação, incluindo de rádio e de televisão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '120035000', 'description' => 'Serviços de instalação de maquinários, equipamentos, instrumentos e aparelhos médico-hospitalares, óticos e de precisão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '120036000', 'description' => 'Serviços de instalação de sensores e sistemas de armas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '120037000', 'description' => 'Serviços de instalação de maquinários e equipamentos de emprego militar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '120038010', 'description' => 'Serviços de montagem sob encomenda de motores, turborreatores e turbopropulsores aeronáuticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '120038090', 'description' => 'Outros serviços de instalação de maquinários e equipamentos de transporte', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '120039000', 'description' => 'Serviços de instalação de maquinários e equipamentos não classificados em outra posição', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '121011000', 'description' => 'Serviços de editoração', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '121012100', 'description' => 'Serviços de impressão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '121012200', 'description' => 'Serviços relacionados à impressão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '121012300', 'description' => 'Serviços de reprodução de mídia gravada', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '121013000', 'description' => 'Serviços de apoio aos serviços de reprodução, impressão e editoração', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '121019000', 'description' => 'Outros serviços de reprodução, impressão e editoração', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '121900000', 'description' => 'Outros serviços de publicação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '122011100', 'description' => 'Serviços de creches ou de entidades equivalentes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122011200', 'description' => 'Serviços de pré-escola', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122011900', 'description' => 'Outros serviços de educação infantil', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122012000', 'description' => 'Serviços de ensino fundamental', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122013000', 'description' => 'Serviços de ensino médio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122020000', 'description' => 'Serviços de educação técnica de nível médio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122031000', 'description' => 'Serviços de alfabetização de jovens e adultos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122032000', 'description' => 'Serviços de ensino fundamental de jovens e adultos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122033000', 'description' => 'Serviços de ensino médio de jovens e adultos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122041000', 'description' => 'Serviços educacionais de graduação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122042000', 'description' => 'Serviços educacionais de pós-graduação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122043000', 'description' => 'Serviços educacionais de extensão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122044000', 'description' => 'Serviços educacionais de cursos sequenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122050000', 'description' => 'Serviços de educação especial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '122901100', 'description' => 'Serviços culturais, com enfoque educacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '122901200', 'description' => 'Serviços de educação desportiva e recreacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '122901300', 'description' => 'Serviços de educação em línguas estrangeiras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '122901910', 'description' => 'Serviços de palestras e conferências', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '122901990', 'description' => 'Outros serviços de educação e treinamento', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '122902000', 'description' => 'Serviços de apoio aos serviços educacionais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '123011100', 'description' => 'Serviços cirúrgicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.12],
            ['ncm' => '123011200', 'description' => 'Serviços ginecológicos e obstétricos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.11],
            ['ncm' => '123011300', 'description' => 'Serviços psiquiátricos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.14],
            ['ncm' => '123011400', 'description' => 'Serviços cardiológicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '123011500', 'description' => 'Serviços oncológicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.30],
            ['ncm' => '123011600', 'description' => 'Serviços aos recém-nascidos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123011700', 'description' => 'Serviços de ambulâncias, exceto aquelas sem envolver atendimento médico ao paciente e destinadas exclusivamente à remoção de enfermos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.15],
            ['ncm' => '123011800', 'description' => 'Serviços prestados em unidades de terapia intensiva', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.15],
            ['ncm' => '123011910', 'description' => 'Serviços de atendimento de urgência', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123011920', 'description' => 'Serviços conexos à saúde pública', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123011990', 'description' => 'Outros serviços hospitalares', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123012100', 'description' => 'Serviços de clínica médica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123012200', 'description' => 'Serviços médicos especializados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.31],
            ['ncm' => '123012300', 'description' => 'Serviços odontológicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.14],
            ['ncm' => '123019100', 'description' => 'Serviços de enfermagem', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.09],
            ['ncm' => '123019200', 'description' => 'Serviços fisioterapêuticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.14],
            ['ncm' => '123019300', 'description' => 'Serviços laboratoriais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123019400', 'description' => 'Serviços de diagnóstico por imagem', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.25],
            ['ncm' => '123019500', 'description' => 'Serviços de bancos de órgãos, esperma e sangue', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.08],
            ['ncm' => '123019600', 'description' => 'Serviços de bancos de leite, tecidos, olhos, ossos, óvulos e outros materiais biológicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.47],
            ['ncm' => '123019900', 'description' => 'Outros serviços de saúde humana, exceto os serviços hospitalares', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.73],
            ['ncm' => '123021000', 'description' => 'Serviços de consultoria em saúde', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '123029000', 'description' => 'Outros serviços de gestão hospitalar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '123030000', 'description' => 'Serviços domiciliares de apoio a idosos, crianças, adolescentes, pessoas com transtornos mentais e com deficiências', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123040000', 'description' => 'Serviços de apoio a idosos, crianças, adolescentes, pessoas com transtornos mentais e com deficiências, exceto domiciliar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '123051100', 'description' => 'Serviços de atenção integral à família', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123051200', 'description' => 'Serviços de convivência para crianças, adolescentes, jovens e idosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.38],
            ['ncm' => '123051300', 'description' => 'Serviços de apoio a à autonomia e à convivência familiar e comunitária', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123051900', 'description' => 'Outros serviços de proteção social básica', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.41],
            ['ncm' => '123052100', 'description' => 'Serviços de acolhida para adultos e idosos em albergues, abrigos ou moradias provisórias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123052200', 'description' => 'Serviços de acolhida para crianças e adolescentes em repúblicas, casas de acolhida, abrigos ou com “família acolhedora”', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123052300', 'description' => 'Serviços especiais de referência para pessoas com necessidades especiais, em situação de abandono, vítimas de negligência, abusos e formas de violência', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123052400', 'description' => 'Serviços de apoio a situações de risco circunstanciais em decorrência de calamidades públicas e emergenciais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123052500', 'description' => 'Serviços especiais de referência para adolescentes em cumprimento de medida socioeducativa de liberdade assistida e de prestação de serviços a à comunidade', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123052910', 'description' => 'Serviços de reabilitação vocacional', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123052990', 'description' => 'Outros serviços de assistência social', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '123060000', 'description' => 'Serviços de planos privados de assistência à saúde', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.14],
            ['ncm' => '124010000', 'description' => 'Serviços de tratamento de água', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124021000', 'description' => 'Serviços de esgoto e tratamento de esgotos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124022000', 'description' => 'Serviços de esvaziamento e limpeza de fossas sépticas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124031000', 'description' => 'Serviços de coleta de resíduos sólidos perigosos, exceto de serviços de saúde', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124032000', 'description' => 'Serviços de coleta de resíduos de serviços de saúde', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124033100', 'description' => 'Serviços de coleta de resíduos sólidos de origem doméstica, comercial e de varrição', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124033200', 'description' => 'Serviços de coleta de resíduos sólidos de origem industrial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124033300', 'description' => 'Serviços de coleta de resíduos sólidos recicláveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124033900', 'description' => 'Serviços de coleta de outros resíduos sólidos não perigosos, inertes ou não inertes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124034000', 'description' => 'Serviços de coleta de resíduos líquidos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124039000', 'description' => 'Outros serviços de coleta de resíduos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124041000', 'description' => 'Serviços de triagem, preparação, consolidação, estocagem e outros tratamentos e disposição de resíduos sólidos perigosos, exceto os resíduos de serviços de saúde', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124042000', 'description' => 'Serviços de triagem, preparação, consolidação, estocagem e outros tratamentos e disposição de resíduos de serviços de saúde', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124043100', 'description' => 'Serviços de triagem, preparação, consolidação, estocagem e outros tratamentos e disposição de resíduos de origem doméstica, comercial e de varrição', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124043200', 'description' => 'Serviços de triagem, preparação, consolidação, estocagem e outros tratamentos e disposição de resíduos sólidos de origem industrial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124043300', 'description' => 'Serviços de triagem, preparação, consolidação, estocagem e outros tratamentos e disposição de resíduos sólidos recicláveis', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124043900', 'description' => 'Serviços de triagem, preparação, consolidação, estocagem e outros tratamentos e disposição de outros resíduos sólidos não perigosos, inertes ou não inertes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124044000', 'description' => 'Serviços de triagem, preparação, consolidação, estocagem e outros tratamentos e disposição de resíduos líquidos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124049000', 'description' => 'Outros serviços de triagem, preparação, consolidação, estocagem e outros tratamentos e disposição de resíduos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124051000', 'description' => 'Serviços de varrição e limpeza de ruas e outros locais públicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124059000', 'description' => 'Outros serviços de saneamento', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '124061000', 'description' => 'Serviços ambientais relacionados à água', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.46],
            ['ncm' => '124062000', 'description' => 'Serviços ambientais relacionados ao solo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.37],
            ['ncm' => '124063000', 'description' => 'Serviços ambientais relacionados ao ar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124069000', 'description' => 'Outros serviços ambientais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124071100', 'description' => 'Serviços de remediação do ar', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124071200', 'description' => 'Serviços de remediação de águas de superfície', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124071300', 'description' => 'Serviços de remediação do solo e águas subterrâneas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124071400', 'description' => 'Serviços de remediação em edificações', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124072000', 'description' => 'Serviços de contenção de contaminantes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '124079000', 'description' => 'Outros serviços de remediação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '125011100', 'description' => 'Serviços de gravação de som em estúdio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125011200', 'description' => 'Serviços de gravação de som ao vivo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125012100', 'description' => 'Serviços de produção de programas de televisão, videoteipes e filmes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.26],
            ['ncm' => '125012200', 'description' => 'Serviços de produção de programas de rádio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.26],
            ['ncm' => '125013100', 'description' => 'Serviços de edição de obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125013200', 'description' => 'Serviços de duplicação e transferência de obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125013300', 'description' => 'Serviços de correção de cor e restauração digital de obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125013400', 'description' => 'Serviços de efeitos visuais em obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125013500', 'description' => 'Serviços de animação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125013600', 'description' => 'Serviços de legendas, títulos e dublagem em obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '125013700', 'description' => 'Serviços de projeto e edição de som em obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125013900', 'description' => 'Outros serviços de pós-produção em obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125014000', 'description' => 'Serviços de agenciamento pela comercialização de obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.00],
            ['ncm' => '125015000', 'description' => 'Serviços de projeção de filmes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '125019000', 'description' => 'Outros serviços de produção audiovisual, de apoio e relacionados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '125021000', 'description' => 'Serviços de organização e promoção de atuações artísticas ao vivo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.93],
            ['ncm' => '125022000', 'description' => 'Serviços de produção e apresentação de atuações artísticas ao vivo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.25],
            ['ncm' => '125023000', 'description' => 'Serviços de apoio para atuações artísticas ao vivo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '125029000', 'description' => 'Outros serviços de entretenimento artístico ao vivo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '125031000', 'description' => 'Serviços de atuação artística', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '125032000', 'description' => 'Serviços de autores, compositores, escultores, pintores e outros artistas, exceto os de atuação artística', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.99],
            ['ncm' => '125041100', 'description' => 'Serviços de museus', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '125041200', 'description' => 'Serviços de preservação e operação de locais e construções históricas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '125042100', 'description' => 'Serviços de jardins botânico e zoológico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '125042200', 'description' => 'Serviços de reserva natural, incluindo preservação de vida selvagem', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '125051100', 'description' => 'Serviços de organização e promoção de eventos desportivos e recreacionais desportivos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.20],
            ['ncm' => '125051200', 'description' => 'Serviços de clubes desportivos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.24],
            ['ncm' => '125059000', 'description' => 'Outros serviços de desportes e de recreação desportiva', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '125060000', 'description' => 'Serviços fornecidos por atletas e desportistas, por conta própria, e serviços de apoio relacionados com desportes e recreação desportiva', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.00],
            ['ncm' => '125071000', 'description' => 'Serviços de parques temáticos de diversão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.53],
            ['ncm' => '125079000', 'description' => 'Outros serviços de parques de diversão e atrações similares', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.31],
            ['ncm' => '125900000', 'description' => 'Outros serviços recreativos, culturais e desportivos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '126011000', 'description' => 'Serviços de limpeza de têxteis, exceto quando realizados a seco', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '126012000', 'description' => 'Serviços de limpeza a seco', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '126013000', 'description' => 'Serviços de tinturaria', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '126019000', 'description' => 'Outros serviços de lavanderia', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '126021000', 'description' => 'Serviços de cabeleireiros e barbeiros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.84],
            ['ncm' => '126022000', 'description' => 'Serviços de manicure, pedicure e tratamento cosmético', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.84],
            ['ncm' => '126023000', 'description' => 'Serviços de bem-estar físico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.63],
            ['ncm' => '126029000', 'description' => 'Outros tratamentos de beleza e bem-estar físico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '126030000', 'description' => 'Serviços funerários, de cremação e de embalsamamento', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.32],
            ['ncm' => '126900000', 'description' => 'Outros serviços pessoais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '127011000', 'description' => 'Cessão de direitos de obras literárias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127012000', 'description' => 'Cessão de direitos sobre programas de computador', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.11],
            ['ncm' => '127013100', 'description' => 'Cessão de direitos de obras cinematográficas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127013200', 'description' => 'Cessão de direitos de obras jornalísticas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127013300', 'description' => 'Cessão de direitos de obras publicitárias', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127013900', 'description' => 'Cessão de direitos de outras obras audiovisuais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127014000', 'description' => 'Cessão de direitos de obras musicais e outros fonogramas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127015000', 'description' => 'Cessão de direitos relacionados à radiodifusão', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127019000', 'description' => 'Cessão de outros direitos de autor e outros direitos conexos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127021000', 'description' => 'Cessão de direitos sobre patentes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127022000', 'description' => 'Cessão de direitos sobre marcas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127023000', 'description' => 'Cessão de direitos sobre desenho industrial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127029000', 'description' => 'Cessão de outros direitos sobre a propriedade industrial', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127030000', 'description' => 'Cessão de direitos sobre cultivares', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127040000', 'description' => 'Cessão de direitos sobre topografias de circuitos integrados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127050000', 'description' => 'Cessão de direitos relativos à informação não divulgada', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '127900000', 'description' => 'Cessão de outros direitos de propriedade intelectual não classificados em nenhuma das posições anteriores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '101', 'description' => 'Análise e desenvolvimento de sistemas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '102', 'description' => 'Programação.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '103', 'description' => 'Processamento de dados e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '104', 'description' => 'Elaboração de programas de computadores, inclusive de jogos eletrônicos.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.10],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '105', 'description' => 'Licenciamento ou cessão de direito de uso de programas de computação.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.11],
            ['ncm' => '106', 'description' => 'Assessoria e consultoria em informática.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '107', 'description' => 'Suporte técnico em informática, inclusive instalação, configuração e manutenção de programas de computação e bancos de dados.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.70],
            ['ncm' => '108', 'description' => 'Planejamento, confecção, manutenção e atualização de páginas eletrônicas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '201', 'description' => 'Serviços de pesquisas e desenvolvimento de qualquer natureza.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.16],
            ['ncm' => '301', 'description' => 'Vetado', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.66],
            ['ncm' => '302', 'description' => 'Cessão de direito de uso de marcas e de sinais de propaganda.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '303', 'description' => 'Exploração de salões de festas, centro de convenções, escritórios virtuais, stands, quadras esportivas, estádios, ginásios, auditórios, casas de espetáculos, parques de diversões, canchas e congêneres, para realização de eventos ou negócios de qualquer na', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.42],
            ['ncm' => '304', 'description' => 'Locação, sublocação, arrendamento, direito de passagem ou permissão de uso, compartilhado ou não, de ferrovia, rodovia, postes, cabos, dutos e condutos de qualquer natureza.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.44],
            ['ncm' => '305', 'description' => 'Cessão de andaimes, palcos, coberturas e outras estruturas de uso temporário.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.28],
            ['ncm' => '401', 'description' => 'Medicina e biomedicina.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.25],
            ['ncm' => '402', 'description' => 'Análises clínicas, patologia, eletricidade médica, radioterapia, quimioterapia, ultra-sonografia, ressonância magnética, radiologia, tomografia e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.30],
            ['ncm' => '403', 'description' => 'Hospitais, clínicas, laboratórios, sanatórios, manicômios, casas de saúde, prontos-socorros, ambulatórios e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.69],
            ['ncm' => '404', 'description' => 'Instrumentação cirúrgica.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.12],
            ['ncm' => '405', 'description' => 'Acupuntura.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.12],
            ['ncm' => '406', 'description' => 'Enfermagem, inclusive serviços auxiliares.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.09],
            ['ncm' => '407', 'description' => 'Serviços farmacêuticos.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.73],
            ['ncm' => '408', 'description' => 'Terapia ocupacional, fisioterapia e fonoaudiologia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.14],
            ['ncm' => '409', 'description' => 'Terapias de qualquer espécie destinadas ao tratamento físico, orgânico e mental.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.14],
            ['ncm' => '410', 'description' => 'Nutrição.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.11],
            ['ncm' => '411', 'description' => 'Obstetrícia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.11],
            ['ncm' => '412', 'description' => 'Odontologia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.13],
            ['ncm' => '413', 'description' => 'Ortóptica.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.71],
            ['ncm' => '414', 'description' => 'Próteses sob encomenda.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.04],
            ['ncm' => '415', 'description' => 'Psicanálise.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.14],
            ['ncm' => '416', 'description' => 'Psicologia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.74],
            ['ncm' => '417', 'description' => 'Casas de repouso e de recuperação, creches, asilos e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.07],
            ['ncm' => '418', 'description' => 'Inseminação artificial, fertilização in vitro e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.15],
            ['ncm' => '419', 'description' => 'Bancos de sangue, leite, pele, olhos, óvulos, sêmen e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.08],
            ['ncm' => '420', 'description' => 'Coleta de sangue, leite, tecidos, sêmen, órgãos e materiais biológicos de qualquer espécie.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.80],
            ['ncm' => '421', 'description' => 'Unidade de atendimento, assistência ou tratamento móvel e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.15],
            ['ncm' => '422', 'description' => 'Planos de medicina de grupo ou individual e convênios para prestação de assistência médica, hospitalar, odontológica e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.14],
            ['ncm' => '423', 'description' => 'Outros planos de saúde que se cumpram através de serviços de terceiros contratados, credenciados, cooperados ou apenas pagos pelo operador do plano mediante indicação do beneficiário.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.15],
            ['ncm' => '501', 'description' => 'Medicina veterinária e zootecnia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.19],
            ['ncm' => '502', 'description' => 'Hospitais, clínicas, ambulatórios, prontos-socorros e congêneres, na área veterinária.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.18],
            ['ncm' => '503', 'description' => 'Laboratórios de análise na área veterinária.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.19],
            ['ncm' => '504', 'description' => 'Inseminação artificial, fertilização in vitro e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.19],
            ['ncm' => '505', 'description' => 'Bancos de sangue e de órgãos e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.13],
            ['ncm' => '506', 'description' => 'Coleta de sangue, leite, tecidos, sêmen, órgãos e materiais biológicos de qualquer espécie.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.82],
            ['ncm' => '507', 'description' => 'Unidade de atendimento, assistência ou tratamento móvel e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.27],
            ['ncm' => '508', 'description' => 'Guarda, tratamento, amestramento, embelezamento, alojamento e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.24],
            ['ncm' => '509', 'description' => 'Planos de atendimento e assistência médico-veterinária.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.24],
            ['ncm' => '601', 'description' => 'Barbearia, cabeleireiros, manicuros, pedicuros e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.84],
            ['ncm' => '602', 'description' => 'Esteticistas, tratamento de pele, depilação e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '603', 'description' => 'Banhos, duchas, sauna, massagens e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '604', 'description' => 'Ginástica, dança, esportes, natação, artes marciais e demais atividades físicas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.01],
            ['ncm' => '605', 'description' => 'Centros de emagrecimento, spa e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.25],
            ['ncm' => '701', 'description' => 'Engenharia, agronomia, agrimensura, arquitetura, geologia, urbanismo, paisagismo e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '702', 'description' => 'Execução, por administração, empreitada ou subempreitada, de obras de construção civil, hidráulica ou elétrica e de outras obras semelhantes, inclusive sondagem, perfuração de poços, escavação, drenagem e irrigação, terraplanagem, pavimentação, concretage', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '703', 'description' => 'Elaboração de planos diretores, estudos de viabilidade, estudos organizacionais e outros, relacionados com obras e serviços de engenharia, elaboração de anteprojetos, projetos básicos e projetos executivos para trabalhos de engenharia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.26],
            ['ncm' => '704', 'description' => 'Demolição.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '705', 'description' => 'Reparação, conservação e reforma de edifícios, estradas, pontes, portos e congêneres  exceto o fornecimento de mercadorias produzidas pelo prestador dos serviços, fora do local da prestação dos serviços, que fica sujeito ao icms .', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '706', 'description' => 'Colocação e instalação de tapetes, carpetes, assoalhos, cortinas, revestimentos de parede, vidros, divisórias, placas de gesso e congêneres, com material fornecido pelo tomador do serviço.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.34],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '707', 'description' => 'Recuperação, raspagem, polimento e lustração de pisos e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.23],
            ['ncm' => '708', 'description' => 'Calafetação.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.21],
            ['ncm' => '709', 'description' => 'Varrição, coleta, remoção, incineração, tratamento, reciclagem, separação e destinação final de lixo, rejeitos e outros resíduos quaisquer.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.53],
            ['ncm' => '710', 'description' => 'Limpeza, manutenção e conservação de vias e logradouros públicos, imóveis, chaminés, piscinas, parques, jardins e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 5.00],
            ['ncm' => '711', 'description' => 'Decoração e jardinagem, inclusive corte e poda de árvores.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.39],
            ['ncm' => '712', 'description' => 'Controle e tratamento de efluentes de qualquer natureza e de agentes físicos, químicos e biológicos.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.52],
            ['ncm' => '713', 'description' => 'Dedetização, desinfecção, desinsetização, imunização, higienização, desratização, pulverização e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.15],
            ['ncm' => '714', 'description' => 'Vetado', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '715', 'description' => 'Vetado', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.12],
            ['ncm' => '716', 'description' => 'Florestamento, reflorestamento, semeadura, adubação e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.37],
            ['ncm' => '717', 'description' => 'Escoramento, contenção de encostas e serviços congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.36],
            ['ncm' => '718', 'description' => 'Limpeza e dragagem de rios, portos, canais, baías, lagos, lagoas, represas, açudes e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.41],
            ['ncm' => '719', 'description' => 'Acompanhamento e fiscalização da execução de obras de engenharia, arquitetura e urbanismo.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.38],
            ['ncm' => '720', 'description' => 'Aerofotogrametria  inclusive interpretação , cartografia, mapeamento, levantamentos topográficos, batimétricos, geográficos, geodésicos, geológicos, geofísicos e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '721', 'description' => 'Pesquisa, perfuração, cimentação, mergulho, perfilagem, concretação, testemunhagem, pescaria, estimulação e outros serviços relacionados com a exploração e explotação de petróleo, gás natural e de outros recursos minerais.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.29],
            ['ncm' => '722', 'description' => 'Nucleação e bombardeamento de nuvens e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.26],
            ['ncm' => '801', 'description' => 'Ensino regular pré-escolar, fundamental, médio e superior.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.06],
            ['ncm' => '802', 'description' => 'Instrução, treinamento, orientação pedagógica e educacional, avaliação de conhecimentos de qualquer natureza.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.08],
            ['ncm' => '901', 'description' => 'Hospedagem de qualquer natureza em hotéis, apart-service condominiais, flat, apart-hotéis, hotéis residência, residence-service, suite service, hotelaria marítima, motéis, pensões e congêneres, ocupação por temporada com fornecimento de serviço  o valor d', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '902', 'description' => 'Agenciamento, organização, promoção, intermediação e execução de programas de turismo, passeios, viagens, excursões, hospedagens e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '903', 'description' => 'Guias de turismo.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '1001', 'description' => 'Agenciamento, corretagem ou intermediação de câmbio, de seguros, de cartões de crédito, de planos de saúde e de planos de previdência privada.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.98],
            ['ncm' => '1002', 'description' => 'Agenciamento, corretagem ou intermediação de títulos em geral, valores mobiliários e contratos quaisquer.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.04],
            ['ncm' => '1003', 'description' => 'Agenciamento, corretagem ou intermediação de direitos de propriedade industrial, artística ou literária.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.08],
            ['ncm' => '1004', 'description' => 'Agenciamento, corretagem ou intermediação de contratos de arrendamento mercantil  leasing , de franquia  franchising  e de faturização  factoring .', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '1005', 'description' => 'Agenciamento, corretagem ou intermediação de bens móveis ou imóveis, não abrangidos em outros itens ou subitens, inclusive aqueles realizados no âmbito de bolsas de mercadorias e futuros, por quaisquer meios.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '1006', 'description' => 'Agenciamento marítimo.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.06],
            ['ncm' => '1007', 'description' => 'Agenciamento de notícias.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '1008', 'description' => 'Agenciamento de publicidade e propaganda, inclusive o agenciamento de veiculação por quaisquer meios.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '1009', 'description' => 'Representação de qualquer natureza, inclusive comercial.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '1010', 'description' => 'Distribuição de bens de terceiros.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.14],
            ['ncm' => '1101', 'description' => 'Guarda e estacionamento de veículos terrestres automotores, de aeronaves e de embarcações.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '1102', 'description' => 'Vigilância, segurança ou monitoramento de bens e pessoas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.26],
            ['ncm' => '1103', 'description' => 'Escolta, inclusive de veículos e cargas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.40],
            ['ncm' => '1104', 'description' => 'Armazenamento, depósito, carga, descarga, arrumação e guarda de bens de qualquer espécie.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.21],
            ['ncm' => '1201', 'description' => 'Espetáculos teatrais.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.14],
            ['ncm' => '1202', 'description' => 'Exibições cinematográficas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.11],
            ['ncm' => '1203', 'description' => 'Espetáculos circenses.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.30],
            ['ncm' => '1204', 'description' => 'Programas de auditório.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.35],
            ['ncm' => '1205', 'description' => 'Parques de diversões, centros de lazer e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.53],
            ['ncm' => '1206', 'description' => 'Boates, taxi-dancing e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.48],
            ['ncm' => '1207', 'description' => 'Shows, ballet, danças, desfiles, bailes, óperas, concertos, recitais, festivais e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.39],
            ['ncm' => '1208', 'description' => 'Feiras, exposições, congressos e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.37],
            ['ncm' => '1209', 'description' => 'Bilhares, boliches e diversões eletrônicas ou não.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.34],
            ['ncm' => '1210', 'description' => 'Corridas e competições de animais.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.20],
            ['ncm' => '1211', 'description' => 'Competições esportivas ou de destreza física ou intelectual, com ou sem a participação do espectador.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.24],
            ['ncm' => '1212', 'description' => 'Execução de música.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '1213', 'description' => 'Produção, mediante ou sem encomenda prévia, de eventos, espetáculos, entrevistas, shows, ballet, danças, desfiles, bailes, teatros, óperas, concertos, recitais, festivais e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '1214', 'description' => 'Fornecimento de música para ambientes fechados ou não, mediante transmissão por qualquer processo.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '1215', 'description' => 'Desfiles de blocos carnavalescos ou folclóricos, trios elétricos e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.05],
            ['ncm' => '1216', 'description' => 'Exibição de filmes, entrevistas, musicais, espetáculos, shows, concertos, desfiles, óperas, competições esportivas, de destreza intelectual ou congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.26],
            ['ncm' => '1217', 'description' => 'Recreação e animação, inclusive em festas e eventos de qualquer natureza.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '1301', 'description' => 'Vetado', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.89],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '1302', 'description' => 'Fonografia ou gravação de sons, inclusive trucagem, dublagem, mixagem e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.13],
            ['ncm' => '1303', 'description' => 'Fotografia e cinematografia, inclusive revelação, ampliação, cópia, reprodução, trucagem e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.22],
            ['ncm' => '1304', 'description' => 'Reprografia, microfilmagem e digitalização.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.35],
            ['ncm' => '1305', 'description' => 'Composição gráfica, fotocomposição, clicheria, zincografia, litografia, fotolitografia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.22],
            ['ncm' => '1401', 'description' => 'Lubrificação, limpeza, lustração, revisão, carga e recarga, conserto, restauração, blindagem, manutenção e conservação de máquinas, veículos, aparelhos, equipamentos, motores, elevadores ou de qualquer objeto  exceto peças e partes empregadas, que ficam s', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.90],
            ['ncm' => '1402', 'description' => 'Assistência técnica.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.82],
            ['ncm' => '1403', 'description' => 'Recondicionamento de motores  exceto peças e partes empregadas, que ficam sujeitas ao icms .', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.30],
            ['ncm' => '1404', 'description' => 'Recauchutagem ou regeneração de pneus.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '1405', 'description' => 'Restauração, recondicionamento, acondicionamento, pintura, beneficiamento, lavagem, secagem, tingimento, galvanoplastia, anodização, corte, recorte, polimento, plastificação e congêneres, de objetos quaisquer.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '1406', 'description' => 'Instalação e montagem de aparelhos, máquinas e equipamentos, inclusive montagem industrial, prestados ao usuário final, exclusivamente com material por ele fornecido.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '1407', 'description' => 'Colocação de molduras e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '1408', 'description' => 'Encadernação, gravação e douração de livros, revistas e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.15],
            ['ncm' => '1409', 'description' => 'Alfaiataria e costura, quando o material for fornecido pelo usuário final, exceto aviamento.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.87],
            ['ncm' => '1410', 'description' => 'Tinturaria e lavanderia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '1411', 'description' => 'Tapeçaria e reforma de estofamentos em geral.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '1412', 'description' => 'Funilaria e lanternagem.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.33],
            ['ncm' => '1413', 'description' => 'Carpintaria e serralheria.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.26],
            ['ncm' => '1501', 'description' => 'Administração de fundos quaisquer, de consórcio, de cartão de crédito ou débito e congêneres, de carteira de clientes, de cheques pré-datados e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.15],
            ['ncm' => '1502', 'description' => 'Abertura de contas em geral, inclusive conta-corrente, conta de investimentos e aplicação e caderneta de poupança, no país e no exterior, bem como a manutenção das referidas contas ativas e inativas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.78],
            ['ncm' => '1503', 'description' => 'Locação e manutenção de cofres particulares, de terminais eletrônicos, de terminais de atendimento e de bens e equipamentos em geral.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.67],
            ['ncm' => '1504', 'description' => 'Fornecimento ou emissão de atestados em geral, inclusive atestado de idoneidade, atestado de capacidade financeira e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '1505', 'description' => 'Cadastro, elaboração de ficha cadastral, renovação cadastral e congêneres, inclusão ou exclusão no cadastro de emitentes de cheques sem fundos ccf ou em quaisquer outros bancos cadastrais.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.68],
            ['ncm' => '1506', 'description' => 'Emissão, reemissão e fornecimento de avisos, comprovantes e documentos em geral, abono de firmas, coleta e entrega de documentos, bens e valores, comunicação com outra agência ou com a administração central, licenciamento eletrônico de veículos, transferê', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '1507', 'description' => 'Acesso, movimentação, atendimento e consulta a contas em geral, por qualquer meio ou processo, inclusive por telefone, fac-símile, internet e telex, acesso a terminais de atendimento, inclusive vinte e quatro horas, acesso a outro banco e a rede compartil', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '1508', 'description' => 'Emissão, reemissão, alteração, cessão, substituição, cancelamento e registro de contrato de crédito, estudo, análise e avaliação de operações de crédito, emissão, concessão, alteração ou contratação de aval, fiança, anuência e congêneres, serviços relativ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '1509', 'description' => 'Arrendamento mercantil  leasing  de quaisquer bens, inclusive cessão de direitos e obrigações, substituição de garantia, alteração, cancelamento e registro de contrato, e demais serviços relacionados ao arrendamento mercantil  leasing .', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.90],
            ['ncm' => '1510', 'description' => 'Serviços relacionados a cobranças, recebimentos ou pagamentos em geral, de títulos quaisquer, de contas ou carnês, de câmbio, de tributos e por conta de terceiros, inclusive os efetuados por meio eletrônico, automático ou por máquinas de atendimento, forn', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.84],
            ['ncm' => '1511', 'description' => 'Devolução de títulos, protesto de títulos, sustação de protesto, manutenção de títulos, reapresentação de títulos, e demais serviços a eles relacionados.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '1512', 'description' => 'Custódia em geral, inclusive de títulos e valores mobiliários.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '1513', 'description' => 'Serviços relacionados a operações de câmbio em geral, edição, alteração, prorrogação, cancelamento e baixa de contrato de câmbio, emissão de registro de exportação ou de crédito, cobrança ou depósito no exterior, emissão, cancelamento e demais serviços re', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.71],
            ['ncm' => '1514', 'description' => 'Fornecimento, emissão, reemissão, renovação e manutenção de cartão magnético, cartão de crédito, cartão de débito, cartão salário e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.84],
            ['ncm' => '1515', 'description' => 'Compensação de cheques e títulos quaisquer, serviços relacionados a depósito, inclusive depósito identificado, a saque de contas quaisquer, por qualquer meio ou processo, inclusive em terminais eletrônicos e de atendimento.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.82],
            ['ncm' => '1516', 'description' => 'Emissão, reemissão, liquidação, alteração, cancelamento e baixa de ordens de pagamento, ordens de crédito e similares, por qualquer meio ou processo, serviços relacionados à transferência de valores, dados, fundos, pagamentos e similares, inclusive entre ', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.77],
            ['ncm' => '1517', 'description' => 'Emissão, fornecimento, devolução, sustação, cancelamento e oposição de cheques quaisquer, avulso ou por talão.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.77],
            ['ncm' => '1518', 'description' => 'Serviços relacionados a crédito imobiliário, avaliação e vistoria de imóvel ou obra, análise técnica e jurídica, emissão, reemissão, alteração, transferência e renegociação de contrato, emissão e reemissão do termo de quitação e demais serviços relacionad', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.67],
            ['ncm' => '1601', 'description' => 'Serviços de transporte de natureza municipal.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.45],
            ['ncm' => '1701', 'description' => 'Assessoria ou consultoria de qualquer natureza, não contida em outros itens desta lista, análise, exame, pesquisa, coleta, compilação e fornecimento de dados e informações de qualquer natureza, inclusive cadastro e similares.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.09],
            ['ncm' => '1702', 'description' => 'Datilografia, digitação, estenografia, expediente, secretaria em geral, resposta audível, redação, edição, interpretação, revisão, tradução, apoio e infra-estrutura administrativa e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.96],
            ['ncm' => '1703', 'description' => 'Planejamento, coordenação, programação ou organização técnica, financeira ou administrativa.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '1704', 'description' => 'Recrutamento, agenciamento, seleção e colocação de mão-de-obra.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '1705', 'description' => 'Fornecimento de mão-de-obra, mesmo em caráter temporário, inclusive de empregados ou trabalhadores, avulsos ou temporários, contratados pelo prestador de serviço.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.17],
            ['ncm' => '1706', 'description' => 'Propaganda e publicidade, inclusive promoção de vendas, planejamento de campanhas ou sistemas de publicidade, elaboração de desenhos, textos e demais materiais publicitários.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '1707', 'description' => 'Vetado', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.68],
            ['ncm' => '1708', 'description' => 'Franquia  franchising .', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '1709', 'description' => 'Perícias, laudos, exames técnicos e análises técnicas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.37],
            ['ncm' => '1710', 'description' => 'Planejamento, organização e administração de feiras, exposições, congressos e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.30],
            ['ncm' => '1711', 'description' => 'Organização de festas e recepções, bufê  exceto o fornecimento de alimentação e bebidas, que fica sujeito ao icms .', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '1712', 'description' => 'Administração em geral, inclusive de bens e negócios de terceiros.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '1713', 'description' => 'Leilão e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.00],
            ['ncm' => '1714', 'description' => 'Advocacia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '1715', 'description' => 'Arbitragem de qualquer espécie, inclusive jurídica.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.94],
            ['ncm' => '1716', 'description' => 'Auditoria.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '1717', 'description' => 'Análise de organização e métodos.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.04],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '1718', 'description' => 'Atuária e cálculos técnicos de qualquer natureza.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.03],
            ['ncm' => '1719', 'description' => 'Contabilidade, inclusive serviços técnicos e auxiliares.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.18],
            ['ncm' => '1720', 'description' => 'Consultoria e assessoria econômica ou financeira.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.91],
            ['ncm' => '1721', 'description' => 'Estatística.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.14],
            ['ncm' => '1722', 'description' => 'Cobrança em geral.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.42],
            ['ncm' => '1723', 'description' => 'Assessoria, análise, avaliação, atendimento, consulta, cadastro, seleção, gerenciamento de informações, administração de contas a receber ou a pagar e em geral, relacionados a operações de faturização  factoring .', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.14],
            ['ncm' => '1724', 'description' => 'Apresentação de palestras, conferências, seminários e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 2.44],
            ['ncm' => '1801', 'description' => 'Serviços de regulação de sinistros vinculados a contratos de seguros, inspeção e avaliação de riscos para cobertura de contratos de seguros, prevenção e gerência de riscos seguráveis e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '1901', 'description' => 'Serviços de distribuição e venda de bilhetes e demais produtos de loteria, bingos, cartões, pules ou cupons de apostas, sorteios, prêmios, inclusive os decorrentes de títulos de capitalização e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.47],
            ['ncm' => '2001', 'description' => 'Serviços portuários, ferroportuários, utilização de porto, movimentação de passageiros, reboque de embarcações, rebocador escoteiro, atracação, desatracação, serviços de praticagem, capatazia, armazenagem de qualquer natureza, serviços acessórios, serviço', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.28],
            ['ncm' => '2002', 'description' => 'Serviços aeroportuários, utilização de aeroporto, movimentação de passageiros, armazenagem de qualquer natureza, capatazia, movimentação de aeronaves, serviços de apoio aeroportuários, serviços acessórios, movimentação de mercadorias, logística e congêner', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.39],
            ['ncm' => '2003', 'description' => 'Serviços de terminais rodoviários, ferroviários, metroviários, movimentação de passageiros, mercadorias, inclusive suas operações, logística e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.01],
            ['ncm' => '2101', 'description' => 'Serviços de registros públicos, cartorários e notariais.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '2201', 'description' => 'Serviços de exploração de rodovia mediante cobrança de preço ou pedágio dos usuários, envolvendo execução de serviços de conservação, manutenção, melhoramentos para adequação de capacidade e segurança de trânsito, operação, monitoração, assistência aos us', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.79],
            ['ncm' => '2301', 'description' => 'Serviços de programação e comunicação visual, desenho industrial e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.27],
            ['ncm' => '2401', 'description' => 'Serviços de chaveiros, confecção de carimbos, placas, sinalização visual, banners, adesivos e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.23],
            ['ncm' => '2501', 'description' => 'Funerais, inclusive fornecimento de caixão, urna ou esquifes, aluguel de capela, transporte do corpo cadavérico, fornecimento de flores, coroas e outros paramentos, desembaraço de certidão de óbito, fornecimento de véu, essa e outros adornos, embalsamento', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.29],
            ['ncm' => '2502', 'description' => 'Cremação de corpos e partes de corpos cadavéricos.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.47],
            ['ncm' => '2503', 'description' => 'Planos ou convênio funerários.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.20],
            ['ncm' => '2504', 'description' => 'Manutenção e conservação de jazigos e cemitérios.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.32],
            ['ncm' => '2601', 'description' => 'Serviços de coleta, remessa ou entrega de correspondências, documentos, objetos, bens ou valores, inclusive pelos correios e suas agências franqueadas, courrier e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.31],
            ['ncm' => '2701', 'description' => 'Serviços de assistência social.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.12],
            ['ncm' => '2801', 'description' => 'Serviços de avaliação de bens e serviços de qualquer natureza.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '2901', 'description' => 'Serviços de biblioteconomia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.10],
            ['ncm' => '3001', 'description' => 'Serviços de biologia, biotecnologia e química.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.00],
            ['ncm' => '3101', 'description' => 'Serviços técnicos em edificações, eletrônica, eletrotécnica, mecânica, telecomunicações e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],
            ['ncm' => '3201', 'description' => 'Serviços de desenhos técnicos.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.12],
            ['ncm' => '3301', 'description' => 'Serviços de desembaraço aduaneiro, comissários, despachantes e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.04],
            ['ncm' => '3401', 'description' => 'Serviços de investigações particulares, detetives e congêneres.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.04],
            ['ncm' => '3501', 'description' => 'Serviços de reportagem, assessoria de imprensa, jornalismo e relações públicas.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.15],
            ['ncm' => '3601', 'description' => 'Serviços de meteorologia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.16],
            ['ncm' => '3701', 'description' => 'Serviços de artistas, atletas, modelos e manequins.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 3.99],
            ['ncm' => '3801', 'description' => 'Serviços de museologia.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.17],
            ['ncm' => '3901', 'description' => 'Serviços de ourivesaria e lapidação  quando o material for fornecido pelo tomador do serviço .', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.19],
            ['ncm' => '4001', 'description' => 'Obras de arte sob encomenda.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 4.07],


        ];

        DB::table('ncm')->insert($data);

    }
}
