document.addEventListener("DOMContentLoaded", function() {
	var data = {action: 'getEstoques'};
	$.post('estoque/resources/php/listagem_functions.php', data, function(dados) {
		var linha = '';
		for (var i = 0; i < dados.length; i++) {
			var tipo = "Não é origem";
			if(dados[i].flOrigem == 1){
				tipo = "É origem";
			}
			linha += '<tr><td>'+dados[i].stEstoque+'</td>';
			linha += '<td>'+tipo+'</td>';
			linha += '<td>';
			if(dados[i].idEstoque != 1 && dados[i].idEstoque != 2){
				linha += '<a onclick="editEstoque('+dados[i].idEstoque+')" style="cursor:pointer"><span class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
				linha += '<a onclick="deleteEstoque('+dados[i].idEstoque+')" style="cursor:pointer"><span class="glyphicon glyphicon-remove col-md-6" align="center" title="Remover"></span></a>';
			}
			linha += '</td></tr>';
		}
		$(linha).appendTo($("#bodyListagemEstoques"));
	});
});

function editEstoque (idEstoque) {
	var data ={action: 'getEstoqueById', idEstoque: idEstoque};
	$.post('estoque/resources/php/listagem_functions.php', data, function(dados) {
		$("#idEstoqueModal").val(dados.idEstoque);
		$("#stEstoqueModal").val(dados.stEstoque);
		$("#origemEstoqueModal").val(dados.flOrigem);
		if(dados.flAtivarSaldo > 0){
			$("#checkSaldoModal").attr("checked", "checked");
		} 
		$("#tituloModalEstoque").html("Edição de Estoque");
		$("#modalEstoque").modal('show');
	});
}

function novoEstoque () {
	$("#tituloModalEstoque").html("Cadastro de Estoque");
	$("#modalEstoque").modal('show');
}

function cadastrarEstoque () {
	toastr.options = 
	{
		"positionClass": "toast-bottom-right"
	}
	var idEstoque = $("#idEstoqueModal").val();
	var stEstoque = $("#stEstoqueModal").val();
	var flOrigemEstoque = $("#origemEstoqueModal").val();
	var flSaldoEstoque = $("#checkSaldoModal").is(':checked');
	if(stEstoque.length <= 0){
		toastr.error("Não é possível salvar um estoque sem nome.");
		return false;
	}
	var data = {action: 'cadastraEstoque', idEstoque: idEstoque, stEstoque: stEstoque, flOrigemEstoque: flOrigemEstoque, flSaldoEstoque: flSaldoEstoque};
	$.post('estoque/resources/php/listagem_functions.php', data, function(response) {
		if(response.status){
			toastr.success(response.msg);
			setTimeout("location.reload()", 1500);
		}else{
			toastr.error(response.msg);
		} 
	});
}

function deleteEstoque (idEstoque) {
	toastr.options = 
	{
		"positionClass": "toast-bottom-right"
	}

	swal({   
		title: 'Tem certeza?',   
		text: 'Deletar um estoque é uma ação definitiva',   
		type: 'warning',   
		showCancelButton: true,   
		confirmButtonColor: '#2A98D3',   
		cancelButtonColor: '#FF2727',   
		confirmButtonText: 'Continuar',
		cancelButtonText: 'Cancelar',   
		closeOnConfirm: true 
	}, function() { 
		$("body").addClass("loading");
		var data = {action: 'deleteEstoque', idEstoque: idEstoque}
		$.post('estoque/resources/php/listagem_functions.php', data, function (response) {
			$("body").removeClass("loading");
			if(response.status){
				toastr.success(response.msg);
				setTimeout("location.reload()", 1500);
			}else{
				toastr.error(response.msg);
			}          
		});
	});
}

$('#modalEstoque').on('hidden.bs.modal', function () {
	$("#idEstoqueModal").val("");
	$("#stEstoqueModal").val("");
	$("#checkSaldoModal").removeAttr("checked");
	$("#origemEstoqueModal").val("1");
})