document.addEventListener("DOMContentLoaded", function() {
	toastr.options = {"positionClass": "toast-bottom-right"};
	var page = $("#page").val();
	if (page == 'satimpostossin') {
		getDates();
	}else if(page == 'satimpostos'){
		getDates();
		getEquipamentos();
	}
});

function getDates() {
	var date = new Date();
	$('#month').val(date.getMonth() + 1);
	$('#year').val(date.getFullYear());
}

function gerarRelatorioSintetico() {
	var firstTableBase = '<table class="table display table-striped table-hover table-condensed table-bordered border-collapse"><tbody>';
	var tableBase = '<table class="table display table-striped table-hover table-condensed table-bordered border-collapse mt20"><tbody>';
	var date = new Date();
	var day = date.getDate();
	if (day < 10) {
		day = '0'+day;
	}
	var month = date.getMonth() + 1;
	if (month < 10) {
		month = '0'+month;
	}

	var mesRelatorio = $('#month option:selected').text();
	$('#mesRelatorio').html('Relatório referente ao mês de <b>' + mesRelatorio +'/'+ date.getFullYear()+ '</b>');
	$.post('relatorios/resources/php/sat.php', {action: 'getDadosOperador'}, function(response){
		$("#dataHoraRelatorio").html('Relatório emitido por <b>'+response['stApelido']+'</b> ['+response['idOperador']+'] em '+day+'/'+month+'/'+date.getFullYear()+' às '+date.getHours()+':'+date.getMinutes()+'H');
	});


	data = {action: 'relatorioSintetico', month: $('#month').val(), year: $('#year').val()};
	$.post('relatorios/resources/php/sat.php', data, function(response){
		for (var i = 0; i < response.length; i++) {
			var table = tableBase;
			if (i == 0) {
				table = firstTableBase;
			}
			
			table += '<tr><td align="center" colspan="5" class="main-td">Equipamento '+response[i]['serial']+'</td></tr>';

			//ICMS
			table += '<tr><td align="center" colspan="5" class="sub-td">ICMS</td></tr>';
			if (response[i]['ICMS']) {
				var icms = response[i]['ICMS'];
				for (var j = 0; j < icms.length; j++) {
					table += '<tr>';
					table += '<td width="20%">CST</td>';
					table += '<td width="20%">'+icms[j]['CstIcms']+'</td>';
					table += '<td width="20%">'+icms[j]['PercentualIcms']+'%</td>';
					table += '<td width="20%">[BC - R$ '+icms[j]['baseCalculo']+']</td>';
					table += '<td align="right" width="20%">R$ '+icms[j]['vrCst']+'</td>';
					table += '</tr>';
				}
			}else{
				table += '<tr><td colspan = "5" align="center">NENHUM IMPOSTO ICMS PARA MOSTRAR</td></tr>';
			}

			//PIS
			table += '<tr><td align="center" colspan="5" class="sub-td">PIS</td></tr>';
			if (response[i]['PIS']) {
				var pis = response[i]['PIS'];
				for (var j = 0; j < pis.length; j++) {
					table += '<tr>';
					table += '<td width="20%">CST</td>';
					table += '<td width="20%">'+pis[j]['CstPis']+'</td>';
					table += '<td width="20%">'+pis[j]['PercentualPis']+'%</td>';
					table += '<td width="20%">[BC - R$ '+pis[j]['baseCalculo']+']</td>';
					table += '<td align="right" width="20%">R$ '+pis[j]['vrCst']+'</td>';
					table += '</tr>';
				}
			}else{
				table += '<tr><td colspan = "5" align="center">NENHUM IMPOSTO PIS PARA MOSTRAR</td></tr>';
			}

			//COFINS
			table += '<tr><td align="center" colspan="5" class="sub-td">COFINS</td></tr>';
			if (response[i]['COFINS']) {
				var cofins = response[i]['COFINS'];
				for (var j = 0; j < cofins.length; j++) {
					table += '<tr>';
					table += '<td width="20%">CST</td>';
					table += '<td width="20%">'+cofins[j]['CstCofins']+'</td>';
					table += '<td width="20%">'+cofins[j]['PercentualCofins']+'%</td>';
					table += '<td width="20%">[BC - R$ '+cofins[j]['baseCalculo']+']</td>';
					table += '<td align="right" width="20%">R$ '+cofins[j]['vrCst']+'</td>';
					table += '</tr>';
				}
			}else{
				table += '<tr><td colspan = "5" align="center">NENHUM IMPOSTO COFINS PARA MOSTRAR</td></tr>';
			}

			//TOTAIS
			table += '<tr><td align="center" colspan="5" class="sub-td">TOTAIS</td></tr>';
			table += '<tr>';
			table += '<td><div class="inline col-md-6 p0">Nº de Vendas</div><div class="inline col-md-6 p0" align="right">'+response[i]['valoresTotais']['nrVendas']+'</div></td>';
			table += '<td><div class="inline col-md-6 p0">Total de Vendas</div><div class="inline col-md-6 p0" align="right">R$ '+response[i]['valoresTotais']['vrVendas']+'</div></td>';
			table += '<td><div class="inline col-md-6 p0">Total ICMS</div><div class="inline col-md-6 p0" align="right">R$ '+response[i]['valoresTotais']['vrIcms']+'</div></td>';
			table += '<td><div class="inline col-md-6 p0">Total PIS</div><div class="inline col-md-6 p0" align="right">R$ '+response[i]['valoresTotais']['vrPis']+'</div></td>';
			table += '<td><div class="inline col-md-6 p0">Total COFINS</div><div class="inline col-md-6 p0" align="right">R$ '+response[i]['valoresTotais']['vrCofins']+'</div></td>';
			table += '</tr>';
			table += '</tbody></table>';
			$(table).appendTo($("#tabelas"));
		}
		$('#filtroRelatorioSin').attr('hidden', true);
		$('#relatorioSin').removeAttr('hidden');
	});
}

function backSin() {
	$("#tabelas").empty();
	$('#filtroRelatorioSin').removeAttr('hidden');
	$('#relatorioSin').attr('hidden', true);
}

function printSin() {
	var printContents = document.getElementById('divPrint').innerHTML;
	var originalContents = document.body.innerHTML;

	var css = '<link href="css/bootstrap.min.css" rel="stylesheet"/><link href="relatorios/resources/css/custom.css" rel="stylesheet"/>';
	document.body.innerHTML = css + printContents;

	window.print();

	document.body.innerHTML = originalContents;
}

function getEquipamentos() {
	$('#equip').append($('<option></option>').val('0').html('Todos'));
	$.post('relatorios/resources/php/sat.php', {action: 'getEquipamentos'}, function(response){
		for (var i = 0; i < response.length; i++) {
			$('#equip').append($('<option></option>').val(response[i]['id']).html(response[i]['serial']));
		}
	});
}

function gerarRelatorioImpostos() {
	$('#noData').attr('hidden', true);
	var firstTableBase = '<table class="table display table-striped table-hover table-condensed table-bordered border-collapse"><tbody>';
	var tableBase = '<table class="table display table-striped table-hover table-condensed table-bordered border-collapse mt20"><tbody>';
	var semana = ['Domingo', 'Segunda-Feira', 'Terça-Feira', 'Quarta-Feira', 'Quinta-Feira', 'Sexta-Feira', 'Sábado'];
	var date = new Date();
	var day = date.getDate();
	if (day < 10) {
		day = '0'+day;
	}
	var month = date.getMonth() + 1;
	if (month < 10) {
		month = '0'+month;
	}

	var mesRelatorio = $('#month option:selected').text();
	var equipId = $('#equip option:selected').val();
	var equipText = $('#equip option:selected').text();
	if (equipId == 0) {
		$('#titleRelatorio').html('Relatório de Impostos SAT Diário de <b>Todos os Equipamentos</b>');
	}else{
		$('#titleRelatorio').html('Relatório de Impostos SAT Diário do Equipamento <b>'+equipText+'</b>');
	}

	$('#mesRelatorio').html('Relatório referente ao mês de <b>' + mesRelatorio +'/'+ date.getFullYear()+ '</b>');
	$.post('relatorios/resources/php/sat.php', {action: 'getDadosOperador'}, function(response){
		$("#dataHoraRelatorio").html('Relatório emitido por <b>'+response['stApelido']+'</b> ['+response['idOperador']+'] em '+day+'/'+month+'/'+date.getFullYear()+' às '+date.getHours()+':'+date.getMinutes()+'H');
	});

	data = {action: 'relatorioDiario', month: $('#month').val(), year: $('#year').val(), equipamento: equipId};
	$.post('relatorios/resources/php/sat.php', data, function(response){
		if (!response) {
			$('#noData').removeAttr('hidden');
			return false;
		}
		for (var i = 0; i < response.length; i++) {
			var table = tableBase;
			if (i == 0) {
				table = firstTableBase;
			}

			var date = new Date($('#year').val(), ($('#month').val() - 1), response[i]['valoresTotais']['day']);
			var data = response[i]['valoresTotais']['day'] + '/' + month + '/' + $('#year').val();
			table += '<tr><td align="center" colspan="5" class="main-td">'+data+'('+semana[date.getDay()]+')'+'</td></tr>';

			//ICMS
			table += '<tr><td align="center" colspan="5" class="sub-td">ICMS</td></tr>';
			if (response[i]['ICMS']) {
				var icms = response[i]['ICMS'];
				for (var j = 0; j < icms.length; j++) {
					table += '<tr>';
					table += '<td width="20%">CST</td>';
					table += '<td width="20%">'+icms[j]['CstIcms']+'</td>';
					table += '<td width="20%">'+icms[j]['PercentualIcms']+'%</td>';
					table += '<td width="20%">[BC - R$ '+icms[j]['baseCalculo']+']</td>';
					table += '<td align="right" width="20%">R$ '+icms[j]['vrCst']+'</td>';
					table += '</tr>';
				}
			}else{
				table += '<tr><td colspan = "5" align="center">NENHUM IMPOSTO ICMS PARA MOSTRAR</td></tr>';
			}

			//PIS
			table += '<tr><td align="center" colspan="5" class="sub-td">PIS</td></tr>';
			if (response[i]['PIS']) {
				var pis = response[i]['PIS'];
				for (var j = 0; j < pis.length; j++) {
					table += '<tr>';
					table += '<td width="20%">CST</td>';
					table += '<td width="20%">'+pis[j]['CstPis']+'</td>';
					table += '<td width="20%">'+pis[j]['PercentualPis']+'%</td>';
					table += '<td width="20%">[BC - R$ '+pis[j]['baseCalculo']+']</td>';
					table += '<td align="right" width="20%">R$ '+pis[j]['vrCst']+'</td>';
					table += '</tr>';
				}
			}else{
				table += '<tr><td colspan = "5" align="center">NENHUM IMPOSTO PIS PARA MOSTRAR</td></tr>';
			}

			//COFINS
			table += '<tr><td align="center" colspan="5" class="sub-td">COFINS</td></tr>';
			if (response[i]['COFINS']) {
				var cofins = response[i]['COFINS'];
				for (var j = 0; j < cofins.length; j++) {
					table += '<tr>';
					table += '<td width="20%">CST</td>';
					table += '<td width="20%">'+cofins[j]['CstCofins']+'</td>';
					table += '<td width="20%">'+cofins[j]['PercentualCofins']+'%</td>';
					table += '<td width="20%">[BC - R$ '+cofins[j]['baseCalculo']+']</td>';
					table += '<td align="right" width="20%">R$ '+cofins[j]['vrCst']+'</td>';
					table += '</tr>';
				}
			}else{
				table += '<tr><td colspan = "5" align="center">NENHUM IMPOSTO COFINS PARA MOSTRAR</td></tr>';
			}

			//TOTAIS
			table += '<tr><td align="center" colspan="5" class="sub-td">TOTAIS</td></tr>';
			table += '<tr>';
			table += '<td><div class="inline col-md-6 p0">Nº de Vendas</div><div class="inline col-md-6 p0" align="right">'+response[i]['valoresTotais']['nrVendas']+'</div></td>';
			table += '<td><div class="inline col-md-6 p0">Total de Vendas</div><div class="inline col-md-6 p0" align="right">R$ '+response[i]['valoresTotais']['vrVendas']+'</div></td>';
			table += '<td><div class="inline col-md-6 p0">Total ICMS</div><div class="inline col-md-6 p0" align="right">R$ '+response[i]['valoresTotais']['vrIcms']+'</div></td>';
			table += '<td><div class="inline col-md-6 p0">Total PIS</div><div class="inline col-md-6 p0" align="right">R$ '+response[i]['valoresTotais']['vrPis']+'</div></td>';
			table += '<td><div class="inline col-md-6 p0">Total COFINS</div><div class="inline col-md-6 p0" align="right">R$ '+response[i]['valoresTotais']['vrCofins']+'</div></td>';
			table += '</tr>';
			table += '</tbody></table>';
			$(table).appendTo($("#tabelas"));
		}
		$('#filtroRelatorioMensal').attr('hidden', true);
		$('#relatorioImposto').removeAttr('hidden');
	});
}

function backMensal() {
	$("#tabelas").empty();
	$('#filtroRelatorioMensal').removeAttr('hidden');
	$('#relatorioCaixa').attr('hidden', true);
}