<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class Comanda.
 *
 * @package namespace App\Entities;
 */
class Comanda extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'mt_Atendimentos';
    protected $primaryKey = 'idComanda';
    public $incrementing = false;
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [];

    protected $casts = [
        'idComanda' => 'integer',
        'vrTotal' => 'float',
    ];

    public function itens()
    {
        return $this->hasMany(ItemComanda::class, 'idComanda', 'idComanda');
    }

}
