<?php

namespace App\Entities\Financeiro;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Grupo extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = "fin_CategoriaContas";
    protected $primaryKey = 'idCategoriaConta';
    public $timestamps = false;
    protected $fillable = [
        "idCategoriaConta",
        "stCategoriaConta",
        "dtAlteracao"
    ];

    protected $casts = [
        "idCategoriaConta" => 'int',
    ];

    public function subGrupo()
    {
        return $this->hasMany(SubGrupo::class, 'idCategoriaConta')->with('conta');
    }
}
