<?php

namespace App\Entities;

use App\Entities\User;
use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class ManagerDetails extends Model implements Transformable
{
    use TransformableTrait;
//    //    use HasCompositePrimaryKey;

    protected $table = 'cx_GerenciadorDetalhes';
    protected $primaryKey = ['idAbertura', 'idFormaPagamento', 'idDetalhe'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'id_open',
        'id_payment',
        'id_detail',
        'value_payment',
        'id_operator',
        'value_payment_micro',
        'pending',
        'update_at',
    ];

    protected $hidden = [
        'idAbertura',
        'idFormaPagamento',
        'idDetalhe',
        'vrPagamento',
        'idOperador',
        'vrPagamentoMicro',
        'flPendente',
        'dtAlteracao',
        'formaPagamento',
        'operador'
    ];

    protected $maps = [
        'id_open' => 'idAbertura',
        'id_payment' => 'idFormaPagamento',
        'id_detail' => 'idDetalhe',
        'value_payment' => 'vrPagamento',
        'id_operator' => 'idOperador',
        'value_payment_micro' => 'vrPagamentoMicro',
        'pending' => 'flPendente',
        'update_at' => 'dtAlteracao',
        'id_type_payment' => 'formaPagamento.id_type',
        'operator_conferred' => 'operador.name'
    ];

    protected $appends = [
        'id_open',
        'id_payment',
        'id_detail',
        'value_payment',
        'id_operator',
        'value_payment_micro',
        'pending',
        'update_at',
        'id_type_payment',
        'operator_conferred'
    ];

    protected $casts = [
        'flPendente' => 'boolean',
    ];

    public function formaPagamento()
    {
        return $this->belongsTo(PaymentMethod::class, 'idFormaPagamento', 'idFormaPagamento');
    }

    public function operador()
    {
        return $this->belongsTo(User::class, 'idOperador', 'idOperador');
    }
}
