<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Nutritional extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'prd_TabelasNutricionais';
    protected $primaryKey = 'idTabelaNutricional';
    public $incrementing = false;
    public $timestamps = false;

    protected $casts = [
        'idTabelaNutricional' => 'integer',
        'idProduto' => 'integer',
        'nrQuantidade' => 'integer',
        'nrUnidadePorcao' => 'integer',
        'nrParteInteiraMedidaCaseira' => 'integer',
        'nrParteDecimalMedidaCaseira' => 'integer',
        'nrMedidaCaseira' => 'integer',
        'nrValorEnergetico' => 'integer',
        'nrCarboidratos' => 'float',
        'nrProteinas' => 'float',
        'nrGordurasTotais' => 'float',
        'nrGordurasSaturadas' => 'float',
        'nrGordurasTrans' => 'float',
        'nrFibraAlimentar' => 'float',
        'nrSodio' => 'float',
        'nrAcucaresTotais' => 'float',
        'nrAcucaresAdicionados' => 'float',
        'nrLactose' => 'float',
        'nrGalactose' => 'float',
        'nrQuantidadePorcoesEmbalagem' => 'integer',
        'flAltoAcucarAdicionado' => 'boolean',
        'flAltoGorduraSaturada' => 'boolean',
        'flAltoSodio' => 'boolean',
        'stTipo' => 'string'
    ];
    protected $fillable = [
        'idTabelaNutricional',
        'idProduto',
        'nrQuantidade',
        'nrUnidadePorcao',
        'nrParteInteiraMedidaCaseira',
        'nrParteDecimalMedidaCaseira',
        'nrMedidaCaseira',
        'nrValorEnergetico',
        'nrCarboidratos',
        'nrProteinas',
        'nrGordurasTotais',
        'nrGordurasSaturadas',
        'nrGordurasTrans',
        'nrFibraAlimentar',
        'nrSodio',
        'nrAcucaresTotais',
        'nrAcucaresAdicionados',
        'nrLactose',
        'nrGalactose',
        'stTipo',
        'nrQuantidadePorcoesEmbalagem',
        'flAltoAcucarAdicionado',
        'flAltoGorduraSaturada',
        'flAltoSodio'
    ];
}
