<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class Pergunta.
 *
 * @package namespace App\Entities\Nati;
 */
class Pergunta extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = "prd_Perguntas";
    protected $primaryKey = 'idPergunta';
    public $incrementing = true;
    public $timestamps = false;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'stPergunta',
        'flObrigatoria',
        'minOpcoes',
        'maxOpcoes',
        'flAtivo',
        'dtAlteracao'
    ];
    protected $casts = [
        'flObrigatoria' => 'boolean'
    ];

    public function respostas()
    {
        return $this->hasMany(Resposta::class, 'idPergunta', 'idPergunta');
    }
    public function respostasObservacoes()
    {
        return $this->belongsToMany(RespostaObservacao::class, 'prd_Respostas', 'idPergunta', 'idRespostaObservacao');
    }

    public function produtos()
    {
        return $this->belongsToMany(Product::class, 'prd_ProdutosPerguntas', 'idPergunta', 'idProduto');
    }
}
