<?php

namespace App\Entities;

use App\Entities\Nati\Product;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class ProductComposite.
 *
 * @package namespace App\Entities;
 */
class ProductComposite extends Model implements Transformable
{
    use TransformableTrait;
//    //    use HasCompositePrimaryKey;

    protected $table = 'prd_FichaTecnica';
    protected $primaryKey = ['idProdutoPrincipal', 'idItem'];
    public $timestamps = false;
    public $incrementing = false;

    protected $maps = [
        'descricao' => 'product.stProdutoAbreviado',
    ];
    protected $appends = [
        'descricao',
    ];

    protected $fillable = [
        'idProdutoPrincipal',
        'idItem',
        'idProduto',
        'nrQuantidade',
        'vrCustoTotal',
        'dtAlteracao',
        'product',
    ];

    public function getDescricaoAttribute()
    {
        return $this->product()->first()->stProdutoAbreviado;
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'idProduto', 'idProduto');
    }

}


