<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
//use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Support\Str;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Supplier extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'frn_Fornecedores';
    protected $primaryKey = 'idFornecedor';
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idFornecedor',
        'stNomeFornecedor',
        'stContato',
        'stEndereco',
        'stNumero',
        'stComplemento',
        'stBairro',
        'stEstado',
        'stPais',
        'stFone1',
        'stFone2',
        'stFax',
        'stCNPJ',
        'stIE',
        'flAtivo',
        'dtUltimaCompra',
        'stCidade',
        'stCMSN',
        'stCFone1',
        'stCFone2',
        'stCEmail',
        'stRazaoSocial',
        'stSite',
        'stEmail',
        'flTipoEstoque',
        'flVisible',
        'stObservacao',
        'stBanco',
        'stAgencia',
        'stConta',
        'stContatoBanco',
        'stTelefoneBanco',
        'stSenha',
        'stFaturamento',
        'dtAlteracao',
        'stCep'
    ];
    protected $casts = [
        'flAtivo' => 'boolean'
    ];

//    public function setStNomeFornecedorAttibute($value){
//        $this->attributes['stNomeFornecedor'] = Str::upper($value);
//    }
}
