<?php

namespace App\Entities;

use App\Traits\HasCompositePrimaryKey;
use App\Entities\User;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Voucher extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cx_Vaucher';
    protected $primaryKey = ['idVaucher', 'idAbertura', 'idCaixa'];

    public $timestamps = false;
    public $incrementing = false;
    protected $fillable = [
        'id',
        'id_open',
        'id_pdv',
        'value_voucher',
        'id_payment',
        'id_operator',
        'id_operator_authorize',
        'date_emission',
        'active',
        'print',
        'id_order',
        'is_liquided',
        'update_date',
    ];

    protected $appends = [
        'id',
        'id_open',
        'id_pdv',
        'value_voucher',
        'id_payment',
        'id_operator',
        'id_operator_authorize',
        'date_emission',
        'active',
        'print',
        'id_order',
        'is_liquided',
        'update_date',
        'payment',
        'operator',
        'operator_authorizer'
    ];

    protected $hidden = [
        'idAbertura',
        'idCaixa',
        'idVaucher',
        'vrVaucher',
        'idFormaPagamento',
        'idOperador',
        'idOperadorAutorizador',
        'dtEmissao',
        'flAtivo',
        'stPrint',
        'idPedido',
        'flLiquidado',
        'dtAlteracao',
        'formaPagamento',
        'operador',
        'authorizer'
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
        'flLiquidado' => 'boolean',
    ];

    protected $maps = [
        'id' => 'idVaucher',
        'id_open' => 'idAbertura',
        'id_pdv' => 'idCaixa',
        'value_voucher' => 'vrVaucher',
        'id_payment' => 'idFormaPagamento',
        'id_operator' => 'idOperador',
        'id_operator_authorize' => 'idOperadorAutorizador',
        'date_emission' => 'dtEmissao',
        'active' => 'flAtivo',
        'print' => 'stPrint',
        'id_order' => 'idPedido',
        'is_liquided' => 'flLiquidado',
        'update_date' => 'dtAlteracao',
        'payment' => 'formaPagamento.payment',
        'operator' => 'operador.name',
        'operator_authorizer' => 'authorizer.name',
    ];

    public function operador()
    {
        return $this->hasOne(User::class, 'idOperador', 'idOperador');
    }

    public function authorizer()
    {
        return $this->hasOne(User::class, 'idOperador', 'idOperadorAutorizador');
    }

    public function abertura()
    {
        return $this->belongsTo(Manager::class, 'idAbertura', 'idAbertura');
    }

    public function formaPagamento()
    {
        return $this->belongsTo(PaymentMethod::class, 'idFormaPagamento', 'idFormaPagamento');
    }

}

