<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class VwSalesItemsReport.
 *
 * @package namespace App\Entities;
 */
class VwSalesItemsReport extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'vw_sales_items_report';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [];

    protected $casts = [
        'idProduto' => 'int',
        'idCodProduto' => 'string',
        'idAliquota' => 'int',
        'stAliquota' => 'string',
        'idCategoria' => 'int',
        'stCategoria' => 'string',
        'idSetor' => 'int',
        'stSetor' => 'string',
        'nrQuantidade' => 'float',
        'vrUnitario' => 'float',
        'vrDesconto' => 'float',
        'vrTotal' => 'float',
        'total' => 'float',
        'flAtivo' => 'bool',
        'nrNCM' => 'string',
    ];

}
