<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\Shared\FormaPagamentoService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Prettus\Validator\Exceptions\ValidatorException;

class FormaPagamentoController extends Controller
{

    /**
     * @var FormaPagamentoService
     */
    protected $service;

    public function __construct(FormaPagamentoService $service)
    {
        $this->service = $service;
    }

    public function index()
    {
        try {
            $response = $this->service->get();
            return response()->json($response);

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */

    public function getAll()
    {

        try {
            $response = $this->service->get();
            return response()->json($response);

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {

        try {
            $response = $this->service->insert($request->all());
            return response()->json(['data' => $response]);

        } catch (ValidatorException $e) {
            return response()->json(['error' => true, 'message' => $e->getMessageBag()], 500);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        try {
            $response = $this->service->getById($id);
            return response()->json($response);

        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => true, 'message' => 'id not found'], 404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param string $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request, $id)
    {

        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json(['data' => $response]);

        } catch (ValidatorException $e) {
            return response()->json(['error' => true, 'message' => $e->getMessageBag()]);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {

        $this->service->delete($id);

        return response()->json(['message' => 'Success'], 200);

    }
}
