<?php

namespace App\Http\Controllers;

use App\Entities\Company;
use App\Entities\Master;
use App\Services\PaymentProviderService;
use Illuminate\Http\Request;
use App\Http\Requests\StoreUpdateCompany;

class PaymentProviderController extends Controller
{
    private $service;

    public function __construct(PaymentProviderService $service)
    {
        $this->service = $service;
    }

    public function getCompany()
    {
        return true;
        try {
            return $this->service->getCompany();
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function storeCompany(StoreUpdateCompany $request)
    {
        try {
            return $this->service->storeCompany($request);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
                'status' => $e->getCode(),
            ], 500);
        }

    }

    public function searchSubscription()
    {
        $company = Company::first();
        if($company->paymentProviderSubscriptionId) {
            $subscriptions = $this->service->searchSubscription($company->paymentProviderSubscriptionId);
            $subscriptions['company'] = [];
            array_push($subscriptions['company'], $company);
            return $subscriptions;
        }
        return;
    }

    public function activateSubscription($id)
    {
        try {
            return $this->service->activateSubscription($id);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
                'status' => $e->getCode(),
            ], 500);
        }
    }

//    public function getInvoices()
//    {
//        try {
//            return $this->service->getInvoices();
//        } catch (\Exception $e) {
//            return response()->json([
//                'error' => true,
//                'message' => $e->getMessage(),
//                'status' => $e->getCode(),
//            ], 500);
//        }
//    }
}
