<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\Nati\CategoriaService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Nati\SubCategoriaCreateRequest;
use App\Http\Requests\Nati\SubCategoriaUpdateRequest;
use App\Services\Nati\SubCategoriaService;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Entities\Logs;


class SubCategoriasController extends Controller
{

    /**
     * @var CategoriaService
     */
    protected $service;

    /**
     * CategoriasController constructor.
     * @param SubCategoriaService $service
     */
    public function __construct(SubCategoriaService $service)
    {
        $this->service  = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return JsonResponse
     */
    public function index()
    {
        try
        {
            $categorias = $this->service->all();

            return response()->json($categorias);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  SubCategoriaCreateRequest $request
     *
     * @return JsonResponse
     */
    public function store(SubCategoriaCreateRequest $request)
    {
        try {
            $subCategoria = $this->service->create($request->all());

            $response = [
                'message' => 'Sub-Categoria created.',
                'data'    => $subCategoria->toArray(),
            ];
            return response()->json($response, 201);

        }catch (ModelNotFoundException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 404);
        }
        catch (ValidatorException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @param $id_category
     * @return JsonResponse
     */
    public function view($id, $id_category)
    {
        try
        {
            $subCategoria = $this->service->getById($id, $id_category);

            return response()->json($subCategoria);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param SubCategoriaUpdateRequest $request
     * @param $idSubCategoria
     * @param $idCategoria
     * @return JsonResponse
     */

    public function atualizar(SubCategoriaUpdateRequest $request, $idSubCategoria, $idCategoria)
    {
        try {
            $response = $this->service->update($request->all(), $idSubCategoria, $idCategoria);
            return response()->json([
                'message' => 'Sub-Categoria Update',
                'data' => $response
            ],201);

        }catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (ValidatorException $e) {

            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }

    public function update(SubCategoriaUpdateRequest $request, $idSubCategoria, $idCategoria)
    {
        try {
            $response = $this->service->atualizar($request->all(), $idSubCategoria, $idCategoria);

            $user = auth()->user();
            Logs::writeLog($user->stApelido, "PRODUTOS", 'O USUARIO [' . $user->stApelido . '] ALTEROU A SUB-CATEGORIA DE: [ ' . $request->subCategoria['stSubCategoria'] . ' ] PARA: [' . $request->subCategoria['newStSubCategoria'] . ' ]');

            return response()->json([
                'message' => 'Sub-Categoria Update',
                'data' => $response
            ],201);

        }catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (ValidatorException $e) {

            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param $idSubCategoria
     * @param $idCategoria
     * @return JsonResponse
     */
    public function delete($idSubCategoria, $idCategoria)
    {
        try {
            $subCategoria = $this->service->delete($idSubCategoria, $idCategoria);

            $response = [
                'message' => 'Sub-Categoria deletada.',
                'data'    => $subCategoria,
            ];
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function transfer(Request $request, $id, $id_category)
    {
        try {
            $subcategory = $this->service->transfer($request->all(), $id, $id_category);
            $response = [
                'message' => 'Sub Categoria transferida com sucesso.',
            ];
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
}
