<?php

namespace App\Http\Resources\Nati;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\Resource;

class AberturasResource extends Resource
{
    public $resource;

    public function __construct($resource)
    {
        $this->resource = $resource;
    }

    public function currency($value) {
        return number_format($value, 2);
    }

    public function datetime($datetime) {
        $dt = Carbon::parse($datetime);
        return
            ($dt->day > 9 ? $dt->day : '0'. $dt->month) .'/'.
            ($dt->month > 9 ? $dt->month : '0'. $dt->month) .'/'. $dt->year .' '.
            ($dt->hour > 9 ? $dt->hour : '0'. $dt->hour) .':'.
            ($dt->minute > 9 ? $dt->minute : '0'. $dt->minute);
    }

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'abertura'          => $this->resource->idAbertura,
            'num_caixa'         => $this->resource->idCaixa,
            'operador'          => $this->resource->operador,
            'valor_abertura'    => $this->resource->vrAbertura,
            'valor_fechamento'  => $this->resource->vrFechamento,
            'clientes'          => $this->resource->nrClientes,
//            'vendas'            => $this->resource->total_vendas,
//            'qtd_aberturas'     => $this->resource->qtd_aberturas,
//            'cancelados'        => $this->resource->cancelados,
            'data_abertura'     => $this->datetime($this->resource->dtAbertura),
            'data_fechamento'   => $this->datetime($this->resource->dtFechamento),
            'data_alteracao'    => $this->datetime($this->resource->dtAlteracao),
//            'sangria'           => $this->currency($this->resource->sangria),
//            'despesa'           => $this->currency($this->resource->despesa),
//            'repique'           => $this->currency($this->resource->repique),
//            'desconto'          => $this->currency($this->resource->desconto),
            'valor_total'       => $this->currency($this->resource->valor_total),
//            'conta_assinada'    => $this->currency($this->resource->conta_assinada),
        ];
    }
}
