<?php

namespace App\Providers;

use App\Entities\Master;
use App\Entities\Nati\Aliquota;
use App\Entities\Nati\Categoria;
use App\Entities\Nati\FormaPagamento;
use App\Entities\Nati\Measure;
use App\Entities\Nati\Customer;
use App\Entities\Nati\Product;
use App\Entities\Nati\ProdutoConfig;
use App\Entities\Nati\Sector;
use App\Entities\Permission;
use App\Entities\PontoDelivery;
use App\Entities\Profile;
use App\Entities\Supplier;
use App\Entities\User;
use App\Observers\AliquotaObserver;
use App\Observers\CategoriaObserver;
use App\Observers\CustomerObserver;
use App\Observers\FormaPagamentoObserver;
use App\Observers\MasterObserver;
use App\Observers\MedidaObserver;
use App\Observers\PermissionObserver;
use App\Observers\PontoDeliveryObserver;
use App\Observers\ProductObserver;
use App\Observers\ProdutoConfigObserver;
use App\Observers\ProfileObserver;
use App\Observers\SetorObserver;
use App\Observers\SupplierObserver;
use App\Observers\UserObserver;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\ServiceProvider;
use Laravel\Passport\Passport;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // Passport::ignoreMigrations();
        $this->app->register(RepositoryServiceProvider::class);
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Carbon::setLocale('pt_BR');
        JsonResource::withoutWrapping();

        Aliquota::observe(AliquotaObserver::class);
        Categoria::observe(CategoriaObserver::class);
        Customer::observe(CustomerObserver::class);
        FormaPagamento::observe(FormaPagamentoObserver::class);
        Measure::observe(MedidaObserver::class);
        Permission::observe(PermissionObserver::class);
        PontoDelivery::observe(PontoDeliveryObserver::class);
        Product::observe(ProductObserver::class);
        ProdutoConfig::observe(ProdutoConfigObserver::class);
        Profile::observe(ProfileObserver::class);
        Sector::observe(SetorObserver::class);
        Supplier::observe(SupplierObserver::class);
        User::observe(UserObserver::class);
        Master::observe(MasterObserver::class);
    }
}
