<?php

namespace App\Repositories;

use App\Entities\Financeiro\Lancamento;
use App\Validators\Financeiro\LancamentosValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class ContasReceberRepositoryEloquent
 * @package namespace App\Repositories;
 */
class LancamentosRepositoryEloquent extends BaseRepository implements LancamentosRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Lancamento::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return LancamentosValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
