<?php

namespace App\Repositories\Nati;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\nati\RespostaRepository;
use App\Entities\Nati\Resposta;
use App\Validators\Nati\RespostaValidator;

/**
 * Class RespostaRepositoryEloquent.
 *
 * @package namespace App\Repositories\\Nati;
 */
class RespostaRepositoryEloquent extends BaseRepository implements RespostaRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Resposta::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return RespostaValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }

}
