<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\TurnosRepository;
use App\Entities\Turnos;
use App\Validators\TurnosValidator;

/**
 * Class TurnosRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class TurnosRepositoryEloquent extends BaseRepository implements TurnosRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Turnos::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return TurnosValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
